# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SsisParameter(Model):
    """Ssis parameter.

    :param id: Parameter id.
    :type id: long
    :param name: Parameter name.
    :type name: str
    :param description: Parameter description.
    :type description: str
    :param data_type: Parameter type.
    :type data_type: str
    :param required: Whether parameter is required.
    :type required: bool
    :param sensitive: Whether parameter is sensitive.
    :type sensitive: bool
    :param design_default_value: Design default value of parameter.
    :type design_default_value: str
    :param default_value: Default value of parameter.
    :type default_value: str
    :param sensitive_default_value: Default sensitive value of parameter.
    :type sensitive_default_value: str
    :param value_type: Parameter value type.
    :type value_type: str
    :param value_set: Parameter value set.
    :type value_set: bool
    :param variable: Parameter reference variable.
    :type variable: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
        'sensitive': {'key': 'sensitive', 'type': 'bool'},
        'design_default_value': {'key': 'designDefaultValue', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'sensitive_default_value': {'key': 'sensitiveDefaultValue', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'value_set': {'key': 'valueSet', 'type': 'bool'},
        'variable': {'key': 'variable', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.data_type = kwargs.get('data_type', None)
        self.required = kwargs.get('required', None)
        self.sensitive = kwargs.get('sensitive', None)
        self.design_default_value = kwargs.get('design_default_value', None)
        self.default_value = kwargs.get('default_value', None)
        self.sensitive_default_value = kwargs.get('sensitive_default_value', None)
        self.value_type = kwargs.get('value_type', None)
        self.value_set = kwargs.get('value_set', None)
        self.variable = kwargs.get('variable', None)
