# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SizeInfoFragment(Model):
    """Contains detailed information about a size.

    :param compute_size: Represents the actual compute size, e.g.
     Standard_A2_v2.
    :type compute_size: str
    :param price: The pay-as-you-go price per hour this size will cost. It
     does not include discounts and may not reflect the actual price the size
     will cost.
    :type price: decimal.Decimal
    :param number_of_cores: The number of cores a VM of this size has.
    :type number_of_cores: int
    :param memory: The amount of memory available (in GB).
    :type memory: float
    """

    _attribute_map = {
        'compute_size': {'key': 'computeSize', 'type': 'str'},
        'price': {'key': 'price', 'type': 'decimal'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'memory': {'key': 'memory', 'type': 'float'},
    }

    def __init__(self, *, compute_size: str=None, price=None, number_of_cores: int=None, memory: float=None, **kwargs) -> None:
        super(SizeInfoFragment, self).__init__(**kwargs)
        self.compute_size = compute_size
        self.price = price
        self.number_of_cores = number_of_cores
        self.memory = memory
