% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{FixedNumberParam-class}
\alias{FixedNumberParam-class}
\alias{centers}
\alias{centers,FixedNumberParam-method}
\alias{centers<-}
\alias{centers<-,FixedNumberParam-method}
\alias{show,FixedNumberParam-method}
\title{The FixedNumberParam class}
\description{
The FixedNumberParam is a virtual subclass of the \linkS4class{BlusterParam} class.
It causes \code{\link{clusterRows}} to dispatch to clustering algorithms that rely on a pre-specified number of clusters, e.g., \linkS4class{KmeansParam}.
}
\section{Available methods}{

\code{centers(x, n=NULL)} will return the specified number of centers in a FixedNumberParam \code{x}.
This can be an positive integer, or a function that accepts the number of observations and returns a positive number.
If a function and \code{n} is supplied, the function is called on \code{n} and the result is rounded to obtain an integer.

\code{centers(x) <- value} will replace the specified number of centers in \code{x} with an integer scalar or function \code{value}.
The function should accept a single argument and return a positive integer.
}

\seealso{
\linkS4class{KmeansParam}, for the archetypal example of a concrete subclass.
}
\author{
Aaron Lun
}
