% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{isPhiX}
\alias{isPhiX}
\title{Determine if input sequence(s) match the phiX genome.}
\usage{
isPhiX(seqs, wordSize = 16, minMatches = 2, nonOverlapping = TRUE,
  ...)
}
\arguments{
\item{seqs}{(Required). A \code{character} vector of A/C/G/T sequences.}

\item{wordSize}{(Optional). Default 16.
The size of the words to use for comparison.}

\item{minMatches}{(Optional). Default 2.
The minimum number of words in the input sequences that must match the phiX genome
(or its reverse complement) for the sequence to be flagged.}

\item{nonOverlapping}{(Optional). Default TRUE.
If TRUE, only non-overlapping matching words are counted.}

\item{...}{(Optional). Ignored.}
}
\value{
\code{logical(1)}.
 TRUE if sequence matched the phiX genome.
}
\description{
This function compares the word-profile of the input
sequences to the phiX genome, and the reverse complement of the phiX genome. If
enough exactly matching words are found, the sequence is flagged.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
sqs1 <- getSequences(derep1)
is.phi <- isPhiX(sqs1)
is.phi <- isPhiX(sqs1, wordSize=20,  minMatches=1)

}
\seealso{
\code{\link{fastqFilter}}, \code{\link{fastqPairedFilter}}
}
