% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportTracks.R
\name{exportTracks}
\alias{exportTracks}
\title{Export Gviz tracks into an annotation file representation.}
\usage{
exportTracks(tracks, range, chromosome, file)
}
\arguments{
\item{tracks}{A list of annotation track objects to be exported into a
single BED file.}

\item{range}{A numeric vector or length 2. The genomic range to display when
opening the file in a browser.}

\item{chromosome}{The chromosome to display when opening the file in a browser.}

\item{file}{Character, the path to the file to write into.}
}
\value{
The function is called for its side effect of writing to a file.
}
\description{
This function is still a bit experimental. Write all tracks provided as a
list \code{tracks} into a single BED file. So far only BED export is supported.
}
\examples{
## export AnnotationTrack to BED file
at <- AnnotationTrack(start = seq(1, 10), width = 1, chromosome = "chr1")
exportTracks(list(at),
    range = c(1, 10), chromosome = "chr1",
    file = paste0(tempfile(), ".bed")
)
}
\author{
Florian Hahne
}
