% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publicS3Config.R
\name{publicS3Config}
\alias{publicS3Config}
\title{Public S3 configuration}
\usage{
publicS3Config(refresh = FALSE, url = restUrl(), cache = cacheDirectory())
}
\arguments{
\item{refresh}{Logical scalar indicating whether to refresh the credentials in the in-memory cache.}

\item{url}{String containing a URL to the gypsum REST API.}

\item{cache}{String containing a path to the cache directory, to store the configuration across R sessions.}
}
\value{
List containing:
\itemize{
\item \code{key}, a string containing the read-only S3 access key ID.
\item \code{secret}, a string containing the associated S3 access secret.
\item \code{bucket}, a string containing the name of the bucket.
\item \code{endpoint}, a string containing the URL for the S3 API.
}
}
\description{
Fetch S3 credentials and other configuration details for read-only access to the underlying gypsum bucket.
}
\details{
The configuration is obtained through a query to \code{url} on the first use of this function.
The result is automatically cached in memory and on disk to reduce the number of network requests to the API.
New credentials are automatically fetched if the on-disk cache is older than a week;
this refresh can be performed manually by calling this function with \code{refresh=TRUE}.
}
\examples{
publicS3Config()

}
\author{
Aaron Lun
}
