% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{GDCquery_clinic}
\alias{GDCquery_clinic}
\title{Get GDC clinical data}
\usage{
GDCquery_clinic(project, type = "clinical", save.csv = FALSE)
}
\arguments{
\item{project}{A valid project (see list with getGDCprojects()$project_id)]
\itemize{
\item{ BEATAML1.0-COHORT }
\item{ BEATAML1.0-CRENOLANIB }
\item{ CGCI-BLGSP }
\item{ CPTAC-2 }
\item{ CPTAC-3 }
\item{ CTSP-DLBCL1 }
\item{ FM-AD }
\item{ HCMI-CMDC }
\item{ MMRF-COMMPASS }
\item{ NCICCR-DLBCL }
\item{ OHSU-CNL }
\item{ ORGANOID-PANCREATIC }
\item{ TARGET-ALL-P1 }
\item{ TARGET-ALL-P2 }
\item{ TARGET-ALL-P3 }
\item{ TARGET-AML }
\item{ TARGET-CCSK }
\item{ TARGET-NBL }
\item{ TARGET-OS }
\item{ TARGET-RT }
\item{ TARGET-WT }
\item{ TCGA-ACC }
\item{ TCGA-BLCA }
\item{ TCGA-BRCA }
\item{ TCGA-CESC }
\item{ TCGA-CHOL }
\item{ TCGA-COAD }
\item{ TCGA-DLBC }
\item{ TCGA-ESCA }
\item{ TCGA-GBM }
\item{ TCGA-HNSC }
\item{ TCGA-KICH }
\item{ TCGA-KIRC }
\item{ TCGA-KIRP }
\item{ TCGA-LAML }
\item{ TCGA-LGG }
\item{ TCGA-LIHC }
\item{ TCGA-LUAD }
\item{ TCGA-LUSC }
\item{ TCGA-MESO }
\item{ TCGA-OV }
\item{ TCGA-PAAD }
\item{ TCGA-PCPG }
\item{ TCGA-PRAD }
\item{ TCGA-READ }
\item{ TCGA-SARC }
\item{ TCGA-SKCM }
\item{ TCGA-STAD }
\item{ TCGA-TGCT }
\item{ TCGA-THCA }
\item{ TCGA-THYM }
\item{ TCGA-UCEC }
\item{ TCGA-UCS }
\item{ TCGA-UVM }
\item{ VAREPOP-APOLLO }
}}

\item{type}{A valid type. Options "clinical", "Biospecimen"  (see list with getGDCprojects()$project_id)]}

\item{save.csv}{Write clinical information into a csv document}
}
\value{
A data frame with the clinical information
}
\description{
GDCquery_clinic will download all clinical information from the API
as the one with using the button from each project
}
\examples{
clinical <- GDCquery_clinic(
   project = "TCGA-ACC",
   type = "clinical",
   save.csv = FALSE
 )
clinical <- GDCquery_clinic(
   project = "TCGA-ACC",
   type = "biospecimen",
   save.csv = FALSE
)
\dontrun{
clinical_cptac_3 <- GDCquery_clinic(
   project = "CPTAC-3",
   type = "clinical"
)
clinical_cptac_2 <- GDCquery_clinic(
   project = "CPTAC-2",
   type = "clinical"
)
clinical_HCMI_CMDC <- GDCquery_clinic(
   project = "HCMI-CMDC",
   type = "clinical"
)
clinical_GCI_HTMCP_CC <- GDCquery_clinic(
   project = "CGCI-HTMCP-CC",
   type = "clinical"
)
clinical <- GDCquery_clinic(
   project = "NCICCR-DLBCL",
   type = "clinical"
)
clinical <- GDCquery_clinic(
   project = "ORGANOID-PANCREATIC",
   type = "clinical"
)
}
}
\author{
Tiago Chedraoui Silva
}
