% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{R2D2}
\alias{R2D2}
\title{R2-D2 Priors in \pkg{brms}}
\usage{
R2D2(mean_R2 = 0.5, prec_R2 = 2, cons_D2 = 1, autoscale = TRUE)
}
\arguments{
\item{mean_R2}{mean of the Beta prior on the coefficient of determination R^2.}

\item{prec_R2}{precision of the Beta prior on the coefficient of determination R^2.}

\item{cons_D2}{concentration vector of the Dirichlet prior on the variance
decomposition parameters.}

\item{autoscale}{Logical; indicating whether the horseshoe
prior should be scaled using the residual standard deviation
\code{sigma} if possible and sensible (defaults to \code{TRUE}).
Autoscaling is not applied for distributional parameters or 
when the model does not contain the parameter \code{sigma}.}
}
\description{
Function used to set up R2D2 priors for population-level effects in
\pkg{brms}. The function does not evaluate its arguments -- it exists purely
to help set up the model.
}
\examples{
set_prior(R2D2(mean_R2 = 0.8, prec_R2 = 10))

}
\references{
Zhang, Y. D., Naughton, B. P., Bondell, H. D., & Reich, B. J. (2020). 
  Bayesian regression using a prior on the model fit: The R2-D2 shrinkage 
  prior. Journal of the American Statistical Association.
  \url{https://arxiv.org/pdf/1609.00046.pdf}
}
\seealso{
\code{\link{set_prior}}
}
