% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnote.R
\name{footnote}
\alias{footnote}
\title{Add footnote (new)}
\usage{
footnote(
  kable_input,
  general = NULL,
  number = NULL,
  alphabet = NULL,
  symbol = NULL,
  footnote_order = c("general", "number", "alphabet", "symbol"),
  footnote_as_chunk = FALSE,
  escape = TRUE,
  threeparttable = FALSE,
  fixed_small_size = FALSE,
  general_title = "Note: ",
  number_title = "",
  alphabet_title = "",
  symbol_title = "",
  title_format = "italic",
  symbol_manual = NULL
)
}
\arguments{
\item{kable_input}{HTML or LaTeX table generated by \code{knitr::kable}}

\item{general}{Text for general footnote comments. Footnotes in this section
won't be labeled with any notations}

\item{number}{A vector of footnote texts. Footnotes here will be numbered.
There is no upper cap for the number of footnotes here}

\item{alphabet}{A vector of footnote texts, Footnotes here will be labeled
with "a,b,c". The vector here should not have more than 26 elements.}

\item{symbol}{A vector of footnote texts, Footnotes here will be labeled
with special symbols. The vector here should not have more than 20 elements.}

\item{footnote_order}{The order of how to arrange \code{general}, \code{number},
\code{alphabet} and \code{symbol}.}

\item{footnote_as_chunk}{T/F value. Default is FALSE. It controls whether
the footnotes should be printed in a chunk (without line break).}

\item{escape}{T/F value. It controls whether the contents and titles should
be escaped against HTML or LaTeX. Default is TRUE.}

\item{threeparttable}{T/F value for whether to use LaTeX package
threeparttable. Threeparttable will force the width of caption and
footnotes be the width of the original table. It's useful when you have
long paragraph of footnotes.}

\item{fixed_small_size}{T/F When you want to keep the footnote small after
specifying large font size with the kable_styling() (e.g. ideal font for headers
and table content with small font in footnotes).}

\item{general_title}{Section header for general footnotes. Default is
"Note: ".}

\item{number_title}{Section header for number footnotes. Default is "".}

\item{alphabet_title}{Section header for alphabet footnotes. Default is "".}

\item{symbol_title}{Section header for symbol footnotes. Default is "".}

\item{title_format}{Choose from "italic"(default), "bold" and "underline".
Multiple options are possible.}

\item{symbol_manual}{User can manually supply a vector of either html or
latex symbols. For example, \code{symbol_manual = c('*', '\\\\\\\\dag', '\\\\\\\\ddag')}.`}
}
\description{
\code{footnote} provides a more flexible way to add footnote. You
can add multiple sets of footnote using different notation systems. It is
also possible to specify footnote section header one by one and print
footnotes as a chunk of texts.
}
\examples{
\dontrun{
dt <- mtcars[1:5, 1:5]
colnames(dt)[1] <- paste0("mpg",
                          footnote_marker_alphabet(2))
rownames(dt)[2] <- paste0(rownames(dt)[2],
                          footnote_marker_alphabet(1))
dt[1,2] <- paste0(dt[1,2], footnote_marker_alphabet(3))

kbl(dt, escape = FALSE) |>
  footnote(alphabet = c("Note a", "Note b", "Note c"))
}

}
\seealso{
\code{\link[=add_footnote]{add_footnote()}}, \code{\link[=footnote_marker_number]{footnote_marker_number()}}
}
