% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedQuantile.R
\name{weightedQuantile}
\alias{weightedQuantile}
\title{Weighted quantiles}
\usage{
weightedQuantile(
  x,
  weights = NULL,
  probs = seq(0, 1, 0.25),
  sorted = FALSE,
  na.rm = FALSE
)
}
\arguments{
\item{x}{a numeric vector.}

\item{weights}{an optional numeric vector giving the sample weights.}

\item{probs}{numeric vector of probabilities with values in \eqn{[0,1]}.}

\item{sorted}{a logical indicating whether the observations in \code{x} are
already sorted.}

\item{na.rm}{a logical indicating whether missing values in \code{x} should
be omitted.}
}
\value{
A numeric vector containing the weighted quantiles of values in
\code{x} at probabilities \code{probs} is returned.  Unlike
\code{\link[stats]{quantile}}, this returns an unnamed vector.
}
\description{
Compute weighted quantiles (Eurostat definition).
}
\details{
The implementation strictly follows the Eurostat definition.
}
\examples{
data(eusilc)
weightedQuantile(eusilc$eqIncome, eusilc$rb050)

}
\references{
Working group on Statistics on Income and Living Conditions
(2004) Common cross-sectional EU indicators based on EU-SILC; the gender pay
gap.  \emph{EU-SILC 131-rev/04}, Eurostat.
}
\seealso{
\code{\link{incQuintile}}, \code{\link{weightedMedian}}
}
\author{
Andreas Alfons and Matthias Templ
}
\keyword{survey}
