% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Image.R
\name{plot_RLum.Data.Image}
\alias{plot_RLum.Data.Image}
\title{Plot function for an \code{RLum.Data.Image} S4 class object}
\usage{
plot_RLum.Data.Image(
  object,
  frames = NULL,
  par.local = TRUE,
  plot.type = "plot.raster",
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Image} (\strong{required}): S4
object of class \code{RLum.Data.Image}}

\item{frames}{\link{numeric} (\emph{optional}): sets the frames to be set, by default all
frames are plotted. Can be sequence of numbers, as long as the frame number is valid.}

\item{par.local}{\link{logical} (\emph{with default}): use local graphical
parameters for plotting, e.g. the plot is shown in one column and one row.
If \code{par.local = FALSE} global parameters are inherited.}

\item{plot.type}{\link{character} (\emph{with default}): plot types.
Supported types are \code{plot.raster}, \code{contour}}

\item{...}{further arguments and graphical parameters that will be passed
to the specific plot functions. Standard supported parameters are \code{xlim}, \code{ylim}, \code{zlim},
\code{xlab}, \code{ylab}, \code{main}, \code{legend} (\code{TRUE} or \code{FALSE}), \code{col}, \code{cex}, \code{axes} (\code{TRUE} or \code{FALSE})}
}
\value{
Returns a plot.
}
\description{
The function provides very basic plot functionality for image data of an
\linkS4class{RLum.Data.Image} object. For more sophisticated plotting it is recommended
to use other very powerful packages for image processing.

\strong{Details on the plot functions}

Supported plot types:

\strong{\code{plot.type = "plot.raster"}}

Uses the standard plot function of R \link[graphics:image]{graphics::image}. If wanted, the image
is enhanced, using the argument \code{stretch}. Possible values are \code{hist}, \code{lin}, and
\code{NULL}. The latter does nothing. The argument \code{useRaster = TRUE} is used by default, but
can be set to \code{FALSE}.

\strong{\code{plot.type = "contour"}}

This uses the function \link[graphics:contour]{graphics::contour}
}
\section{Function version}{
 0.2.0
}

\examples{

##load data
data(ExampleData.RLum.Data.Image, envir = environment())

##plot data
plot_RLum.Data.Image(ExampleData.RLum.Data.Image)

}
\seealso{
\linkS4class{RLum.Data.Image}, \link{plot}, \link{plot_RLum}, \link[graphics:image]{graphics::image}, \link[graphics:contour]{graphics::contour}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2022. plot_RLum.Data.Image(): Plot function for an RLum.Data.Image S4 class object. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.18. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
