% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.nexus.splits.R
\name{read.nexus.splits}
\alias{read.nexus.splits}
\alias{write.nexus.splits}
\alias{write.nexus.networx}
\alias{read.nexus.networx}
\alias{write.splits}
\title{Function to import and export splits and networks}
\usage{
read.nexus.splits(file)

write.nexus.splits(obj, file = "", weights = NULL, taxa = TRUE, append = FALSE)

write.nexus.networx(obj, file = "", taxa = TRUE, splits = TRUE, append = FALSE)

read.nexus.networx(file, splits = TRUE)

write.splits(x, file = "", zero.print = ".", one.print = "|",
  print.labels = TRUE, ...)
}
\arguments{
\item{file}{a file name.}

\item{obj}{An object of class splits.}

\item{weights}{Edge weights.}

\item{taxa}{logical. If TRUE a taxa block is added}

\item{append}{logical. If TRUE the nexus blocks will be added to a file.}

\item{splits}{logical. If TRUE the nexus blocks will be added to a file.}

\item{x}{An object of class splits.}

\item{zero.print}{character which should be printed for zeros.}

\item{one.print}{character which should be printed for ones.}

\item{print.labels}{logical. If TRUE labels are printed.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{labels}{names of taxa.}
}
\value{
\code{write.nexus.splits} and \code{write.nexus.networx} write out
the \code{splits} and \code{networx} object to read with
other software like SplitsTree.
\code{read.nexus.splits} and \code{read.nexus.networx} return an \code{splits}
and \code{networx} object.
}
\description{
\code{read.nexus.splits}, \code{write.nexus.splits}, \code{read.nexus.networx}, \code{write.nexus.networx}
can be used to import and export splits and networks with nexus format
and allow to exchange these object with other software like SplitsTree.
\code{write.splits} returns a human readable output.
}
\note{
\code{read.nexus.splits} reads in the splits block of a nexus file. It
assumes that different co-variables are tab delimited and the bipartition
are separated with white-space. Comments in square brackets are ignored.
}
\examples{

(sp <- as.splits(rtree(5)))
write.nexus.splits(sp)
spl <- allCircularSplits(5)
plot(as.networx(spl), "2D")
write.splits(spl, print.labels = FALSE)

}
\seealso{
\code{\link{prop.part}}, \code{\link{lento}},
\code{\link{as.splits}}, \code{\link{as.networx}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
