% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knots.R
\name{knots}
\alias{knots}
\alias{knots.splines2}
\title{Extract Knots from the Given Object}
\usage{
\method{knots}{splines2}(Fn, type = c("internal", "boundary"), ...)
}
\arguments{
\item{Fn}{An \code{splines2} object produced by this package.}

\item{type}{A character vector of length one indicating the type of knots to
return.  The available choices are \code{"internal"} for internal knots
and \code{"Boundary"} for boundary knots.}

\item{...}{Optional arguments that are not used now.}
}
\value{
A numerical vector.
}
\description{
Methods for the generic function \code{knots} from the \pkg{stats} package
to obtain internal or boundary knots from the objects produced by this
package.
}
\examples{
library(splines2)

set.seed(123)
x <- rnorm(100)

## B-spline basis
bsMat <- bSpline(x, df = 8, degree = 3)

## extract internal knots placed based on the quantile of x
(internal_knots <- knots(bsMat))

## extract boundary knots placed based on the range of x
boundary_knots <- knots(bsMat, type = "boundary")
all.equal(boundary_knots, range(x))
}
