/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-decompose.py and re-run.  */

/*
 * Decomposition mappings.
 *
 * Defined in UAX #44 "Unicode Character Database"
 *
 *     http://www.unicode.org/reports/tr44/
 *
 * Section 5.7.3, Table 14.
 *
 *
 * We use a two-stage lookup strategy as described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef UNICODE_DECOMPOSE_H
#define UNICODE_DECOMPOSE_H

#include <stdint.h>

/* decomposition_type
 * ------------------
 * compatibility decompositions have decomposition_type != 0
 */
enum decomposition_type {
	DECOMPOSITION_HANGUL = -1,
	DECOMPOSITION_NONE = 0,
	DECOMPOSITION_FONT = 1,
	DECOMPOSITION_NOBREAK = 2,
	DECOMPOSITION_INITIAL = 3,
	DECOMPOSITION_MEDIAL = 4,
	DECOMPOSITION_FINAL = 5,
	DECOMPOSITION_ISOLATED = 6,
	DECOMPOSITION_CIRCLE = 7,
	DECOMPOSITION_SUPER = 8,
	DECOMPOSITION_SUB = 9,
	DECOMPOSITION_VERTICAL = 10,
	DECOMPOSITION_WIDE = 11,
	DECOMPOSITION_NARROW = 12,
	DECOMPOSITION_SMALL = 13,
	DECOMPOSITION_SQUARE = 14,
	DECOMPOSITION_FRACTION = 15,
	DECOMPOSITION_COMPAT = 16
};

/* decomposition
 * -------------
 * type:   the decomposition_type
 *
 * length: the length (in codepoints) of the decomposition mapping,
 *         or 0 if there is no decomposition
 *
 * data:   the mapped-to codepoint (length = 1), or
 *         an index into the `decomposition_mapping` array, pointing
 *         to the first codepoint in the mapping (length > 1)
 */
struct decomposition {
	int type : 6;
	unsigned length : 5;
	unsigned data : 21;
};

#define DECOMPOSITION_BLOCK_SIZE 256

static const uint8_t decomposition_stage1[] = {
/* U+0000 */  0,  1,  2,  3,  4,  5,  6,  7,  7,  8,  9, 10, 11, 12, 13, 14,
/* U+1000 */ 15,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 16,  7, 17, 18, 19,
/* U+2000 */ 20, 21, 22, 23, 24,  7,  7,  7,  7,  7, 25,  7, 26, 27, 28, 29,
/* U+3000 */ 30, 31, 32, 33,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A000 */  7,  7,  7,  7,  7,  7, 34, 35,  7,  7,  7, 36, 37, 37, 37, 37,
/* U+B000 */ 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
/* U+C000 */ 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
/* U+D000 */ 37, 37, 37, 37, 37, 37, 37, 38,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7, 39, 40, 41, 42, 43, 44, 45,
/* U+10000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+11000 */ 46, 47,  7, 48, 49, 50,  7,  7,  7, 51,  7,  7,  7,  7,  7,  7,
/* U+12000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+13000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+14000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+15000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+16000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+17000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+18000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+19000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+1A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+1B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+1C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+1D000 */  7, 52,  7,  7, 53, 54, 55, 56,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+1E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7, 57,  7,
/* U+1F000 */  7, 58, 59,  7,  7,  7,  7,  7,  7,  7,  7, 60,  7,  7,  7,  7,
/* U+20000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+21000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+22000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+23000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+24000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+25000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+26000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+27000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+28000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+29000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+2F000 */  7,  7,  7,  7,  7,  7,  7,  7, 61, 62, 63,  7,  7,  7,  7,  7,
/* U+30000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+31000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+32000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+33000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+34000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+35000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+36000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+37000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+38000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+39000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+3F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+40000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+41000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+42000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+43000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+44000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+45000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+46000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+47000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+48000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+49000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+4F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+50000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+51000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+52000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+53000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+54000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+55000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+56000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+57000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+58000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+59000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+5F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+60000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+61000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+62000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+63000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+64000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+65000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+66000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+67000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+68000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+69000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+6F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+70000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+71000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+72000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+73000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+74000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+75000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+76000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+77000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+78000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+79000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+7F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+80000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+81000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+82000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+83000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+84000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+85000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+86000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+87000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+88000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+89000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+8F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+90000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+91000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+92000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+93000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+94000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+95000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+96000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+97000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+98000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+99000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+9F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+A9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AD000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+AF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+B9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BD000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+BF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+C9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CD000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+CF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+D9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DD000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+DF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+E9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+EA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+EB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+EC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+ED000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+EE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+EF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F0000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F1000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F2000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F3000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F4000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F5000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F6000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F7000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F8000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+F9000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FA000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FB000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FC000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FD000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FE000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+FF000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+100000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+101000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+102000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+103000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+104000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+105000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+106000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+107000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+108000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+109000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10A000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10B000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10C000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10D000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10E000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* U+10F000 */  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
};

static const struct decomposition decomposition_stage2[][256] = {
  /* block 0 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {2,1,0x00020},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{16,2,0x00000},{0,0,0},
   {8,1,0x00061},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,2,0x00002},{0,0,0},{0,0,0},{8,1,0x00032},{8,1,0x00033},
   {16,2,0x00004},{16,1,0x003BC},{0,0,0},{0,0,0},{16,2,0x00006},
   {8,1,0x00031},{8,1,0x0006F},{0,0,0},{15,3,0x00008},{15,3,0x0000B},
   {15,3,0x0000E},{0,0,0},{0,2,0x00011},{0,2,0x00013},{0,2,0x00015},
   {0,2,0x00017},{0,2,0x00019},{0,2,0x0001B},{0,0,0},{0,2,0x0001D},
   {0,2,0x0001F},{0,2,0x00021},{0,2,0x00023},{0,2,0x00025},{0,2,0x00027},
   {0,2,0x00029},{0,2,0x0002B},{0,2,0x0002D},{0,0,0},{0,2,0x0002F},
   {0,2,0x00031},{0,2,0x00033},{0,2,0x00035},{0,2,0x00037},{0,2,0x00039},
   {0,0,0},{0,0,0},{0,2,0x0003B},{0,2,0x0003D},{0,2,0x0003F},
   {0,2,0x00041},{0,2,0x00043},{0,0,0},{0,0,0},{0,2,0x00045},
   {0,2,0x00047},{0,2,0x00049},{0,2,0x0004B},{0,2,0x0004D},{0,2,0x0004F},
   {0,0,0},{0,2,0x00051},{0,2,0x00053},{0,2,0x00055},{0,2,0x00057},
   {0,2,0x00059},{0,2,0x0005B},{0,2,0x0005D},{0,2,0x0005F},{0,2,0x00061},
   {0,0,0},{0,2,0x00063},{0,2,0x00065},{0,2,0x00067},{0,2,0x00069},
   {0,2,0x0006B},{0,2,0x0006D},{0,0,0},{0,0,0},{0,2,0x0006F},
   {0,2,0x00071},{0,2,0x00073},{0,2,0x00075},{0,2,0x00077},{0,0,0},
   {0,2,0x00079}
  },

  /* block 1 */
  {{0,2,0x0007B},{0,2,0x0007D},{0,2,0x0007F},{0,2,0x00081},{0,2,0x00083},
   {0,2,0x00085},{0,2,0x00087},{0,2,0x00089},{0,2,0x0008B},{0,2,0x0008D},
   {0,2,0x0008F},{0,2,0x00091},{0,2,0x00093},{0,2,0x00095},{0,2,0x00097},
   {0,2,0x00099},{0,0,0},{0,0,0},{0,2,0x0009B},{0,2,0x0009D},
   {0,2,0x0009F},{0,2,0x000A1},{0,2,0x000A3},{0,2,0x000A5},{0,2,0x000A7},
   {0,2,0x000A9},{0,2,0x000AB},{0,2,0x000AD},{0,2,0x000AF},{0,2,0x000B1},
   {0,2,0x000B3},{0,2,0x000B5},{0,2,0x000B7},{0,2,0x000B9},{0,2,0x000BB},
   {0,2,0x000BD},{0,2,0x000BF},{0,2,0x000C1},{0,0,0},{0,0,0},
   {0,2,0x000C3},{0,2,0x000C5},{0,2,0x000C7},{0,2,0x000C9},{0,2,0x000CB},
   {0,2,0x000CD},{0,2,0x000CF},{0,2,0x000D1},{0,2,0x000D3},{0,0,0},
   {16,2,0x000D5},{16,2,0x000D7},{0,2,0x000D9},{0,2,0x000DB},{0,2,0x000DD},
   {0,2,0x000DF},{0,0,0},{0,2,0x000E1},{0,2,0x000E3},{0,2,0x000E5},
   {0,2,0x000E7},{0,2,0x000E9},{0,2,0x000EB},{16,2,0x000ED},{16,2,0x000EF},
   {0,0,0},{0,0,0},{0,2,0x000F1},{0,2,0x000F3},{0,2,0x000F5},
   {0,2,0x000F7},{0,2,0x000F9},{0,2,0x000FB},{16,2,0x000FD},{0,0,0},
   {0,0,0},{0,2,0x000FF},{0,2,0x00101},{0,2,0x00103},{0,2,0x00105},
   {0,2,0x00107},{0,2,0x00109},{0,0,0},{0,0,0},{0,2,0x0010B},
   {0,2,0x0010D},{0,2,0x0010F},{0,2,0x00111},{0,2,0x00113},{0,2,0x00115},
   {0,2,0x00117},{0,2,0x00119},{0,2,0x0011B},{0,2,0x0011D},{0,2,0x0011F},
   {0,2,0x00121},{0,2,0x00123},{0,2,0x00125},{0,2,0x00127},{0,2,0x00129},
   {0,2,0x0012B},{0,2,0x0012D},{0,0,0},{0,0,0},{0,2,0x0012F},
   {0,2,0x00131},{0,2,0x00133},{0,2,0x00135},{0,2,0x00137},{0,2,0x00139},
   {0,2,0x0013B},{0,2,0x0013D},{0,2,0x0013F},{0,2,0x00141},{0,2,0x00143},
   {0,2,0x00145},{0,2,0x00147},{0,2,0x00149},{0,2,0x0014B},{0,2,0x0014D},
   {0,2,0x0014F},{0,2,0x00151},{0,2,0x00153},{0,2,0x00155},{0,2,0x00157},
   {0,2,0x00159},{0,2,0x0015B},{16,1,0x00073},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x0015D},{0,2,0x0015F},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00161},{0,2,0x00163},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,2,0x00165},{16,2,0x00167},{16,2,0x00169},{16,2,0x0016B},
   {16,2,0x0016D},{16,2,0x0016F},{16,2,0x00171},{16,2,0x00173},{16,2,0x00175},
   {0,2,0x00177},{0,2,0x00179},{0,2,0x0017B},{0,2,0x0017D},{0,2,0x0017F},
   {0,2,0x00181},{0,2,0x00183},{0,2,0x00185},{0,2,0x00187},{0,2,0x00189},
   {0,2,0x0018B},{0,2,0x0018D},{0,2,0x0018F},{0,2,0x00191},{0,2,0x00193},
   {0,2,0x00195},{0,0,0},{0,2,0x00197},{0,2,0x00199},{0,2,0x0019B},
   {0,2,0x0019D},{0,2,0x0019F},{0,2,0x001A1},{0,0,0},{0,0,0},
   {0,2,0x001A3},{0,2,0x001A5},{0,2,0x001A7},{0,2,0x001A9},{0,2,0x001AB},
   {0,2,0x001AD},{0,2,0x001AF},{0,2,0x001B1},{0,2,0x001B3},{0,2,0x001B5},
   {0,2,0x001B7},{16,2,0x001B9},{16,2,0x001BB},{16,2,0x001BD},{0,2,0x001BF},
   {0,2,0x001C1},{0,0,0},{0,0,0},{0,2,0x001C3},{0,2,0x001C5},
   {0,2,0x001C7},{0,2,0x001C9},{0,2,0x001CB},{0,2,0x001CD},{0,2,0x001CF},
   {0,2,0x001D1}
  },

  /* block 2 */
  {{0,2,0x001D3},{0,2,0x001D5},{0,2,0x001D7},{0,2,0x001D9},{0,2,0x001DB},
   {0,2,0x001DD},{0,2,0x001DF},{0,2,0x001E1},{0,2,0x001E3},{0,2,0x001E5},
   {0,2,0x001E7},{0,2,0x001E9},{0,2,0x001EB},{0,2,0x001ED},{0,2,0x001EF},
   {0,2,0x001F1},{0,2,0x001F3},{0,2,0x001F5},{0,2,0x001F7},{0,2,0x001F9},
   {0,2,0x001FB},{0,2,0x001FD},{0,2,0x001FF},{0,2,0x00201},{0,2,0x00203},
   {0,2,0x00205},{0,2,0x00207},{0,2,0x00209},{0,0,0},{0,0,0},
   {0,2,0x0020B},{0,2,0x0020D},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0020F},{0,2,0x00211},
   {0,2,0x00213},{0,2,0x00215},{0,2,0x00217},{0,2,0x00219},{0,2,0x0021B},
   {0,2,0x0021D},{0,2,0x0021F},{0,2,0x00221},{0,2,0x00223},{0,2,0x00225},
   {0,2,0x00227},{0,2,0x00229},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{8,1,0x00068},{8,1,0x00266},{8,1,0x0006A},{8,1,0x00072},
   {8,1,0x00279},{8,1,0x0027B},{8,1,0x00281},{8,1,0x00077},{8,1,0x00079},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,2,0x0022B},{16,2,0x0022D},{16,2,0x0022F},{16,2,0x00231},
   {16,2,0x00233},{16,2,0x00235},{0,0,0},{0,0,0},{8,1,0x00263},
   {8,1,0x0006C},{8,1,0x00073},{8,1,0x00078},{8,1,0x00295},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 3 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,1,0x00300},
   {0,1,0x00301},{0,0,0},{0,1,0x00313},{0,2,0x00237},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,1,0x002B9},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{16,2,0x00239},{0,0,0},{0,0,0},
   {0,0,0},{0,1,0x0003B},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{16,2,0x0023B},{0,2,0x0023D},{0,2,0x0023F},
   {0,1,0x000B7},{0,2,0x00241},{0,2,0x00243},{0,2,0x00245},{0,0,0},
   {0,2,0x00247},{0,0,0},{0,2,0x00249},{0,2,0x0024B},{0,2,0x0024D},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x0024F},{0,2,0x00251},{0,2,0x00253},{0,2,0x00255},{0,2,0x00257},
   {0,2,0x00259},{0,2,0x0025B},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0025D},{0,2,0x0025F},{0,2,0x00261},
   {0,2,0x00263},{0,2,0x00265},{0,0,0},{16,1,0x003B2},{16,1,0x003B8},
   {16,1,0x003A5},{0,2,0x00267},{0,2,0x00269},{16,1,0x003C6},{16,1,0x003C0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,1,0x003BA},{16,1,0x003C1},{16,1,0x003C2},{0,0,0},{16,1,0x00398},
   {16,1,0x003B5},{0,0,0},{0,0,0},{0,0,0},{16,1,0x003A3},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 4 */
  {{0,2,0x0026B},{0,2,0x0026D},{0,0,0},{0,2,0x0026F},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00271},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00273},{0,2,0x00275},{0,2,0x00277},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00279},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0027B},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x0027D},{0,2,0x0027F},{0,0,0},{0,2,0x00281},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00283},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00285},{0,2,0x00287},{0,2,0x00289},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0028B},{0,2,0x0028D},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0028F},{0,2,0x00291},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x00293},{0,2,0x00295},
   {0,2,0x00297},{0,2,0x00299},{0,0,0},{0,0,0},{0,2,0x0029B},
   {0,2,0x0029D},{0,0,0},{0,0,0},{0,2,0x0029F},{0,2,0x002A1},
   {0,2,0x002A3},{0,2,0x002A5},{0,2,0x002A7},{0,2,0x002A9},{0,0,0},
   {0,0,0},{0,2,0x002AB},{0,2,0x002AD},{0,2,0x002AF},{0,2,0x002B1},
   {0,2,0x002B3},{0,2,0x002B5},{0,0,0},{0,0,0},{0,2,0x002B7},
   {0,2,0x002B9},{0,2,0x002BB},{0,2,0x002BD},{0,2,0x002BF},{0,2,0x002C1},
   {0,2,0x002C3},{0,2,0x002C5},{0,2,0x002C7},{0,2,0x002C9},{0,2,0x002CB},
   {0,2,0x002CD},{0,0,0},{0,0,0},{0,2,0x002CF},{0,2,0x002D1},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 5 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,2,0x002D3},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 6 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x002D5},
   {0,2,0x002D7},{0,2,0x002D9},{0,2,0x002DB},{0,2,0x002DD},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{16,2,0x002DF},{16,2,0x002E1},{16,2,0x002E3},
   {16,2,0x002E5},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x002E7},{0,0,0},{0,2,0x002E9},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x002EB},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 7 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 8 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x002ED},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x002EF},
   {0,0,0},{0,0,0},{0,2,0x002F1},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x002F3},{0,2,0x002F5},
   {0,2,0x002F7},{0,2,0x002F9},{0,2,0x002FB},{0,2,0x002FD},{0,2,0x002FF},
   {0,2,0x00301},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x00303},{0,2,0x00305},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00307},{0,2,0x00309},{0,0,0},{0,2,0x0030B},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 9 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x0030D},{0,0,0},{0,0,0},{0,2,0x0030F},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00311},
   {0,2,0x00313},{0,2,0x00315},{0,0,0},{0,0,0},{0,2,0x00317},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 10 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00319},{0,0,0},{0,0,0},
   {0,2,0x0031B},{0,2,0x0031D},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0031F},{0,2,0x00321},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x00323},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00325},{0,2,0x00327},{0,2,0x00329},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 11 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0032B},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0032D},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x0032F},
   {0,2,0x00331},{0,0,0},{0,2,0x00333},{0,2,0x00335},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 12 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00337},
   {0,2,0x00339},{0,2,0x0033B},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0033D},{0,0,0},
   {0,2,0x0033F},{0,2,0x00341},{0,2,0x00343},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 13 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,2,0x00345},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,2,0x00347},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,2,0x00349},{16,2,0x0034B},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 14 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{2,1,0x00F0B},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0034D},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0034F},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00351},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00353},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00355},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00357},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00359},{0,0,0},{0,2,0x0035B},{0,2,0x0035D},{16,2,0x0035F},
   {0,2,0x00361},{16,2,0x00363},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00365},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00367},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00369},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0036B},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0036D},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0036F},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x00371},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 15 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x00373},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{8,1,0x010DC},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 16 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x00375},{0,0,0},{0,2,0x00377},{0,0,0},
   {0,2,0x00379},{0,0,0},{0,2,0x0037B},{0,0,0},{0,2,0x0037D},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0037F},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00381},
   {0,0,0},{0,2,0x00383},{0,0,0},{0,0,0},{0,2,0x00385},
   {0,2,0x00387},{0,0,0},{0,2,0x00389},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 17 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{8,1,0x00041},
   {8,1,0x000C6},{8,1,0x00042},{0,0,0},{8,1,0x00044},{8,1,0x00045},
   {8,1,0x0018E},{8,1,0x00047},{8,1,0x00048},{8,1,0x00049},{8,1,0x0004A},
   {8,1,0x0004B},{8,1,0x0004C},{8,1,0x0004D},{8,1,0x0004E},{0,0,0},
   {8,1,0x0004F},{8,1,0x00222},{8,1,0x00050},{8,1,0x00052},{8,1,0x00054},
   {8,1,0x00055},{8,1,0x00057},{8,1,0x00061},{8,1,0x00250},{8,1,0x00251},
   {8,1,0x01D02},{8,1,0x00062},{8,1,0x00064},{8,1,0x00065},{8,1,0x00259},
   {8,1,0x0025B},{8,1,0x0025C},{8,1,0x00067},{0,0,0},{8,1,0x0006B},
   {8,1,0x0006D},{8,1,0x0014B},{8,1,0x0006F},{8,1,0x00254},{8,1,0x01D16},
   {8,1,0x01D17},{8,1,0x00070},{8,1,0x00074},{8,1,0x00075},{8,1,0x01D1D},
   {8,1,0x0026F},{8,1,0x00076},{8,1,0x01D25},{8,1,0x003B2},{8,1,0x003B3},
   {8,1,0x003B4},{8,1,0x003C6},{8,1,0x003C7},{9,1,0x00069},{9,1,0x00072},
   {9,1,0x00075},{9,1,0x00076},{9,1,0x003B2},{9,1,0x003B3},{9,1,0x003C1},
   {9,1,0x003C6},{9,1,0x003C7},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {8,1,0x0043D},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {8,1,0x00252},{8,1,0x00063},{8,1,0x00255},{8,1,0x000F0},{8,1,0x0025C},
   {8,1,0x00066},{8,1,0x0025F},{8,1,0x00261},{8,1,0x00265},{8,1,0x00268},
   {8,1,0x00269},{8,1,0x0026A},{8,1,0x01D7B},{8,1,0x0029D},{8,1,0x0026D},
   {8,1,0x01D85},{8,1,0x0029F},{8,1,0x00271},{8,1,0x00270},{8,1,0x00272},
   {8,1,0x00273},{8,1,0x00274},{8,1,0x00275},{8,1,0x00278},{8,1,0x00282},
   {8,1,0x00283},{8,1,0x001AB},{8,1,0x00289},{8,1,0x0028A},{8,1,0x01D1C},
   {8,1,0x0028B},{8,1,0x0028C},{8,1,0x0007A},{8,1,0x00290},{8,1,0x00291},
   {8,1,0x00292},{8,1,0x003B8},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 18 */
  {{0,2,0x0038B},{0,2,0x0038D},{0,2,0x0038F},{0,2,0x00391},{0,2,0x00393},
   {0,2,0x00395},{0,2,0x00397},{0,2,0x00399},{0,2,0x0039B},{0,2,0x0039D},
   {0,2,0x0039F},{0,2,0x003A1},{0,2,0x003A3},{0,2,0x003A5},{0,2,0x003A7},
   {0,2,0x003A9},{0,2,0x003AB},{0,2,0x003AD},{0,2,0x003AF},{0,2,0x003B1},
   {0,2,0x003B3},{0,2,0x003B5},{0,2,0x003B7},{0,2,0x003B9},{0,2,0x003BB},
   {0,2,0x003BD},{0,2,0x003BF},{0,2,0x003C1},{0,2,0x003C3},{0,2,0x003C5},
   {0,2,0x003C7},{0,2,0x003C9},{0,2,0x003CB},{0,2,0x003CD},{0,2,0x003CF},
   {0,2,0x003D1},{0,2,0x003D3},{0,2,0x003D5},{0,2,0x003D7},{0,2,0x003D9},
   {0,2,0x003DB},{0,2,0x003DD},{0,2,0x003DF},{0,2,0x003E1},{0,2,0x003E3},
   {0,2,0x003E5},{0,2,0x003E7},{0,2,0x003E9},{0,2,0x003EB},{0,2,0x003ED},
   {0,2,0x003EF},{0,2,0x003F1},{0,2,0x003F3},{0,2,0x003F5},{0,2,0x003F7},
   {0,2,0x003F9},{0,2,0x003FB},{0,2,0x003FD},{0,2,0x003FF},{0,2,0x00401},
   {0,2,0x00403},{0,2,0x00405},{0,2,0x00407},{0,2,0x00409},{0,2,0x0040B},
   {0,2,0x0040D},{0,2,0x0040F},{0,2,0x00411},{0,2,0x00413},{0,2,0x00415},
   {0,2,0x00417},{0,2,0x00419},{0,2,0x0041B},{0,2,0x0041D},{0,2,0x0041F},
   {0,2,0x00421},{0,2,0x00423},{0,2,0x00425},{0,2,0x00427},{0,2,0x00429},
   {0,2,0x0042B},{0,2,0x0042D},{0,2,0x0042F},{0,2,0x00431},{0,2,0x00433},
   {0,2,0x00435},{0,2,0x00437},{0,2,0x00439},{0,2,0x0043B},{0,2,0x0043D},
   {0,2,0x0043F},{0,2,0x00441},{0,2,0x00443},{0,2,0x00445},{0,2,0x00447},
   {0,2,0x00449},{0,2,0x0044B},{0,2,0x0044D},{0,2,0x0044F},{0,2,0x00451},
   {0,2,0x00453},{0,2,0x00455},{0,2,0x00457},{0,2,0x00459},{0,2,0x0045B},
   {0,2,0x0045D},{0,2,0x0045F},{0,2,0x00461},{0,2,0x00463},{0,2,0x00465},
   {0,2,0x00467},{0,2,0x00469},{0,2,0x0046B},{0,2,0x0046D},{0,2,0x0046F},
   {0,2,0x00471},{0,2,0x00473},{0,2,0x00475},{0,2,0x00477},{0,2,0x00479},
   {0,2,0x0047B},{0,2,0x0047D},{0,2,0x0047F},{0,2,0x00481},{0,2,0x00483},
   {0,2,0x00485},{0,2,0x00487},{0,2,0x00489},{0,2,0x0048B},{0,2,0x0048D},
   {0,2,0x0048F},{0,2,0x00491},{0,2,0x00493},{0,2,0x00495},{0,2,0x00497},
   {0,2,0x00499},{0,2,0x0049B},{0,2,0x0049D},{0,2,0x0049F},{0,2,0x004A1},
   {0,2,0x004A3},{0,2,0x004A5},{0,2,0x004A7},{0,2,0x004A9},{0,2,0x004AB},
   {0,2,0x004AD},{0,2,0x004AF},{0,2,0x004B1},{0,2,0x004B3},{0,2,0x004B5},
   {0,2,0x004B7},{0,2,0x004B9},{0,2,0x004BB},{0,2,0x004BD},{16,2,0x004BF},
   {0,2,0x004C1},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x004C3},{0,2,0x004C5},{0,2,0x004C7},{0,2,0x004C9},{0,2,0x004CB},
   {0,2,0x004CD},{0,2,0x004CF},{0,2,0x004D1},{0,2,0x004D3},{0,2,0x004D5},
   {0,2,0x004D7},{0,2,0x004D9},{0,2,0x004DB},{0,2,0x004DD},{0,2,0x004DF},
   {0,2,0x004E1},{0,2,0x004E3},{0,2,0x004E5},{0,2,0x004E7},{0,2,0x004E9},
   {0,2,0x004EB},{0,2,0x004ED},{0,2,0x004EF},{0,2,0x004F1},{0,2,0x004F3},
   {0,2,0x004F5},{0,2,0x004F7},{0,2,0x004F9},{0,2,0x004FB},{0,2,0x004FD},
   {0,2,0x004FF},{0,2,0x00501},{0,2,0x00503},{0,2,0x00505},{0,2,0x00507},
   {0,2,0x00509},{0,2,0x0050B},{0,2,0x0050D},{0,2,0x0050F},{0,2,0x00511},
   {0,2,0x00513},{0,2,0x00515},{0,2,0x00517},{0,2,0x00519},{0,2,0x0051B},
   {0,2,0x0051D},{0,2,0x0051F},{0,2,0x00521},{0,2,0x00523},{0,2,0x00525},
   {0,2,0x00527},{0,2,0x00529},{0,2,0x0052B},{0,2,0x0052D},{0,2,0x0052F},
   {0,2,0x00531},{0,2,0x00533},{0,2,0x00535},{0,2,0x00537},{0,2,0x00539},
   {0,2,0x0053B},{0,2,0x0053D},{0,2,0x0053F},{0,2,0x00541},{0,2,0x00543},
   {0,2,0x00545},{0,2,0x00547},{0,2,0x00549},{0,2,0x0054B},{0,2,0x0054D},
   {0,2,0x0054F},{0,2,0x00551},{0,2,0x00553},{0,2,0x00555},{0,2,0x00557},
   {0,2,0x00559},{0,2,0x0055B},{0,2,0x0055D},{0,2,0x0055F},{0,2,0x00561},
   {0,2,0x00563},{0,2,0x00565},{0,2,0x00567},{0,2,0x00569},{0,2,0x0056B},
   {0,2,0x0056D},{0,2,0x0056F},{0,2,0x00571},{0,2,0x00573},{0,2,0x00575},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 19 */
  {{0,2,0x00577},{0,2,0x00579},{0,2,0x0057B},{0,2,0x0057D},{0,2,0x0057F},
   {0,2,0x00581},{0,2,0x00583},{0,2,0x00585},{0,2,0x00587},{0,2,0x00589},
   {0,2,0x0058B},{0,2,0x0058D},{0,2,0x0058F},{0,2,0x00591},{0,2,0x00593},
   {0,2,0x00595},{0,2,0x00597},{0,2,0x00599},{0,2,0x0059B},{0,2,0x0059D},
   {0,2,0x0059F},{0,2,0x005A1},{0,0,0},{0,0,0},{0,2,0x005A3},
   {0,2,0x005A5},{0,2,0x005A7},{0,2,0x005A9},{0,2,0x005AB},{0,2,0x005AD},
   {0,0,0},{0,0,0},{0,2,0x005AF},{0,2,0x005B1},{0,2,0x005B3},
   {0,2,0x005B5},{0,2,0x005B7},{0,2,0x005B9},{0,2,0x005BB},{0,2,0x005BD},
   {0,2,0x005BF},{0,2,0x005C1},{0,2,0x005C3},{0,2,0x005C5},{0,2,0x005C7},
   {0,2,0x005C9},{0,2,0x005CB},{0,2,0x005CD},{0,2,0x005CF},{0,2,0x005D1},
   {0,2,0x005D3},{0,2,0x005D5},{0,2,0x005D7},{0,2,0x005D9},{0,2,0x005DB},
   {0,2,0x005DD},{0,2,0x005DF},{0,2,0x005E1},{0,2,0x005E3},{0,2,0x005E5},
   {0,2,0x005E7},{0,2,0x005E9},{0,2,0x005EB},{0,2,0x005ED},{0,2,0x005EF},
   {0,2,0x005F1},{0,2,0x005F3},{0,2,0x005F5},{0,2,0x005F7},{0,2,0x005F9},
   {0,0,0},{0,0,0},{0,2,0x005FB},{0,2,0x005FD},{0,2,0x005FF},
   {0,2,0x00601},{0,2,0x00603},{0,2,0x00605},{0,0,0},{0,0,0},
   {0,2,0x00607},{0,2,0x00609},{0,2,0x0060B},{0,2,0x0060D},{0,2,0x0060F},
   {0,2,0x00611},{0,2,0x00613},{0,2,0x00615},{0,0,0},{0,2,0x00617},
   {0,0,0},{0,2,0x00619},{0,0,0},{0,2,0x0061B},{0,0,0},
   {0,2,0x0061D},{0,2,0x0061F},{0,2,0x00621},{0,2,0x00623},{0,2,0x00625},
   {0,2,0x00627},{0,2,0x00629},{0,2,0x0062B},{0,2,0x0062D},{0,2,0x0062F},
   {0,2,0x00631},{0,2,0x00633},{0,2,0x00635},{0,2,0x00637},{0,2,0x00639},
   {0,2,0x0063B},{0,2,0x0063D},{0,2,0x0063F},{0,1,0x003AC},{0,2,0x00641},
   {0,1,0x003AD},{0,2,0x00643},{0,1,0x003AE},{0,2,0x00645},{0,1,0x003AF},
   {0,2,0x00647},{0,1,0x003CC},{0,2,0x00649},{0,1,0x003CD},{0,2,0x0064B},
   {0,1,0x003CE},{0,0,0},{0,0,0},{0,2,0x0064D},{0,2,0x0064F},
   {0,2,0x00651},{0,2,0x00653},{0,2,0x00655},{0,2,0x00657},{0,2,0x00659},
   {0,2,0x0065B},{0,2,0x0065D},{0,2,0x0065F},{0,2,0x00661},{0,2,0x00663},
   {0,2,0x00665},{0,2,0x00667},{0,2,0x00669},{0,2,0x0066B},{0,2,0x0066D},
   {0,2,0x0066F},{0,2,0x00671},{0,2,0x00673},{0,2,0x00675},{0,2,0x00677},
   {0,2,0x00679},{0,2,0x0067B},{0,2,0x0067D},{0,2,0x0067F},{0,2,0x00681},
   {0,2,0x00683},{0,2,0x00685},{0,2,0x00687},{0,2,0x00689},{0,2,0x0068B},
   {0,2,0x0068D},{0,2,0x0068F},{0,2,0x00691},{0,2,0x00693},{0,2,0x00695},
   {0,2,0x00697},{0,2,0x00699},{0,2,0x0069B},{0,2,0x0069D},{0,2,0x0069F},
   {0,2,0x006A1},{0,2,0x006A3},{0,2,0x006A5},{0,2,0x006A7},{0,2,0x006A9},
   {0,2,0x006AB},{0,2,0x006AD},{0,2,0x006AF},{0,2,0x006B1},{0,2,0x006B3},
   {0,2,0x006B5},{0,0,0},{0,2,0x006B7},{0,2,0x006B9},{0,2,0x006BB},
   {0,2,0x006BD},{0,2,0x006BF},{0,1,0x00386},{0,2,0x006C1},{16,2,0x006C3},
   {0,1,0x003B9},{16,2,0x006C5},{16,2,0x006C7},{0,2,0x006C9},{0,2,0x006CB},
   {0,2,0x006CD},{0,2,0x006CF},{0,0,0},{0,2,0x006D1},{0,2,0x006D3},
   {0,2,0x006D5},{0,1,0x00388},{0,2,0x006D7},{0,1,0x00389},{0,2,0x006D9},
   {0,2,0x006DB},{0,2,0x006DD},{0,2,0x006DF},{0,2,0x006E1},{0,2,0x006E3},
   {0,2,0x006E5},{0,1,0x00390},{0,0,0},{0,0,0},{0,2,0x006E7},
   {0,2,0x006E9},{0,2,0x006EB},{0,2,0x006ED},{0,2,0x006EF},{0,1,0x0038A},
   {0,0,0},{0,2,0x006F1},{0,2,0x006F3},{0,2,0x006F5},{0,2,0x006F7},
   {0,2,0x006F9},{0,2,0x006FB},{0,1,0x003B0},{0,2,0x006FD},{0,2,0x006FF},
   {0,2,0x00701},{0,2,0x00703},{0,2,0x00705},{0,2,0x00707},{0,2,0x00709},
   {0,1,0x0038E},{0,2,0x0070B},{0,2,0x0070D},{0,1,0x00385},{0,1,0x00060},
   {0,0,0},{0,0,0},{0,2,0x0070F},{0,2,0x00711},{0,2,0x00713},
   {0,0,0},{0,2,0x00715},{0,2,0x00717},{0,2,0x00719},{0,1,0x0038C},
   {0,2,0x0071B},{0,1,0x0038F},{0,2,0x0071D},{0,1,0x000B4},{16,2,0x0071F},
   {0,0,0}
  },

  /* block 20 */
  {{0,1,0x02002},{0,1,0x02003},{16,1,0x00020},{16,1,0x00020},{16,1,0x00020},
   {16,1,0x00020},{16,1,0x00020},{2,1,0x00020},{16,1,0x00020},{16,1,0x00020},
   {16,1,0x00020},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{2,1,0x02010},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{16,2,0x00721},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,1,0x0002E},{16,2,0x00723},{16,3,0x00725},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{2,1,0x00020},{0,0,0},{0,0,0},
   {0,0,0},{16,2,0x00728},{16,3,0x0072A},{0,0,0},{16,2,0x0072D},
   {16,3,0x0072F},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,2,0x00732},{0,0,0},{16,2,0x00734},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,2,0x00736},{16,2,0x00738},{16,2,0x0073A},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{16,4,0x0073C},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,1,0x00020},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{8,1,0x00030},{8,1,0x00069},{0,0,0},
   {0,0,0},{8,1,0x00034},{8,1,0x00035},{8,1,0x00036},{8,1,0x00037},
   {8,1,0x00038},{8,1,0x00039},{8,1,0x0002B},{8,1,0x02212},{8,1,0x0003D},
   {8,1,0x00028},{8,1,0x00029},{8,1,0x0006E},{9,1,0x00030},{9,1,0x00031},
   {9,1,0x00032},{9,1,0x00033},{9,1,0x00034},{9,1,0x00035},{9,1,0x00036},
   {9,1,0x00037},{9,1,0x00038},{9,1,0x00039},{9,1,0x0002B},{9,1,0x02212},
   {9,1,0x0003D},{9,1,0x00028},{9,1,0x00029},{0,0,0},{9,1,0x00061},
   {9,1,0x00065},{9,1,0x0006F},{9,1,0x00078},{9,1,0x00259},{9,1,0x00068},
   {9,1,0x0006B},{9,1,0x0006C},{9,1,0x0006D},{9,1,0x0006E},{9,1,0x00070},
   {9,1,0x00073},{9,1,0x00074},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{16,2,0x00740},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 21 */
  {{16,3,0x00742},{16,3,0x00745},{1,1,0x00043},{16,2,0x00748},{0,0,0},
   {16,3,0x0074A},{16,3,0x0074D},{16,1,0x00190},{0,0,0},{16,2,0x00750},
   {1,1,0x00067},{1,1,0x00048},{1,1,0x00048},{1,1,0x00048},{1,1,0x00068},
   {1,1,0x00127},{1,1,0x00049},{1,1,0x00049},{1,1,0x0004C},{1,1,0x0006C},
   {0,0,0},{1,1,0x0004E},{16,2,0x00752},{0,0,0},{0,0,0},
   {1,1,0x00050},{1,1,0x00051},{1,1,0x00052},{1,1,0x00052},{1,1,0x00052},
   {0,0,0},{0,0,0},{8,2,0x00754},{16,3,0x00756},{8,2,0x00759},
   {0,0,0},{1,1,0x0005A},{0,0,0},{0,1,0x003A9},{0,0,0},
   {1,1,0x0005A},{0,0,0},{0,1,0x0004B},{0,1,0x000C5},{1,1,0x00042},
   {1,1,0x00043},{0,0,0},{1,1,0x00065},{1,1,0x00045},{1,1,0x00046},
   {0,0,0},{1,1,0x0004D},{1,1,0x0006F},{16,1,0x005D0},{16,1,0x005D1},
   {16,1,0x005D2},{16,1,0x005D3},{1,1,0x00069},{0,0,0},{16,3,0x0075B},
   {1,1,0x003C0},{1,1,0x003B3},{1,1,0x00393},{1,1,0x003A0},{1,1,0x02211},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{1,1,0x00044},
   {1,1,0x00064},{1,1,0x00065},{1,1,0x00069},{1,1,0x0006A},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {15,3,0x0075E},{15,3,0x00761},{15,4,0x00764},{15,3,0x00768},{15,3,0x0076B},
   {15,3,0x0076E},{15,3,0x00771},{15,3,0x00774},{15,3,0x00777},{15,3,0x0077A},
   {15,3,0x0077D},{15,3,0x00780},{15,3,0x00783},{15,3,0x00786},{15,3,0x00789},
   {15,2,0x0078C},{16,1,0x00049},{16,2,0x0078E},{16,3,0x00790},{16,2,0x00793},
   {16,1,0x00056},{16,2,0x00795},{16,3,0x00797},{16,4,0x0079A},{16,2,0x0079E},
   {16,1,0x00058},{16,2,0x007A0},{16,3,0x007A2},{16,1,0x0004C},{16,1,0x00043},
   {16,1,0x00044},{16,1,0x0004D},{16,1,0x00069},{16,2,0x007A5},{16,3,0x007A7},
   {16,2,0x007AA},{16,1,0x00076},{16,2,0x007AC},{16,3,0x007AE},{16,4,0x007B1},
   {16,2,0x007B5},{16,1,0x00078},{16,2,0x007B7},{16,3,0x007B9},{16,1,0x0006C},
   {16,1,0x00063},{16,1,0x00064},{16,1,0x0006D},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{15,3,0x007BC},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x007BF},
   {0,2,0x007C1},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x007C3},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x007C5},{0,2,0x007C7},{0,2,0x007C9},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 22 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x007CB},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x007CD},
   {0,0,0},{0,0,0},{0,2,0x007CF},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x007D1},{0,0,0},{0,2,0x007D3},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,2,0x007D5},
   {16,3,0x007D7},{0,0,0},{16,2,0x007DA},{16,3,0x007DC},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x007DF},{0,0,0},{0,0,0},{0,2,0x007E1},{0,0,0},
   {0,0,0},{0,2,0x007E3},{0,0,0},{0,2,0x007E5},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x007E7},{0,0,0},{0,2,0x007E9},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x007EB},
   {0,2,0x007ED},{0,2,0x007EF},{0,2,0x007F1},{0,2,0x007F3},{0,0,0},
   {0,0,0},{0,2,0x007F5},{0,2,0x007F7},{0,0,0},{0,0,0},
   {0,2,0x007F9},{0,2,0x007FB},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x007FD},{0,2,0x007FF},
   {0,0,0},{0,0,0},{0,2,0x00801},{0,2,0x00803},{0,0,0},
   {0,0,0},{0,2,0x00805},{0,2,0x00807},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00809},{0,2,0x0080B},{0,2,0x0080D},
   {0,2,0x0080F},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00811},
   {0,2,0x00813},{0,2,0x00815},{0,2,0x00817},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00819},
   {0,2,0x0081B},{0,2,0x0081D},{0,2,0x0081F},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 23 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,1,0x03008},{0,1,0x03009},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 24 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{7,1,0x00031},{7,1,0x00032},{7,1,0x00033},{7,1,0x00034},
   {7,1,0x00035},{7,1,0x00036},{7,1,0x00037},{7,1,0x00038},{7,1,0x00039},
   {7,2,0x00821},{7,2,0x00823},{7,2,0x00825},{7,2,0x00827},{7,2,0x00829},
   {7,2,0x0082B},{7,2,0x0082D},{7,2,0x0082F},{7,2,0x00831},{7,2,0x00833},
   {7,2,0x00835},{16,3,0x00837},{16,3,0x0083A},{16,3,0x0083D},{16,3,0x00840},
   {16,3,0x00843},{16,3,0x00846},{16,3,0x00849},{16,3,0x0084C},{16,3,0x0084F},
   {16,4,0x00852},{16,4,0x00856},{16,4,0x0085A},{16,4,0x0085E},{16,4,0x00862},
   {16,4,0x00866},{16,4,0x0086A},{16,4,0x0086E},{16,4,0x00872},{16,4,0x00876},
   {16,4,0x0087A},{16,2,0x0087E},{16,2,0x00880},{16,2,0x00882},{16,2,0x00884},
   {16,2,0x00886},{16,2,0x00888},{16,2,0x0088A},{16,2,0x0088C},{16,2,0x0088E},
   {16,3,0x00890},{16,3,0x00893},{16,3,0x00896},{16,3,0x00899},{16,3,0x0089C},
   {16,3,0x0089F},{16,3,0x008A2},{16,3,0x008A5},{16,3,0x008A8},{16,3,0x008AB},
   {16,3,0x008AE},{16,3,0x008B1},{16,3,0x008B4},{16,3,0x008B7},{16,3,0x008BA},
   {16,3,0x008BD},{16,3,0x008C0},{16,3,0x008C3},{16,3,0x008C6},{16,3,0x008C9},
   {16,3,0x008CC},{16,3,0x008CF},{16,3,0x008D2},{16,3,0x008D5},{16,3,0x008D8},
   {16,3,0x008DB},{16,3,0x008DE},{16,3,0x008E1},{16,3,0x008E4},{16,3,0x008E7},
   {16,3,0x008EA},{16,3,0x008ED},{16,3,0x008F0},{16,3,0x008F3},{16,3,0x008F6},
   {16,3,0x008F9},{16,3,0x008FC},{7,1,0x00041},{7,1,0x00042},{7,1,0x00043},
   {7,1,0x00044},{7,1,0x00045},{7,1,0x00046},{7,1,0x00047},{7,1,0x00048},
   {7,1,0x00049},{7,1,0x0004A},{7,1,0x0004B},{7,1,0x0004C},{7,1,0x0004D},
   {7,1,0x0004E},{7,1,0x0004F},{7,1,0x00050},{7,1,0x00051},{7,1,0x00052},
   {7,1,0x00053},{7,1,0x00054},{7,1,0x00055},{7,1,0x00056},{7,1,0x00057},
   {7,1,0x00058},{7,1,0x00059},{7,1,0x0005A},{7,1,0x00061},{7,1,0x00062},
   {7,1,0x00063},{7,1,0x00064},{7,1,0x00065},{7,1,0x00066},{7,1,0x00067},
   {7,1,0x00068},{7,1,0x00069},{7,1,0x0006A},{7,1,0x0006B},{7,1,0x0006C},
   {7,1,0x0006D},{7,1,0x0006E},{7,1,0x0006F},{7,1,0x00070},{7,1,0x00071},
   {7,1,0x00072},{7,1,0x00073},{7,1,0x00074},{7,1,0x00075},{7,1,0x00076},
   {7,1,0x00077},{7,1,0x00078},{7,1,0x00079},{7,1,0x0007A},{7,1,0x00030},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 25 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{16,4,0x008FF},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,3,0x00903},{16,2,0x00906},{16,3,0x00908},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x0090B},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 26 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{9,1,0x0006A},
   {8,1,0x00056},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 27 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{8,1,0x02D61},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 28 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,1,0x06BCD},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{16,1,0x09F9F},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 29 */
  {{16,1,0x04E00},{16,1,0x04E28},{16,1,0x04E36},{16,1,0x04E3F},{16,1,0x04E59},
   {16,1,0x04E85},{16,1,0x04E8C},{16,1,0x04EA0},{16,1,0x04EBA},{16,1,0x0513F},
   {16,1,0x05165},{16,1,0x0516B},{16,1,0x05182},{16,1,0x05196},{16,1,0x051AB},
   {16,1,0x051E0},{16,1,0x051F5},{16,1,0x05200},{16,1,0x0529B},{16,1,0x052F9},
   {16,1,0x05315},{16,1,0x0531A},{16,1,0x05338},{16,1,0x05341},{16,1,0x0535C},
   {16,1,0x05369},{16,1,0x05382},{16,1,0x053B6},{16,1,0x053C8},{16,1,0x053E3},
   {16,1,0x056D7},{16,1,0x0571F},{16,1,0x058EB},{16,1,0x05902},{16,1,0x0590A},
   {16,1,0x05915},{16,1,0x05927},{16,1,0x05973},{16,1,0x05B50},{16,1,0x05B80},
   {16,1,0x05BF8},{16,1,0x05C0F},{16,1,0x05C22},{16,1,0x05C38},{16,1,0x05C6E},
   {16,1,0x05C71},{16,1,0x05DDB},{16,1,0x05DE5},{16,1,0x05DF1},{16,1,0x05DFE},
   {16,1,0x05E72},{16,1,0x05E7A},{16,1,0x05E7F},{16,1,0x05EF4},{16,1,0x05EFE},
   {16,1,0x05F0B},{16,1,0x05F13},{16,1,0x05F50},{16,1,0x05F61},{16,1,0x05F73},
   {16,1,0x05FC3},{16,1,0x06208},{16,1,0x06236},{16,1,0x0624B},{16,1,0x0652F},
   {16,1,0x06534},{16,1,0x06587},{16,1,0x06597},{16,1,0x065A4},{16,1,0x065B9},
   {16,1,0x065E0},{16,1,0x065E5},{16,1,0x066F0},{16,1,0x06708},{16,1,0x06728},
   {16,1,0x06B20},{16,1,0x06B62},{16,1,0x06B79},{16,1,0x06BB3},{16,1,0x06BCB},
   {16,1,0x06BD4},{16,1,0x06BDB},{16,1,0x06C0F},{16,1,0x06C14},{16,1,0x06C34},
   {16,1,0x0706B},{16,1,0x0722A},{16,1,0x07236},{16,1,0x0723B},{16,1,0x0723F},
   {16,1,0x07247},{16,1,0x07259},{16,1,0x0725B},{16,1,0x072AC},{16,1,0x07384},
   {16,1,0x07389},{16,1,0x074DC},{16,1,0x074E6},{16,1,0x07518},{16,1,0x0751F},
   {16,1,0x07528},{16,1,0x07530},{16,1,0x0758B},{16,1,0x07592},{16,1,0x07676},
   {16,1,0x0767D},{16,1,0x076AE},{16,1,0x076BF},{16,1,0x076EE},{16,1,0x077DB},
   {16,1,0x077E2},{16,1,0x077F3},{16,1,0x0793A},{16,1,0x079B8},{16,1,0x079BE},
   {16,1,0x07A74},{16,1,0x07ACB},{16,1,0x07AF9},{16,1,0x07C73},{16,1,0x07CF8},
   {16,1,0x07F36},{16,1,0x07F51},{16,1,0x07F8A},{16,1,0x07FBD},{16,1,0x08001},
   {16,1,0x0800C},{16,1,0x08012},{16,1,0x08033},{16,1,0x0807F},{16,1,0x08089},
   {16,1,0x081E3},{16,1,0x081EA},{16,1,0x081F3},{16,1,0x081FC},{16,1,0x0820C},
   {16,1,0x0821B},{16,1,0x0821F},{16,1,0x0826E},{16,1,0x08272},{16,1,0x08278},
   {16,1,0x0864D},{16,1,0x0866B},{16,1,0x08840},{16,1,0x0884C},{16,1,0x08863},
   {16,1,0x0897E},{16,1,0x0898B},{16,1,0x089D2},{16,1,0x08A00},{16,1,0x08C37},
   {16,1,0x08C46},{16,1,0x08C55},{16,1,0x08C78},{16,1,0x08C9D},{16,1,0x08D64},
   {16,1,0x08D70},{16,1,0x08DB3},{16,1,0x08EAB},{16,1,0x08ECA},{16,1,0x08F9B},
   {16,1,0x08FB0},{16,1,0x08FB5},{16,1,0x09091},{16,1,0x09149},{16,1,0x091C6},
   {16,1,0x091CC},{16,1,0x091D1},{16,1,0x09577},{16,1,0x09580},{16,1,0x0961C},
   {16,1,0x096B6},{16,1,0x096B9},{16,1,0x096E8},{16,1,0x09751},{16,1,0x0975E},
   {16,1,0x09762},{16,1,0x09769},{16,1,0x097CB},{16,1,0x097ED},{16,1,0x097F3},
   {16,1,0x09801},{16,1,0x098A8},{16,1,0x098DB},{16,1,0x098DF},{16,1,0x09996},
   {16,1,0x09999},{16,1,0x099AC},{16,1,0x09AA8},{16,1,0x09AD8},{16,1,0x09ADF},
   {16,1,0x09B25},{16,1,0x09B2F},{16,1,0x09B32},{16,1,0x09B3C},{16,1,0x09B5A},
   {16,1,0x09CE5},{16,1,0x09E75},{16,1,0x09E7F},{16,1,0x09EA5},{16,1,0x09EBB},
   {16,1,0x09EC3},{16,1,0x09ECD},{16,1,0x09ED1},{16,1,0x09EF9},{16,1,0x09EFD},
   {16,1,0x09F0E},{16,1,0x09F13},{16,1,0x09F20},{16,1,0x09F3B},{16,1,0x09F4A},
   {16,1,0x09F52},{16,1,0x09F8D},{16,1,0x09F9C},{16,1,0x09FA0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 30 */
  {{11,1,0x00020},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,1,0x03012},
   {0,0,0},{16,1,0x05341},{16,1,0x05344},{16,1,0x05345},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x0090D},{0,0,0},{0,2,0x0090F},{0,0,0},
   {0,2,0x00911},{0,0,0},{0,2,0x00913},{0,0,0},{0,2,0x00915},
   {0,0,0},{0,2,0x00917},{0,0,0},{0,2,0x00919},{0,0,0},
   {0,2,0x0091B},{0,0,0},{0,2,0x0091D},{0,0,0},{0,2,0x0091F},
   {0,0,0},{0,2,0x00921},{0,0,0},{0,2,0x00923},{0,0,0},
   {0,0,0},{0,2,0x00925},{0,0,0},{0,2,0x00927},{0,0,0},
   {0,2,0x00929},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x0092B},{0,2,0x0092D},{0,0,0},
   {0,2,0x0092F},{0,2,0x00931},{0,0,0},{0,2,0x00933},{0,2,0x00935},
   {0,0,0},{0,2,0x00937},{0,2,0x00939},{0,0,0},{0,2,0x0093B},
   {0,2,0x0093D},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x0093F},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {16,2,0x00941},{16,2,0x00943},{0,0,0},{0,2,0x00945},{10,2,0x00947},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x00949},{0,0,0},{0,2,0x0094B},
   {0,0,0},{0,2,0x0094D},{0,0,0},{0,2,0x0094F},{0,0,0},
   {0,2,0x00951},{0,0,0},{0,2,0x00953},{0,0,0},{0,2,0x00955},
   {0,0,0},{0,2,0x00957},{0,0,0},{0,2,0x00959},{0,0,0},
   {0,2,0x0095B},{0,0,0},{0,2,0x0095D},{0,0,0},{0,2,0x0095F},
   {0,0,0},{0,0,0},{0,2,0x00961},{0,0,0},{0,2,0x00963},
   {0,0,0},{0,2,0x00965},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,2,0x00967},{0,2,0x00969},
   {0,0,0},{0,2,0x0096B},{0,2,0x0096D},{0,0,0},{0,2,0x0096F},
   {0,2,0x00971},{0,0,0},{0,2,0x00973},{0,2,0x00975},{0,0,0},
   {0,2,0x00977},{0,2,0x00979},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x0097B},
   {0,0,0},{0,0,0},{0,2,0x0097D},{0,2,0x0097F},{0,2,0x00981},
   {0,2,0x00983},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00985},
   {10,2,0x00987}
  },

  /* block 31 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,1,0x01100},
   {16,1,0x01101},{16,1,0x011AA},{16,1,0x01102},{16,1,0x011AC},{16,1,0x011AD},
   {16,1,0x01103},{16,1,0x01104},{16,1,0x01105},{16,1,0x011B0},{16,1,0x011B1},
   {16,1,0x011B2},{16,1,0x011B3},{16,1,0x011B4},{16,1,0x011B5},{16,1,0x0111A},
   {16,1,0x01106},{16,1,0x01107},{16,1,0x01108},{16,1,0x01121},{16,1,0x01109},
   {16,1,0x0110A},{16,1,0x0110B},{16,1,0x0110C},{16,1,0x0110D},{16,1,0x0110E},
   {16,1,0x0110F},{16,1,0x01110},{16,1,0x01111},{16,1,0x01112},{16,1,0x01161},
   {16,1,0x01162},{16,1,0x01163},{16,1,0x01164},{16,1,0x01165},{16,1,0x01166},
   {16,1,0x01167},{16,1,0x01168},{16,1,0x01169},{16,1,0x0116A},{16,1,0x0116B},
   {16,1,0x0116C},{16,1,0x0116D},{16,1,0x0116E},{16,1,0x0116F},{16,1,0x01170},
   {16,1,0x01171},{16,1,0x01172},{16,1,0x01173},{16,1,0x01174},{16,1,0x01175},
   {16,1,0x01160},{16,1,0x01114},{16,1,0x01115},{16,1,0x011C7},{16,1,0x011C8},
   {16,1,0x011CC},{16,1,0x011CE},{16,1,0x011D3},{16,1,0x011D7},{16,1,0x011D9},
   {16,1,0x0111C},{16,1,0x011DD},{16,1,0x011DF},{16,1,0x0111D},{16,1,0x0111E},
   {16,1,0x01120},{16,1,0x01122},{16,1,0x01123},{16,1,0x01127},{16,1,0x01129},
   {16,1,0x0112B},{16,1,0x0112C},{16,1,0x0112D},{16,1,0x0112E},{16,1,0x0112F},
   {16,1,0x01132},{16,1,0x01136},{16,1,0x01140},{16,1,0x01147},{16,1,0x0114C},
   {16,1,0x011F1},{16,1,0x011F2},{16,1,0x01157},{16,1,0x01158},{16,1,0x01159},
   {16,1,0x01184},{16,1,0x01185},{16,1,0x01188},{16,1,0x01191},{16,1,0x01192},
   {16,1,0x01194},{16,1,0x0119E},{16,1,0x011A1},{0,0,0},{0,0,0},
   {0,0,0},{8,1,0x04E00},{8,1,0x04E8C},{8,1,0x04E09},{8,1,0x056DB},
   {8,1,0x04E0A},{8,1,0x04E2D},{8,1,0x04E0B},{8,1,0x07532},{8,1,0x04E59},
   {8,1,0x04E19},{8,1,0x04E01},{8,1,0x05929},{8,1,0x05730},{8,1,0x04EBA},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 32 */
  {{16,3,0x00989},{16,3,0x0098C},{16,3,0x0098F},{16,3,0x00992},{16,3,0x00995},
   {16,3,0x00998},{16,3,0x0099B},{16,3,0x0099E},{16,3,0x009A1},{16,3,0x009A4},
   {16,3,0x009A7},{16,3,0x009AA},{16,3,0x009AD},{16,3,0x009B0},{16,4,0x009B3},
   {16,4,0x009B7},{16,4,0x009BB},{16,4,0x009BF},{16,4,0x009C3},{16,4,0x009C7},
   {16,4,0x009CB},{16,4,0x009CF},{16,4,0x009D3},{16,4,0x009D7},{16,4,0x009DB},
   {16,4,0x009DF},{16,4,0x009E3},{16,4,0x009E7},{16,4,0x009EB},{16,7,0x009EF},
   {16,6,0x009F6},{0,0,0},{16,3,0x009FC},{16,3,0x009FF},{16,3,0x00A02},
   {16,3,0x00A05},{16,3,0x00A08},{16,3,0x00A0B},{16,3,0x00A0E},{16,3,0x00A11},
   {16,3,0x00A14},{16,3,0x00A17},{16,3,0x00A1A},{16,3,0x00A1D},{16,3,0x00A20},
   {16,3,0x00A23},{16,3,0x00A26},{16,3,0x00A29},{16,3,0x00A2C},{16,3,0x00A2F},
   {16,3,0x00A32},{16,3,0x00A35},{16,3,0x00A38},{16,3,0x00A3B},{16,3,0x00A3E},
   {16,3,0x00A41},{16,3,0x00A44},{16,3,0x00A47},{16,3,0x00A4A},{16,3,0x00A4D},
   {16,3,0x00A50},{16,3,0x00A53},{16,3,0x00A56},{16,3,0x00A59},{16,3,0x00A5C},
   {16,3,0x00A5F},{16,3,0x00A62},{16,3,0x00A65},{7,1,0x0554F},{7,1,0x05E7C},
   {7,1,0x06587},{7,1,0x07B8F},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {14,3,0x00A68},{7,2,0x00A6B},{7,2,0x00A6D},{7,2,0x00A6F},{7,2,0x00A71},
   {7,2,0x00A73},{7,2,0x00A75},{7,2,0x00A77},{7,2,0x00A79},{7,2,0x00A7B},
   {7,2,0x00A7D},{7,2,0x00A7F},{7,2,0x00A81},{7,2,0x00A83},{7,2,0x00A85},
   {7,2,0x00A87},{7,1,0x01100},{7,1,0x01102},{7,1,0x01103},{7,1,0x01105},
   {7,1,0x01106},{7,1,0x01107},{7,1,0x01109},{7,1,0x0110B},{7,1,0x0110C},
   {7,1,0x0110E},{7,1,0x0110F},{7,1,0x01110},{7,1,0x01111},{7,1,0x01112},
   {7,2,0x00A89},{7,2,0x00A8B},{7,2,0x00A8D},{7,2,0x00A8F},{7,2,0x00A91},
   {7,2,0x00A93},{7,2,0x00A95},{7,2,0x00A97},{7,2,0x00A99},{7,2,0x00A9B},
   {7,2,0x00A9D},{7,2,0x00A9F},{7,2,0x00AA1},{7,2,0x00AA3},{7,5,0x00AA5},
   {7,4,0x00AAA},{7,2,0x00AAE},{0,0,0},{7,1,0x04E00},{7,1,0x04E8C},
   {7,1,0x04E09},{7,1,0x056DB},{7,1,0x04E94},{7,1,0x0516D},{7,1,0x04E03},
   {7,1,0x0516B},{7,1,0x04E5D},{7,1,0x05341},{7,1,0x06708},{7,1,0x0706B},
   {7,1,0x06C34},{7,1,0x06728},{7,1,0x091D1},{7,1,0x0571F},{7,1,0x065E5},
   {7,1,0x0682A},{7,1,0x06709},{7,1,0x0793E},{7,1,0x0540D},{7,1,0x07279},
   {7,1,0x08CA1},{7,1,0x0795D},{7,1,0x052B4},{7,1,0x079D8},{7,1,0x07537},
   {7,1,0x05973},{7,1,0x09069},{7,1,0x0512A},{7,1,0x05370},{7,1,0x06CE8},
   {7,1,0x09805},{7,1,0x04F11},{7,1,0x05199},{7,1,0x06B63},{7,1,0x04E0A},
   {7,1,0x04E2D},{7,1,0x04E0B},{7,1,0x05DE6},{7,1,0x053F3},{7,1,0x0533B},
   {7,1,0x05B97},{7,1,0x05B66},{7,1,0x076E3},{7,1,0x04F01},{7,1,0x08CC7},
   {7,1,0x05354},{7,1,0x0591C},{7,2,0x00AB0},{7,2,0x00AB2},{7,2,0x00AB4},
   {7,2,0x00AB6},{7,2,0x00AB8},{7,2,0x00ABA},{7,2,0x00ABC},{7,2,0x00ABE},
   {7,2,0x00AC0},{7,2,0x00AC2},{7,2,0x00AC4},{7,2,0x00AC6},{7,2,0x00AC8},
   {7,2,0x00ACA},{7,2,0x00ACC},{16,2,0x00ACE},{16,2,0x00AD0},{16,2,0x00AD2},
   {16,2,0x00AD4},{16,2,0x00AD6},{16,2,0x00AD8},{16,2,0x00ADA},{16,2,0x00ADC},
   {16,2,0x00ADE},{16,3,0x00AE0},{16,3,0x00AE3},{16,3,0x00AE6},{14,2,0x00AE9},
   {14,3,0x00AEB},{14,2,0x00AEE},{14,3,0x00AF0},{7,1,0x030A2},{7,1,0x030A4},
   {7,1,0x030A6},{7,1,0x030A8},{7,1,0x030AA},{7,1,0x030AB},{7,1,0x030AD},
   {7,1,0x030AF},{7,1,0x030B1},{7,1,0x030B3},{7,1,0x030B5},{7,1,0x030B7},
   {7,1,0x030B9},{7,1,0x030BB},{7,1,0x030BD},{7,1,0x030BF},{7,1,0x030C1},
   {7,1,0x030C4},{7,1,0x030C6},{7,1,0x030C8},{7,1,0x030CA},{7,1,0x030CB},
   {7,1,0x030CC},{7,1,0x030CD},{7,1,0x030CE},{7,1,0x030CF},{7,1,0x030D2},
   {7,1,0x030D5},{7,1,0x030D8},{7,1,0x030DB},{7,1,0x030DE},{7,1,0x030DF},
   {7,1,0x030E0},{7,1,0x030E1},{7,1,0x030E2},{7,1,0x030E4},{7,1,0x030E6},
   {7,1,0x030E8},{7,1,0x030E9},{7,1,0x030EA},{7,1,0x030EB},{7,1,0x030EC},
   {7,1,0x030ED},{7,1,0x030EF},{7,1,0x030F0},{7,1,0x030F1},{7,1,0x030F2},
   {14,2,0x00AF3}
  },

  /* block 33 */
  {{14,4,0x00AF5},{14,4,0x00AF9},{14,4,0x00AFD},{14,3,0x00B01},{14,4,0x00B04},
   {14,3,0x00B08},{14,3,0x00B0B},{14,5,0x00B0E},{14,4,0x00B13},{14,3,0x00B17},
   {14,3,0x00B1A},{14,3,0x00B1D},{14,4,0x00B20},{14,4,0x00B24},{14,3,0x00B28},
   {14,3,0x00B2B},{14,2,0x00B2E},{14,3,0x00B30},{14,4,0x00B33},{14,4,0x00B37},
   {14,2,0x00B3B},{14,5,0x00B3D},{14,6,0x00B42},{14,5,0x00B48},{14,3,0x00B4D},
   {14,5,0x00B50},{14,5,0x00B55},{14,4,0x00B5A},{14,3,0x00B5E},{14,3,0x00B61},
   {14,3,0x00B64},{14,4,0x00B67},{14,5,0x00B6B},{14,4,0x00B70},{14,3,0x00B74},
   {14,3,0x00B77},{14,3,0x00B7A},{14,2,0x00B7D},{14,2,0x00B7F},{14,2,0x00B81},
   {14,2,0x00B83},{14,3,0x00B85},{14,3,0x00B88},{14,5,0x00B8B},{14,3,0x00B90},
   {14,4,0x00B93},{14,5,0x00B97},{14,3,0x00B9C},{14,2,0x00B9F},{14,2,0x00BA1},
   {14,5,0x00BA3},{14,4,0x00BA8},{14,5,0x00BAC},{14,3,0x00BB1},{14,5,0x00BB4},
   {14,2,0x00BB9},{14,3,0x00BBB},{14,3,0x00BBE},{14,3,0x00BC1},{14,3,0x00BC4},
   {14,3,0x00BC7},{14,4,0x00BCA},{14,3,0x00BCE},{14,2,0x00BD1},{14,3,0x00BD3},
   {14,3,0x00BD6},{14,3,0x00BD9},{14,4,0x00BDC},{14,3,0x00BE0},{14,3,0x00BE3},
   {14,3,0x00BE6},{14,5,0x00BE9},{14,4,0x00BEE},{14,2,0x00BF2},{14,5,0x00BF4},
   {14,2,0x00BF9},{14,4,0x00BFB},{14,4,0x00BFF},{14,3,0x00C03},{14,3,0x00C06},
   {14,3,0x00C09},{14,4,0x00C0C},{14,2,0x00C10},{14,3,0x00C12},{14,4,0x00C15},
   {14,2,0x00C19},{14,5,0x00C1B},{14,3,0x00C20},{16,2,0x00C23},{16,2,0x00C25},
   {16,2,0x00C27},{16,2,0x00C29},{16,2,0x00C2B},{16,2,0x00C2D},{16,2,0x00C2F},
   {16,2,0x00C31},{16,2,0x00C33},{16,2,0x00C35},{16,3,0x00C37},{16,3,0x00C3A},
   {16,3,0x00C3D},{16,3,0x00C40},{16,3,0x00C43},{16,3,0x00C46},{16,3,0x00C49},
   {16,3,0x00C4C},{16,3,0x00C4F},{16,3,0x00C52},{16,3,0x00C55},{16,3,0x00C58},
   {16,3,0x00C5B},{16,3,0x00C5E},{16,3,0x00C61},{14,3,0x00C64},{14,2,0x00C67},
   {14,2,0x00C69},{14,3,0x00C6B},{14,2,0x00C6E},{14,2,0x00C70},{14,2,0x00C72},
   {14,3,0x00C74},{14,3,0x00C77},{14,2,0x00C7A},{14,2,0x00C7C},{14,2,0x00C7E},
   {14,2,0x00C80},{14,2,0x00C82},{14,4,0x00C84},{14,2,0x00C88},{14,2,0x00C8A},
   {14,2,0x00C8C},{14,2,0x00C8E},{14,2,0x00C90},{14,2,0x00C92},{14,2,0x00C94},
   {14,2,0x00C96},{14,3,0x00C98},{14,4,0x00C9B},{14,2,0x00C9F},{14,2,0x00CA1},
   {14,2,0x00CA3},{14,2,0x00CA5},{14,2,0x00CA7},{14,2,0x00CA9},{14,2,0x00CAB},
   {14,3,0x00CAD},{14,3,0x00CB0},{14,3,0x00CB3},{14,3,0x00CB6},{14,2,0x00CB9},
   {14,2,0x00CBB},{14,2,0x00CBD},{14,2,0x00CBF},{14,2,0x00CC1},{14,2,0x00CC3},
   {14,2,0x00CC5},{14,2,0x00CC7},{14,2,0x00CC9},{14,2,0x00CCB},{14,3,0x00CCD},
   {14,3,0x00CD0},{14,2,0x00CD3},{14,3,0x00CD5},{14,3,0x00CD8},{14,3,0x00CDB},
   {14,2,0x00CDE},{14,3,0x00CE0},{14,3,0x00CE3},{14,4,0x00CE6},{14,2,0x00CEA},
   {14,3,0x00CEC},{14,3,0x00CEF},{14,3,0x00CF2},{14,3,0x00CF5},{14,5,0x00CF8},
   {14,6,0x00CFD},{14,2,0x00D03},{14,2,0x00D05},{14,2,0x00D07},{14,2,0x00D09},
   {14,2,0x00D0B},{14,2,0x00D0D},{14,2,0x00D0F},{14,2,0x00D11},{14,2,0x00D13},
   {14,2,0x00D15},{14,2,0x00D17},{14,2,0x00D19},{14,2,0x00D1B},{14,2,0x00D1D},
   {14,2,0x00D1F},{14,2,0x00D21},{14,2,0x00D23},{14,2,0x00D25},{14,4,0x00D27},
   {14,2,0x00D2B},{14,2,0x00D2D},{14,2,0x00D2F},{14,4,0x00D31},{14,3,0x00D35},
   {14,2,0x00D38},{14,2,0x00D3A},{14,2,0x00D3C},{14,2,0x00D3E},{14,2,0x00D40},
   {14,2,0x00D42},{14,2,0x00D44},{14,2,0x00D46},{14,2,0x00D48},{14,2,0x00D4A},
   {14,3,0x00D4C},{14,2,0x00D4F},{14,2,0x00D51},{14,3,0x00D53},{14,3,0x00D56},
   {14,2,0x00D59},{14,4,0x00D5B},{14,3,0x00D5F},{14,2,0x00D62},{14,2,0x00D64},
   {14,2,0x00D66},{14,2,0x00D68},{14,3,0x00D6A},{14,3,0x00D6D},{16,2,0x00D70},
   {16,2,0x00D72},{16,2,0x00D74},{16,2,0x00D76},{16,2,0x00D78},{16,2,0x00D7A},
   {16,2,0x00D7C},{16,2,0x00D7E},{16,2,0x00D80},{16,3,0x00D82},{16,3,0x00D85},
   {16,3,0x00D88},{16,3,0x00D8B},{16,3,0x00D8E},{16,3,0x00D91},{16,3,0x00D94},
   {16,3,0x00D97},{16,3,0x00D9A},{16,3,0x00D9D},{16,3,0x00DA0},{16,3,0x00DA3},
   {16,3,0x00DA6},{16,3,0x00DA9},{16,3,0x00DAC},{16,3,0x00DAF},{16,3,0x00DB2},
   {16,3,0x00DB5},{16,3,0x00DB8},{16,3,0x00DBB},{16,3,0x00DBE},{16,3,0x00DC1},
   {14,3,0x00DC4}
  },

  /* block 34 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{8,1,0x0044A},{8,1,0x0044C},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 35 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{8,1,0x0A76F},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{8,1,0x00126},{8,1,0x00153},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 36 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{8,1,0x0A727},{8,1,0x0AB37},{8,1,0x0026B},
   {8,1,0x0AB52},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {8,1,0x0028D},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 37 */
  {{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000}
  },

  /* block 38 */
  {{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},
   {-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{-1,2,0x00000},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 39 */
  {{0,1,0x08C48},{0,1,0x066F4},{0,1,0x08ECA},{0,1,0x08CC8},{0,1,0x06ED1},
   {0,1,0x04E32},{0,1,0x053E5},{0,1,0x09F9C},{0,1,0x09F9C},{0,1,0x05951},
   {0,1,0x091D1},{0,1,0x05587},{0,1,0x05948},{0,1,0x061F6},{0,1,0x07669},
   {0,1,0x07F85},{0,1,0x0863F},{0,1,0x087BA},{0,1,0x088F8},{0,1,0x0908F},
   {0,1,0x06A02},{0,1,0x06D1B},{0,1,0x070D9},{0,1,0x073DE},{0,1,0x0843D},
   {0,1,0x0916A},{0,1,0x099F1},{0,1,0x04E82},{0,1,0x05375},{0,1,0x06B04},
   {0,1,0x0721B},{0,1,0x0862D},{0,1,0x09E1E},{0,1,0x05D50},{0,1,0x06FEB},
   {0,1,0x085CD},{0,1,0x08964},{0,1,0x062C9},{0,1,0x081D8},{0,1,0x0881F},
   {0,1,0x05ECA},{0,1,0x06717},{0,1,0x06D6A},{0,1,0x072FC},{0,1,0x090CE},
   {0,1,0x04F86},{0,1,0x051B7},{0,1,0x052DE},{0,1,0x064C4},{0,1,0x06AD3},
   {0,1,0x07210},{0,1,0x076E7},{0,1,0x08001},{0,1,0x08606},{0,1,0x0865C},
   {0,1,0x08DEF},{0,1,0x09732},{0,1,0x09B6F},{0,1,0x09DFA},{0,1,0x0788C},
   {0,1,0x0797F},{0,1,0x07DA0},{0,1,0x083C9},{0,1,0x09304},{0,1,0x09E7F},
   {0,1,0x08AD6},{0,1,0x058DF},{0,1,0x05F04},{0,1,0x07C60},{0,1,0x0807E},
   {0,1,0x07262},{0,1,0x078CA},{0,1,0x08CC2},{0,1,0x096F7},{0,1,0x058D8},
   {0,1,0x05C62},{0,1,0x06A13},{0,1,0x06DDA},{0,1,0x06F0F},{0,1,0x07D2F},
   {0,1,0x07E37},{0,1,0x0964B},{0,1,0x052D2},{0,1,0x0808B},{0,1,0x051DC},
   {0,1,0x051CC},{0,1,0x07A1C},{0,1,0x07DBE},{0,1,0x083F1},{0,1,0x09675},
   {0,1,0x08B80},{0,1,0x062CF},{0,1,0x06A02},{0,1,0x08AFE},{0,1,0x04E39},
   {0,1,0x05BE7},{0,1,0x06012},{0,1,0x07387},{0,1,0x07570},{0,1,0x05317},
   {0,1,0x078FB},{0,1,0x04FBF},{0,1,0x05FA9},{0,1,0x04E0D},{0,1,0x06CCC},
   {0,1,0x06578},{0,1,0x07D22},{0,1,0x053C3},{0,1,0x0585E},{0,1,0x07701},
   {0,1,0x08449},{0,1,0x08AAA},{0,1,0x06BBA},{0,1,0x08FB0},{0,1,0x06C88},
   {0,1,0x062FE},{0,1,0x082E5},{0,1,0x063A0},{0,1,0x07565},{0,1,0x04EAE},
   {0,1,0x05169},{0,1,0x051C9},{0,1,0x06881},{0,1,0x07CE7},{0,1,0x0826F},
   {0,1,0x08AD2},{0,1,0x091CF},{0,1,0x052F5},{0,1,0x05442},{0,1,0x05973},
   {0,1,0x05EEC},{0,1,0x065C5},{0,1,0x06FFE},{0,1,0x0792A},{0,1,0x095AD},
   {0,1,0x09A6A},{0,1,0x09E97},{0,1,0x09ECE},{0,1,0x0529B},{0,1,0x066C6},
   {0,1,0x06B77},{0,1,0x08F62},{0,1,0x05E74},{0,1,0x06190},{0,1,0x06200},
   {0,1,0x0649A},{0,1,0x06F23},{0,1,0x07149},{0,1,0x07489},{0,1,0x079CA},
   {0,1,0x07DF4},{0,1,0x0806F},{0,1,0x08F26},{0,1,0x084EE},{0,1,0x09023},
   {0,1,0x0934A},{0,1,0x05217},{0,1,0x052A3},{0,1,0x054BD},{0,1,0x070C8},
   {0,1,0x088C2},{0,1,0x08AAA},{0,1,0x05EC9},{0,1,0x05FF5},{0,1,0x0637B},
   {0,1,0x06BAE},{0,1,0x07C3E},{0,1,0x07375},{0,1,0x04EE4},{0,1,0x056F9},
   {0,1,0x05BE7},{0,1,0x05DBA},{0,1,0x0601C},{0,1,0x073B2},{0,1,0x07469},
   {0,1,0x07F9A},{0,1,0x08046},{0,1,0x09234},{0,1,0x096F6},{0,1,0x09748},
   {0,1,0x09818},{0,1,0x04F8B},{0,1,0x079AE},{0,1,0x091B4},{0,1,0x096B8},
   {0,1,0x060E1},{0,1,0x04E86},{0,1,0x050DA},{0,1,0x05BEE},{0,1,0x05C3F},
   {0,1,0x06599},{0,1,0x06A02},{0,1,0x071CE},{0,1,0x07642},{0,1,0x084FC},
   {0,1,0x0907C},{0,1,0x09F8D},{0,1,0x06688},{0,1,0x0962E},{0,1,0x05289},
   {0,1,0x0677B},{0,1,0x067F3},{0,1,0x06D41},{0,1,0x06E9C},{0,1,0x07409},
   {0,1,0x07559},{0,1,0x0786B},{0,1,0x07D10},{0,1,0x0985E},{0,1,0x0516D},
   {0,1,0x0622E},{0,1,0x09678},{0,1,0x0502B},{0,1,0x05D19},{0,1,0x06DEA},
   {0,1,0x08F2A},{0,1,0x05F8B},{0,1,0x06144},{0,1,0x06817},{0,1,0x07387},
   {0,1,0x09686},{0,1,0x05229},{0,1,0x0540F},{0,1,0x05C65},{0,1,0x06613},
   {0,1,0x0674E},{0,1,0x068A8},{0,1,0x06CE5},{0,1,0x07406},{0,1,0x075E2},
   {0,1,0x07F79},{0,1,0x088CF},{0,1,0x088E1},{0,1,0x091CC},{0,1,0x096E2},
   {0,1,0x0533F},{0,1,0x06EBA},{0,1,0x0541D},{0,1,0x071D0},{0,1,0x07498},
   {0,1,0x085FA},{0,1,0x096A3},{0,1,0x09C57},{0,1,0x09E9F},{0,1,0x06797},
   {0,1,0x06DCB},{0,1,0x081E8},{0,1,0x07ACB},{0,1,0x07B20},{0,1,0x07C92},
   {0,1,0x072C0},{0,1,0x07099},{0,1,0x08B58},{0,1,0x04EC0},{0,1,0x08336},
   {0,1,0x0523A}
  },

  /* block 40 */
  {{0,1,0x05207},{0,1,0x05EA6},{0,1,0x062D3},{0,1,0x07CD6},{0,1,0x05B85},
   {0,1,0x06D1E},{0,1,0x066B4},{0,1,0x08F3B},{0,1,0x0884C},{0,1,0x0964D},
   {0,1,0x0898B},{0,1,0x05ED3},{0,1,0x05140},{0,1,0x055C0},{0,0,0},
   {0,0,0},{0,1,0x0585A},{0,0,0},{0,1,0x06674},{0,0,0},
   {0,0,0},{0,1,0x051DE},{0,1,0x0732A},{0,1,0x076CA},{0,1,0x0793C},
   {0,1,0x0795E},{0,1,0x07965},{0,1,0x0798F},{0,1,0x09756},{0,1,0x07CBE},
   {0,1,0x07FBD},{0,0,0},{0,1,0x08612},{0,0,0},{0,1,0x08AF8},
   {0,0,0},{0,0,0},{0,1,0x09038},{0,1,0x090FD},{0,0,0},
   {0,0,0},{0,0,0},{0,1,0x098EF},{0,1,0x098FC},{0,1,0x09928},
   {0,1,0x09DB4},{0,1,0x090DE},{0,1,0x096B7},{0,1,0x04FAE},{0,1,0x050E7},
   {0,1,0x0514D},{0,1,0x052C9},{0,1,0x052E4},{0,1,0x05351},{0,1,0x0559D},
   {0,1,0x05606},{0,1,0x05668},{0,1,0x05840},{0,1,0x058A8},{0,1,0x05C64},
   {0,1,0x05C6E},{0,1,0x06094},{0,1,0x06168},{0,1,0x0618E},{0,1,0x061F2},
   {0,1,0x0654F},{0,1,0x065E2},{0,1,0x06691},{0,1,0x06885},{0,1,0x06D77},
   {0,1,0x06E1A},{0,1,0x06F22},{0,1,0x0716E},{0,1,0x0722B},{0,1,0x07422},
   {0,1,0x07891},{0,1,0x0793E},{0,1,0x07949},{0,1,0x07948},{0,1,0x07950},
   {0,1,0x07956},{0,1,0x0795D},{0,1,0x0798D},{0,1,0x0798E},{0,1,0x07A40},
   {0,1,0x07A81},{0,1,0x07BC0},{0,1,0x07DF4},{0,1,0x07E09},{0,1,0x07E41},
   {0,1,0x07F72},{0,1,0x08005},{0,1,0x081ED},{0,1,0x08279},{0,1,0x08279},
   {0,1,0x08457},{0,1,0x08910},{0,1,0x08996},{0,1,0x08B01},{0,1,0x08B39},
   {0,1,0x08CD3},{0,1,0x08D08},{0,1,0x08FB6},{0,1,0x09038},{0,1,0x096E3},
   {0,1,0x097FF},{0,1,0x0983B},{0,1,0x06075},{0,1,0x242EE},{0,1,0x08218},
   {0,0,0},{0,0,0},{0,1,0x04E26},{0,1,0x051B5},{0,1,0x05168},
   {0,1,0x04F80},{0,1,0x05145},{0,1,0x05180},{0,1,0x052C7},{0,1,0x052FA},
   {0,1,0x0559D},{0,1,0x05555},{0,1,0x05599},{0,1,0x055E2},{0,1,0x0585A},
   {0,1,0x058B3},{0,1,0x05944},{0,1,0x05954},{0,1,0x05A62},{0,1,0x05B28},
   {0,1,0x05ED2},{0,1,0x05ED9},{0,1,0x05F69},{0,1,0x05FAD},{0,1,0x060D8},
   {0,1,0x0614E},{0,1,0x06108},{0,1,0x0618E},{0,1,0x06160},{0,1,0x061F2},
   {0,1,0x06234},{0,1,0x063C4},{0,1,0x0641C},{0,1,0x06452},{0,1,0x06556},
   {0,1,0x06674},{0,1,0x06717},{0,1,0x0671B},{0,1,0x06756},{0,1,0x06B79},
   {0,1,0x06BBA},{0,1,0x06D41},{0,1,0x06EDB},{0,1,0x06ECB},{0,1,0x06F22},
   {0,1,0x0701E},{0,1,0x0716E},{0,1,0x077A7},{0,1,0x07235},{0,1,0x072AF},
   {0,1,0x0732A},{0,1,0x07471},{0,1,0x07506},{0,1,0x0753B},{0,1,0x0761D},
   {0,1,0x0761F},{0,1,0x076CA},{0,1,0x076DB},{0,1,0x076F4},{0,1,0x0774A},
   {0,1,0x07740},{0,1,0x078CC},{0,1,0x07AB1},{0,1,0x07BC0},{0,1,0x07C7B},
   {0,1,0x07D5B},{0,1,0x07DF4},{0,1,0x07F3E},{0,1,0x08005},{0,1,0x08352},
   {0,1,0x083EF},{0,1,0x08779},{0,1,0x08941},{0,1,0x08986},{0,1,0x08996},
   {0,1,0x08ABF},{0,1,0x08AF8},{0,1,0x08ACB},{0,1,0x08B01},{0,1,0x08AFE},
   {0,1,0x08AED},{0,1,0x08B39},{0,1,0x08B8A},{0,1,0x08D08},{0,1,0x08F38},
   {0,1,0x09072},{0,1,0x09199},{0,1,0x09276},{0,1,0x0967C},{0,1,0x096E3},
   {0,1,0x09756},{0,1,0x097DB},{0,1,0x097FF},{0,1,0x0980B},{0,1,0x0983B},
   {0,1,0x09B12},{0,1,0x09F9C},{0,1,0x2284A},{0,1,0x22844},{0,1,0x233D5},
   {0,1,0x03B9D},{0,1,0x04018},{0,1,0x04039},{0,1,0x25249},{0,1,0x25CD0},
   {0,1,0x27ED3},{0,1,0x09F43},{0,1,0x09F8E},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 41 */
  {{16,2,0x00DC7},{16,2,0x00DC9},{16,2,0x00DCB},{16,3,0x00DCD},{16,3,0x00DD0},
   {16,2,0x00DD3},{16,2,0x00DD5},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,2,0x00DD7},
   {16,2,0x00DD9},{16,2,0x00DDB},{16,2,0x00DDD},{16,2,0x00DDF},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x00DE1},
   {0,0,0},{0,2,0x00DE3},{1,1,0x005E2},{1,1,0x005D0},{1,1,0x005D3},
   {1,1,0x005D4},{1,1,0x005DB},{1,1,0x005DC},{1,1,0x005DD},{1,1,0x005E8},
   {1,1,0x005EA},{1,1,0x0002B},{0,2,0x00DE5},{0,2,0x00DE7},{0,2,0x00DE9},
   {0,2,0x00DEB},{0,2,0x00DED},{0,2,0x00DEF},{0,2,0x00DF1},{0,2,0x00DF3},
   {0,2,0x00DF5},{0,2,0x00DF7},{0,2,0x00DF9},{0,2,0x00DFB},{0,2,0x00DFD},
   {0,0,0},{0,2,0x00DFF},{0,2,0x00E01},{0,2,0x00E03},{0,2,0x00E05},
   {0,2,0x00E07},{0,0,0},{0,2,0x00E09},{0,0,0},{0,2,0x00E0B},
   {0,2,0x00E0D},{0,0,0},{0,2,0x00E0F},{0,2,0x00E11},{0,0,0},
   {0,2,0x00E13},{0,2,0x00E15},{0,2,0x00E17},{0,2,0x00E19},{0,2,0x00E1B},
   {0,2,0x00E1D},{0,2,0x00E1F},{0,2,0x00E21},{0,2,0x00E23},{16,2,0x00E25},
   {6,1,0x00671},{5,1,0x00671},{6,1,0x0067B},{5,1,0x0067B},{3,1,0x0067B},
   {4,1,0x0067B},{6,1,0x0067E},{5,1,0x0067E},{3,1,0x0067E},{4,1,0x0067E},
   {6,1,0x00680},{5,1,0x00680},{3,1,0x00680},{4,1,0x00680},{6,1,0x0067A},
   {5,1,0x0067A},{3,1,0x0067A},{4,1,0x0067A},{6,1,0x0067F},{5,1,0x0067F},
   {3,1,0x0067F},{4,1,0x0067F},{6,1,0x00679},{5,1,0x00679},{3,1,0x00679},
   {4,1,0x00679},{6,1,0x006A4},{5,1,0x006A4},{3,1,0x006A4},{4,1,0x006A4},
   {6,1,0x006A6},{5,1,0x006A6},{3,1,0x006A6},{4,1,0x006A6},{6,1,0x00684},
   {5,1,0x00684},{3,1,0x00684},{4,1,0x00684},{6,1,0x00683},{5,1,0x00683},
   {3,1,0x00683},{4,1,0x00683},{6,1,0x00686},{5,1,0x00686},{3,1,0x00686},
   {4,1,0x00686},{6,1,0x00687},{5,1,0x00687},{3,1,0x00687},{4,1,0x00687},
   {6,1,0x0068D},{5,1,0x0068D},{6,1,0x0068C},{5,1,0x0068C},{6,1,0x0068E},
   {5,1,0x0068E},{6,1,0x00688},{5,1,0x00688},{6,1,0x00698},{5,1,0x00698},
   {6,1,0x00691},{5,1,0x00691},{6,1,0x006A9},{5,1,0x006A9},{3,1,0x006A9},
   {4,1,0x006A9},{6,1,0x006AF},{5,1,0x006AF},{3,1,0x006AF},{4,1,0x006AF},
   {6,1,0x006B3},{5,1,0x006B3},{3,1,0x006B3},{4,1,0x006B3},{6,1,0x006B1},
   {5,1,0x006B1},{3,1,0x006B1},{4,1,0x006B1},{6,1,0x006BA},{5,1,0x006BA},
   {6,1,0x006BB},{5,1,0x006BB},{3,1,0x006BB},{4,1,0x006BB},{6,1,0x006C0},
   {5,1,0x006C0},{6,1,0x006C1},{5,1,0x006C1},{3,1,0x006C1},{4,1,0x006C1},
   {6,1,0x006BE},{5,1,0x006BE},{3,1,0x006BE},{4,1,0x006BE},{6,1,0x006D2},
   {5,1,0x006D2},{6,1,0x006D3},{5,1,0x006D3},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{6,1,0x006AD},{5,1,0x006AD},{3,1,0x006AD},{4,1,0x006AD},
   {6,1,0x006C7},{5,1,0x006C7},{6,1,0x006C6},{5,1,0x006C6},{6,1,0x006C8},
   {5,1,0x006C8},{6,1,0x00677},{6,1,0x006CB},{5,1,0x006CB},{6,1,0x006C5},
   {5,1,0x006C5},{6,1,0x006C9},{5,1,0x006C9},{6,1,0x006D0},{5,1,0x006D0},
   {3,1,0x006D0},{4,1,0x006D0},{3,1,0x00649},{4,1,0x00649},{6,2,0x00E27},
   {5,2,0x00E29},{6,2,0x00E2B},{5,2,0x00E2D},{6,2,0x00E2F},{5,2,0x00E31},
   {6,2,0x00E33},{5,2,0x00E35},{6,2,0x00E37},{5,2,0x00E39},{6,2,0x00E3B},
   {5,2,0x00E3D},{6,2,0x00E3F},{5,2,0x00E41},{3,2,0x00E43},{6,2,0x00E45},
   {5,2,0x00E47},{3,2,0x00E49},{6,1,0x006CC},{5,1,0x006CC},{3,1,0x006CC},
   {4,1,0x006CC}
  },

  /* block 42 */
  {{6,2,0x00E4B},{6,2,0x00E4D},{6,2,0x00E4F},{6,2,0x00E51},{6,2,0x00E53},
   {6,2,0x00E55},{6,2,0x00E57},{6,2,0x00E59},{6,2,0x00E5B},{6,2,0x00E5D},
   {6,2,0x00E5F},{6,2,0x00E61},{6,2,0x00E63},{6,2,0x00E65},{6,2,0x00E67},
   {6,2,0x00E69},{6,2,0x00E6B},{6,2,0x00E6D},{6,2,0x00E6F},{6,2,0x00E71},
   {6,2,0x00E73},{6,2,0x00E75},{6,2,0x00E77},{6,2,0x00E79},{6,2,0x00E7B},
   {6,2,0x00E7D},{6,2,0x00E7F},{6,2,0x00E81},{6,2,0x00E83},{6,2,0x00E85},
   {6,2,0x00E87},{6,2,0x00E89},{6,2,0x00E8B},{6,2,0x00E8D},{6,2,0x00E8F},
   {6,2,0x00E91},{6,2,0x00E93},{6,2,0x00E95},{6,2,0x00E97},{6,2,0x00E99},
   {6,2,0x00E9B},{6,2,0x00E9D},{6,2,0x00E9F},{6,2,0x00EA1},{6,2,0x00EA3},
   {6,2,0x00EA5},{6,2,0x00EA7},{6,2,0x00EA9},{6,2,0x00EAB},{6,2,0x00EAD},
   {6,2,0x00EAF},{6,2,0x00EB1},{6,2,0x00EB3},{6,2,0x00EB5},{6,2,0x00EB7},
   {6,2,0x00EB9},{6,2,0x00EBB},{6,2,0x00EBD},{6,2,0x00EBF},{6,2,0x00EC1},
   {6,2,0x00EC3},{6,2,0x00EC5},{6,2,0x00EC7},{6,2,0x00EC9},{6,2,0x00ECB},
   {6,2,0x00ECD},{6,2,0x00ECF},{6,2,0x00ED1},{6,2,0x00ED3},{6,2,0x00ED5},
   {6,2,0x00ED7},{6,2,0x00ED9},{6,2,0x00EDB},{6,2,0x00EDD},{6,2,0x00EDF},
   {6,2,0x00EE1},{6,2,0x00EE3},{6,2,0x00EE5},{6,2,0x00EE7},{6,2,0x00EE9},
   {6,2,0x00EEB},{6,2,0x00EED},{6,2,0x00EEF},{6,2,0x00EF1},{6,2,0x00EF3},
   {6,2,0x00EF5},{6,2,0x00EF7},{6,2,0x00EF9},{6,2,0x00EFB},{6,2,0x00EFD},
   {6,2,0x00EFF},{6,2,0x00F01},{6,2,0x00F03},{6,2,0x00F05},{6,3,0x00F07},
   {6,3,0x00F0A},{6,3,0x00F0D},{6,3,0x00F10},{6,3,0x00F13},{6,3,0x00F16},
   {5,2,0x00F19},{5,2,0x00F1B},{5,2,0x00F1D},{5,2,0x00F1F},{5,2,0x00F21},
   {5,2,0x00F23},{5,2,0x00F25},{5,2,0x00F27},{5,2,0x00F29},{5,2,0x00F2B},
   {5,2,0x00F2D},{5,2,0x00F2F},{5,2,0x00F31},{5,2,0x00F33},{5,2,0x00F35},
   {5,2,0x00F37},{5,2,0x00F39},{5,2,0x00F3B},{5,2,0x00F3D},{5,2,0x00F3F},
   {5,2,0x00F41},{5,2,0x00F43},{5,2,0x00F45},{5,2,0x00F47},{5,2,0x00F49},
   {5,2,0x00F4B},{5,2,0x00F4D},{5,2,0x00F4F},{5,2,0x00F51},{5,2,0x00F53},
   {5,2,0x00F55},{5,2,0x00F57},{5,2,0x00F59},{5,2,0x00F5B},{5,2,0x00F5D},
   {5,2,0x00F5F},{5,2,0x00F61},{5,2,0x00F63},{5,2,0x00F65},{5,2,0x00F67},
   {5,2,0x00F69},{5,2,0x00F6B},{5,2,0x00F6D},{5,2,0x00F6F},{5,2,0x00F71},
   {5,2,0x00F73},{5,2,0x00F75},{5,2,0x00F77},{5,2,0x00F79},{5,2,0x00F7B},
   {5,2,0x00F7D},{3,2,0x00F7F},{3,2,0x00F81},{3,2,0x00F83},{3,2,0x00F85},
   {3,2,0x00F87},{3,2,0x00F89},{3,2,0x00F8B},{3,2,0x00F8D},{3,2,0x00F8F},
   {3,2,0x00F91},{3,2,0x00F93},{3,2,0x00F95},{3,2,0x00F97},{3,2,0x00F99},
   {3,2,0x00F9B},{3,2,0x00F9D},{3,2,0x00F9F},{3,2,0x00FA1},{3,2,0x00FA3},
   {3,2,0x00FA5},{3,2,0x00FA7},{3,2,0x00FA9},{3,2,0x00FAB},{3,2,0x00FAD},
   {3,2,0x00FAF},{3,2,0x00FB1},{3,2,0x00FB3},{3,2,0x00FB5},{3,2,0x00FB7},
   {3,2,0x00FB9},{3,2,0x00FBB},{3,2,0x00FBD},{3,2,0x00FBF},{3,2,0x00FC1},
   {3,2,0x00FC3},{3,2,0x00FC5},{3,2,0x00FC7},{3,2,0x00FC9},{3,2,0x00FCB},
   {3,2,0x00FCD},{3,2,0x00FCF},{3,2,0x00FD1},{3,2,0x00FD3},{3,2,0x00FD5},
   {3,2,0x00FD7},{3,2,0x00FD9},{3,2,0x00FDB},{3,2,0x00FDD},{3,2,0x00FDF},
   {3,2,0x00FE1},{3,2,0x00FE3},{3,2,0x00FE5},{3,2,0x00FE7},{3,2,0x00FE9},
   {3,2,0x00FEB},{3,2,0x00FED},{3,2,0x00FEF},{3,2,0x00FF1},{3,2,0x00FF3},
   {3,2,0x00FF5},{3,2,0x00FF7},{3,2,0x00FF9},{3,2,0x00FFB},{3,2,0x00FFD},
   {3,2,0x00FFF},{3,2,0x01001},{3,2,0x01003},{3,2,0x01005},{3,2,0x01007},
   {3,2,0x01009},{3,2,0x0100B},{3,2,0x0100D},{4,2,0x0100F},{4,2,0x01011},
   {4,2,0x01013},{4,2,0x01015},{4,2,0x01017},{4,2,0x01019},{4,2,0x0101B},
   {4,2,0x0101D},{4,2,0x0101F},{4,2,0x01021},{4,2,0x01023},{4,2,0x01025},
   {4,2,0x01027},{4,2,0x01029},{4,2,0x0102B},{4,2,0x0102D},{4,2,0x0102F},
   {4,2,0x01031},{4,2,0x01033},{4,3,0x01035},{4,3,0x01038},{4,3,0x0103B},
   {6,2,0x0103E},{6,2,0x01040},{6,2,0x01042},{6,2,0x01044},{6,2,0x01046},
   {6,2,0x01048},{6,2,0x0104A},{6,2,0x0104C},{6,2,0x0104E},{6,2,0x01050},
   {6,2,0x01052}
  },

  /* block 43 */
  {{6,2,0x01054},{6,2,0x01056},{6,2,0x01058},{6,2,0x0105A},{6,2,0x0105C},
   {6,2,0x0105E},{6,2,0x01060},{6,2,0x01062},{6,2,0x01064},{6,2,0x01066},
   {6,2,0x01068},{6,2,0x0106A},{6,2,0x0106C},{6,2,0x0106E},{6,2,0x01070},
   {6,2,0x01072},{6,2,0x01074},{5,2,0x01076},{5,2,0x01078},{5,2,0x0107A},
   {5,2,0x0107C},{5,2,0x0107E},{5,2,0x01080},{5,2,0x01082},{5,2,0x01084},
   {5,2,0x01086},{5,2,0x01088},{5,2,0x0108A},{5,2,0x0108C},{5,2,0x0108E},
   {5,2,0x01090},{5,2,0x01092},{5,2,0x01094},{5,2,0x01096},{5,2,0x01098},
   {5,2,0x0109A},{5,2,0x0109C},{5,2,0x0109E},{5,2,0x010A0},{5,2,0x010A2},
   {5,2,0x010A4},{5,2,0x010A6},{5,2,0x010A8},{5,2,0x010AA},{5,2,0x010AC},
   {3,2,0x010AE},{3,2,0x010B0},{3,2,0x010B2},{3,2,0x010B4},{3,2,0x010B6},
   {3,2,0x010B8},{3,2,0x010BA},{4,2,0x010BC},{4,2,0x010BE},{4,2,0x010C0},
   {4,2,0x010C2},{4,2,0x010C4},{4,2,0x010C6},{4,2,0x010C8},{4,2,0x010CA},
   {5,2,0x010CC},{6,2,0x010CE},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {3,3,0x010D0},{5,3,0x010D3},{3,3,0x010D6},{3,3,0x010D9},{3,3,0x010DC},
   {3,3,0x010DF},{3,3,0x010E2},{3,3,0x010E5},{5,3,0x010E8},{3,3,0x010EB},
   {5,3,0x010EE},{5,3,0x010F1},{3,3,0x010F4},{3,3,0x010F7},{5,3,0x010FA},
   {5,3,0x010FD},{3,3,0x01100},{3,3,0x01103},{5,3,0x01106},{3,3,0x01109},
   {5,3,0x0110C},{3,3,0x0110F},{5,3,0x01112},{5,3,0x01115},{3,3,0x01118},
   {5,3,0x0111B},{5,3,0x0111E},{3,3,0x01121},{5,3,0x01124},{3,3,0x01127},
   {5,3,0x0112A},{5,3,0x0112D},{3,3,0x01130},{5,3,0x01133},{3,3,0x01136},
   {3,3,0x01139},{5,3,0x0113C},{5,3,0x0113F},{5,3,0x01142},{3,3,0x01145},
   {5,3,0x01148},{5,3,0x0114B},{5,3,0x0114E},{5,3,0x01151},{5,3,0x01154},
   {3,3,0x01157},{5,3,0x0115A},{5,3,0x0115D},{5,3,0x01160},{5,3,0x01163},
   {5,3,0x01166},{3,3,0x01169},{5,3,0x0116C},{5,3,0x0116F},{3,3,0x01172},
   {5,3,0x01175},{3,3,0x01178},{3,3,0x0117B},{3,3,0x0117E},{5,3,0x01181},
   {3,3,0x01184},{3,3,0x01187},{3,3,0x0118A},{3,3,0x0118D},{0,0,0},
   {0,0,0},{3,3,0x01190},{3,3,0x01193},{3,3,0x01196},{3,3,0x01199},
   {5,3,0x0119C},{5,3,0x0119F},{3,3,0x011A2},{5,3,0x011A5},{5,3,0x011A8},
   {5,3,0x011AB},{5,3,0x011AE},{3,3,0x011B1},{5,3,0x011B4},{5,3,0x011B7},
   {5,3,0x011BA},{5,3,0x011BD},{5,3,0x011C0},{5,3,0x011C3},{5,3,0x011C6},
   {5,3,0x011C9},{5,3,0x011CC},{5,3,0x011CF},{5,3,0x011D2},{5,3,0x011D5},
   {5,3,0x011D8},{5,3,0x011DB},{5,3,0x011DE},{5,3,0x011E1},{5,3,0x011E4},
   {5,3,0x011E7},{5,3,0x011EA},{5,3,0x011ED},{5,3,0x011F0},{5,3,0x011F3},
   {3,3,0x011F6},{3,3,0x011F9},{5,3,0x011FC},{5,3,0x011FF},{3,3,0x01202},
   {5,3,0x01205},{3,3,0x01208},{5,3,0x0120B},{5,3,0x0120E},{5,3,0x01211},
   {5,3,0x01214},{5,3,0x01217},{5,3,0x0121A},{5,3,0x0121D},{5,3,0x01220},
   {3,3,0x01223},{3,3,0x01226},{3,3,0x01229},{5,3,0x0122C},{5,3,0x0122F},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {6,3,0x01232},{6,3,0x01235},{6,4,0x01238},{6,4,0x0123C},{6,4,0x01240},
   {6,4,0x01244},{6,4,0x01248},{6,4,0x0124C},{6,4,0x01250},{6,3,0x01254},
   {6,18,0x01257},{6,8,0x01269},{6,4,0x01271},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 44 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{10,1,0x0002C},{10,1,0x03001},{10,1,0x03002},{10,1,0x0003A},
   {10,1,0x0003B},{10,1,0x00021},{10,1,0x0003F},{10,1,0x03016},{10,1,0x03017},
   {10,1,0x02026},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{10,1,0x02025},{10,1,0x02014},
   {10,1,0x02013},{10,1,0x0005F},{10,1,0x0005F},{10,1,0x00028},{10,1,0x00029},
   {10,1,0x0007B},{10,1,0x0007D},{10,1,0x03014},{10,1,0x03015},{10,1,0x03010},
   {10,1,0x03011},{10,1,0x0300A},{10,1,0x0300B},{10,1,0x03008},{10,1,0x03009},
   {10,1,0x0300C},{10,1,0x0300D},{10,1,0x0300E},{10,1,0x0300F},{0,0,0},
   {0,0,0},{10,1,0x0005B},{10,1,0x0005D},{16,1,0x0203E},{16,1,0x0203E},
   {16,1,0x0203E},{16,1,0x0203E},{16,1,0x0005F},{16,1,0x0005F},{16,1,0x0005F},
   {13,1,0x0002C},{13,1,0x03001},{13,1,0x0002E},{0,0,0},{13,1,0x0003B},
   {13,1,0x0003A},{13,1,0x0003F},{13,1,0x00021},{13,1,0x02014},{13,1,0x00028},
   {13,1,0x00029},{13,1,0x0007B},{13,1,0x0007D},{13,1,0x03014},{13,1,0x03015},
   {13,1,0x00023},{13,1,0x00026},{13,1,0x0002A},{13,1,0x0002B},{13,1,0x0002D},
   {13,1,0x0003C},{13,1,0x0003E},{13,1,0x0003D},{0,0,0},{13,1,0x0005C},
   {13,1,0x00024},{13,1,0x00025},{13,1,0x00040},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{6,2,0x01275},{4,2,0x01277},{6,2,0x01279},
   {0,0,0},{6,2,0x0127B},{0,0,0},{6,2,0x0127D},{4,2,0x0127F},
   {6,2,0x01281},{4,2,0x01283},{6,2,0x01285},{4,2,0x01287},{6,2,0x01289},
   {4,2,0x0128B},{6,2,0x0128D},{4,2,0x0128F},{6,1,0x00621},{6,1,0x00622},
   {5,1,0x00622},{6,1,0x00623},{5,1,0x00623},{6,1,0x00624},{5,1,0x00624},
   {6,1,0x00625},{5,1,0x00625},{6,1,0x00626},{5,1,0x00626},{3,1,0x00626},
   {4,1,0x00626},{6,1,0x00627},{5,1,0x00627},{6,1,0x00628},{5,1,0x00628},
   {3,1,0x00628},{4,1,0x00628},{6,1,0x00629},{5,1,0x00629},{6,1,0x0062A},
   {5,1,0x0062A},{3,1,0x0062A},{4,1,0x0062A},{6,1,0x0062B},{5,1,0x0062B},
   {3,1,0x0062B},{4,1,0x0062B},{6,1,0x0062C},{5,1,0x0062C},{3,1,0x0062C},
   {4,1,0x0062C},{6,1,0x0062D},{5,1,0x0062D},{3,1,0x0062D},{4,1,0x0062D},
   {6,1,0x0062E},{5,1,0x0062E},{3,1,0x0062E},{4,1,0x0062E},{6,1,0x0062F},
   {5,1,0x0062F},{6,1,0x00630},{5,1,0x00630},{6,1,0x00631},{5,1,0x00631},
   {6,1,0x00632},{5,1,0x00632},{6,1,0x00633},{5,1,0x00633},{3,1,0x00633},
   {4,1,0x00633},{6,1,0x00634},{5,1,0x00634},{3,1,0x00634},{4,1,0x00634},
   {6,1,0x00635},{5,1,0x00635},{3,1,0x00635},{4,1,0x00635},{6,1,0x00636},
   {5,1,0x00636},{3,1,0x00636},{4,1,0x00636},{6,1,0x00637},{5,1,0x00637},
   {3,1,0x00637},{4,1,0x00637},{6,1,0x00638},{5,1,0x00638},{3,1,0x00638},
   {4,1,0x00638},{6,1,0x00639},{5,1,0x00639},{3,1,0x00639},{4,1,0x00639},
   {6,1,0x0063A},{5,1,0x0063A},{3,1,0x0063A},{4,1,0x0063A},{6,1,0x00641},
   {5,1,0x00641},{3,1,0x00641},{4,1,0x00641},{6,1,0x00642},{5,1,0x00642},
   {3,1,0x00642},{4,1,0x00642},{6,1,0x00643},{5,1,0x00643},{3,1,0x00643},
   {4,1,0x00643},{6,1,0x00644},{5,1,0x00644},{3,1,0x00644},{4,1,0x00644},
   {6,1,0x00645},{5,1,0x00645},{3,1,0x00645},{4,1,0x00645},{6,1,0x00646},
   {5,1,0x00646},{3,1,0x00646},{4,1,0x00646},{6,1,0x00647},{5,1,0x00647},
   {3,1,0x00647},{4,1,0x00647},{6,1,0x00648},{5,1,0x00648},{6,1,0x00649},
   {5,1,0x00649},{6,1,0x0064A},{5,1,0x0064A},{3,1,0x0064A},{4,1,0x0064A},
   {6,2,0x01291},{5,2,0x01293},{6,2,0x01295},{5,2,0x01297},{6,2,0x01299},
   {5,2,0x0129B},{6,2,0x0129D},{5,2,0x0129F},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 45 */
  {{0,0,0},{11,1,0x00021},{11,1,0x00022},{11,1,0x00023},{11,1,0x00024},
   {11,1,0x00025},{11,1,0x00026},{11,1,0x00027},{11,1,0x00028},{11,1,0x00029},
   {11,1,0x0002A},{11,1,0x0002B},{11,1,0x0002C},{11,1,0x0002D},{11,1,0x0002E},
   {11,1,0x0002F},{11,1,0x00030},{11,1,0x00031},{11,1,0x00032},{11,1,0x00033},
   {11,1,0x00034},{11,1,0x00035},{11,1,0x00036},{11,1,0x00037},{11,1,0x00038},
   {11,1,0x00039},{11,1,0x0003A},{11,1,0x0003B},{11,1,0x0003C},{11,1,0x0003D},
   {11,1,0x0003E},{11,1,0x0003F},{11,1,0x00040},{11,1,0x00041},{11,1,0x00042},
   {11,1,0x00043},{11,1,0x00044},{11,1,0x00045},{11,1,0x00046},{11,1,0x00047},
   {11,1,0x00048},{11,1,0x00049},{11,1,0x0004A},{11,1,0x0004B},{11,1,0x0004C},
   {11,1,0x0004D},{11,1,0x0004E},{11,1,0x0004F},{11,1,0x00050},{11,1,0x00051},
   {11,1,0x00052},{11,1,0x00053},{11,1,0x00054},{11,1,0x00055},{11,1,0x00056},
   {11,1,0x00057},{11,1,0x00058},{11,1,0x00059},{11,1,0x0005A},{11,1,0x0005B},
   {11,1,0x0005C},{11,1,0x0005D},{11,1,0x0005E},{11,1,0x0005F},{11,1,0x00060},
   {11,1,0x00061},{11,1,0x00062},{11,1,0x00063},{11,1,0x00064},{11,1,0x00065},
   {11,1,0x00066},{11,1,0x00067},{11,1,0x00068},{11,1,0x00069},{11,1,0x0006A},
   {11,1,0x0006B},{11,1,0x0006C},{11,1,0x0006D},{11,1,0x0006E},{11,1,0x0006F},
   {11,1,0x00070},{11,1,0x00071},{11,1,0x00072},{11,1,0x00073},{11,1,0x00074},
   {11,1,0x00075},{11,1,0x00076},{11,1,0x00077},{11,1,0x00078},{11,1,0x00079},
   {11,1,0x0007A},{11,1,0x0007B},{11,1,0x0007C},{11,1,0x0007D},{11,1,0x0007E},
   {11,1,0x02985},{11,1,0x02986},{12,1,0x03002},{12,1,0x0300C},{12,1,0x0300D},
   {12,1,0x03001},{12,1,0x030FB},{12,1,0x030F2},{12,1,0x030A1},{12,1,0x030A3},
   {12,1,0x030A5},{12,1,0x030A7},{12,1,0x030A9},{12,1,0x030E3},{12,1,0x030E5},
   {12,1,0x030E7},{12,1,0x030C3},{12,1,0x030FC},{12,1,0x030A2},{12,1,0x030A4},
   {12,1,0x030A6},{12,1,0x030A8},{12,1,0x030AA},{12,1,0x030AB},{12,1,0x030AD},
   {12,1,0x030AF},{12,1,0x030B1},{12,1,0x030B3},{12,1,0x030B5},{12,1,0x030B7},
   {12,1,0x030B9},{12,1,0x030BB},{12,1,0x030BD},{12,1,0x030BF},{12,1,0x030C1},
   {12,1,0x030C4},{12,1,0x030C6},{12,1,0x030C8},{12,1,0x030CA},{12,1,0x030CB},
   {12,1,0x030CC},{12,1,0x030CD},{12,1,0x030CE},{12,1,0x030CF},{12,1,0x030D2},
   {12,1,0x030D5},{12,1,0x030D8},{12,1,0x030DB},{12,1,0x030DE},{12,1,0x030DF},
   {12,1,0x030E0},{12,1,0x030E1},{12,1,0x030E2},{12,1,0x030E4},{12,1,0x030E6},
   {12,1,0x030E8},{12,1,0x030E9},{12,1,0x030EA},{12,1,0x030EB},{12,1,0x030EC},
   {12,1,0x030ED},{12,1,0x030EF},{12,1,0x030F3},{12,1,0x03099},{12,1,0x0309A},
   {12,1,0x03164},{12,1,0x03131},{12,1,0x03132},{12,1,0x03133},{12,1,0x03134},
   {12,1,0x03135},{12,1,0x03136},{12,1,0x03137},{12,1,0x03138},{12,1,0x03139},
   {12,1,0x0313A},{12,1,0x0313B},{12,1,0x0313C},{12,1,0x0313D},{12,1,0x0313E},
   {12,1,0x0313F},{12,1,0x03140},{12,1,0x03141},{12,1,0x03142},{12,1,0x03143},
   {12,1,0x03144},{12,1,0x03145},{12,1,0x03146},{12,1,0x03147},{12,1,0x03148},
   {12,1,0x03149},{12,1,0x0314A},{12,1,0x0314B},{12,1,0x0314C},{12,1,0x0314D},
   {12,1,0x0314E},{0,0,0},{0,0,0},{0,0,0},{12,1,0x0314F},
   {12,1,0x03150},{12,1,0x03151},{12,1,0x03152},{12,1,0x03153},{12,1,0x03154},
   {0,0,0},{0,0,0},{12,1,0x03155},{12,1,0x03156},{12,1,0x03157},
   {12,1,0x03158},{12,1,0x03159},{12,1,0x0315A},{0,0,0},{0,0,0},
   {12,1,0x0315B},{12,1,0x0315C},{12,1,0x0315D},{12,1,0x0315E},{12,1,0x0315F},
   {12,1,0x03160},{0,0,0},{0,0,0},{12,1,0x03161},{12,1,0x03162},
   {12,1,0x03163},{0,0,0},{0,0,0},{0,0,0},{11,1,0x000A2},
   {11,1,0x000A3},{11,1,0x000AC},{11,1,0x000AF},{11,1,0x000A6},{11,1,0x000A5},
   {11,1,0x020A9},{0,0,0},{12,1,0x02502},{12,1,0x02190},{12,1,0x02191},
   {12,1,0x02192},{12,1,0x02193},{12,1,0x025A0},{12,1,0x025CB},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 46 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x012A1},
   {0,0,0},{0,2,0x012A3},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x012A5},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 47 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x012A7},{0,2,0x012A9},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 48 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,2,0x012AB},{0,2,0x012AD},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 49 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x012AF},{0,2,0x012B1},{0,0,0},
   {0,2,0x012B3},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 50 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x012B5},{0,2,0x012B7},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 51 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,2,0x012B9},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 52 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,2,0x012BB},
   {0,2,0x012BD},{0,2,0x012BF},{0,2,0x012C1},{0,2,0x012C3},{0,2,0x012C5},
   {0,2,0x012C7},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,2,0x012C9},{0,2,0x012CB},{0,2,0x012CD},
   {0,2,0x012CF},{0,2,0x012D1},{0,2,0x012D3},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 53 */
  {{1,1,0x00041},{1,1,0x00042},{1,1,0x00043},{1,1,0x00044},{1,1,0x00045},
   {1,1,0x00046},{1,1,0x00047},{1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},
   {1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},
   {1,1,0x00050},{1,1,0x00051},{1,1,0x00052},{1,1,0x00053},{1,1,0x00054},
   {1,1,0x00055},{1,1,0x00056},{1,1,0x00057},{1,1,0x00058},{1,1,0x00059},
   {1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},{1,1,0x00063},{1,1,0x00064},
   {1,1,0x00065},{1,1,0x00066},{1,1,0x00067},{1,1,0x00068},{1,1,0x00069},
   {1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},
   {1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},{1,1,0x00072},{1,1,0x00073},
   {1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},{1,1,0x00078},
   {1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},{1,1,0x00043},
   {1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},{1,1,0x00048},
   {1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},
   {1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},{1,1,0x00052},
   {1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},{1,1,0x00057},
   {1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},
   {1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},{1,1,0x00067},
   {0,0,0},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},
   {1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},
   {1,1,0x00072},{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},{1,1,0x00076},
   {1,1,0x00077},{1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},
   {1,1,0x00042},{1,1,0x00043},{1,1,0x00044},{1,1,0x00045},{1,1,0x00046},
   {1,1,0x00047},{1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},
   {1,1,0x0004C},{1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},
   {1,1,0x00051},{1,1,0x00052},{1,1,0x00053},{1,1,0x00054},{1,1,0x00055},
   {1,1,0x00056},{1,1,0x00057},{1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},
   {1,1,0x00061},{1,1,0x00062},{1,1,0x00063},{1,1,0x00064},{1,1,0x00065},
   {1,1,0x00066},{1,1,0x00067},{1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},
   {1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},
   {1,1,0x00070},{1,1,0x00071},{1,1,0x00072},{1,1,0x00073},{1,1,0x00074},
   {1,1,0x00075},{1,1,0x00076},{1,1,0x00077},{1,1,0x00078},{1,1,0x00079},
   {1,1,0x0007A},{1,1,0x00041},{0,0,0},{1,1,0x00043},{1,1,0x00044},
   {0,0,0},{0,0,0},{1,1,0x00047},{0,0,0},{0,0,0},
   {1,1,0x0004A},{1,1,0x0004B},{0,0,0},{0,0,0},{1,1,0x0004E},
   {1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},{0,0,0},{1,1,0x00053},
   {1,1,0x00054},{1,1,0x00055},{1,1,0x00056},{1,1,0x00057},{1,1,0x00058},
   {1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},{1,1,0x00063},
   {1,1,0x00064},{0,0,0},{1,1,0x00066},{0,0,0},{1,1,0x00068},
   {1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},
   {1,1,0x0006E},{0,0,0},{1,1,0x00070},{1,1,0x00071},{1,1,0x00072},
   {1,1,0x00073},{1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},
   {1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},
   {1,1,0x00043},{1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},
   {1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},
   {1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},
   {1,1,0x00052},{1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},
   {1,1,0x00057},{1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},
   {1,1,0x00062},{1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},
   {1,1,0x00067},{1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},
   {1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},
   {1,1,0x00071},{1,1,0x00072},{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},
   {1,1,0x00076}
  },

  /* block 54 */
  {{1,1,0x00077},{1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},
   {1,1,0x00042},{0,0,0},{1,1,0x00044},{1,1,0x00045},{1,1,0x00046},
   {1,1,0x00047},{0,0,0},{0,0,0},{1,1,0x0004A},{1,1,0x0004B},
   {1,1,0x0004C},{1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},
   {1,1,0x00051},{0,0,0},{1,1,0x00053},{1,1,0x00054},{1,1,0x00055},
   {1,1,0x00056},{1,1,0x00057},{1,1,0x00058},{1,1,0x00059},{0,0,0},
   {1,1,0x00061},{1,1,0x00062},{1,1,0x00063},{1,1,0x00064},{1,1,0x00065},
   {1,1,0x00066},{1,1,0x00067},{1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},
   {1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},
   {1,1,0x00070},{1,1,0x00071},{1,1,0x00072},{1,1,0x00073},{1,1,0x00074},
   {1,1,0x00075},{1,1,0x00076},{1,1,0x00077},{1,1,0x00078},{1,1,0x00079},
   {1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},{0,0,0},{1,1,0x00044},
   {1,1,0x00045},{1,1,0x00046},{1,1,0x00047},{0,0,0},{1,1,0x00049},
   {1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},{0,0,0},
   {1,1,0x0004F},{0,0,0},{0,0,0},{0,0,0},{1,1,0x00053},
   {1,1,0x00054},{1,1,0x00055},{1,1,0x00056},{1,1,0x00057},{1,1,0x00058},
   {1,1,0x00059},{0,0,0},{1,1,0x00061},{1,1,0x00062},{1,1,0x00063},
   {1,1,0x00064},{1,1,0x00065},{1,1,0x00066},{1,1,0x00067},{1,1,0x00068},
   {1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},
   {1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},{1,1,0x00072},
   {1,1,0x00073},{1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},
   {1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},
   {1,1,0x00043},{1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},
   {1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},
   {1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},
   {1,1,0x00052},{1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},
   {1,1,0x00057},{1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},
   {1,1,0x00062},{1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},
   {1,1,0x00067},{1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},
   {1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},
   {1,1,0x00071},{1,1,0x00072},{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},
   {1,1,0x00076},{1,1,0x00077},{1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},
   {1,1,0x00041},{1,1,0x00042},{1,1,0x00043},{1,1,0x00044},{1,1,0x00045},
   {1,1,0x00046},{1,1,0x00047},{1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},
   {1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},
   {1,1,0x00050},{1,1,0x00051},{1,1,0x00052},{1,1,0x00053},{1,1,0x00054},
   {1,1,0x00055},{1,1,0x00056},{1,1,0x00057},{1,1,0x00058},{1,1,0x00059},
   {1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},{1,1,0x00063},{1,1,0x00064},
   {1,1,0x00065},{1,1,0x00066},{1,1,0x00067},{1,1,0x00068},{1,1,0x00069},
   {1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},
   {1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},{1,1,0x00072},{1,1,0x00073},
   {1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},{1,1,0x00078},
   {1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},{1,1,0x00043},
   {1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},{1,1,0x00048},
   {1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},
   {1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},{1,1,0x00052},
   {1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},{1,1,0x00057},
   {1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},
   {1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},{1,1,0x00067},
   {1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},
   {1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},
   {1,1,0x00072}
  },

  /* block 55 */
  {{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},
   {1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},
   {1,1,0x00043},{1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},
   {1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},
   {1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},
   {1,1,0x00052},{1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},
   {1,1,0x00057},{1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},
   {1,1,0x00062},{1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},
   {1,1,0x00067},{1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},
   {1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},
   {1,1,0x00071},{1,1,0x00072},{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},
   {1,1,0x00076},{1,1,0x00077},{1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},
   {1,1,0x00041},{1,1,0x00042},{1,1,0x00043},{1,1,0x00044},{1,1,0x00045},
   {1,1,0x00046},{1,1,0x00047},{1,1,0x00048},{1,1,0x00049},{1,1,0x0004A},
   {1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},{1,1,0x0004E},{1,1,0x0004F},
   {1,1,0x00050},{1,1,0x00051},{1,1,0x00052},{1,1,0x00053},{1,1,0x00054},
   {1,1,0x00055},{1,1,0x00056},{1,1,0x00057},{1,1,0x00058},{1,1,0x00059},
   {1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},{1,1,0x00063},{1,1,0x00064},
   {1,1,0x00065},{1,1,0x00066},{1,1,0x00067},{1,1,0x00068},{1,1,0x00069},
   {1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},{1,1,0x0006D},{1,1,0x0006E},
   {1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},{1,1,0x00072},{1,1,0x00073},
   {1,1,0x00074},{1,1,0x00075},{1,1,0x00076},{1,1,0x00077},{1,1,0x00078},
   {1,1,0x00079},{1,1,0x0007A},{1,1,0x00041},{1,1,0x00042},{1,1,0x00043},
   {1,1,0x00044},{1,1,0x00045},{1,1,0x00046},{1,1,0x00047},{1,1,0x00048},
   {1,1,0x00049},{1,1,0x0004A},{1,1,0x0004B},{1,1,0x0004C},{1,1,0x0004D},
   {1,1,0x0004E},{1,1,0x0004F},{1,1,0x00050},{1,1,0x00051},{1,1,0x00052},
   {1,1,0x00053},{1,1,0x00054},{1,1,0x00055},{1,1,0x00056},{1,1,0x00057},
   {1,1,0x00058},{1,1,0x00059},{1,1,0x0005A},{1,1,0x00061},{1,1,0x00062},
   {1,1,0x00063},{1,1,0x00064},{1,1,0x00065},{1,1,0x00066},{1,1,0x00067},
   {1,1,0x00068},{1,1,0x00069},{1,1,0x0006A},{1,1,0x0006B},{1,1,0x0006C},
   {1,1,0x0006D},{1,1,0x0006E},{1,1,0x0006F},{1,1,0x00070},{1,1,0x00071},
   {1,1,0x00072},{1,1,0x00073},{1,1,0x00074},{1,1,0x00075},{1,1,0x00076},
   {1,1,0x00077},{1,1,0x00078},{1,1,0x00079},{1,1,0x0007A},{1,1,0x00131},
   {1,1,0x00237},{0,0,0},{0,0,0},{1,1,0x00391},{1,1,0x00392},
   {1,1,0x00393},{1,1,0x00394},{1,1,0x00395},{1,1,0x00396},{1,1,0x00397},
   {1,1,0x00398},{1,1,0x00399},{1,1,0x0039A},{1,1,0x0039B},{1,1,0x0039C},
   {1,1,0x0039D},{1,1,0x0039E},{1,1,0x0039F},{1,1,0x003A0},{1,1,0x003A1},
   {1,1,0x003F4},{1,1,0x003A3},{1,1,0x003A4},{1,1,0x003A5},{1,1,0x003A6},
   {1,1,0x003A7},{1,1,0x003A8},{1,1,0x003A9},{1,1,0x02207},{1,1,0x003B1},
   {1,1,0x003B2},{1,1,0x003B3},{1,1,0x003B4},{1,1,0x003B5},{1,1,0x003B6},
   {1,1,0x003B7},{1,1,0x003B8},{1,1,0x003B9},{1,1,0x003BA},{1,1,0x003BB},
   {1,1,0x003BC},{1,1,0x003BD},{1,1,0x003BE},{1,1,0x003BF},{1,1,0x003C0},
   {1,1,0x003C1},{1,1,0x003C2},{1,1,0x003C3},{1,1,0x003C4},{1,1,0x003C5},
   {1,1,0x003C6},{1,1,0x003C7},{1,1,0x003C8},{1,1,0x003C9},{1,1,0x02202},
   {1,1,0x003F5},{1,1,0x003D1},{1,1,0x003F0},{1,1,0x003D5},{1,1,0x003F1},
   {1,1,0x003D6},{1,1,0x00391},{1,1,0x00392},{1,1,0x00393},{1,1,0x00394},
   {1,1,0x00395},{1,1,0x00396},{1,1,0x00397},{1,1,0x00398},{1,1,0x00399},
   {1,1,0x0039A},{1,1,0x0039B},{1,1,0x0039C},{1,1,0x0039D},{1,1,0x0039E},
   {1,1,0x0039F},{1,1,0x003A0},{1,1,0x003A1},{1,1,0x003F4},{1,1,0x003A3},
   {1,1,0x003A4},{1,1,0x003A5},{1,1,0x003A6},{1,1,0x003A7},{1,1,0x003A8},
   {1,1,0x003A9},{1,1,0x02207},{1,1,0x003B1},{1,1,0x003B2},{1,1,0x003B3},
   {1,1,0x003B4}
  },

  /* block 56 */
  {{1,1,0x003B5},{1,1,0x003B6},{1,1,0x003B7},{1,1,0x003B8},{1,1,0x003B9},
   {1,1,0x003BA},{1,1,0x003BB},{1,1,0x003BC},{1,1,0x003BD},{1,1,0x003BE},
   {1,1,0x003BF},{1,1,0x003C0},{1,1,0x003C1},{1,1,0x003C2},{1,1,0x003C3},
   {1,1,0x003C4},{1,1,0x003C5},{1,1,0x003C6},{1,1,0x003C7},{1,1,0x003C8},
   {1,1,0x003C9},{1,1,0x02202},{1,1,0x003F5},{1,1,0x003D1},{1,1,0x003F0},
   {1,1,0x003D5},{1,1,0x003F1},{1,1,0x003D6},{1,1,0x00391},{1,1,0x00392},
   {1,1,0x00393},{1,1,0x00394},{1,1,0x00395},{1,1,0x00396},{1,1,0x00397},
   {1,1,0x00398},{1,1,0x00399},{1,1,0x0039A},{1,1,0x0039B},{1,1,0x0039C},
   {1,1,0x0039D},{1,1,0x0039E},{1,1,0x0039F},{1,1,0x003A0},{1,1,0x003A1},
   {1,1,0x003F4},{1,1,0x003A3},{1,1,0x003A4},{1,1,0x003A5},{1,1,0x003A6},
   {1,1,0x003A7},{1,1,0x003A8},{1,1,0x003A9},{1,1,0x02207},{1,1,0x003B1},
   {1,1,0x003B2},{1,1,0x003B3},{1,1,0x003B4},{1,1,0x003B5},{1,1,0x003B6},
   {1,1,0x003B7},{1,1,0x003B8},{1,1,0x003B9},{1,1,0x003BA},{1,1,0x003BB},
   {1,1,0x003BC},{1,1,0x003BD},{1,1,0x003BE},{1,1,0x003BF},{1,1,0x003C0},
   {1,1,0x003C1},{1,1,0x003C2},{1,1,0x003C3},{1,1,0x003C4},{1,1,0x003C5},
   {1,1,0x003C6},{1,1,0x003C7},{1,1,0x003C8},{1,1,0x003C9},{1,1,0x02202},
   {1,1,0x003F5},{1,1,0x003D1},{1,1,0x003F0},{1,1,0x003D5},{1,1,0x003F1},
   {1,1,0x003D6},{1,1,0x00391},{1,1,0x00392},{1,1,0x00393},{1,1,0x00394},
   {1,1,0x00395},{1,1,0x00396},{1,1,0x00397},{1,1,0x00398},{1,1,0x00399},
   {1,1,0x0039A},{1,1,0x0039B},{1,1,0x0039C},{1,1,0x0039D},{1,1,0x0039E},
   {1,1,0x0039F},{1,1,0x003A0},{1,1,0x003A1},{1,1,0x003F4},{1,1,0x003A3},
   {1,1,0x003A4},{1,1,0x003A5},{1,1,0x003A6},{1,1,0x003A7},{1,1,0x003A8},
   {1,1,0x003A9},{1,1,0x02207},{1,1,0x003B1},{1,1,0x003B2},{1,1,0x003B3},
   {1,1,0x003B4},{1,1,0x003B5},{1,1,0x003B6},{1,1,0x003B7},{1,1,0x003B8},
   {1,1,0x003B9},{1,1,0x003BA},{1,1,0x003BB},{1,1,0x003BC},{1,1,0x003BD},
   {1,1,0x003BE},{1,1,0x003BF},{1,1,0x003C0},{1,1,0x003C1},{1,1,0x003C2},
   {1,1,0x003C3},{1,1,0x003C4},{1,1,0x003C5},{1,1,0x003C6},{1,1,0x003C7},
   {1,1,0x003C8},{1,1,0x003C9},{1,1,0x02202},{1,1,0x003F5},{1,1,0x003D1},
   {1,1,0x003F0},{1,1,0x003D5},{1,1,0x003F1},{1,1,0x003D6},{1,1,0x00391},
   {1,1,0x00392},{1,1,0x00393},{1,1,0x00394},{1,1,0x00395},{1,1,0x00396},
   {1,1,0x00397},{1,1,0x00398},{1,1,0x00399},{1,1,0x0039A},{1,1,0x0039B},
   {1,1,0x0039C},{1,1,0x0039D},{1,1,0x0039E},{1,1,0x0039F},{1,1,0x003A0},
   {1,1,0x003A1},{1,1,0x003F4},{1,1,0x003A3},{1,1,0x003A4},{1,1,0x003A5},
   {1,1,0x003A6},{1,1,0x003A7},{1,1,0x003A8},{1,1,0x003A9},{1,1,0x02207},
   {1,1,0x003B1},{1,1,0x003B2},{1,1,0x003B3},{1,1,0x003B4},{1,1,0x003B5},
   {1,1,0x003B6},{1,1,0x003B7},{1,1,0x003B8},{1,1,0x003B9},{1,1,0x003BA},
   {1,1,0x003BB},{1,1,0x003BC},{1,1,0x003BD},{1,1,0x003BE},{1,1,0x003BF},
   {1,1,0x003C0},{1,1,0x003C1},{1,1,0x003C2},{1,1,0x003C3},{1,1,0x003C4},
   {1,1,0x003C5},{1,1,0x003C6},{1,1,0x003C7},{1,1,0x003C8},{1,1,0x003C9},
   {1,1,0x02202},{1,1,0x003F5},{1,1,0x003D1},{1,1,0x003F0},{1,1,0x003D5},
   {1,1,0x003F1},{1,1,0x003D6},{1,1,0x003DC},{1,1,0x003DD},{0,0,0},
   {0,0,0},{1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},
   {1,1,0x00034},{1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},
   {1,1,0x00039},{1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},
   {1,1,0x00034},{1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},
   {1,1,0x00039},{1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},
   {1,1,0x00034},{1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},
   {1,1,0x00039},{1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},
   {1,1,0x00034},{1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},
   {1,1,0x00039},{1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},
   {1,1,0x00034},{1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},
   {1,1,0x00039}
  },

  /* block 57 */
  {{1,1,0x00627},{1,1,0x00628},{1,1,0x0062C},{1,1,0x0062F},{0,0,0},
   {1,1,0x00648},{1,1,0x00632},{1,1,0x0062D},{1,1,0x00637},{1,1,0x0064A},
   {1,1,0x00643},{1,1,0x00644},{1,1,0x00645},{1,1,0x00646},{1,1,0x00633},
   {1,1,0x00639},{1,1,0x00641},{1,1,0x00635},{1,1,0x00642},{1,1,0x00631},
   {1,1,0x00634},{1,1,0x0062A},{1,1,0x0062B},{1,1,0x0062E},{1,1,0x00630},
   {1,1,0x00636},{1,1,0x00638},{1,1,0x0063A},{1,1,0x0066E},{1,1,0x006BA},
   {1,1,0x006A1},{1,1,0x0066F},{0,0,0},{1,1,0x00628},{1,1,0x0062C},
   {0,0,0},{1,1,0x00647},{0,0,0},{0,0,0},{1,1,0x0062D},
   {0,0,0},{1,1,0x0064A},{1,1,0x00643},{1,1,0x00644},{1,1,0x00645},
   {1,1,0x00646},{1,1,0x00633},{1,1,0x00639},{1,1,0x00641},{1,1,0x00635},
   {1,1,0x00642},{0,0,0},{1,1,0x00634},{1,1,0x0062A},{1,1,0x0062B},
   {1,1,0x0062E},{0,0,0},{1,1,0x00636},{0,0,0},{1,1,0x0063A},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{1,1,0x0062C},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{1,1,0x0062D},{0,0,0},{1,1,0x0064A},{0,0,0},
   {1,1,0x00644},{0,0,0},{1,1,0x00646},{1,1,0x00633},{1,1,0x00639},
   {0,0,0},{1,1,0x00635},{1,1,0x00642},{0,0,0},{1,1,0x00634},
   {0,0,0},{0,0,0},{1,1,0x0062E},{0,0,0},{1,1,0x00636},
   {0,0,0},{1,1,0x0063A},{0,0,0},{1,1,0x006BA},{0,0,0},
   {1,1,0x0066F},{0,0,0},{1,1,0x00628},{1,1,0x0062C},{0,0,0},
   {1,1,0x00647},{0,0,0},{0,0,0},{1,1,0x0062D},{1,1,0x00637},
   {1,1,0x0064A},{1,1,0x00643},{0,0,0},{1,1,0x00645},{1,1,0x00646},
   {1,1,0x00633},{1,1,0x00639},{1,1,0x00641},{1,1,0x00635},{1,1,0x00642},
   {0,0,0},{1,1,0x00634},{1,1,0x0062A},{1,1,0x0062B},{1,1,0x0062E},
   {0,0,0},{1,1,0x00636},{1,1,0x00638},{1,1,0x0063A},{1,1,0x0066E},
   {0,0,0},{1,1,0x006A1},{0,0,0},{1,1,0x00627},{1,1,0x00628},
   {1,1,0x0062C},{1,1,0x0062F},{1,1,0x00647},{1,1,0x00648},{1,1,0x00632},
   {1,1,0x0062D},{1,1,0x00637},{1,1,0x0064A},{0,0,0},{1,1,0x00644},
   {1,1,0x00645},{1,1,0x00646},{1,1,0x00633},{1,1,0x00639},{1,1,0x00641},
   {1,1,0x00635},{1,1,0x00642},{1,1,0x00631},{1,1,0x00634},{1,1,0x0062A},
   {1,1,0x0062B},{1,1,0x0062E},{1,1,0x00630},{1,1,0x00636},{1,1,0x00638},
   {1,1,0x0063A},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{1,1,0x00628},{1,1,0x0062C},{1,1,0x0062F},{0,0,0},
   {1,1,0x00648},{1,1,0x00632},{1,1,0x0062D},{1,1,0x00637},{1,1,0x0064A},
   {0,0,0},{1,1,0x00644},{1,1,0x00645},{1,1,0x00646},{1,1,0x00633},
   {1,1,0x00639},{1,1,0x00641},{1,1,0x00635},{1,1,0x00642},{1,1,0x00631},
   {1,1,0x00634},{1,1,0x0062A},{1,1,0x0062B},{1,1,0x0062E},{1,1,0x00630},
   {1,1,0x00636},{1,1,0x00638},{1,1,0x0063A},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 58 */
  {{16,2,0x012D5},{16,2,0x012D7},{16,2,0x012D9},{16,2,0x012DB},{16,2,0x012DD},
   {16,2,0x012DF},{16,2,0x012E1},{16,2,0x012E3},{16,2,0x012E5},{16,2,0x012E7},
   {16,2,0x012E9},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{16,3,0x012EB},{16,3,0x012EE},{16,3,0x012F1},{16,3,0x012F4},
   {16,3,0x012F7},{16,3,0x012FA},{16,3,0x012FD},{16,3,0x01300},{16,3,0x01303},
   {16,3,0x01306},{16,3,0x01309},{16,3,0x0130C},{16,3,0x0130F},{16,3,0x01312},
   {16,3,0x01315},{16,3,0x01318},{16,3,0x0131B},{16,3,0x0131E},{16,3,0x01321},
   {16,3,0x01324},{16,3,0x01327},{16,3,0x0132A},{16,3,0x0132D},{16,3,0x01330},
   {16,3,0x01333},{16,3,0x01336},{16,3,0x01339},{7,1,0x00043},{7,1,0x00052},
   {7,2,0x0133C},{7,2,0x0133E},{0,0,0},{14,1,0x00041},{14,1,0x00042},
   {14,1,0x00043},{14,1,0x00044},{14,1,0x00045},{14,1,0x00046},{14,1,0x00047},
   {14,1,0x00048},{14,1,0x00049},{14,1,0x0004A},{14,1,0x0004B},{14,1,0x0004C},
   {14,1,0x0004D},{14,1,0x0004E},{14,1,0x0004F},{14,1,0x00050},{14,1,0x00051},
   {14,1,0x00052},{14,1,0x00053},{14,1,0x00054},{14,1,0x00055},{14,1,0x00056},
   {14,1,0x00057},{14,1,0x00058},{14,1,0x00059},{14,1,0x0005A},{14,2,0x01340},
   {14,2,0x01342},{14,2,0x01344},{14,2,0x01346},{14,3,0x01348},{14,2,0x0134B},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{8,2,0x0134D},{8,2,0x0134F},{8,2,0x01351},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{14,2,0x01353},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 59 */
  {{14,2,0x01355},{14,2,0x01357},{14,1,0x030B5},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{14,1,0x0624B},{14,1,0x05B57},{14,1,0x053CC},{14,1,0x030C7},
   {14,1,0x04E8C},{14,1,0x0591A},{14,1,0x089E3},{14,1,0x05929},{14,1,0x04EA4},
   {14,1,0x06620},{14,1,0x07121},{14,1,0x06599},{14,1,0x0524D},{14,1,0x05F8C},
   {14,1,0x0518D},{14,1,0x065B0},{14,1,0x0521D},{14,1,0x07D42},{14,1,0x0751F},
   {14,1,0x08CA9},{14,1,0x058F0},{14,1,0x05439},{14,1,0x06F14},{14,1,0x06295},
   {14,1,0x06355},{14,1,0x04E00},{14,1,0x04E09},{14,1,0x0904A},{14,1,0x05DE6},
   {14,1,0x04E2D},{14,1,0x053F3},{14,1,0x06307},{14,1,0x08D70},{14,1,0x06253},
   {14,1,0x07981},{14,1,0x07A7A},{14,1,0x05408},{14,1,0x06E80},{14,1,0x06709},
   {14,1,0x06708},{14,1,0x07533},{14,1,0x05272},{14,1,0x055B6},{14,1,0x0914D},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{16,3,0x01359},
   {16,3,0x0135C},{16,3,0x0135F},{16,3,0x01362},{16,3,0x01365},{16,3,0x01368},
   {16,3,0x0136B},{16,3,0x0136E},{16,3,0x01371},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {7,1,0x05F97},{7,1,0x053EF},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 60 */
  {{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {1,1,0x00030},{1,1,0x00031},{1,1,0x00032},{1,1,0x00033},{1,1,0x00034},
   {1,1,0x00035},{1,1,0x00036},{1,1,0x00037},{1,1,0x00038},{1,1,0x00039},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  },

  /* block 61 */
  {{0,1,0x04E3D},{0,1,0x04E38},{0,1,0x04E41},{0,1,0x20122},{0,1,0x04F60},
   {0,1,0x04FAE},{0,1,0x04FBB},{0,1,0x05002},{0,1,0x0507A},{0,1,0x05099},
   {0,1,0x050E7},{0,1,0x050CF},{0,1,0x0349E},{0,1,0x2063A},{0,1,0x0514D},
   {0,1,0x05154},{0,1,0x05164},{0,1,0x05177},{0,1,0x2051C},{0,1,0x034B9},
   {0,1,0x05167},{0,1,0x0518D},{0,1,0x2054B},{0,1,0x05197},{0,1,0x051A4},
   {0,1,0x04ECC},{0,1,0x051AC},{0,1,0x051B5},{0,1,0x291DF},{0,1,0x051F5},
   {0,1,0x05203},{0,1,0x034DF},{0,1,0x0523B},{0,1,0x05246},{0,1,0x05272},
   {0,1,0x05277},{0,1,0x03515},{0,1,0x052C7},{0,1,0x052C9},{0,1,0x052E4},
   {0,1,0x052FA},{0,1,0x05305},{0,1,0x05306},{0,1,0x05317},{0,1,0x05349},
   {0,1,0x05351},{0,1,0x0535A},{0,1,0x05373},{0,1,0x0537D},{0,1,0x0537F},
   {0,1,0x0537F},{0,1,0x0537F},{0,1,0x20A2C},{0,1,0x07070},{0,1,0x053CA},
   {0,1,0x053DF},{0,1,0x20B63},{0,1,0x053EB},{0,1,0x053F1},{0,1,0x05406},
   {0,1,0x0549E},{0,1,0x05438},{0,1,0x05448},{0,1,0x05468},{0,1,0x054A2},
   {0,1,0x054F6},{0,1,0x05510},{0,1,0x05553},{0,1,0x05563},{0,1,0x05584},
   {0,1,0x05584},{0,1,0x05599},{0,1,0x055AB},{0,1,0x055B3},{0,1,0x055C2},
   {0,1,0x05716},{0,1,0x05606},{0,1,0x05717},{0,1,0x05651},{0,1,0x05674},
   {0,1,0x05207},{0,1,0x058EE},{0,1,0x057CE},{0,1,0x057F4},{0,1,0x0580D},
   {0,1,0x0578B},{0,1,0x05832},{0,1,0x05831},{0,1,0x058AC},{0,1,0x214E4},
   {0,1,0x058F2},{0,1,0x058F7},{0,1,0x05906},{0,1,0x0591A},{0,1,0x05922},
   {0,1,0x05962},{0,1,0x216A8},{0,1,0x216EA},{0,1,0x059EC},{0,1,0x05A1B},
   {0,1,0x05A27},{0,1,0x059D8},{0,1,0x05A66},{0,1,0x036EE},{0,1,0x036FC},
   {0,1,0x05B08},{0,1,0x05B3E},{0,1,0x05B3E},{0,1,0x219C8},{0,1,0x05BC3},
   {0,1,0x05BD8},{0,1,0x05BE7},{0,1,0x05BF3},{0,1,0x21B18},{0,1,0x05BFF},
   {0,1,0x05C06},{0,1,0x05F53},{0,1,0x05C22},{0,1,0x03781},{0,1,0x05C60},
   {0,1,0x05C6E},{0,1,0x05CC0},{0,1,0x05C8D},{0,1,0x21DE4},{0,1,0x05D43},
   {0,1,0x21DE6},{0,1,0x05D6E},{0,1,0x05D6B},{0,1,0x05D7C},{0,1,0x05DE1},
   {0,1,0x05DE2},{0,1,0x0382F},{0,1,0x05DFD},{0,1,0x05E28},{0,1,0x05E3D},
   {0,1,0x05E69},{0,1,0x03862},{0,1,0x22183},{0,1,0x0387C},{0,1,0x05EB0},
   {0,1,0x05EB3},{0,1,0x05EB6},{0,1,0x05ECA},{0,1,0x2A392},{0,1,0x05EFE},
   {0,1,0x22331},{0,1,0x22331},{0,1,0x08201},{0,1,0x05F22},{0,1,0x05F22},
   {0,1,0x038C7},{0,1,0x232B8},{0,1,0x261DA},{0,1,0x05F62},{0,1,0x05F6B},
   {0,1,0x038E3},{0,1,0x05F9A},{0,1,0x05FCD},{0,1,0x05FD7},{0,1,0x05FF9},
   {0,1,0x06081},{0,1,0x0393A},{0,1,0x0391C},{0,1,0x06094},{0,1,0x226D4},
   {0,1,0x060C7},{0,1,0x06148},{0,1,0x0614C},{0,1,0x0614E},{0,1,0x0614C},
   {0,1,0x0617A},{0,1,0x0618E},{0,1,0x061B2},{0,1,0x061A4},{0,1,0x061AF},
   {0,1,0x061DE},{0,1,0x061F2},{0,1,0x061F6},{0,1,0x06210},{0,1,0x0621B},
   {0,1,0x0625D},{0,1,0x062B1},{0,1,0x062D4},{0,1,0x06350},{0,1,0x22B0C},
   {0,1,0x0633D},{0,1,0x062FC},{0,1,0x06368},{0,1,0x06383},{0,1,0x063E4},
   {0,1,0x22BF1},{0,1,0x06422},{0,1,0x063C5},{0,1,0x063A9},{0,1,0x03A2E},
   {0,1,0x06469},{0,1,0x0647E},{0,1,0x0649D},{0,1,0x06477},{0,1,0x03A6C},
   {0,1,0x0654F},{0,1,0x0656C},{0,1,0x2300A},{0,1,0x065E3},{0,1,0x066F8},
   {0,1,0x06649},{0,1,0x03B19},{0,1,0x06691},{0,1,0x03B08},{0,1,0x03AE4},
   {0,1,0x05192},{0,1,0x05195},{0,1,0x06700},{0,1,0x0669C},{0,1,0x080AD},
   {0,1,0x043D9},{0,1,0x06717},{0,1,0x0671B},{0,1,0x06721},{0,1,0x0675E},
   {0,1,0x06753},{0,1,0x233C3},{0,1,0x03B49},{0,1,0x067FA},{0,1,0x06785},
   {0,1,0x06852},{0,1,0x06885},{0,1,0x2346D},{0,1,0x0688E},{0,1,0x0681F},
   {0,1,0x06914},{0,1,0x03B9D},{0,1,0x06942},{0,1,0x069A3},{0,1,0x069EA},
   {0,1,0x06AA8},{0,1,0x236A3},{0,1,0x06ADB},{0,1,0x03C18},{0,1,0x06B21},
   {0,1,0x238A7},{0,1,0x06B54},{0,1,0x03C4E},{0,1,0x06B72},{0,1,0x06B9F},
   {0,1,0x06BBA},{0,1,0x06BBB},{0,1,0x23A8D},{0,1,0x21D0B},{0,1,0x23AFA},
   {0,1,0x06C4E},{0,1,0x23CBC},{0,1,0x06CBF},{0,1,0x06CCD},{0,1,0x06C67},
   {0,1,0x06D16}
  },

  /* block 62 */
  {{0,1,0x06D3E},{0,1,0x06D77},{0,1,0x06D41},{0,1,0x06D69},{0,1,0x06D78},
   {0,1,0x06D85},{0,1,0x23D1E},{0,1,0x06D34},{0,1,0x06E2F},{0,1,0x06E6E},
   {0,1,0x03D33},{0,1,0x06ECB},{0,1,0x06EC7},{0,1,0x23ED1},{0,1,0x06DF9},
   {0,1,0x06F6E},{0,1,0x23F5E},{0,1,0x23F8E},{0,1,0x06FC6},{0,1,0x07039},
   {0,1,0x0701E},{0,1,0x0701B},{0,1,0x03D96},{0,1,0x0704A},{0,1,0x0707D},
   {0,1,0x07077},{0,1,0x070AD},{0,1,0x20525},{0,1,0x07145},{0,1,0x24263},
   {0,1,0x0719C},{0,1,0x243AB},{0,1,0x07228},{0,1,0x07235},{0,1,0x07250},
   {0,1,0x24608},{0,1,0x07280},{0,1,0x07295},{0,1,0x24735},{0,1,0x24814},
   {0,1,0x0737A},{0,1,0x0738B},{0,1,0x03EAC},{0,1,0x073A5},{0,1,0x03EB8},
   {0,1,0x03EB8},{0,1,0x07447},{0,1,0x0745C},{0,1,0x07471},{0,1,0x07485},
   {0,1,0x074CA},{0,1,0x03F1B},{0,1,0x07524},{0,1,0x24C36},{0,1,0x0753E},
   {0,1,0x24C92},{0,1,0x07570},{0,1,0x2219F},{0,1,0x07610},{0,1,0x24FA1},
   {0,1,0x24FB8},{0,1,0x25044},{0,1,0x03FFC},{0,1,0x04008},{0,1,0x076F4},
   {0,1,0x250F3},{0,1,0x250F2},{0,1,0x25119},{0,1,0x25133},{0,1,0x0771E},
   {0,1,0x0771F},{0,1,0x0771F},{0,1,0x0774A},{0,1,0x04039},{0,1,0x0778B},
   {0,1,0x04046},{0,1,0x04096},{0,1,0x2541D},{0,1,0x0784E},{0,1,0x0788C},
   {0,1,0x078CC},{0,1,0x040E3},{0,1,0x25626},{0,1,0x07956},{0,1,0x2569A},
   {0,1,0x256C5},{0,1,0x0798F},{0,1,0x079EB},{0,1,0x0412F},{0,1,0x07A40},
   {0,1,0x07A4A},{0,1,0x07A4F},{0,1,0x2597C},{0,1,0x25AA7},{0,1,0x25AA7},
   {0,1,0x07AEE},{0,1,0x04202},{0,1,0x25BAB},{0,1,0x07BC6},{0,1,0x07BC9},
   {0,1,0x04227},{0,1,0x25C80},{0,1,0x07CD2},{0,1,0x042A0},{0,1,0x07CE8},
   {0,1,0x07CE3},{0,1,0x07D00},{0,1,0x25F86},{0,1,0x07D63},{0,1,0x04301},
   {0,1,0x07DC7},{0,1,0x07E02},{0,1,0x07E45},{0,1,0x04334},{0,1,0x26228},
   {0,1,0x26247},{0,1,0x04359},{0,1,0x262D9},{0,1,0x07F7A},{0,1,0x2633E},
   {0,1,0x07F95},{0,1,0x07FFA},{0,1,0x08005},{0,1,0x264DA},{0,1,0x26523},
   {0,1,0x08060},{0,1,0x265A8},{0,1,0x08070},{0,1,0x2335F},{0,1,0x043D5},
   {0,1,0x080B2},{0,1,0x08103},{0,1,0x0440B},{0,1,0x0813E},{0,1,0x05AB5},
   {0,1,0x267A7},{0,1,0x267B5},{0,1,0x23393},{0,1,0x2339C},{0,1,0x08201},
   {0,1,0x08204},{0,1,0x08F9E},{0,1,0x0446B},{0,1,0x08291},{0,1,0x0828B},
   {0,1,0x0829D},{0,1,0x052B3},{0,1,0x082B1},{0,1,0x082B3},{0,1,0x082BD},
   {0,1,0x082E6},{0,1,0x26B3C},{0,1,0x082E5},{0,1,0x0831D},{0,1,0x08363},
   {0,1,0x083AD},{0,1,0x08323},{0,1,0x083BD},{0,1,0x083E7},{0,1,0x08457},
   {0,1,0x08353},{0,1,0x083CA},{0,1,0x083CC},{0,1,0x083DC},{0,1,0x26C36},
   {0,1,0x26D6B},{0,1,0x26CD5},{0,1,0x0452B},{0,1,0x084F1},{0,1,0x084F3},
   {0,1,0x08516},{0,1,0x273CA},{0,1,0x08564},{0,1,0x26F2C},{0,1,0x0455D},
   {0,1,0x04561},{0,1,0x26FB1},{0,1,0x270D2},{0,1,0x0456B},{0,1,0x08650},
   {0,1,0x0865C},{0,1,0x08667},{0,1,0x08669},{0,1,0x086A9},{0,1,0x08688},
   {0,1,0x0870E},{0,1,0x086E2},{0,1,0x08779},{0,1,0x08728},{0,1,0x0876B},
   {0,1,0x08786},{0,1,0x045D7},{0,1,0x087E1},{0,1,0x08801},{0,1,0x045F9},
   {0,1,0x08860},{0,1,0x08863},{0,1,0x27667},{0,1,0x088D7},{0,1,0x088DE},
   {0,1,0x04635},{0,1,0x088FA},{0,1,0x034BB},{0,1,0x278AE},{0,1,0x27966},
   {0,1,0x046BE},{0,1,0x046C7},{0,1,0x08AA0},{0,1,0x08AED},{0,1,0x08B8A},
   {0,1,0x08C55},{0,1,0x27CA8},{0,1,0x08CAB},{0,1,0x08CC1},{0,1,0x08D1B},
   {0,1,0x08D77},{0,1,0x27F2F},{0,1,0x20804},{0,1,0x08DCB},{0,1,0x08DBC},
   {0,1,0x08DF0},{0,1,0x208DE},{0,1,0x08ED4},{0,1,0x08F38},{0,1,0x285D2},
   {0,1,0x285ED},{0,1,0x09094},{0,1,0x090F1},{0,1,0x09111},{0,1,0x2872E},
   {0,1,0x0911B},{0,1,0x09238},{0,1,0x092D7},{0,1,0x092D8},{0,1,0x0927C},
   {0,1,0x093F9},{0,1,0x09415},{0,1,0x28BFA},{0,1,0x0958B},{0,1,0x04995},
   {0,1,0x095B7},{0,1,0x28D77},{0,1,0x049E6},{0,1,0x096C3},{0,1,0x05DB2},
   {0,1,0x09723},{0,1,0x29145},{0,1,0x2921A},{0,1,0x04A6E},{0,1,0x04A76},
   {0,1,0x097E0},{0,1,0x2940A},{0,1,0x04AB2},{0,1,0x29496},{0,1,0x0980B},
   {0,1,0x0980B}
  },

  /* block 63 */
  {{0,1,0x09829},{0,1,0x295B6},{0,1,0x098E2},{0,1,0x04B33},{0,1,0x09929},
   {0,1,0x099A7},{0,1,0x099C2},{0,1,0x099FE},{0,1,0x04BCE},{0,1,0x29B30},
   {0,1,0x09B12},{0,1,0x09C40},{0,1,0x09CFD},{0,1,0x04CCE},{0,1,0x04CED},
   {0,1,0x09D67},{0,1,0x2A0CE},{0,1,0x04CF8},{0,1,0x2A105},{0,1,0x2A20E},
   {0,1,0x2A291},{0,1,0x09EBB},{0,1,0x04D56},{0,1,0x09EF9},{0,1,0x09EFE},
   {0,1,0x09F05},{0,1,0x09F0F},{0,1,0x09F16},{0,1,0x09F3B},{0,1,0x2A600},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
   {0,0,0}
  }
};

static const int32_t decomposition_mapping[] = {
/* 0x0000 */ 0x0020,0x0308,0x0020,0x0304,0x0020,0x0301,0x0020,0x0327,
/* 0x0008 */ 0x0031,0x2044,0x0034,0x0031,0x2044,0x0032,0x0033,0x2044,
/* 0x0010 */ 0x0034,0x0041,0x0300,0x0041,0x0301,0x0041,0x0302,0x0041,
/* 0x0018 */ 0x0303,0x0041,0x0308,0x0041,0x030A,0x0043,0x0327,0x0045,
/* 0x0020 */ 0x0300,0x0045,0x0301,0x0045,0x0302,0x0045,0x0308,0x0049,
/* 0x0028 */ 0x0300,0x0049,0x0301,0x0049,0x0302,0x0049,0x0308,0x004E,
/* 0x0030 */ 0x0303,0x004F,0x0300,0x004F,0x0301,0x004F,0x0302,0x004F,
/* 0x0038 */ 0x0303,0x004F,0x0308,0x0055,0x0300,0x0055,0x0301,0x0055,
/* 0x0040 */ 0x0302,0x0055,0x0308,0x0059,0x0301,0x0061,0x0300,0x0061,
/* 0x0048 */ 0x0301,0x0061,0x0302,0x0061,0x0303,0x0061,0x0308,0x0061,
/* 0x0050 */ 0x030A,0x0063,0x0327,0x0065,0x0300,0x0065,0x0301,0x0065,
/* 0x0058 */ 0x0302,0x0065,0x0308,0x0069,0x0300,0x0069,0x0301,0x0069,
/* 0x0060 */ 0x0302,0x0069,0x0308,0x006E,0x0303,0x006F,0x0300,0x006F,
/* 0x0068 */ 0x0301,0x006F,0x0302,0x006F,0x0303,0x006F,0x0308,0x0075,
/* 0x0070 */ 0x0300,0x0075,0x0301,0x0075,0x0302,0x0075,0x0308,0x0079,
/* 0x0078 */ 0x0301,0x0079,0x0308,0x0041,0x0304,0x0061,0x0304,0x0041,
/* 0x0080 */ 0x0306,0x0061,0x0306,0x0041,0x0328,0x0061,0x0328,0x0043,
/* 0x0088 */ 0x0301,0x0063,0x0301,0x0043,0x0302,0x0063,0x0302,0x0043,
/* 0x0090 */ 0x0307,0x0063,0x0307,0x0043,0x030C,0x0063,0x030C,0x0044,
/* 0x0098 */ 0x030C,0x0064,0x030C,0x0045,0x0304,0x0065,0x0304,0x0045,
/* 0x00A0 */ 0x0306,0x0065,0x0306,0x0045,0x0307,0x0065,0x0307,0x0045,
/* 0x00A8 */ 0x0328,0x0065,0x0328,0x0045,0x030C,0x0065,0x030C,0x0047,
/* 0x00B0 */ 0x0302,0x0067,0x0302,0x0047,0x0306,0x0067,0x0306,0x0047,
/* 0x00B8 */ 0x0307,0x0067,0x0307,0x0047,0x0327,0x0067,0x0327,0x0048,
/* 0x00C0 */ 0x0302,0x0068,0x0302,0x0049,0x0303,0x0069,0x0303,0x0049,
/* 0x00C8 */ 0x0304,0x0069,0x0304,0x0049,0x0306,0x0069,0x0306,0x0049,
/* 0x00D0 */ 0x0328,0x0069,0x0328,0x0049,0x0307,0x0049,0x004A,0x0069,
/* 0x00D8 */ 0x006A,0x004A,0x0302,0x006A,0x0302,0x004B,0x0327,0x006B,
/* 0x00E0 */ 0x0327,0x004C,0x0301,0x006C,0x0301,0x004C,0x0327,0x006C,
/* 0x00E8 */ 0x0327,0x004C,0x030C,0x006C,0x030C,0x004C,0x00B7,0x006C,
/* 0x00F0 */ 0x00B7,0x004E,0x0301,0x006E,0x0301,0x004E,0x0327,0x006E,
/* 0x00F8 */ 0x0327,0x004E,0x030C,0x006E,0x030C,0x02BC,0x006E,0x004F,
/* 0x0100 */ 0x0304,0x006F,0x0304,0x004F,0x0306,0x006F,0x0306,0x004F,
/* 0x0108 */ 0x030B,0x006F,0x030B,0x0052,0x0301,0x0072,0x0301,0x0052,
/* 0x0110 */ 0x0327,0x0072,0x0327,0x0052,0x030C,0x0072,0x030C,0x0053,
/* 0x0118 */ 0x0301,0x0073,0x0301,0x0053,0x0302,0x0073,0x0302,0x0053,
/* 0x0120 */ 0x0327,0x0073,0x0327,0x0053,0x030C,0x0073,0x030C,0x0054,
/* 0x0128 */ 0x0327,0x0074,0x0327,0x0054,0x030C,0x0074,0x030C,0x0055,
/* 0x0130 */ 0x0303,0x0075,0x0303,0x0055,0x0304,0x0075,0x0304,0x0055,
/* 0x0138 */ 0x0306,0x0075,0x0306,0x0055,0x030A,0x0075,0x030A,0x0055,
/* 0x0140 */ 0x030B,0x0075,0x030B,0x0055,0x0328,0x0075,0x0328,0x0057,
/* 0x0148 */ 0x0302,0x0077,0x0302,0x0059,0x0302,0x0079,0x0302,0x0059,
/* 0x0150 */ 0x0308,0x005A,0x0301,0x007A,0x0301,0x005A,0x0307,0x007A,
/* 0x0158 */ 0x0307,0x005A,0x030C,0x007A,0x030C,0x004F,0x031B,0x006F,
/* 0x0160 */ 0x031B,0x0055,0x031B,0x0075,0x031B,0x0044,0x017D,0x0044,
/* 0x0168 */ 0x017E,0x0064,0x017E,0x004C,0x004A,0x004C,0x006A,0x006C,
/* 0x0170 */ 0x006A,0x004E,0x004A,0x004E,0x006A,0x006E,0x006A,0x0041,
/* 0x0178 */ 0x030C,0x0061,0x030C,0x0049,0x030C,0x0069,0x030C,0x004F,
/* 0x0180 */ 0x030C,0x006F,0x030C,0x0055,0x030C,0x0075,0x030C,0x00DC,
/* 0x0188 */ 0x0304,0x00FC,0x0304,0x00DC,0x0301,0x00FC,0x0301,0x00DC,
/* 0x0190 */ 0x030C,0x00FC,0x030C,0x00DC,0x0300,0x00FC,0x0300,0x00C4,
/* 0x0198 */ 0x0304,0x00E4,0x0304,0x0226,0x0304,0x0227,0x0304,0x00C6,
/* 0x01A0 */ 0x0304,0x00E6,0x0304,0x0047,0x030C,0x0067,0x030C,0x004B,
/* 0x01A8 */ 0x030C,0x006B,0x030C,0x004F,0x0328,0x006F,0x0328,0x01EA,
/* 0x01B0 */ 0x0304,0x01EB,0x0304,0x01B7,0x030C,0x0292,0x030C,0x006A,
/* 0x01B8 */ 0x030C,0x0044,0x005A,0x0044,0x007A,0x0064,0x007A,0x0047,
/* 0x01C0 */ 0x0301,0x0067,0x0301,0x004E,0x0300,0x006E,0x0300,0x00C5,
/* 0x01C8 */ 0x0301,0x00E5,0x0301,0x00C6,0x0301,0x00E6,0x0301,0x00D8,
/* 0x01D0 */ 0x0301,0x00F8,0x0301,0x0041,0x030F,0x0061,0x030F,0x0041,
/* 0x01D8 */ 0x0311,0x0061,0x0311,0x0045,0x030F,0x0065,0x030F,0x0045,
/* 0x01E0 */ 0x0311,0x0065,0x0311,0x0049,0x030F,0x0069,0x030F,0x0049,
/* 0x01E8 */ 0x0311,0x0069,0x0311,0x004F,0x030F,0x006F,0x030F,0x004F,
/* 0x01F0 */ 0x0311,0x006F,0x0311,0x0052,0x030F,0x0072,0x030F,0x0052,
/* 0x01F8 */ 0x0311,0x0072,0x0311,0x0055,0x030F,0x0075,0x030F,0x0055,
/* 0x0200 */ 0x0311,0x0075,0x0311,0x0053,0x0326,0x0073,0x0326,0x0054,
/* 0x0208 */ 0x0326,0x0074,0x0326,0x0048,0x030C,0x0068,0x030C,0x0041,
/* 0x0210 */ 0x0307,0x0061,0x0307,0x0045,0x0327,0x0065,0x0327,0x00D6,
/* 0x0218 */ 0x0304,0x00F6,0x0304,0x00D5,0x0304,0x00F5,0x0304,0x004F,
/* 0x0220 */ 0x0307,0x006F,0x0307,0x022E,0x0304,0x022F,0x0304,0x0059,
/* 0x0228 */ 0x0304,0x0079,0x0304,0x0020,0x0306,0x0020,0x0307,0x0020,
/* 0x0230 */ 0x030A,0x0020,0x0328,0x0020,0x0303,0x0020,0x030B,0x0308,
/* 0x0238 */ 0x0301,0x0020,0x0345,0x0020,0x0301,0x00A8,0x0301,0x0391,
/* 0x0240 */ 0x0301,0x0395,0x0301,0x0397,0x0301,0x0399,0x0301,0x039F,
/* 0x0248 */ 0x0301,0x03A5,0x0301,0x03A9,0x0301,0x03CA,0x0301,0x0399,
/* 0x0250 */ 0x0308,0x03A5,0x0308,0x03B1,0x0301,0x03B5,0x0301,0x03B7,
/* 0x0258 */ 0x0301,0x03B9,0x0301,0x03CB,0x0301,0x03B9,0x0308,0x03C5,
/* 0x0260 */ 0x0308,0x03BF,0x0301,0x03C5,0x0301,0x03C9,0x0301,0x03D2,
/* 0x0268 */ 0x0301,0x03D2,0x0308,0x0415,0x0300,0x0415,0x0308,0x0413,
/* 0x0270 */ 0x0301,0x0406,0x0308,0x041A,0x0301,0x0418,0x0300,0x0423,
/* 0x0278 */ 0x0306,0x0418,0x0306,0x0438,0x0306,0x0435,0x0300,0x0435,
/* 0x0280 */ 0x0308,0x0433,0x0301,0x0456,0x0308,0x043A,0x0301,0x0438,
/* 0x0288 */ 0x0300,0x0443,0x0306,0x0474,0x030F,0x0475,0x030F,0x0416,
/* 0x0290 */ 0x0306,0x0436,0x0306,0x0410,0x0306,0x0430,0x0306,0x0410,
/* 0x0298 */ 0x0308,0x0430,0x0308,0x0415,0x0306,0x0435,0x0306,0x04D8,
/* 0x02A0 */ 0x0308,0x04D9,0x0308,0x0416,0x0308,0x0436,0x0308,0x0417,
/* 0x02A8 */ 0x0308,0x0437,0x0308,0x0418,0x0304,0x0438,0x0304,0x0418,
/* 0x02B0 */ 0x0308,0x0438,0x0308,0x041E,0x0308,0x043E,0x0308,0x04E8,
/* 0x02B8 */ 0x0308,0x04E9,0x0308,0x042D,0x0308,0x044D,0x0308,0x0423,
/* 0x02C0 */ 0x0304,0x0443,0x0304,0x0423,0x0308,0x0443,0x0308,0x0423,
/* 0x02C8 */ 0x030B,0x0443,0x030B,0x0427,0x0308,0x0447,0x0308,0x042B,
/* 0x02D0 */ 0x0308,0x044B,0x0308,0x0565,0x0582,0x0627,0x0653,0x0627,
/* 0x02D8 */ 0x0654,0x0648,0x0654,0x0627,0x0655,0x064A,0x0654,0x0627,
/* 0x02E0 */ 0x0674,0x0648,0x0674,0x06C7,0x0674,0x064A,0x0674,0x06D5,
/* 0x02E8 */ 0x0654,0x06C1,0x0654,0x06D2,0x0654,0x0928,0x093C,0x0930,
/* 0x02F0 */ 0x093C,0x0933,0x093C,0x0915,0x093C,0x0916,0x093C,0x0917,
/* 0x02F8 */ 0x093C,0x091C,0x093C,0x0921,0x093C,0x0922,0x093C,0x092B,
/* 0x0300 */ 0x093C,0x092F,0x093C,0x09C7,0x09BE,0x09C7,0x09D7,0x09A1,
/* 0x0308 */ 0x09BC,0x09A2,0x09BC,0x09AF,0x09BC,0x0A32,0x0A3C,0x0A38,
/* 0x0310 */ 0x0A3C,0x0A16,0x0A3C,0x0A17,0x0A3C,0x0A1C,0x0A3C,0x0A2B,
/* 0x0318 */ 0x0A3C,0x0B47,0x0B56,0x0B47,0x0B3E,0x0B47,0x0B57,0x0B21,
/* 0x0320 */ 0x0B3C,0x0B22,0x0B3C,0x0B92,0x0BD7,0x0BC6,0x0BBE,0x0BC7,
/* 0x0328 */ 0x0BBE,0x0BC6,0x0BD7,0x0C46,0x0C56,0x0CBF,0x0CD5,0x0CC6,
/* 0x0330 */ 0x0CD5,0x0CC6,0x0CD6,0x0CC6,0x0CC2,0x0CCA,0x0CD5,0x0D46,
/* 0x0338 */ 0x0D3E,0x0D47,0x0D3E,0x0D46,0x0D57,0x0DD9,0x0DCA,0x0DD9,
/* 0x0340 */ 0x0DCF,0x0DDC,0x0DCA,0x0DD9,0x0DDF,0x0E4D,0x0E32,0x0ECD,
/* 0x0348 */ 0x0EB2,0x0EAB,0x0E99,0x0EAB,0x0EA1,0x0F42,0x0FB7,0x0F4C,
/* 0x0350 */ 0x0FB7,0x0F51,0x0FB7,0x0F56,0x0FB7,0x0F5B,0x0FB7,0x0F40,
/* 0x0358 */ 0x0FB5,0x0F71,0x0F72,0x0F71,0x0F74,0x0FB2,0x0F80,0x0FB2,
/* 0x0360 */ 0x0F81,0x0FB3,0x0F80,0x0FB3,0x0F81,0x0F71,0x0F80,0x0F92,
/* 0x0368 */ 0x0FB7,0x0F9C,0x0FB7,0x0FA1,0x0FB7,0x0FA6,0x0FB7,0x0FAB,
/* 0x0370 */ 0x0FB7,0x0F90,0x0FB5,0x1025,0x102E,0x1B05,0x1B35,0x1B07,
/* 0x0378 */ 0x1B35,0x1B09,0x1B35,0x1B0B,0x1B35,0x1B0D,0x1B35,0x1B11,
/* 0x0380 */ 0x1B35,0x1B3A,0x1B35,0x1B3C,0x1B35,0x1B3E,0x1B35,0x1B3F,
/* 0x0388 */ 0x1B35,0x1B42,0x1B35,0x0041,0x0325,0x0061,0x0325,0x0042,
/* 0x0390 */ 0x0307,0x0062,0x0307,0x0042,0x0323,0x0062,0x0323,0x0042,
/* 0x0398 */ 0x0331,0x0062,0x0331,0x00C7,0x0301,0x00E7,0x0301,0x0044,
/* 0x03A0 */ 0x0307,0x0064,0x0307,0x0044,0x0323,0x0064,0x0323,0x0044,
/* 0x03A8 */ 0x0331,0x0064,0x0331,0x0044,0x0327,0x0064,0x0327,0x0044,
/* 0x03B0 */ 0x032D,0x0064,0x032D,0x0112,0x0300,0x0113,0x0300,0x0112,
/* 0x03B8 */ 0x0301,0x0113,0x0301,0x0045,0x032D,0x0065,0x032D,0x0045,
/* 0x03C0 */ 0x0330,0x0065,0x0330,0x0228,0x0306,0x0229,0x0306,0x0046,
/* 0x03C8 */ 0x0307,0x0066,0x0307,0x0047,0x0304,0x0067,0x0304,0x0048,
/* 0x03D0 */ 0x0307,0x0068,0x0307,0x0048,0x0323,0x0068,0x0323,0x0048,
/* 0x03D8 */ 0x0308,0x0068,0x0308,0x0048,0x0327,0x0068,0x0327,0x0048,
/* 0x03E0 */ 0x032E,0x0068,0x032E,0x0049,0x0330,0x0069,0x0330,0x00CF,
/* 0x03E8 */ 0x0301,0x00EF,0x0301,0x004B,0x0301,0x006B,0x0301,0x004B,
/* 0x03F0 */ 0x0323,0x006B,0x0323,0x004B,0x0331,0x006B,0x0331,0x004C,
/* 0x03F8 */ 0x0323,0x006C,0x0323,0x1E36,0x0304,0x1E37,0x0304,0x004C,
/* 0x0400 */ 0x0331,0x006C,0x0331,0x004C,0x032D,0x006C,0x032D,0x004D,
/* 0x0408 */ 0x0301,0x006D,0x0301,0x004D,0x0307,0x006D,0x0307,0x004D,
/* 0x0410 */ 0x0323,0x006D,0x0323,0x004E,0x0307,0x006E,0x0307,0x004E,
/* 0x0418 */ 0x0323,0x006E,0x0323,0x004E,0x0331,0x006E,0x0331,0x004E,
/* 0x0420 */ 0x032D,0x006E,0x032D,0x00D5,0x0301,0x00F5,0x0301,0x00D5,
/* 0x0428 */ 0x0308,0x00F5,0x0308,0x014C,0x0300,0x014D,0x0300,0x014C,
/* 0x0430 */ 0x0301,0x014D,0x0301,0x0050,0x0301,0x0070,0x0301,0x0050,
/* 0x0438 */ 0x0307,0x0070,0x0307,0x0052,0x0307,0x0072,0x0307,0x0052,
/* 0x0440 */ 0x0323,0x0072,0x0323,0x1E5A,0x0304,0x1E5B,0x0304,0x0052,
/* 0x0448 */ 0x0331,0x0072,0x0331,0x0053,0x0307,0x0073,0x0307,0x0053,
/* 0x0450 */ 0x0323,0x0073,0x0323,0x015A,0x0307,0x015B,0x0307,0x0160,
/* 0x0458 */ 0x0307,0x0161,0x0307,0x1E62,0x0307,0x1E63,0x0307,0x0054,
/* 0x0460 */ 0x0307,0x0074,0x0307,0x0054,0x0323,0x0074,0x0323,0x0054,
/* 0x0468 */ 0x0331,0x0074,0x0331,0x0054,0x032D,0x0074,0x032D,0x0055,
/* 0x0470 */ 0x0324,0x0075,0x0324,0x0055,0x0330,0x0075,0x0330,0x0055,
/* 0x0478 */ 0x032D,0x0075,0x032D,0x0168,0x0301,0x0169,0x0301,0x016A,
/* 0x0480 */ 0x0308,0x016B,0x0308,0x0056,0x0303,0x0076,0x0303,0x0056,
/* 0x0488 */ 0x0323,0x0076,0x0323,0x0057,0x0300,0x0077,0x0300,0x0057,
/* 0x0490 */ 0x0301,0x0077,0x0301,0x0057,0x0308,0x0077,0x0308,0x0057,
/* 0x0498 */ 0x0307,0x0077,0x0307,0x0057,0x0323,0x0077,0x0323,0x0058,
/* 0x04A0 */ 0x0307,0x0078,0x0307,0x0058,0x0308,0x0078,0x0308,0x0059,
/* 0x04A8 */ 0x0307,0x0079,0x0307,0x005A,0x0302,0x007A,0x0302,0x005A,
/* 0x04B0 */ 0x0323,0x007A,0x0323,0x005A,0x0331,0x007A,0x0331,0x0068,
/* 0x04B8 */ 0x0331,0x0074,0x0308,0x0077,0x030A,0x0079,0x030A,0x0061,
/* 0x04C0 */ 0x02BE,0x017F,0x0307,0x0041,0x0323,0x0061,0x0323,0x0041,
/* 0x04C8 */ 0x0309,0x0061,0x0309,0x00C2,0x0301,0x00E2,0x0301,0x00C2,
/* 0x04D0 */ 0x0300,0x00E2,0x0300,0x00C2,0x0309,0x00E2,0x0309,0x00C2,
/* 0x04D8 */ 0x0303,0x00E2,0x0303,0x1EA0,0x0302,0x1EA1,0x0302,0x0102,
/* 0x04E0 */ 0x0301,0x0103,0x0301,0x0102,0x0300,0x0103,0x0300,0x0102,
/* 0x04E8 */ 0x0309,0x0103,0x0309,0x0102,0x0303,0x0103,0x0303,0x1EA0,
/* 0x04F0 */ 0x0306,0x1EA1,0x0306,0x0045,0x0323,0x0065,0x0323,0x0045,
/* 0x04F8 */ 0x0309,0x0065,0x0309,0x0045,0x0303,0x0065,0x0303,0x00CA,
/* 0x0500 */ 0x0301,0x00EA,0x0301,0x00CA,0x0300,0x00EA,0x0300,0x00CA,
/* 0x0508 */ 0x0309,0x00EA,0x0309,0x00CA,0x0303,0x00EA,0x0303,0x1EB8,
/* 0x0510 */ 0x0302,0x1EB9,0x0302,0x0049,0x0309,0x0069,0x0309,0x0049,
/* 0x0518 */ 0x0323,0x0069,0x0323,0x004F,0x0323,0x006F,0x0323,0x004F,
/* 0x0520 */ 0x0309,0x006F,0x0309,0x00D4,0x0301,0x00F4,0x0301,0x00D4,
/* 0x0528 */ 0x0300,0x00F4,0x0300,0x00D4,0x0309,0x00F4,0x0309,0x00D4,
/* 0x0530 */ 0x0303,0x00F4,0x0303,0x1ECC,0x0302,0x1ECD,0x0302,0x01A0,
/* 0x0538 */ 0x0301,0x01A1,0x0301,0x01A0,0x0300,0x01A1,0x0300,0x01A0,
/* 0x0540 */ 0x0309,0x01A1,0x0309,0x01A0,0x0303,0x01A1,0x0303,0x01A0,
/* 0x0548 */ 0x0323,0x01A1,0x0323,0x0055,0x0323,0x0075,0x0323,0x0055,
/* 0x0550 */ 0x0309,0x0075,0x0309,0x01AF,0x0301,0x01B0,0x0301,0x01AF,
/* 0x0558 */ 0x0300,0x01B0,0x0300,0x01AF,0x0309,0x01B0,0x0309,0x01AF,
/* 0x0560 */ 0x0303,0x01B0,0x0303,0x01AF,0x0323,0x01B0,0x0323,0x0059,
/* 0x0568 */ 0x0300,0x0079,0x0300,0x0059,0x0323,0x0079,0x0323,0x0059,
/* 0x0570 */ 0x0309,0x0079,0x0309,0x0059,0x0303,0x0079,0x0303,0x03B1,
/* 0x0578 */ 0x0313,0x03B1,0x0314,0x1F00,0x0300,0x1F01,0x0300,0x1F00,
/* 0x0580 */ 0x0301,0x1F01,0x0301,0x1F00,0x0342,0x1F01,0x0342,0x0391,
/* 0x0588 */ 0x0313,0x0391,0x0314,0x1F08,0x0300,0x1F09,0x0300,0x1F08,
/* 0x0590 */ 0x0301,0x1F09,0x0301,0x1F08,0x0342,0x1F09,0x0342,0x03B5,
/* 0x0598 */ 0x0313,0x03B5,0x0314,0x1F10,0x0300,0x1F11,0x0300,0x1F10,
/* 0x05A0 */ 0x0301,0x1F11,0x0301,0x0395,0x0313,0x0395,0x0314,0x1F18,
/* 0x05A8 */ 0x0300,0x1F19,0x0300,0x1F18,0x0301,0x1F19,0x0301,0x03B7,
/* 0x05B0 */ 0x0313,0x03B7,0x0314,0x1F20,0x0300,0x1F21,0x0300,0x1F20,
/* 0x05B8 */ 0x0301,0x1F21,0x0301,0x1F20,0x0342,0x1F21,0x0342,0x0397,
/* 0x05C0 */ 0x0313,0x0397,0x0314,0x1F28,0x0300,0x1F29,0x0300,0x1F28,
/* 0x05C8 */ 0x0301,0x1F29,0x0301,0x1F28,0x0342,0x1F29,0x0342,0x03B9,
/* 0x05D0 */ 0x0313,0x03B9,0x0314,0x1F30,0x0300,0x1F31,0x0300,0x1F30,
/* 0x05D8 */ 0x0301,0x1F31,0x0301,0x1F30,0x0342,0x1F31,0x0342,0x0399,
/* 0x05E0 */ 0x0313,0x0399,0x0314,0x1F38,0x0300,0x1F39,0x0300,0x1F38,
/* 0x05E8 */ 0x0301,0x1F39,0x0301,0x1F38,0x0342,0x1F39,0x0342,0x03BF,
/* 0x05F0 */ 0x0313,0x03BF,0x0314,0x1F40,0x0300,0x1F41,0x0300,0x1F40,
/* 0x05F8 */ 0x0301,0x1F41,0x0301,0x039F,0x0313,0x039F,0x0314,0x1F48,
/* 0x0600 */ 0x0300,0x1F49,0x0300,0x1F48,0x0301,0x1F49,0x0301,0x03C5,
/* 0x0608 */ 0x0313,0x03C5,0x0314,0x1F50,0x0300,0x1F51,0x0300,0x1F50,
/* 0x0610 */ 0x0301,0x1F51,0x0301,0x1F50,0x0342,0x1F51,0x0342,0x03A5,
/* 0x0618 */ 0x0314,0x1F59,0x0300,0x1F59,0x0301,0x1F59,0x0342,0x03C9,
/* 0x0620 */ 0x0313,0x03C9,0x0314,0x1F60,0x0300,0x1F61,0x0300,0x1F60,
/* 0x0628 */ 0x0301,0x1F61,0x0301,0x1F60,0x0342,0x1F61,0x0342,0x03A9,
/* 0x0630 */ 0x0313,0x03A9,0x0314,0x1F68,0x0300,0x1F69,0x0300,0x1F68,
/* 0x0638 */ 0x0301,0x1F69,0x0301,0x1F68,0x0342,0x1F69,0x0342,0x03B1,
/* 0x0640 */ 0x0300,0x03B5,0x0300,0x03B7,0x0300,0x03B9,0x0300,0x03BF,
/* 0x0648 */ 0x0300,0x03C5,0x0300,0x03C9,0x0300,0x1F00,0x0345,0x1F01,
/* 0x0650 */ 0x0345,0x1F02,0x0345,0x1F03,0x0345,0x1F04,0x0345,0x1F05,
/* 0x0658 */ 0x0345,0x1F06,0x0345,0x1F07,0x0345,0x1F08,0x0345,0x1F09,
/* 0x0660 */ 0x0345,0x1F0A,0x0345,0x1F0B,0x0345,0x1F0C,0x0345,0x1F0D,
/* 0x0668 */ 0x0345,0x1F0E,0x0345,0x1F0F,0x0345,0x1F20,0x0345,0x1F21,
/* 0x0670 */ 0x0345,0x1F22,0x0345,0x1F23,0x0345,0x1F24,0x0345,0x1F25,
/* 0x0678 */ 0x0345,0x1F26,0x0345,0x1F27,0x0345,0x1F28,0x0345,0x1F29,
/* 0x0680 */ 0x0345,0x1F2A,0x0345,0x1F2B,0x0345,0x1F2C,0x0345,0x1F2D,
/* 0x0688 */ 0x0345,0x1F2E,0x0345,0x1F2F,0x0345,0x1F60,0x0345,0x1F61,
/* 0x0690 */ 0x0345,0x1F62,0x0345,0x1F63,0x0345,0x1F64,0x0345,0x1F65,
/* 0x0698 */ 0x0345,0x1F66,0x0345,0x1F67,0x0345,0x1F68,0x0345,0x1F69,
/* 0x06A0 */ 0x0345,0x1F6A,0x0345,0x1F6B,0x0345,0x1F6C,0x0345,0x1F6D,
/* 0x06A8 */ 0x0345,0x1F6E,0x0345,0x1F6F,0x0345,0x03B1,0x0306,0x03B1,
/* 0x06B0 */ 0x0304,0x1F70,0x0345,0x03B1,0x0345,0x03AC,0x0345,0x03B1,
/* 0x06B8 */ 0x0342,0x1FB6,0x0345,0x0391,0x0306,0x0391,0x0304,0x0391,
/* 0x06C0 */ 0x0300,0x0391,0x0345,0x0020,0x0313,0x0020,0x0313,0x0020,
/* 0x06C8 */ 0x0342,0x00A8,0x0342,0x1F74,0x0345,0x03B7,0x0345,0x03AE,
/* 0x06D0 */ 0x0345,0x03B7,0x0342,0x1FC6,0x0345,0x0395,0x0300,0x0397,
/* 0x06D8 */ 0x0300,0x0397,0x0345,0x1FBF,0x0300,0x1FBF,0x0301,0x1FBF,
/* 0x06E0 */ 0x0342,0x03B9,0x0306,0x03B9,0x0304,0x03CA,0x0300,0x03B9,
/* 0x06E8 */ 0x0342,0x03CA,0x0342,0x0399,0x0306,0x0399,0x0304,0x0399,
/* 0x06F0 */ 0x0300,0x1FFE,0x0300,0x1FFE,0x0301,0x1FFE,0x0342,0x03C5,
/* 0x06F8 */ 0x0306,0x03C5,0x0304,0x03CB,0x0300,0x03C1,0x0313,0x03C1,
/* 0x0700 */ 0x0314,0x03C5,0x0342,0x03CB,0x0342,0x03A5,0x0306,0x03A5,
/* 0x0708 */ 0x0304,0x03A5,0x0300,0x03A1,0x0314,0x00A8,0x0300,0x1F7C,
/* 0x0710 */ 0x0345,0x03C9,0x0345,0x03CE,0x0345,0x03C9,0x0342,0x1FF6,
/* 0x0718 */ 0x0345,0x039F,0x0300,0x03A9,0x0300,0x03A9,0x0345,0x0020,
/* 0x0720 */ 0x0314,0x0020,0x0333,0x002E,0x002E,0x002E,0x002E,0x002E,
/* 0x0728 */ 0x2032,0x2032,0x2032,0x2032,0x2032,0x2035,0x2035,0x2035,
/* 0x0730 */ 0x2035,0x2035,0x0021,0x0021,0x0020,0x0305,0x003F,0x003F,
/* 0x0738 */ 0x003F,0x0021,0x0021,0x003F,0x2032,0x2032,0x2032,0x2032,
/* 0x0740 */ 0x0052,0x0073,0x0061,0x002F,0x0063,0x0061,0x002F,0x0073,
/* 0x0748 */ 0x00B0,0x0043,0x0063,0x002F,0x006F,0x0063,0x002F,0x0075,
/* 0x0750 */ 0x00B0,0x0046,0x004E,0x006F,0x0053,0x004D,0x0054,0x0045,
/* 0x0758 */ 0x004C,0x0054,0x004D,0x0046,0x0041,0x0058,0x0031,0x2044,
/* 0x0760 */ 0x0037,0x0031,0x2044,0x0039,0x0031,0x2044,0x0031,0x0030,
/* 0x0768 */ 0x0031,0x2044,0x0033,0x0032,0x2044,0x0033,0x0031,0x2044,
/* 0x0770 */ 0x0035,0x0032,0x2044,0x0035,0x0033,0x2044,0x0035,0x0034,
/* 0x0778 */ 0x2044,0x0035,0x0031,0x2044,0x0036,0x0035,0x2044,0x0036,
/* 0x0780 */ 0x0031,0x2044,0x0038,0x0033,0x2044,0x0038,0x0035,0x2044,
/* 0x0788 */ 0x0038,0x0037,0x2044,0x0038,0x0031,0x2044,0x0049,0x0049,
/* 0x0790 */ 0x0049,0x0049,0x0049,0x0049,0x0056,0x0056,0x0049,0x0056,
/* 0x0798 */ 0x0049,0x0049,0x0056,0x0049,0x0049,0x0049,0x0049,0x0058,
/* 0x07A0 */ 0x0058,0x0049,0x0058,0x0049,0x0049,0x0069,0x0069,0x0069,
/* 0x07A8 */ 0x0069,0x0069,0x0069,0x0076,0x0076,0x0069,0x0076,0x0069,
/* 0x07B0 */ 0x0069,0x0076,0x0069,0x0069,0x0069,0x0069,0x0078,0x0078,
/* 0x07B8 */ 0x0069,0x0078,0x0069,0x0069,0x0030,0x2044,0x0033,0x2190,
/* 0x07C0 */ 0x0338,0x2192,0x0338,0x2194,0x0338,0x21D0,0x0338,0x21D4,
/* 0x07C8 */ 0x0338,0x21D2,0x0338,0x2203,0x0338,0x2208,0x0338,0x220B,
/* 0x07D0 */ 0x0338,0x2223,0x0338,0x2225,0x0338,0x222B,0x222B,0x222B,
/* 0x07D8 */ 0x222B,0x222B,0x222E,0x222E,0x222E,0x222E,0x222E,0x223C,
/* 0x07E0 */ 0x0338,0x2243,0x0338,0x2245,0x0338,0x2248,0x0338,0x003D,
/* 0x07E8 */ 0x0338,0x2261,0x0338,0x224D,0x0338,0x003C,0x0338,0x003E,
/* 0x07F0 */ 0x0338,0x2264,0x0338,0x2265,0x0338,0x2272,0x0338,0x2273,
/* 0x07F8 */ 0x0338,0x2276,0x0338,0x2277,0x0338,0x227A,0x0338,0x227B,
/* 0x0800 */ 0x0338,0x2282,0x0338,0x2283,0x0338,0x2286,0x0338,0x2287,
/* 0x0808 */ 0x0338,0x22A2,0x0338,0x22A8,0x0338,0x22A9,0x0338,0x22AB,
/* 0x0810 */ 0x0338,0x227C,0x0338,0x227D,0x0338,0x2291,0x0338,0x2292,
/* 0x0818 */ 0x0338,0x22B2,0x0338,0x22B3,0x0338,0x22B4,0x0338,0x22B5,
/* 0x0820 */ 0x0338,0x0031,0x0030,0x0031,0x0031,0x0031,0x0032,0x0031,
/* 0x0828 */ 0x0033,0x0031,0x0034,0x0031,0x0035,0x0031,0x0036,0x0031,
/* 0x0830 */ 0x0037,0x0031,0x0038,0x0031,0x0039,0x0032,0x0030,0x0028,
/* 0x0838 */ 0x0031,0x0029,0x0028,0x0032,0x0029,0x0028,0x0033,0x0029,
/* 0x0840 */ 0x0028,0x0034,0x0029,0x0028,0x0035,0x0029,0x0028,0x0036,
/* 0x0848 */ 0x0029,0x0028,0x0037,0x0029,0x0028,0x0038,0x0029,0x0028,
/* 0x0850 */ 0x0039,0x0029,0x0028,0x0031,0x0030,0x0029,0x0028,0x0031,
/* 0x0858 */ 0x0031,0x0029,0x0028,0x0031,0x0032,0x0029,0x0028,0x0031,
/* 0x0860 */ 0x0033,0x0029,0x0028,0x0031,0x0034,0x0029,0x0028,0x0031,
/* 0x0868 */ 0x0035,0x0029,0x0028,0x0031,0x0036,0x0029,0x0028,0x0031,
/* 0x0870 */ 0x0037,0x0029,0x0028,0x0031,0x0038,0x0029,0x0028,0x0031,
/* 0x0878 */ 0x0039,0x0029,0x0028,0x0032,0x0030,0x0029,0x0031,0x002E,
/* 0x0880 */ 0x0032,0x002E,0x0033,0x002E,0x0034,0x002E,0x0035,0x002E,
/* 0x0888 */ 0x0036,0x002E,0x0037,0x002E,0x0038,0x002E,0x0039,0x002E,
/* 0x0890 */ 0x0031,0x0030,0x002E,0x0031,0x0031,0x002E,0x0031,0x0032,
/* 0x0898 */ 0x002E,0x0031,0x0033,0x002E,0x0031,0x0034,0x002E,0x0031,
/* 0x08A0 */ 0x0035,0x002E,0x0031,0x0036,0x002E,0x0031,0x0037,0x002E,
/* 0x08A8 */ 0x0031,0x0038,0x002E,0x0031,0x0039,0x002E,0x0032,0x0030,
/* 0x08B0 */ 0x002E,0x0028,0x0061,0x0029,0x0028,0x0062,0x0029,0x0028,
/* 0x08B8 */ 0x0063,0x0029,0x0028,0x0064,0x0029,0x0028,0x0065,0x0029,
/* 0x08C0 */ 0x0028,0x0066,0x0029,0x0028,0x0067,0x0029,0x0028,0x0068,
/* 0x08C8 */ 0x0029,0x0028,0x0069,0x0029,0x0028,0x006A,0x0029,0x0028,
/* 0x08D0 */ 0x006B,0x0029,0x0028,0x006C,0x0029,0x0028,0x006D,0x0029,
/* 0x08D8 */ 0x0028,0x006E,0x0029,0x0028,0x006F,0x0029,0x0028,0x0070,
/* 0x08E0 */ 0x0029,0x0028,0x0071,0x0029,0x0028,0x0072,0x0029,0x0028,
/* 0x08E8 */ 0x0073,0x0029,0x0028,0x0074,0x0029,0x0028,0x0075,0x0029,
/* 0x08F0 */ 0x0028,0x0076,0x0029,0x0028,0x0077,0x0029,0x0028,0x0078,
/* 0x08F8 */ 0x0029,0x0028,0x0079,0x0029,0x0028,0x007A,0x0029,0x222B,
/* 0x0900 */ 0x222B,0x222B,0x222B,0x003A,0x003A,0x003D,0x003D,0x003D,
/* 0x0908 */ 0x003D,0x003D,0x003D,0x2ADD,0x0338,0x304B,0x3099,0x304D,
/* 0x0910 */ 0x3099,0x304F,0x3099,0x3051,0x3099,0x3053,0x3099,0x3055,
/* 0x0918 */ 0x3099,0x3057,0x3099,0x3059,0x3099,0x305B,0x3099,0x305D,
/* 0x0920 */ 0x3099,0x305F,0x3099,0x3061,0x3099,0x3064,0x3099,0x3066,
/* 0x0928 */ 0x3099,0x3068,0x3099,0x306F,0x3099,0x306F,0x309A,0x3072,
/* 0x0930 */ 0x3099,0x3072,0x309A,0x3075,0x3099,0x3075,0x309A,0x3078,
/* 0x0938 */ 0x3099,0x3078,0x309A,0x307B,0x3099,0x307B,0x309A,0x3046,
/* 0x0940 */ 0x3099,0x0020,0x3099,0x0020,0x309A,0x309D,0x3099,0x3088,
/* 0x0948 */ 0x308A,0x30AB,0x3099,0x30AD,0x3099,0x30AF,0x3099,0x30B1,
/* 0x0950 */ 0x3099,0x30B3,0x3099,0x30B5,0x3099,0x30B7,0x3099,0x30B9,
/* 0x0958 */ 0x3099,0x30BB,0x3099,0x30BD,0x3099,0x30BF,0x3099,0x30C1,
/* 0x0960 */ 0x3099,0x30C4,0x3099,0x30C6,0x3099,0x30C8,0x3099,0x30CF,
/* 0x0968 */ 0x3099,0x30CF,0x309A,0x30D2,0x3099,0x30D2,0x309A,0x30D5,
/* 0x0970 */ 0x3099,0x30D5,0x309A,0x30D8,0x3099,0x30D8,0x309A,0x30DB,
/* 0x0978 */ 0x3099,0x30DB,0x309A,0x30A6,0x3099,0x30EF,0x3099,0x30F0,
/* 0x0980 */ 0x3099,0x30F1,0x3099,0x30F2,0x3099,0x30FD,0x3099,0x30B3,
/* 0x0988 */ 0x30C8,0x0028,0x1100,0x0029,0x0028,0x1102,0x0029,0x0028,
/* 0x0990 */ 0x1103,0x0029,0x0028,0x1105,0x0029,0x0028,0x1106,0x0029,
/* 0x0998 */ 0x0028,0x1107,0x0029,0x0028,0x1109,0x0029,0x0028,0x110B,
/* 0x09A0 */ 0x0029,0x0028,0x110C,0x0029,0x0028,0x110E,0x0029,0x0028,
/* 0x09A8 */ 0x110F,0x0029,0x0028,0x1110,0x0029,0x0028,0x1111,0x0029,
/* 0x09B0 */ 0x0028,0x1112,0x0029,0x0028,0x1100,0x1161,0x0029,0x0028,
/* 0x09B8 */ 0x1102,0x1161,0x0029,0x0028,0x1103,0x1161,0x0029,0x0028,
/* 0x09C0 */ 0x1105,0x1161,0x0029,0x0028,0x1106,0x1161,0x0029,0x0028,
/* 0x09C8 */ 0x1107,0x1161,0x0029,0x0028,0x1109,0x1161,0x0029,0x0028,
/* 0x09D0 */ 0x110B,0x1161,0x0029,0x0028,0x110C,0x1161,0x0029,0x0028,
/* 0x09D8 */ 0x110E,0x1161,0x0029,0x0028,0x110F,0x1161,0x0029,0x0028,
/* 0x09E0 */ 0x1110,0x1161,0x0029,0x0028,0x1111,0x1161,0x0029,0x0028,
/* 0x09E8 */ 0x1112,0x1161,0x0029,0x0028,0x110C,0x116E,0x0029,0x0028,
/* 0x09F0 */ 0x110B,0x1169,0x110C,0x1165,0x11AB,0x0029,0x0028,0x110B,
/* 0x09F8 */ 0x1169,0x1112,0x116E,0x0029,0x0028,0x4E00,0x0029,0x0028,
/* 0x0A00 */ 0x4E8C,0x0029,0x0028,0x4E09,0x0029,0x0028,0x56DB,0x0029,
/* 0x0A08 */ 0x0028,0x4E94,0x0029,0x0028,0x516D,0x0029,0x0028,0x4E03,
/* 0x0A10 */ 0x0029,0x0028,0x516B,0x0029,0x0028,0x4E5D,0x0029,0x0028,
/* 0x0A18 */ 0x5341,0x0029,0x0028,0x6708,0x0029,0x0028,0x706B,0x0029,
/* 0x0A20 */ 0x0028,0x6C34,0x0029,0x0028,0x6728,0x0029,0x0028,0x91D1,
/* 0x0A28 */ 0x0029,0x0028,0x571F,0x0029,0x0028,0x65E5,0x0029,0x0028,
/* 0x0A30 */ 0x682A,0x0029,0x0028,0x6709,0x0029,0x0028,0x793E,0x0029,
/* 0x0A38 */ 0x0028,0x540D,0x0029,0x0028,0x7279,0x0029,0x0028,0x8CA1,
/* 0x0A40 */ 0x0029,0x0028,0x795D,0x0029,0x0028,0x52B4,0x0029,0x0028,
/* 0x0A48 */ 0x4EE3,0x0029,0x0028,0x547C,0x0029,0x0028,0x5B66,0x0029,
/* 0x0A50 */ 0x0028,0x76E3,0x0029,0x0028,0x4F01,0x0029,0x0028,0x8CC7,
/* 0x0A58 */ 0x0029,0x0028,0x5354,0x0029,0x0028,0x796D,0x0029,0x0028,
/* 0x0A60 */ 0x4F11,0x0029,0x0028,0x81EA,0x0029,0x0028,0x81F3,0x0029,
/* 0x0A68 */ 0x0050,0x0054,0x0045,0x0032,0x0031,0x0032,0x0032,0x0032,
/* 0x0A70 */ 0x0033,0x0032,0x0034,0x0032,0x0035,0x0032,0x0036,0x0032,
/* 0x0A78 */ 0x0037,0x0032,0x0038,0x0032,0x0039,0x0033,0x0030,0x0033,
/* 0x0A80 */ 0x0031,0x0033,0x0032,0x0033,0x0033,0x0033,0x0034,0x0033,
/* 0x0A88 */ 0x0035,0x1100,0x1161,0x1102,0x1161,0x1103,0x1161,0x1105,
/* 0x0A90 */ 0x1161,0x1106,0x1161,0x1107,0x1161,0x1109,0x1161,0x110B,
/* 0x0A98 */ 0x1161,0x110C,0x1161,0x110E,0x1161,0x110F,0x1161,0x1110,
/* 0x0AA0 */ 0x1161,0x1111,0x1161,0x1112,0x1161,0x110E,0x1161,0x11B7,
/* 0x0AA8 */ 0x1100,0x1169,0x110C,0x116E,0x110B,0x1174,0x110B,0x116E,
/* 0x0AB0 */ 0x0033,0x0036,0x0033,0x0037,0x0033,0x0038,0x0033,0x0039,
/* 0x0AB8 */ 0x0034,0x0030,0x0034,0x0031,0x0034,0x0032,0x0034,0x0033,
/* 0x0AC0 */ 0x0034,0x0034,0x0034,0x0035,0x0034,0x0036,0x0034,0x0037,
/* 0x0AC8 */ 0x0034,0x0038,0x0034,0x0039,0x0035,0x0030,0x0031,0x6708,
/* 0x0AD0 */ 0x0032,0x6708,0x0033,0x6708,0x0034,0x6708,0x0035,0x6708,
/* 0x0AD8 */ 0x0036,0x6708,0x0037,0x6708,0x0038,0x6708,0x0039,0x6708,
/* 0x0AE0 */ 0x0031,0x0030,0x6708,0x0031,0x0031,0x6708,0x0031,0x0032,
/* 0x0AE8 */ 0x6708,0x0048,0x0067,0x0065,0x0072,0x0067,0x0065,0x0056,
/* 0x0AF0 */ 0x004C,0x0054,0x0044,0x4EE4,0x548C,0x30A2,0x30D1,0x30FC,
/* 0x0AF8 */ 0x30C8,0x30A2,0x30EB,0x30D5,0x30A1,0x30A2,0x30F3,0x30DA,
/* 0x0B00 */ 0x30A2,0x30A2,0x30FC,0x30EB,0x30A4,0x30CB,0x30F3,0x30B0,
/* 0x0B08 */ 0x30A4,0x30F3,0x30C1,0x30A6,0x30A9,0x30F3,0x30A8,0x30B9,
/* 0x0B10 */ 0x30AF,0x30FC,0x30C9,0x30A8,0x30FC,0x30AB,0x30FC,0x30AA,
/* 0x0B18 */ 0x30F3,0x30B9,0x30AA,0x30FC,0x30E0,0x30AB,0x30A4,0x30EA,
/* 0x0B20 */ 0x30AB,0x30E9,0x30C3,0x30C8,0x30AB,0x30ED,0x30EA,0x30FC,
/* 0x0B28 */ 0x30AC,0x30ED,0x30F3,0x30AC,0x30F3,0x30DE,0x30AE,0x30AC,
/* 0x0B30 */ 0x30AE,0x30CB,0x30FC,0x30AD,0x30E5,0x30EA,0x30FC,0x30AE,
/* 0x0B38 */ 0x30EB,0x30C0,0x30FC,0x30AD,0x30ED,0x30AD,0x30ED,0x30B0,
/* 0x0B40 */ 0x30E9,0x30E0,0x30AD,0x30ED,0x30E1,0x30FC,0x30C8,0x30EB,
/* 0x0B48 */ 0x30AD,0x30ED,0x30EF,0x30C3,0x30C8,0x30B0,0x30E9,0x30E0,
/* 0x0B50 */ 0x30B0,0x30E9,0x30E0,0x30C8,0x30F3,0x30AF,0x30EB,0x30BC,
/* 0x0B58 */ 0x30A4,0x30ED,0x30AF,0x30ED,0x30FC,0x30CD,0x30B1,0x30FC,
/* 0x0B60 */ 0x30B9,0x30B3,0x30EB,0x30CA,0x30B3,0x30FC,0x30DD,0x30B5,
/* 0x0B68 */ 0x30A4,0x30AF,0x30EB,0x30B5,0x30F3,0x30C1,0x30FC,0x30E0,
/* 0x0B70 */ 0x30B7,0x30EA,0x30F3,0x30B0,0x30BB,0x30F3,0x30C1,0x30BB,
/* 0x0B78 */ 0x30F3,0x30C8,0x30C0,0x30FC,0x30B9,0x30C7,0x30B7,0x30C9,
/* 0x0B80 */ 0x30EB,0x30C8,0x30F3,0x30CA,0x30CE,0x30CE,0x30C3,0x30C8,
/* 0x0B88 */ 0x30CF,0x30A4,0x30C4,0x30D1,0x30FC,0x30BB,0x30F3,0x30C8,
/* 0x0B90 */ 0x30D1,0x30FC,0x30C4,0x30D0,0x30FC,0x30EC,0x30EB,0x30D4,
/* 0x0B98 */ 0x30A2,0x30B9,0x30C8,0x30EB,0x30D4,0x30AF,0x30EB,0x30D4,
/* 0x0BA0 */ 0x30B3,0x30D3,0x30EB,0x30D5,0x30A1,0x30E9,0x30C3,0x30C9,
/* 0x0BA8 */ 0x30D5,0x30A3,0x30FC,0x30C8,0x30D6,0x30C3,0x30B7,0x30A7,
/* 0x0BB0 */ 0x30EB,0x30D5,0x30E9,0x30F3,0x30D8,0x30AF,0x30BF,0x30FC,
/* 0x0BB8 */ 0x30EB,0x30DA,0x30BD,0x30DA,0x30CB,0x30D2,0x30D8,0x30EB,
/* 0x0BC0 */ 0x30C4,0x30DA,0x30F3,0x30B9,0x30DA,0x30FC,0x30B8,0x30D9,
/* 0x0BC8 */ 0x30FC,0x30BF,0x30DD,0x30A4,0x30F3,0x30C8,0x30DC,0x30EB,
/* 0x0BD0 */ 0x30C8,0x30DB,0x30F3,0x30DD,0x30F3,0x30C9,0x30DB,0x30FC,
/* 0x0BD8 */ 0x30EB,0x30DB,0x30FC,0x30F3,0x30DE,0x30A4,0x30AF,0x30ED,
/* 0x0BE0 */ 0x30DE,0x30A4,0x30EB,0x30DE,0x30C3,0x30CF,0x30DE,0x30EB,
/* 0x0BE8 */ 0x30AF,0x30DE,0x30F3,0x30B7,0x30E7,0x30F3,0x30DF,0x30AF,
/* 0x0BF0 */ 0x30ED,0x30F3,0x30DF,0x30EA,0x30DF,0x30EA,0x30D0,0x30FC,
/* 0x0BF8 */ 0x30EB,0x30E1,0x30AC,0x30E1,0x30AC,0x30C8,0x30F3,0x30E1,
/* 0x0C00 */ 0x30FC,0x30C8,0x30EB,0x30E4,0x30FC,0x30C9,0x30E4,0x30FC,
/* 0x0C08 */ 0x30EB,0x30E6,0x30A2,0x30F3,0x30EA,0x30C3,0x30C8,0x30EB,
/* 0x0C10 */ 0x30EA,0x30E9,0x30EB,0x30D4,0x30FC,0x30EB,0x30FC,0x30D6,
/* 0x0C18 */ 0x30EB,0x30EC,0x30E0,0x30EC,0x30F3,0x30C8,0x30B2,0x30F3,
/* 0x0C20 */ 0x30EF,0x30C3,0x30C8,0x0030,0x70B9,0x0031,0x70B9,0x0032,
/* 0x0C28 */ 0x70B9,0x0033,0x70B9,0x0034,0x70B9,0x0035,0x70B9,0x0036,
/* 0x0C30 */ 0x70B9,0x0037,0x70B9,0x0038,0x70B9,0x0039,0x70B9,0x0031,
/* 0x0C38 */ 0x0030,0x70B9,0x0031,0x0031,0x70B9,0x0031,0x0032,0x70B9,
/* 0x0C40 */ 0x0031,0x0033,0x70B9,0x0031,0x0034,0x70B9,0x0031,0x0035,
/* 0x0C48 */ 0x70B9,0x0031,0x0036,0x70B9,0x0031,0x0037,0x70B9,0x0031,
/* 0x0C50 */ 0x0038,0x70B9,0x0031,0x0039,0x70B9,0x0032,0x0030,0x70B9,
/* 0x0C58 */ 0x0032,0x0031,0x70B9,0x0032,0x0032,0x70B9,0x0032,0x0033,
/* 0x0C60 */ 0x70B9,0x0032,0x0034,0x70B9,0x0068,0x0050,0x0061,0x0064,
/* 0x0C68 */ 0x0061,0x0041,0x0055,0x0062,0x0061,0x0072,0x006F,0x0056,
/* 0x0C70 */ 0x0070,0x0063,0x0064,0x006D,0x0064,0x006D,0x00B2,0x0064,
/* 0x0C78 */ 0x006D,0x00B3,0x0049,0x0055,0x5E73,0x6210,0x662D,0x548C,
/* 0x0C80 */ 0x5927,0x6B63,0x660E,0x6CBB,0x682A,0x5F0F,0x4F1A,0x793E,
/* 0x0C88 */ 0x0070,0x0041,0x006E,0x0041,0x03BC,0x0041,0x006D,0x0041,
/* 0x0C90 */ 0x006B,0x0041,0x004B,0x0042,0x004D,0x0042,0x0047,0x0042,
/* 0x0C98 */ 0x0063,0x0061,0x006C,0x006B,0x0063,0x0061,0x006C,0x0070,
/* 0x0CA0 */ 0x0046,0x006E,0x0046,0x03BC,0x0046,0x03BC,0x0067,0x006D,
/* 0x0CA8 */ 0x0067,0x006B,0x0067,0x0048,0x007A,0x006B,0x0048,0x007A,
/* 0x0CB0 */ 0x004D,0x0048,0x007A,0x0047,0x0048,0x007A,0x0054,0x0048,
/* 0x0CB8 */ 0x007A,0x03BC,0x2113,0x006D,0x2113,0x0064,0x2113,0x006B,
/* 0x0CC0 */ 0x2113,0x0066,0x006D,0x006E,0x006D,0x03BC,0x006D,0x006D,
/* 0x0CC8 */ 0x006D,0x0063,0x006D,0x006B,0x006D,0x006D,0x006D,0x00B2,
/* 0x0CD0 */ 0x0063,0x006D,0x00B2,0x006D,0x00B2,0x006B,0x006D,0x00B2,
/* 0x0CD8 */ 0x006D,0x006D,0x00B3,0x0063,0x006D,0x00B3,0x006D,0x00B3,
/* 0x0CE0 */ 0x006B,0x006D,0x00B3,0x006D,0x2215,0x0073,0x006D,0x2215,
/* 0x0CE8 */ 0x0073,0x00B2,0x0050,0x0061,0x006B,0x0050,0x0061,0x004D,
/* 0x0CF0 */ 0x0050,0x0061,0x0047,0x0050,0x0061,0x0072,0x0061,0x0064,
/* 0x0CF8 */ 0x0072,0x0061,0x0064,0x2215,0x0073,0x0072,0x0061,0x0064,
/* 0x0D00 */ 0x2215,0x0073,0x00B2,0x0070,0x0073,0x006E,0x0073,0x03BC,
/* 0x0D08 */ 0x0073,0x006D,0x0073,0x0070,0x0056,0x006E,0x0056,0x03BC,
/* 0x0D10 */ 0x0056,0x006D,0x0056,0x006B,0x0056,0x004D,0x0056,0x0070,
/* 0x0D18 */ 0x0057,0x006E,0x0057,0x03BC,0x0057,0x006D,0x0057,0x006B,
/* 0x0D20 */ 0x0057,0x004D,0x0057,0x006B,0x03A9,0x004D,0x03A9,0x0061,
/* 0x0D28 */ 0x002E,0x006D,0x002E,0x0042,0x0071,0x0063,0x0063,0x0063,
/* 0x0D30 */ 0x0064,0x0043,0x2215,0x006B,0x0067,0x0043,0x006F,0x002E,
/* 0x0D38 */ 0x0064,0x0042,0x0047,0x0079,0x0068,0x0061,0x0048,0x0050,
/* 0x0D40 */ 0x0069,0x006E,0x004B,0x004B,0x004B,0x004D,0x006B,0x0074,
/* 0x0D48 */ 0x006C,0x006D,0x006C,0x006E,0x006C,0x006F,0x0067,0x006C,
/* 0x0D50 */ 0x0078,0x006D,0x0062,0x006D,0x0069,0x006C,0x006D,0x006F,
/* 0x0D58 */ 0x006C,0x0050,0x0048,0x0070,0x002E,0x006D,0x002E,0x0050,
/* 0x0D60 */ 0x0050,0x004D,0x0050,0x0052,0x0073,0x0072,0x0053,0x0076,
/* 0x0D68 */ 0x0057,0x0062,0x0056,0x2215,0x006D,0x0041,0x2215,0x006D,
/* 0x0D70 */ 0x0031,0x65E5,0x0032,0x65E5,0x0033,0x65E5,0x0034,0x65E5,
/* 0x0D78 */ 0x0035,0x65E5,0x0036,0x65E5,0x0037,0x65E5,0x0038,0x65E5,
/* 0x0D80 */ 0x0039,0x65E5,0x0031,0x0030,0x65E5,0x0031,0x0031,0x65E5,
/* 0x0D88 */ 0x0031,0x0032,0x65E5,0x0031,0x0033,0x65E5,0x0031,0x0034,
/* 0x0D90 */ 0x65E5,0x0031,0x0035,0x65E5,0x0031,0x0036,0x65E5,0x0031,
/* 0x0D98 */ 0x0037,0x65E5,0x0031,0x0038,0x65E5,0x0031,0x0039,0x65E5,
/* 0x0DA0 */ 0x0032,0x0030,0x65E5,0x0032,0x0031,0x65E5,0x0032,0x0032,
/* 0x0DA8 */ 0x65E5,0x0032,0x0033,0x65E5,0x0032,0x0034,0x65E5,0x0032,
/* 0x0DB0 */ 0x0035,0x65E5,0x0032,0x0036,0x65E5,0x0032,0x0037,0x65E5,
/* 0x0DB8 */ 0x0032,0x0038,0x65E5,0x0032,0x0039,0x65E5,0x0033,0x0030,
/* 0x0DC0 */ 0x65E5,0x0033,0x0031,0x65E5,0x0067,0x0061,0x006C,0x0066,
/* 0x0DC8 */ 0x0066,0x0066,0x0069,0x0066,0x006C,0x0066,0x0066,0x0069,
/* 0x0DD0 */ 0x0066,0x0066,0x006C,0x017F,0x0074,0x0073,0x0074,0x0574,
/* 0x0DD8 */ 0x0576,0x0574,0x0565,0x0574,0x056B,0x057E,0x0576,0x0574,
/* 0x0DE0 */ 0x056D,0x05D9,0x05B4,0x05F2,0x05B7,0x05E9,0x05C1,0x05E9,
/* 0x0DE8 */ 0x05C2,0xFB49,0x05C1,0xFB49,0x05C2,0x05D0,0x05B7,0x05D0,
/* 0x0DF0 */ 0x05B8,0x05D0,0x05BC,0x05D1,0x05BC,0x05D2,0x05BC,0x05D3,
/* 0x0DF8 */ 0x05BC,0x05D4,0x05BC,0x05D5,0x05BC,0x05D6,0x05BC,0x05D8,
/* 0x0E00 */ 0x05BC,0x05D9,0x05BC,0x05DA,0x05BC,0x05DB,0x05BC,0x05DC,
/* 0x0E08 */ 0x05BC,0x05DE,0x05BC,0x05E0,0x05BC,0x05E1,0x05BC,0x05E3,
/* 0x0E10 */ 0x05BC,0x05E4,0x05BC,0x05E6,0x05BC,0x05E7,0x05BC,0x05E8,
/* 0x0E18 */ 0x05BC,0x05E9,0x05BC,0x05EA,0x05BC,0x05D5,0x05B9,0x05D1,
/* 0x0E20 */ 0x05BF,0x05DB,0x05BF,0x05E4,0x05BF,0x05D0,0x05DC,0x0626,
/* 0x0E28 */ 0x0627,0x0626,0x0627,0x0626,0x06D5,0x0626,0x06D5,0x0626,
/* 0x0E30 */ 0x0648,0x0626,0x0648,0x0626,0x06C7,0x0626,0x06C7,0x0626,
/* 0x0E38 */ 0x06C6,0x0626,0x06C6,0x0626,0x06C8,0x0626,0x06C8,0x0626,
/* 0x0E40 */ 0x06D0,0x0626,0x06D0,0x0626,0x06D0,0x0626,0x0649,0x0626,
/* 0x0E48 */ 0x0649,0x0626,0x0649,0x0626,0x062C,0x0626,0x062D,0x0626,
/* 0x0E50 */ 0x0645,0x0626,0x0649,0x0626,0x064A,0x0628,0x062C,0x0628,
/* 0x0E58 */ 0x062D,0x0628,0x062E,0x0628,0x0645,0x0628,0x0649,0x0628,
/* 0x0E60 */ 0x064A,0x062A,0x062C,0x062A,0x062D,0x062A,0x062E,0x062A,
/* 0x0E68 */ 0x0645,0x062A,0x0649,0x062A,0x064A,0x062B,0x062C,0x062B,
/* 0x0E70 */ 0x0645,0x062B,0x0649,0x062B,0x064A,0x062C,0x062D,0x062C,
/* 0x0E78 */ 0x0645,0x062D,0x062C,0x062D,0x0645,0x062E,0x062C,0x062E,
/* 0x0E80 */ 0x062D,0x062E,0x0645,0x0633,0x062C,0x0633,0x062D,0x0633,
/* 0x0E88 */ 0x062E,0x0633,0x0645,0x0635,0x062D,0x0635,0x0645,0x0636,
/* 0x0E90 */ 0x062C,0x0636,0x062D,0x0636,0x062E,0x0636,0x0645,0x0637,
/* 0x0E98 */ 0x062D,0x0637,0x0645,0x0638,0x0645,0x0639,0x062C,0x0639,
/* 0x0EA0 */ 0x0645,0x063A,0x062C,0x063A,0x0645,0x0641,0x062C,0x0641,
/* 0x0EA8 */ 0x062D,0x0641,0x062E,0x0641,0x0645,0x0641,0x0649,0x0641,
/* 0x0EB0 */ 0x064A,0x0642,0x062D,0x0642,0x0645,0x0642,0x0649,0x0642,
/* 0x0EB8 */ 0x064A,0x0643,0x0627,0x0643,0x062C,0x0643,0x062D,0x0643,
/* 0x0EC0 */ 0x062E,0x0643,0x0644,0x0643,0x0645,0x0643,0x0649,0x0643,
/* 0x0EC8 */ 0x064A,0x0644,0x062C,0x0644,0x062D,0x0644,0x062E,0x0644,
/* 0x0ED0 */ 0x0645,0x0644,0x0649,0x0644,0x064A,0x0645,0x062C,0x0645,
/* 0x0ED8 */ 0x062D,0x0645,0x062E,0x0645,0x0645,0x0645,0x0649,0x0645,
/* 0x0EE0 */ 0x064A,0x0646,0x062C,0x0646,0x062D,0x0646,0x062E,0x0646,
/* 0x0EE8 */ 0x0645,0x0646,0x0649,0x0646,0x064A,0x0647,0x062C,0x0647,
/* 0x0EF0 */ 0x0645,0x0647,0x0649,0x0647,0x064A,0x064A,0x062C,0x064A,
/* 0x0EF8 */ 0x062D,0x064A,0x062E,0x064A,0x0645,0x064A,0x0649,0x064A,
/* 0x0F00 */ 0x064A,0x0630,0x0670,0x0631,0x0670,0x0649,0x0670,0x0020,
/* 0x0F08 */ 0x064C,0x0651,0x0020,0x064D,0x0651,0x0020,0x064E,0x0651,
/* 0x0F10 */ 0x0020,0x064F,0x0651,0x0020,0x0650,0x0651,0x0020,0x0651,
/* 0x0F18 */ 0x0670,0x0626,0x0631,0x0626,0x0632,0x0626,0x0645,0x0626,
/* 0x0F20 */ 0x0646,0x0626,0x0649,0x0626,0x064A,0x0628,0x0631,0x0628,
/* 0x0F28 */ 0x0632,0x0628,0x0645,0x0628,0x0646,0x0628,0x0649,0x0628,
/* 0x0F30 */ 0x064A,0x062A,0x0631,0x062A,0x0632,0x062A,0x0645,0x062A,
/* 0x0F38 */ 0x0646,0x062A,0x0649,0x062A,0x064A,0x062B,0x0631,0x062B,
/* 0x0F40 */ 0x0632,0x062B,0x0645,0x062B,0x0646,0x062B,0x0649,0x062B,
/* 0x0F48 */ 0x064A,0x0641,0x0649,0x0641,0x064A,0x0642,0x0649,0x0642,
/* 0x0F50 */ 0x064A,0x0643,0x0627,0x0643,0x0644,0x0643,0x0645,0x0643,
/* 0x0F58 */ 0x0649,0x0643,0x064A,0x0644,0x0645,0x0644,0x0649,0x0644,
/* 0x0F60 */ 0x064A,0x0645,0x0627,0x0645,0x0645,0x0646,0x0631,0x0646,
/* 0x0F68 */ 0x0632,0x0646,0x0645,0x0646,0x0646,0x0646,0x0649,0x0646,
/* 0x0F70 */ 0x064A,0x0649,0x0670,0x064A,0x0631,0x064A,0x0632,0x064A,
/* 0x0F78 */ 0x0645,0x064A,0x0646,0x064A,0x0649,0x064A,0x064A,0x0626,
/* 0x0F80 */ 0x062C,0x0626,0x062D,0x0626,0x062E,0x0626,0x0645,0x0626,
/* 0x0F88 */ 0x0647,0x0628,0x062C,0x0628,0x062D,0x0628,0x062E,0x0628,
/* 0x0F90 */ 0x0645,0x0628,0x0647,0x062A,0x062C,0x062A,0x062D,0x062A,
/* 0x0F98 */ 0x062E,0x062A,0x0645,0x062A,0x0647,0x062B,0x0645,0x062C,
/* 0x0FA0 */ 0x062D,0x062C,0x0645,0x062D,0x062C,0x062D,0x0645,0x062E,
/* 0x0FA8 */ 0x062C,0x062E,0x0645,0x0633,0x062C,0x0633,0x062D,0x0633,
/* 0x0FB0 */ 0x062E,0x0633,0x0645,0x0635,0x062D,0x0635,0x062E,0x0635,
/* 0x0FB8 */ 0x0645,0x0636,0x062C,0x0636,0x062D,0x0636,0x062E,0x0636,
/* 0x0FC0 */ 0x0645,0x0637,0x062D,0x0638,0x0645,0x0639,0x062C,0x0639,
/* 0x0FC8 */ 0x0645,0x063A,0x062C,0x063A,0x0645,0x0641,0x062C,0x0641,
/* 0x0FD0 */ 0x062D,0x0641,0x062E,0x0641,0x0645,0x0642,0x062D,0x0642,
/* 0x0FD8 */ 0x0645,0x0643,0x062C,0x0643,0x062D,0x0643,0x062E,0x0643,
/* 0x0FE0 */ 0x0644,0x0643,0x0645,0x0644,0x062C,0x0644,0x062D,0x0644,
/* 0x0FE8 */ 0x062E,0x0644,0x0645,0x0644,0x0647,0x0645,0x062C,0x0645,
/* 0x0FF0 */ 0x062D,0x0645,0x062E,0x0645,0x0645,0x0646,0x062C,0x0646,
/* 0x0FF8 */ 0x062D,0x0646,0x062E,0x0646,0x0645,0x0646,0x0647,0x0647,
/* 0x1000 */ 0x062C,0x0647,0x0645,0x0647,0x0670,0x064A,0x062C,0x064A,
/* 0x1008 */ 0x062D,0x064A,0x062E,0x064A,0x0645,0x064A,0x0647,0x0626,
/* 0x1010 */ 0x0645,0x0626,0x0647,0x0628,0x0645,0x0628,0x0647,0x062A,
/* 0x1018 */ 0x0645,0x062A,0x0647,0x062B,0x0645,0x062B,0x0647,0x0633,
/* 0x1020 */ 0x0645,0x0633,0x0647,0x0634,0x0645,0x0634,0x0647,0x0643,
/* 0x1028 */ 0x0644,0x0643,0x0645,0x0644,0x0645,0x0646,0x0645,0x0646,
/* 0x1030 */ 0x0647,0x064A,0x0645,0x064A,0x0647,0x0640,0x064E,0x0651,
/* 0x1038 */ 0x0640,0x064F,0x0651,0x0640,0x0650,0x0651,0x0637,0x0649,
/* 0x1040 */ 0x0637,0x064A,0x0639,0x0649,0x0639,0x064A,0x063A,0x0649,
/* 0x1048 */ 0x063A,0x064A,0x0633,0x0649,0x0633,0x064A,0x0634,0x0649,
/* 0x1050 */ 0x0634,0x064A,0x062D,0x0649,0x062D,0x064A,0x062C,0x0649,
/* 0x1058 */ 0x062C,0x064A,0x062E,0x0649,0x062E,0x064A,0x0635,0x0649,
/* 0x1060 */ 0x0635,0x064A,0x0636,0x0649,0x0636,0x064A,0x0634,0x062C,
/* 0x1068 */ 0x0634,0x062D,0x0634,0x062E,0x0634,0x0645,0x0634,0x0631,
/* 0x1070 */ 0x0633,0x0631,0x0635,0x0631,0x0636,0x0631,0x0637,0x0649,
/* 0x1078 */ 0x0637,0x064A,0x0639,0x0649,0x0639,0x064A,0x063A,0x0649,
/* 0x1080 */ 0x063A,0x064A,0x0633,0x0649,0x0633,0x064A,0x0634,0x0649,
/* 0x1088 */ 0x0634,0x064A,0x062D,0x0649,0x062D,0x064A,0x062C,0x0649,
/* 0x1090 */ 0x062C,0x064A,0x062E,0x0649,0x062E,0x064A,0x0635,0x0649,
/* 0x1098 */ 0x0635,0x064A,0x0636,0x0649,0x0636,0x064A,0x0634,0x062C,
/* 0x10A0 */ 0x0634,0x062D,0x0634,0x062E,0x0634,0x0645,0x0634,0x0631,
/* 0x10A8 */ 0x0633,0x0631,0x0635,0x0631,0x0636,0x0631,0x0634,0x062C,
/* 0x10B0 */ 0x0634,0x062D,0x0634,0x062E,0x0634,0x0645,0x0633,0x0647,
/* 0x10B8 */ 0x0634,0x0647,0x0637,0x0645,0x0633,0x062C,0x0633,0x062D,
/* 0x10C0 */ 0x0633,0x062E,0x0634,0x062C,0x0634,0x062D,0x0634,0x062E,
/* 0x10C8 */ 0x0637,0x0645,0x0638,0x0645,0x0627,0x064B,0x0627,0x064B,
/* 0x10D0 */ 0x062A,0x062C,0x0645,0x062A,0x062D,0x062C,0x062A,0x062D,
/* 0x10D8 */ 0x062C,0x062A,0x062D,0x0645,0x062A,0x062E,0x0645,0x062A,
/* 0x10E0 */ 0x0645,0x062C,0x062A,0x0645,0x062D,0x062A,0x0645,0x062E,
/* 0x10E8 */ 0x062C,0x0645,0x062D,0x062C,0x0645,0x062D,0x062D,0x0645,
/* 0x10F0 */ 0x064A,0x062D,0x0645,0x0649,0x0633,0x062D,0x062C,0x0633,
/* 0x10F8 */ 0x062C,0x062D,0x0633,0x062C,0x0649,0x0633,0x0645,0x062D,
/* 0x1100 */ 0x0633,0x0645,0x062D,0x0633,0x0645,0x062C,0x0633,0x0645,
/* 0x1108 */ 0x0645,0x0633,0x0645,0x0645,0x0635,0x062D,0x062D,0x0635,
/* 0x1110 */ 0x062D,0x062D,0x0635,0x0645,0x0645,0x0634,0x062D,0x0645,
/* 0x1118 */ 0x0634,0x062D,0x0645,0x0634,0x062C,0x064A,0x0634,0x0645,
/* 0x1120 */ 0x062E,0x0634,0x0645,0x062E,0x0634,0x0645,0x0645,0x0634,
/* 0x1128 */ 0x0645,0x0645,0x0636,0x062D,0x0649,0x0636,0x062E,0x0645,
/* 0x1130 */ 0x0636,0x062E,0x0645,0x0637,0x0645,0x062D,0x0637,0x0645,
/* 0x1138 */ 0x062D,0x0637,0x0645,0x0645,0x0637,0x0645,0x064A,0x0639,
/* 0x1140 */ 0x062C,0x0645,0x0639,0x0645,0x0645,0x0639,0x0645,0x0645,
/* 0x1148 */ 0x0639,0x0645,0x0649,0x063A,0x0645,0x0645,0x063A,0x0645,
/* 0x1150 */ 0x064A,0x063A,0x0645,0x0649,0x0641,0x062E,0x0645,0x0641,
/* 0x1158 */ 0x062E,0x0645,0x0642,0x0645,0x062D,0x0642,0x0645,0x0645,
/* 0x1160 */ 0x0644,0x062D,0x0645,0x0644,0x062D,0x064A,0x0644,0x062D,
/* 0x1168 */ 0x0649,0x0644,0x062C,0x062C,0x0644,0x062C,0x062C,0x0644,
/* 0x1170 */ 0x062E,0x0645,0x0644,0x062E,0x0645,0x0644,0x0645,0x062D,
/* 0x1178 */ 0x0644,0x0645,0x062D,0x0645,0x062D,0x062C,0x0645,0x062D,
/* 0x1180 */ 0x0645,0x0645,0x062D,0x064A,0x0645,0x062C,0x062D,0x0645,
/* 0x1188 */ 0x062C,0x0645,0x0645,0x062E,0x062C,0x0645,0x062E,0x0645,
/* 0x1190 */ 0x0645,0x062C,0x062E,0x0647,0x0645,0x062C,0x0647,0x0645,
/* 0x1198 */ 0x0645,0x0646,0x062D,0x0645,0x0646,0x062D,0x0649,0x0646,
/* 0x11A0 */ 0x062C,0x0645,0x0646,0x062C,0x0645,0x0646,0x062C,0x0649,
/* 0x11A8 */ 0x0646,0x0645,0x064A,0x0646,0x0645,0x0649,0x064A,0x0645,
/* 0x11B0 */ 0x0645,0x064A,0x0645,0x0645,0x0628,0x062E,0x064A,0x062A,
/* 0x11B8 */ 0x062C,0x064A,0x062A,0x062C,0x0649,0x062A,0x062E,0x064A,
/* 0x11C0 */ 0x062A,0x062E,0x0649,0x062A,0x0645,0x064A,0x062A,0x0645,
/* 0x11C8 */ 0x0649,0x062C,0x0645,0x064A,0x062C,0x062D,0x0649,0x062C,
/* 0x11D0 */ 0x0645,0x0649,0x0633,0x062E,0x0649,0x0635,0x062D,0x064A,
/* 0x11D8 */ 0x0634,0x062D,0x064A,0x0636,0x062D,0x064A,0x0644,0x062C,
/* 0x11E0 */ 0x064A,0x0644,0x0645,0x064A,0x064A,0x062D,0x064A,0x064A,
/* 0x11E8 */ 0x062C,0x064A,0x064A,0x0645,0x064A,0x0645,0x0645,0x064A,
/* 0x11F0 */ 0x0642,0x0645,0x064A,0x0646,0x062D,0x064A,0x0642,0x0645,
/* 0x11F8 */ 0x062D,0x0644,0x062D,0x0645,0x0639,0x0645,0x064A,0x0643,
/* 0x1200 */ 0x0645,0x064A,0x0646,0x062C,0x062D,0x0645,0x062E,0x064A,
/* 0x1208 */ 0x0644,0x062C,0x0645,0x0643,0x0645,0x0645,0x0644,0x062C,
/* 0x1210 */ 0x0645,0x0646,0x062C,0x062D,0x062C,0x062D,0x064A,0x062D,
/* 0x1218 */ 0x062C,0x064A,0x0645,0x062C,0x064A,0x0641,0x0645,0x064A,
/* 0x1220 */ 0x0628,0x062D,0x064A,0x0643,0x0645,0x0645,0x0639,0x062C,
/* 0x1228 */ 0x0645,0x0635,0x0645,0x0645,0x0633,0x062E,0x064A,0x0646,
/* 0x1230 */ 0x062C,0x064A,0x0635,0x0644,0x06D2,0x0642,0x0644,0x06D2,
/* 0x1238 */ 0x0627,0x0644,0x0644,0x0647,0x0627,0x0643,0x0628,0x0631,
/* 0x1240 */ 0x0645,0x062D,0x0645,0x062F,0x0635,0x0644,0x0639,0x0645,
/* 0x1248 */ 0x0631,0x0633,0x0648,0x0644,0x0639,0x0644,0x064A,0x0647,
/* 0x1250 */ 0x0648,0x0633,0x0644,0x0645,0x0635,0x0644,0x0649,0x0635,
/* 0x1258 */ 0x0644,0x0649,0x0020,0x0627,0x0644,0x0644,0x0647,0x0020,
/* 0x1260 */ 0x0639,0x0644,0x064A,0x0647,0x0020,0x0648,0x0633,0x0644,
/* 0x1268 */ 0x0645,0x062C,0x0644,0x0020,0x062C,0x0644,0x0627,0x0644,
/* 0x1270 */ 0x0647,0x0631,0x06CC,0x0627,0x0644,0x0020,0x064B,0x0640,
/* 0x1278 */ 0x064B,0x0020,0x064C,0x0020,0x064D,0x0020,0x064E,0x0640,
/* 0x1280 */ 0x064E,0x0020,0x064F,0x0640,0x064F,0x0020,0x0650,0x0640,
/* 0x1288 */ 0x0650,0x0020,0x0651,0x0640,0x0651,0x0020,0x0652,0x0640,
/* 0x1290 */ 0x0652,0x0644,0x0622,0x0644,0x0622,0x0644,0x0623,0x0644,
/* 0x1298 */ 0x0623,0x0644,0x0625,0x0644,0x0625,0x0644,0x0627,0x0644,
/* 0x12A0 */ 0x0627,0x11099,0x110BA,0x1109B,0x110BA,0x110A5,0x110BA,0x11131,
/* 0x12A8 */ 0x11127,0x11132,0x11127,0x11347,0x1133E,0x11347,0x11357,0x114B9,
/* 0x12B0 */ 0x114BA,0x114B9,0x114B0,0x114B9,0x114BD,0x115B8,0x115AF,0x115B9,
/* 0x12B8 */ 0x115AF,0x11935,0x11930,0x1D157,0x1D165,0x1D158,0x1D165,0x1D15F,
/* 0x12C0 */ 0x1D16E,0x1D15F,0x1D16F,0x1D15F,0x1D170,0x1D15F,0x1D171,0x1D15F,
/* 0x12C8 */ 0x1D172,0x1D1B9,0x1D165,0x1D1BA,0x1D165,0x1D1BB,0x1D16E,0x1D1BC,
/* 0x12D0 */ 0x1D16E,0x1D1BB,0x1D16F,0x1D1BC,0x1D16F,0x0030,0x002E,0x0030,
/* 0x12D8 */ 0x002C,0x0031,0x002C,0x0032,0x002C,0x0033,0x002C,0x0034,
/* 0x12E0 */ 0x002C,0x0035,0x002C,0x0036,0x002C,0x0037,0x002C,0x0038,
/* 0x12E8 */ 0x002C,0x0039,0x002C,0x0028,0x0041,0x0029,0x0028,0x0042,
/* 0x12F0 */ 0x0029,0x0028,0x0043,0x0029,0x0028,0x0044,0x0029,0x0028,
/* 0x12F8 */ 0x0045,0x0029,0x0028,0x0046,0x0029,0x0028,0x0047,0x0029,
/* 0x1300 */ 0x0028,0x0048,0x0029,0x0028,0x0049,0x0029,0x0028,0x004A,
/* 0x1308 */ 0x0029,0x0028,0x004B,0x0029,0x0028,0x004C,0x0029,0x0028,
/* 0x1310 */ 0x004D,0x0029,0x0028,0x004E,0x0029,0x0028,0x004F,0x0029,
/* 0x1318 */ 0x0028,0x0050,0x0029,0x0028,0x0051,0x0029,0x0028,0x0052,
/* 0x1320 */ 0x0029,0x0028,0x0053,0x0029,0x0028,0x0054,0x0029,0x0028,
/* 0x1328 */ 0x0055,0x0029,0x0028,0x0056,0x0029,0x0028,0x0057,0x0029,
/* 0x1330 */ 0x0028,0x0058,0x0029,0x0028,0x0059,0x0029,0x0028,0x005A,
/* 0x1338 */ 0x0029,0x3014,0x0053,0x3015,0x0043,0x0044,0x0057,0x005A,
/* 0x1340 */ 0x0048,0x0056,0x004D,0x0056,0x0053,0x0044,0x0053,0x0053,
/* 0x1348 */ 0x0050,0x0050,0x0056,0x0057,0x0043,0x004D,0x0043,0x004D,
/* 0x1350 */ 0x0044,0x004D,0x0052,0x0044,0x004A,0x307B,0x304B,0x30B3,
/* 0x1358 */ 0x30B3,0x3014,0x672C,0x3015,0x3014,0x4E09,0x3015,0x3014,
/* 0x1360 */ 0x4E8C,0x3015,0x3014,0x5B89,0x3015,0x3014,0x70B9,0x3015,
/* 0x1368 */ 0x3014,0x6253,0x3015,0x3014,0x76D7,0x3015,0x3014,0x52DD,
/* 0x1370 */ 0x3015,0x3014,0x6557,0x3015
};

#endif /* UNICODE_DECOMPOSE_H */
