% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gets.R
\name{searcher}
\alias{searcher}
\title{Convert an input to a item QID}
\usage{
searcher(search_term, language, limit, type, ...)
}
\arguments{
\item{search_term}{a term to search for.}

\item{language}{the language to return the labels and descriptions in; this should
consist of an ISO language code. Set to "en" by default.}

\item{limit}{the number of results to return; set to 10 by default.}

\item{type}{type of wikidata object to return (default = "item")}

\item{\\dots}{Additional parameters to supply to [httr::POST]}
}
\value{
If the inputted string matches an item label, return its QID.
If the inputted string matches multiple labels of multiple items, return the QID of the first hit.
If the inputted string is already a QID, return the string.
}
\description{
Convert an input string to the most likely item QID
}
\examples{
# if input string is a valid QID
as_qid("Q42")
# if input string matches multiple item labels
as_qid("Douglas Adams")
# if input string matches a single unique label
as_qid("Douglas Adams and the question of arterial blood pressure in mammals")
}
