/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: version.c,v 1.23 1999/06/23 23:40:45 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include        <sys/types.h>
#include	<stdio.h>
#include	<syslog.h>
#include	"radius.h"

extern char	*progname;
extern int	radius_dbm;
extern int	accept_zero;

/*  If you make any changes to this software please update this version number
 */

#define		VERSION		"Livingston RADIUS 2.1 1999/6/23"

/*************************************************************************
 *
 *	Function: version
 *
 *	Purpose: Display the revision number for this program
 *
 *************************************************************************/

void
version()
{
	char	buffer[1024];
	void	build_version();

	build_version(buffer);
	fprintf(stderr, buffer);
	exit(-1);
}

void
log_version()
{
	char buffer[1024];
	void build_version();
	void log_msg();

	build_version(buffer);
	log_msg(LOG_INFO, buffer);
}

void
build_version(bp)
char * bp;
{
	extern int accept_zero;
	extern int radius_dbm;

	sprintf(bp, "%s: %s ", progname, VERSION);

	/* here are all the conditional feature flags */

# if defined(ACTIVCARD)
	strcat(bp," ACTIVCARD");
# endif

# if defined(IPASS)
	strcat(bp," IPASS");
# endif

# if defined(SECURID)
	strcat(bp," SECURID");
# endif

# if defined(NDBM)
	strcat(bp," NDBM");
# endif

#if defined(NOSHADOW)
	strcat(bp," NOSHADOW");	/* system has no /usr/include/shadow.h */
#endif
#if defined(PASSCHANGE)
	strcat(bp," PASSCHANGE");	/* support deprecated radpass
					 * for changing passwords 
					 */
#endif

	/* here are all the system definitions compilation uses */
#if defined(__alpha)
	strcat(bp," __alpha");
#endif
#if defined(__FreeBSD__)
	strcat(bp," __FreeBSD__");
#endif
#if defined(__osf__)
	strcat(bp," __osf__");
#endif
#if defined(aix)
	strcat(bp," aix");
#endif
#if defined(bsdi)
	strcat(bp," bsdi");
#endif
#if defined(hpux)
	strcat(bp," hpux");
#endif
#if defined(sun)
	strcat(bp," sun");
#endif
#if defined(sys5)
	strcat(bp," sys5");
#endif
#if defined(unixware)
	strcat(bp," unixware");
#endif
#if defined(M_UNIX)
	strcat(bp," M_UNIX");
#endif
	if (accept_zero) {
		strcat(bp, " zero_accepted");
	}
	strcat(bp, radius_dbm ? " dbm_users" : " flat_users");
	strcat(bp,"\n");
}
