# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from KeypadManager.idl.

use strict;

package Raritan::RPC::smartlock::KeypadManager;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "smartlock.KeypadManager:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::smartlock::KeypadManager::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}


sub getKeypads($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getKeypads', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'smartlock.Keypad');
    }
    return $_ret_;
}


sub getKeypadById($$) {
    my ($self, $keypadId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'keypadId'} = "$keypadId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getKeypadById', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}, 'smartlock.Keypad');
    return $_ret_;
}

use Raritan::RPC::smartlock::KeypadManager::KeypadSettings;

sub setKeypadSettings($$$) {
    my ($self, $position, $setting) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'position'} = "$position";
    $args->{'setting'} = Raritan::RPC::smartlock::KeypadManager::KeypadSettings::encode($setting);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setKeypadSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::smartlock::KeypadManager::KeypadSettings;

sub getAllKeypadSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getAllKeypadSettings', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::smartlock::KeypadManager::KeypadSettings::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('smartlock.KeypadManager', 1, 0, 0, 'Raritan::RPC::smartlock::KeypadManager');
1;
