-module(rebar_completion).

-export([generate/2]).

-type arg_type() :: atom | binary | boolean | float | integer | string.

-type cmpl_arg() :: #{short => char() | undefined,
                      long => string() | undefined,
                      type => arg_type(),
                      help => string()}.

-type cmpl_cmd() :: #{name := string(),
                      help := string() | undefined,
                      args := [cmpl_arg()],
                      cmds => [cmpl_cmd()]}.

-type cmpl_opts() :: #{aliases => [string()],
                       file => file:filename(),
                       %% TODO support fish and maybe some more shells
                       shell => bash | zsh}.
-export([prelude/1]).

-export_type([cmpl_opts/0, cmpl_cmd/0, cmpl_arg/0]).

-callback generate([cmpl_cmd()], cmpl_opts()) -> iolist().

-spec generate([cmpl_cmd()], cmpl_opts()) -> iolist().
generate(Commands, #{shell:=bash}=CmplOpts) ->
    rebar_completion_bash:generate(Commands,CmplOpts);
generate(Commands, #{shell:=zsh}=CmplOpts) ->
    rebar_completion_zsh:generate(Commands,CmplOpts).

prelude(#{shell:=Shell}) ->
    "# "++atom_to_list(Shell)++" completion file for rebar3 (autogenerated by rebar3).\n".
