#include "expr_ops_make.icc"
// -----------------------------------------------------------------------------
/* example:			abbrev

   int 				i
   T				t	n_scalar=2

   vec<T,M>			F

   vec_expr<E>		E	expr

  => binary matrix profile :

                iF   iE
                tF   tE

	Fi Ft   FF   FE

	Ei Et   EF   EE

  template:
     xY	Xy => template<T,M>		x=i,t  X=F
	XY => template<T1,T2,M>		X,Y=F
     iE Ei => template<E>		x=i
     tE Et => template<T,E>		x=t
     XE EX => template<E,T,M>		X=F
     EE    => template<E1,E2>
*/
// -----------------------------------------------------------------------------
// =====================================================================================
int main() {
// =====================================================================================
  s expr    = "vec_expr";
  s details = "vec_detail";
  s domain  = "vec_domain";
  s tag  = "is_vec";

  vector<rhs> Rhsclass;
  Rhsclass.push_back (rhs("vec",   "&"));

  vector<s> Class;
  Class.push_back ("vec");

  vector<op> Unop;
  Unop.push_back (op("+", "boost::proto::tag::unary_plus"));
  Unop.push_back (op("-", "boost::proto::tag::negate"));

  vector<op> Binop;
  Binop.push_back (op("+", "boost::proto::tag::plus"));
  Binop.push_back (op("-", "boost::proto::tag::minus"));
  Binop.push_back (op("*", "boost::proto::tag::multiplies"));
  Binop.push_back (op("/", "boost::proto::tag::divides"));

  vector<aop> Assign_op;
  Assign_op.push_back (aop("+=", "plus_assign"));
  Assign_op.push_back (aop("-=", "minus_assign"));
  Assign_op.push_back (aop("*=", "multiplies_assign"));
  Assign_op.push_back (aop("/=", "divides_assign"));

  vector<func> Ufunc;
  Ufunc.push_back (func("abs"));
  Ufunc.push_back (func("fabs"));
  Ufunc.push_back (func("floor"));
  Ufunc.push_back (func("ceil"));
  Ufunc.push_back (func("sqr"));	// rheolef extension

  vector<func> Bifunc;
  Bifunc.push_back (func("min"));	// std::algorithm
  Bifunc.push_back (func("max"));

  header("VEC", "vec");
  all_unops      (tag, domain, Unop,  Class, expr);
  all_binops     (tag, domain, Binop, Class, expr);
  all_assign_ops ("vec", "size", tag, domain, details, Assign_op, Rhsclass, Class, expr);
  all_ufunc  ("boost::proto::tag::function", domain, details, Ufunc,  Class, expr);
  all_bifunc ("boost::proto::tag::function", domain, details, Bifunc, Class, expr);
  ucompose   ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  bicompose  ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  dot ("dot", "vec", Class, expr, "size");
  footer("VEC", "vec");
}
