///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// extended arithmetic issue:
//
// 0.5*point(1,0) -> (0,0) : bug between double(0.5) and point_basic<Float>
// it was because there was two specialized:
//	point operator* (int k,   point x)
//	point operator* (Float k, point x)
// and scalar "double" prefer to convert implicitely into "int" than
// into "Float", that represents the extended arithmetic.
// The same situation occurs with Float=dd_real and Float=float128.
//
// Bug was fixed by removing the "int" specialized version:
// then "double" converts implicitely into "Float".
//
#include "rheolef/point.h"
#include "rheolef/tensor.h"
using namespace std;
using namespace rheolef;
int main (int argc, char**argv) {
#ifdef _RHEOLEF_USE_NEW_CODE
  environment rheolef(argc, argv);
#endif // _RHEOLEF_USE_NEW_CODE
  Float tol = std::numeric_limits<Float>::epsilon();
  point x1 = 0.5*point(2,2);
  point x2 = point(1,1);
  Float err = norm(x1-x2);
  if (err >= tol) {
    cerr << "x="<<x1<<endl;
  }
  tensor t1 = 0.5*tensor(2);
  tensor t2 = tensor(1);
  err += norm(t1-t2);
  if (err >= tol) {
    cerr << "t="<<t1<<endl;
  }
  cerr << "x3="<<point(2,2)*0.5<<endl;
  cerr << "t3="<<tensor(2)*0.5<<endl;
  cerr << "x4="<<point(1)*1<<endl;
  cerr << "x5="<<1.*point(1)<<endl;
  cerr << "t4="<<tensor(1)*1.<<endl;
  cerr << "t5="<<1.*tensor(1)<<endl;
  return err < tol ? 0 : 1;
}
