#include "rheolef.h"
using namespace rheolef;
int main (int argc, char** argv) {
  environment rheolef (argc, argv);
  check_macro (communicator().size() == 1, "please, use sequentially");
  field psi_h;
  din >> psi_h; 
  size_t idof_min = 0;
  Float psi_min = std::numeric_limits<Float>::max();
  for (size_t idof = 0, ndof = psi_h.ndof(); idof < ndof; idof++) {
    if (psi_h.dof(idof) >= psi_min) continue;
    psi_min = psi_h.dof(idof);
    idof_min = idof;
  }
  const disarray<point>& xdof = psi_h.get_space().get_xdofs();
  point xmin = xdof [idof_min];
  dout << "xc\t\tyc\t\tpsi" << std::endl
       << xmin[0] << "\t" << xmin[1] << "\t" << psi_min << std::endl;
}
