//rat.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2014
 *
 *  This file is part of rat a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 */

#ifndef _RAT_H_
#define _RAT_H_

#include <stdio.h>

void rat_init(const char * name, const char * desc);
int  rat_fin(void);

void rat_test(const char * title, int res);
void rat_test_zero(const char * title, int res);
void rat_test_with_output(const char * title, int res);

void rat_test_with_subtests(const char * title);
void rat_subtests_fin(void);

void rat_subtest(int res);
void rat_subtest_crit(int res);

#endif

//ll
