<?php

/*
 +-----------------------------------------------------------------------+
 | localization/<lang>/labels.inc                                        |
 |                                                                       |
 | Localization file of the Roundcube Webmail client                     |
 | Copyright (C) 2005-2013, The Roundcube Dev Team                       |
 |                                                                       |
 | Licensed under the GNU General Public License version 3 or            |
 | any later version with exceptions for skins & plugins.                |
 | See the README file for a full license statement.                     |
 |                                                                       |
 +-----------------------------------------------------------------------+

 For translation see https://www.transifex.com/projects/p/roundcube-webmail/resource/labels/
*/

$labels = array();

// login page
$labels['welcome']   = '欢迎使用 $product';
$labels['username']  = '用户名';
$labels['password']  = '密码';
$labels['server']    = '服务器';
$labels['login']     = '登录';

// taskbar
$labels['logout']   = '注销';
$labels['mail']     = '邮件';
$labels['settings'] = '设置';
$labels['addressbook'] = '通讯录';

// mailbox names
$labels['inbox']  = '收件箱';
$labels['drafts'] = '草稿箱';
$labels['sent']   = '已发送邮件';
$labels['trash']  = '已删除邮件';
$labels['junk']   = '垃圾邮件';

// message listing
$labels['subject'] = '主题';
$labels['from']    = '发件人';
$labels['sender']  = '发件人';
$labels['to']      = '收件人';
$labels['cc']      = '抄送';
$labels['bcc']     = '密送';
$labels['replyto'] = '回复至';
$labels['followupto'] = '投递组';
$labels['date']    = '日期';
$labels['size']    = '大小';
$labels['priority'] = '优先级';
$labels['organization'] = '组织';
$labels['readstatus'] = '阅读状态';
$labels['listoptions'] = '列表选项';

$labels['mailboxlist'] = '邮件夹';
$labels['messagesfromto'] = '第 $from 到 $to，共计 $count 封邮件';
$labels['threadsfromto'] = '第 $from 到 $to，共计 $count 个主题';
$labels['messagenrof'] = '第 $nr 封邮件，共计 $count 封';
$labels['fromtoshort'] = '自 $from – $to 统计 $count';

$labels['copy']     = '复制';
$labels['move']     = '移动';
$labels['moveto']   = '移至...';
$labels['download'] = '下载';
$labels['open']     = '打开';
$labels['showattachment'] = '显示';
$labels['showanyway'] = '总是显示';

$labels['filename'] = '文件名';
$labels['filesize'] = '文件大小';

$labels['addtoaddressbook'] = '添加至通讯录';

// weekdays short
$labels['sun'] = '星期日';
$labels['mon'] = '星期一';
$labels['tue'] = '星期二';
$labels['wed'] = '星期三';
$labels['thu'] = '星期四';
$labels['fri'] = '星期五';
$labels['sat'] = '星期六';

// weekdays long
$labels['sunday']    = '星期日';
$labels['monday']    = '星期一';
$labels['tuesday']   = '星期二';
$labels['wednesday'] = '星期三';
$labels['thursday']  = '星期四';
$labels['friday']    = '星期五';
$labels['saturday']  = '星期六';

// months short
$labels['jan']	= '一月';
$labels['feb']	= '二月';
$labels['mar']	= '三月';
$labels['apr']	= '四月';
$labels['may']	= '五月';
$labels['jun']	= '六月';
$labels['jul'] 	= '七月';
$labels['aug']	= '八月';
$labels['sep']	= '九月';
$labels['oct']	= '十月';
$labels['nov']	= '十一月';
$labels['dec']	= '十二月';

// months long
$labels['longjan']	= '一月';
$labels['longfeb']	= '二月';
$labels['longmar']	= '三月';
$labels['longapr']	= '四月';
$labels['longmay']	= '五月';
$labels['longjun']	= '六月';
$labels['longjul']	= '七月';
$labels['longaug']	= '八月';
$labels['longsep']	= '九月';
$labels['longoct']	= '十月';
$labels['longnov']	= '十一月';
$labels['longdec']	= '十二月';

$labels['today'] = '今天';

// toolbar buttons
$labels['refresh']          = '刷新';
$labels['checkmail']        = '检查新邮件';
$labels['compose']          = '撰写新邮件';
$labels['writenewmessage']  = '写邮件';
$labels['reply']            = '回复';
$labels['replytomessage']   = '回复发件人';
$labels['replytoallmessage'] = '回复所有';
$labels['replyall']         = '回复全部';
$labels['replylist']        = '回复列表';
$labels['forward']          = '转发';
$labels['forwardinline']    = '直接转发';
$labels['forwardattachment'] = '以附件转发';
$labels['forwardmessage']   = '转发邮件';
$labels['deletemessage']    = '删除邮件';
$labels['movemessagetotrash'] = '移至已删除邮件';
$labels['printmessage']     = '打印邮件';
$labels['previousmessage']  = '显示上一封邮件';
$labels['firstmessage']     = '显示第一封邮件';
$labels['nextmessage']      = '下一封';
$labels['lastmessage']      = '最后一封';
$labels['backtolist']       = '返回邮件列表';
$labels['viewsource']       = '显示原始邮件文件';
$labels['mark']             = '标记';
$labels['markmessages']     = '标记选中的邮件为';
$labels['markread']         = '已读';
$labels['markunread']       = '未读';
$labels['markflagged']      = '已标记';
$labels['markunflagged']    = '未标记';
$labels['moreactions']      = '更多操作...';
$labels['more']             = '更多';
$labels['back']             = '返回';
$labels['options']          = '选项';

$labels['select'] = '选择';
$labels['all'] = '全部';
$labels['none'] = '无';
$labels['currpage'] = '当前页';
$labels['unread'] = '未读邮件';
$labels['flagged'] = '已标记邮件';
$labels['unanswered'] = '未回复邮件';
$labels['withattachment'] = 'With attachment';
$labels['deleted'] = '已删除邮件';
$labels['undeleted'] = '未删除邮件';
$labels['invert'] = '反选';
$labels['filter'] = '过滤';
$labels['list'] = '列表';
$labels['threads'] = '主题';
$labels['expand-all'] = '展开全部';
$labels['expand-unread'] = '展开未读';
$labels['collapse-all'] = '收起全部';
$labels['threaded'] = '所有邮件';

$labels['autoexpand_threads'] = '展开消息主题';
$labels['do_expand'] = '所有主题';
$labels['expand_only_unread'] = '仅未读消息';
$labels['fromto'] = '发件人/收件人';
$labels['flag'] = '标志';
$labels['attachment'] = '附件';
$labels['nonesort'] = '无';
$labels['sentdate'] = '发送日期';
$labels['arrival'] = '到达日期';
$labels['asc'] = '升序';
$labels['desc'] = '降序';
$labels['listcolumns'] = '列表列';
$labels['listsorting'] = '排序列';
$labels['listorder'] = '排序';
$labels['listmode'] = '列表视图样式';

$labels['folderactions'] = '文件夹操作...';
$labels['compact'] = '压缩';
$labels['empty'] = '清空';

$labels['quota'] = '邮箱容量';
$labels['unknown']  = '未知';
$labels['unlimited']  = '无限制';

$labels['quicksearch']  = '快速查找';
$labels['resetsearch']  = '清空';
$labels['searchmod']  = '修改搜索';
$labels['msgtext']  = '整封邮件';
$labels['body']  = '正文';

$labels['openinextwin'] = '在新窗口中打开';
$labels['emlsave'] = '下载(.eml)';
$labels['changeformattext'] = 'Display in plain text format';
$labels['changeformathtml'] = 'Display in HTML format';

// message compose
$labels['editasnew']      = '以新邮件编辑';
$labels['send']           = '发送';
$labels['sendmessage']    = '立即发送';
$labels['savemessage']    = '保存为草稿';
$labels['addattachment']  = '添加附件';
$labels['charset']        = '字符集';
$labels['editortype']     = '编辑器类型';
$labels['returnreceipt']  = '需要已读回执';
$labels['dsn']            = '投递状态通知';
$labels['mailreplyintro'] = '在 $date，$sender 写道：';
$labels['originalmessage'] = '原始邮件';

$labels['editidents']    = '编辑身份';
$labels['spellcheck']    = '拼写';
$labels['checkspelling'] = '拼写检查';
$labels['resumeediting'] = '继续编辑';
$labels['revertto']      = '恢复至';

$labels['attach'] = '附加';
$labels['attachments'] = '附件';
$labels['upload'] = '上传';
$labels['uploadprogress'] = '$percent ($current / $total)';
$labels['close']  = '关闭';
$labels['messageoptions']  = '邮件选项...';

$labels['low']     = '低';
$labels['lowest']  = '最低';
$labels['normal']  = '普通';
$labels['high']    = '高';
$labels['highest'] = '最高';

$labels['nosubject']  = '(无主题)';
$labels['showimages'] = '显示图片';
$labels['alwaysshow'] = '总是在来自 $sender 的邮件中显示图片';
$labels['isdraft']    = '这是一封草稿';
$labels['andnmore']   = '第$nr封或更多...';
$labels['togglemoreheaders'] = '显示更多消息头';
$labels['togglefullheaders'] = '切换至原始消息头';

$labels['htmltoggle'] = 'HTML';
$labels['plaintoggle'] = '纯文本';
$labels['savesentmessagein'] = '保存已发送邮件至';
$labels['dontsave'] = '不保存';
$labels['maxuploadsize'] = '上传附件最大不超过 $size';

$labels['addcc'] = '添加抄送';
$labels['addbcc'] = '添加密送';
$labels['addreplyto'] = '添加回复';
$labels['addfollowupto'] = '添加投递组';

// mdn
$labels['mdnrequest'] = '发件人要求在您阅读这封邮件时发送已读通知。您是否希望通知发件人？';
$labels['receiptread'] = '发送回执(已读)';
$labels['yourmessage'] = '这是您的邮件回执';
$labels['receiptnote'] = '注意：回执只表示邮件在收件人的电脑上被打开过，不表示收件人已经阅读或了解邮件内容。';

// address boook
$labels['name']         = '显示名称';
$labels['firstname']    = '名字';
$labels['surname']      = '姓氏';
$labels['middlename']   = '中名';
$labels['nameprefix']   = '前缀';
$labels['namesuffix']   = '后缀';
$labels['nickname']     = '昵称';
$labels['jobtitle']     = '职位';
$labels['department']   = '部门';
$labels['gender']       = '性别';
$labels['maidenname']   = '娘家姓';
$labels['email']        = '邮件地址';
$labels['phone']        = '电话';
$labels['address']      = '地址';
$labels['street']       = '街道';
$labels['locality']     = '城市';
$labels['zipcode']      = '邮编';
$labels['region']       = '省份';
$labels['country']      = '国家';
$labels['birthday']     = '生日';
$labels['anniversary']  = '纪念日';
$labels['website']      = '主页';
$labels['instantmessenger'] = '即时通讯';
$labels['notes'] = '备注';
$labels['male']   = '男';
$labels['female'] = '女';
$labels['manager'] = '经理';
$labels['assistant'] = '助理';
$labels['spouse'] = '配偶';
$labels['allfields'] = '所有栏目';
$labels['search'] = '查询';
$labels['advsearch'] = '高级查询';
$labels['advanced'] = '高级选项';
$labels['other'] = '其他';

$labels['typehome']   = '家庭';
$labels['typework']   = '工作';
$labels['typeother']  = '其他';
$labels['typemobile']  = '手机';
$labels['typemain']  = '主要';
$labels['typehomefax']  = '家庭传真';
$labels['typeworkfax']  = '工作传真';
$labels['typecar']  = '车牌';
$labels['typepager']  = '呼机';
$labels['typevideo']  = '视频';
$labels['typeassistant']  = '助理';
$labels['typehomepage']  = '主页';
$labels['typeblog'] = '博客';
$labels['typeprofile'] = '资料';

$labels['addfield'] = '新增条目...';
$labels['addcontact'] = '新建联系人';
$labels['editcontact'] = '编辑联系人';
$labels['contacts'] = '联系人';
$labels['contactproperties'] = '联系人信息';
$labels['personalinfo'] = '个人信息';

$labels['edit']   = '编辑';
$labels['cancel'] = '取消';
$labels['save']   = '保存';
$labels['delete'] = '删除';
$labels['rename'] = '重命名';
$labels['addphoto'] = '上传';
$labels['replacephoto'] = '替换照片';
$labels['uploadphoto'] = '上传照片';

$labels['newcontact']     = '新建联系人';
$labels['deletecontact']  = '删除选中的联系人';
$labels['composeto']      = '写信至选中的联系人';
$labels['contactsfromto'] = '第 $from 到 $to 个联系人，共 $count 个';
$labels['print']          = '打印';
$labels['export']         = '导出';
$labels['exportall']      = '导出全部';
$labels['exportsel']      = '导出选中';
$labels['exportvcards']   = '导出联系人为 vCard 格式';
$labels['newcontactgroup'] = '创建新的联系人群组';
$labels['grouprename']    = '重命名群组';
$labels['groupdelete']    = '删除群组组';
$labels['groupremoveselected'] = '删除选中';

$labels['previouspage']   = '上一页';
$labels['firstpage']      = '第一页';
$labels['nextpage']       = '下一页';
$labels['lastpage']       = '最后一页';

$labels['group'] = '分组';
$labels['groups'] = '分组';
$labels['personaladrbook'] = '个人通讯录';

$labels['searchsave'] = '保存搜索';
$labels['searchdelete'] = '删除搜索';

$labels['import'] = '导入';
$labels['importcontacts'] = '导入通讯录';
$labels['importfromfile'] = '从文件导入';
$labels['importtarget'] = '添加新联系人至通讯录:';
$labels['importreplace'] = '替换全部通讯录';
$labels['importdesc'] = '您可以从通讯录文件上传联系人，目前已支持 <a href="http://en.wikipedia.org/wiki/VCard">vCard</a> 和 CSV(逗号分隔)格式';
$labels['done'] = '完成';

// settings
$labels['settingsfor'] = '设置';
$labels['about'] = '关于';
$labels['preferences'] = '选项';
$labels['userpreferences'] = '个人选项';
$labels['editpreferences'] = '修改个人选项';

$labels['identities'] = '发件身份';
$labels['manageidentities'] = '管理此账号的身份';
$labels['newidentity'] = '添加身份';

$labels['newitem'] = '添加条目';
$labels['edititem'] = '编辑条目';

$labels['preferhtml'] = '以 HTML 格式显示';
$labels['defaultcharset'] = '默认字符集';
$labels['htmlmessage'] = 'HTML 邮件';
$labels['messagepart'] = '部分';
$labels['digitalsig'] = '数字签名';
$labels['dateformat'] = '日期格式';
$labels['timeformat'] = '时间格式';
$labels['prettydate'] = '短日期格式';
$labels['setdefault']  = '设为默认';
$labels['autodetect']  = '自动';
$labels['language']  = '语言';
$labels['timezone']  = '时区';
$labels['pagesize']  = '每页显示的邮件数量';
$labels['signature'] = '签名';
$labels['dstactive']  = '夏令时';
$labels['showinextwin'] = '在新窗口中打开';
$labels['composeextwin'] = '在新窗口中撰写';
$labels['htmleditor'] = '使用 HTML 编辑器';
$labels['htmlonreply'] = '仅当回复 HTML 邮件';
$labels['htmlonreplyandforward'] = 'on forward or reply to HTML message';
$labels['htmlsignature'] = '使用 HTML 签名';
$labels['showemail'] = 'Show email address with display name';
$labels['previewpane'] = '显示预览窗口';
$labels['skin'] = '界面皮肤';
$labels['logoutclear'] = '退出时清空回收站';
$labels['logoutcompact'] = '退出时压缩收件箱';
$labels['uisettings'] = '用户界面';
$labels['serversettings'] = '服务器设置';
$labels['mailboxview'] = '显示邮件';
$labels['mdnrequests'] = '发件人请求回执';
$labels['askuser'] = '询问用户';
$labels['autosend'] = '自动发送';
$labels['autosendknown'] = '对我的联系人发送回执，否则询问';
$labels['autosendknownignore'] = '对我的联系人发送回执，否则忽略';
$labels['ignore'] = '忽略';
$labels['readwhendeleted'] = '删除后标记为已读';
$labels['flagfordeletion'] = '标记邮件为已删除而不是实际删除';
$labels['skipdeleted'] = '不显示标记为已删除的邮件';
$labels['deletealways'] = '如果移动邮件到回收站失败，则删除';
$labels['deletejunk'] = '在、';
$labels['showremoteimages'] = '显示内嵌的图片';
$labels['fromknownsenders'] = '来自已知发件人';
$labels['always'] = '总是';
$labels['showinlineimages'] = '在邮件下方显示附件中的图片';
$labels['autosavedraft']  = '自动保存到草稿箱';
$labels['everynminutes']  = '每隔 $n 分钟';
$labels['refreshinterval']  = '刷新间隔';
$labels['never']  = '从不';
$labels['immediately']  = '立即';
$labels['messagesdisplaying'] = '显示参数';
$labels['messagescomposition'] = '撰写邮件';
$labels['mimeparamfolding'] = '附件名';
$labels['2231folding'] = '完整的 RFC 2231（Thunderbird）';
$labels['miscfolding'] = 'RFC 2047/2232（MS Outlook）';
$labels['2047folding'] = '完整的 RFC 2047（其它）';
$labels['force7bit'] = '对8位字符使用 MIME 编码';
$labels['advancedoptions'] = '高级选项';
$labels['focusonnewmessage'] = '新邮件到达时将窗口提升为焦点窗口';
$labels['checkallfolders'] = '检查所有邮件夹里的新邮件';
$labels['displaynext'] = '当邮件删除/移动后显示下一封邮件';
$labels['defaultfont'] = '默认的 HTML 格式字体';
$labels['mainoptions'] = '主要选项';
$labels['browseroptions'] = '浏览器选项';
$labels['section'] = '项目';
$labels['maintenance'] = '维护';
$labels['newmessage'] = '新邮件';
$labels['signatureoptions'] = '签名选项';
$labels['whenreplying'] = '当回复时';
$labels['replyempty'] = '不要引用原始邮件';
$labels['replytopposting'] = '在原文上面开始新邮件';
$labels['replybottomposting'] = '在原文下面开始新邮件';
$labels['replyremovesignature'] = '当回复时从邮件移除原始签名';
$labels['autoaddsignature'] = '自动插入签名';
$labels['newmessageonly'] = '仅新邮件';
$labels['replyandforwardonly'] = '仅回复和转发邮件';
$labels['insertsignature'] = '插入签名';
$labels['previewpanemarkread']  = '标记预览邮件为已读';
$labels['afternseconds']  = '$n 秒之后';
$labels['reqmdn'] = '总是要求回执';
$labels['reqdsn'] = '总是要求投递状态通知';
$labels['replysamefolder'] = '保存回复邮件到邮件相同的目录';
$labels['defaultabook'] = '默认地址薄';
$labels['autocompletesingle'] = '跳过自动完成的电子邮件地址';
$labels['listnamedisplay'] = '列出联系人为';
$labels['spellcheckbeforesend'] = '发邮件前进行拼写检查';
$labels['spellcheckoptions'] = '拼写检查选项';
$labels['spellcheckignoresyms'] = '忽略带符号的单词';
$labels['spellcheckignorenums'] = '忽略带数字的单词';
$labels['spellcheckignorecaps'] = '忽略所有大写字母的单词';
$labels['addtodict'] = '添加到字典中';
$labels['mailtoprotohandler'] = 'Register protocol handler for mailto: links';
$labels['forwardmode'] = '邮件转发方式';
$labels['inline'] = '内嵌';
$labels['asattachment'] = '作为附件';

$labels['folder']  = '目录管理';
$labels['folders']  = '目录管理';
$labels['foldername']  = '邮件夹名称';
$labels['subscribed']  = '已订阅';
$labels['messagecount'] = '邮件数量';
$labels['create']  = '建立';
$labels['createfolder']  = '建立新邮件夹';
$labels['managefolders']  = '管理邮件夹';
$labels['specialfolders'] = '定义邮件夹';
$labels['properties'] = '属性';
$labels['folderproperties'] = '文件夹属性';
$labels['parentfolder'] = '父文件夹';
$labels['location'] = '位置';
$labels['info'] = '信息';
$labels['getfoldersize'] = '获得文件夹容量';
$labels['changesubscription'] = '更改订阅';
$labels['foldertype'] = '目录类型';
$labels['personalfolder']  = '私有目录';
$labels['otherfolder']  = '他人目录';
$labels['sharedfolder']  = '共享目录';

$labels['sortby'] = '排序';
$labels['sortasc']  = '递增排序';
$labels['sortdesc'] = '递减排序';
$labels['undo'] = '撤销';

$labels['installedplugins'] = '已安装插件';
$labels['plugin'] = '插件';
$labels['version'] = '版本';
$labels['source'] = '源代码';
$labels['license'] = '许可协议';
$labels['support'] = '支持';

// units
$labels['B'] = 'B';
$labels['KB'] = 'KB';
$labels['MB'] = 'MB';
$labels['GB'] = 'GB';

// character sets
$labels['unicode'] = 'Unicode';
$labels['english'] = '英语';
$labels['westerneuropean'] = '西欧';
$labels['easterneuropean'] = '东欧';
$labels['southeasterneuropean'] = '东南欧';
$labels['baltic'] = '波罗的语';
$labels['cyrillic'] = '西里尔语';
$labels['arabic'] = '阿拉伯语';
$labels['greek'] = '希腊语';
$labels['hebrew'] = '希伯来语';
$labels['turkish'] = '土耳其语';
$labels['nordic'] = '北欧';
$labels['thai'] = '泰语';
$labels['celtic'] = '塞尔特语';
$labels['vietnamese'] = '越南语';
$labels['japanese'] = '日文';
$labels['korean'] = '韩语';
$labels['chinese'] = '中文';

?>
