/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CWE17Module.h
    \author Romain BONDUE
    \date 21/08/2005 */
#ifndef __CWE17MODULE_H__
#define __CWE17MODULE_H__

#include <vector>
#include <string>
#include <memory> // std::auto_ptr<>

#include "Module.h"
#include "UserData.h"
#include "ProfileEditor.h"
#include "WE17Driver.h"



namespace nsCore
{
    class CWE17CLIModule : public ICLIModule
    {
      public :
        CWE17CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CWE17CLIModule () throw();
        const nsUserData::CProfile& GetProfile (unsigned) const throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        unsigned GetNbProfile () const throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();


      private :
        CWE17CLIModule (const CWE17CLIModule&);
        CWE17CLIModule& operator = (const CWE17CLIModule&);

        nsWireless::CWE17Driver m_Driver;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CWE17CLIModule


    class CWE17Module : public IModule
    {
      public :
        CWE17Module (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CWE17Module () throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile (::GtkWindow*) throw();
        nsUserData::CProfile* NewProfile
                              (::GtkWindow*, const nsWireless::CCell&) throw();
        bool EditProfile (::GtkWindow*, unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        void ApplyProfile (unsigned, const nsWireless::CMacAddress&)
                                                throw (nsErrors::CSystemExc);
        /** \warning No bound check! */
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void RecordProfiles () throw (nsErrors::CException);
        ::GtkWidget* GetPrivateTab () throw();
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);


      protected :
        nsUserData::CProfile* EditNewProfile (::GtkWindow*) throw();
        static const char* const NewProfileDefaultName;


      private :
        CWE17Module (const CWE17Module&);
        CWE17Module& operator = (const CWE17Module&);

        std::auto_ptr<nsWireless::CWE17Driver> m_pDriver;
        nsCore::CProfileEditor m_Editor;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CWE17Module

} // namespace nsCore

#include "private/CWE17Module.hxx"

#endif // __CWE17MODULE_H__
