/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.CircleEditDialog;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SimulationObject;

public class FixedCircleObject
extends PrimitiveCircleObject
implements MoveableObject,
SimulationObject {
    Expression E;
    boolean EditAborted = false;
    boolean Dragable = false;
    double x1;
    double y1;
    double x2;
    double y2;

    public FixedCircleObject(Construction construction, PointObject pointObject, double d2, double d3) {
        super(construction, pointObject);
        this.init(construction, d2, d3);
    }

    public void init(Construction construction, double d2, double d3) {
        this.E = new Expression("" + Math.sqrt((d2 - this.M.getX()) * (d2 - this.M.getX()) + (d3 - this.M.getY()) * (d3 - this.M.getY())), construction, this);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Circle";
    }

    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedCircleObject.text2(Zirkel.name("text.fixedcircle"), this.M.getName(), "" + this.E.toString()));
    }

    public void validate() {
        super.validate();
        if (!this.M.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        if (this.E != null && !this.E.isValid()) {
            return;
        }
        try {
            if (this.E != null) {
                this.R = this.E.getValue();
            }
        }
        catch (Exception exception) {
            this.R = 0.0;
            this.Valid = false;
        }
        if (this.R < -1.0E-10) {
            this.Valid = false;
            return;
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        if (this.E.isValid()) {
            xmlWriter.printArg("fixed", this.E.toString());
        } else {
            xmlWriter.printArg("fixed", "" + this.R);
        }
        if (this.Dragable) {
            xmlWriter.printArg("dragable", "true");
        }
        super.printArgs(xmlWriter);
    }

    public boolean canFix() {
        return true;
    }

    public boolean fixed() {
        return true;
    }

    public void setFixed(String string) {
        this.E = new Expression(string, this.getConstruction(), this);
    }

    public void round() {
        try {
            this.setFixed(this.round(this.E.getValue(), ZirkelCanvas.LengthsFactor) + "");
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        CircleEditDialog circleEditDialog;
        while (true) {
            circleEditDialog = new CircleEditDialog(zirkelCanvas.getFrame(), this, zirkelCanvas);
            circleEditDialog.setVisible(true);
            this.EditAborted = false;
            if (circleEditDialog.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (this.E.isValid()) break;
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        this.validate();
        this.updateText();
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.repaint();
        if (circleEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.Valid && this.M.valid()) {
            return this.M.nearto(n, n2, zirkelCanvas);
        }
        return super.nearto(n, n2, zirkelCanvas);
    }

    public boolean isValidFix() {
        return this.E.isValid();
    }

    public void translate() {
        super.translate();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStringLength() {
        return this.E.toString();
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    public Enumeration depending() {
        super.depending();
        Enumeration enumeration = this.E.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            DL.add((ConstructionObject)enumeration.nextElement());
        }
        return DL.elements();
    }

    public void move(double d2, double d3) {
        this.init(this.getConstruction(), d2, d3);
    }

    public boolean moveable() {
        return this.Dragable || this.M.moveable();
    }

    public boolean isFixed() {
        return true;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    public boolean isDragable() {
        return this.Dragable;
    }

    public void setDragable(boolean bl) {
        this.Dragable = bl;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    public void setSimulationValue(double d2) {
        this.R = d2;
        Expression expression = this.E;
        this.E = null;
        this.validate();
        this.E = expression;
    }

    public void resetSimulationValue() {
        this.validate();
    }

    public void startDrag(double d2, double d3) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = d2;
        this.y2 = d3;
    }

    public void dragTo(double d2, double d3) {
        if (this.Dragable) {
            this.move(d2, d3);
        } else {
            this.M.move(this.x1 + (d2 - this.x2), this.y1 + (d3 - this.y2));
        }
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable() && !this.Dragable) {
            this.M.snap(zirkelCanvas);
        }
    }
}

