# Overview

The Ideal Graph Visualizer is a tool developed to help examine the intermediate
representation of C2 which is commonly referred to as the "ideal graph". It was
developed in collaboration with the University of Linz in Austria and has been
included as part of HotSpot since that was the primary target of the tool. The
tool itself is fairly general with only a few modules that contain C2 specific
elements.

The tool is built on top of the NetBeans Platform, and requires a JDK version
between 11 and 17 (the JDKs supported by the current NetBeans Platform).

# Building and Running

The build system used for IGV is Maven. To download all required libraries and
build IGV, issue `mvn install`. To run IGV, use the `igv.sh` command; it will
put all log messages generated by the run to the file `.igv.log`.

To build and run IGV on a different JDK than the system default, set first the
`JAVA_HOME` to the appropriate directory. The same JDK version should be used
for building and running IGV.

# Usage

The JVM support is controlled by the flag `-XX:PrintIdealGraphLevel=#` where `#`
is:

* 0: no output, the default
* 1: dumps graph after parsing, before matching, and final code (also dumps
     graphs for failed compilations, if available)
* 2: more detail, including after loop opts
* 3: even more detail
* 4: prints graph after parsing every bytecode (very slow)

By default the JVM expects that it will connect to a visualizer on the local
host on port 4444. This can be configured using the options
`-XX:PrintIdealGraphAddress=` and `-XX:PrintIdealGraphPort=`.
`PrintIdealGraphAddress` can actually be a hostname.

It is advisable to run the JVM with background compilation disabled (-Xbatch).
Compilations going on in the background may be cancelled when the VM terminates,
which can lead to incomplete dumps being sent to IGV.

Alternatively the output can be sent to a file using
`-XX:PrintIdealGraphFile=filename`. Each compiler thread will get it's own file
with unique names being generated by adding a number onto the provided file
name.

## Defining Custom Filters

IGV has a powerful filter mechanism with which nodes and blocks can be colored,
hidden, updated, etc. according to user-defined rules. Filters are programmed in
JavaScript using a set of predefined primitives and auxiliary functions. For
more information, see the documentation in
`Filter/src/main/resources/com/sun/hotspot/igv/filter/helper.js` and the default
filters in
`ServerCompiler/src/main/resources/com/sun/hotspot/igv/servercompiler/filters`.

More information about the tool is available at
https://wiki.openjdk.org/display/HotSpot/IdealGraphVisualizer.
