/*
 * ***************************************************************************
 * MC = < Manifold Code >
 * Copyright (C) 1994-- Michael Holst 
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public 
 * License as published by the Free Software Foundation; either  
 * version 2.1 of the License, or (at your option) any later version. 
 *
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details. 
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software  
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   
 * 
 * rcsid="$Id: mainFpoint.c,v 1.5 2010/08/12 05:17:31 fetk Exp $"
 * ***************************************************************************
 */

/*
 * ***************************************************************************
 * File:     main.c
 *
 * Purpose:  Driver program for testing Bchar_assem routines
 *
 * Notes:    A random non-symmetric block problem (with unequal blocks sizes)
 *           and a corresponding random permutation matrix were generated in
 *           in Matlab.  The exact solution was generated using simple Matlab 
 *           "find" commands to ensure correctness.  This routine will expose 
 *           most all bugs in the Bchar_assem routines, if any such bugs 
 *           exist.  The Matlab code for generating the test problem is 
 *           attached at the end of this file as a comment.
 *
 * Author:   Stephen Bond
 * ***************************************************************************
 */

#include "mc/mc.h"
VPRIVATE Bmat* Bmat_example_Pro( int key )
{
   int numB, numC[MAXV], numR[MAXV];
   Mat *Ab;
   double *AD;
   int p, q, *IJA;
   MATmirror mirror[MAXV][MAXV];
   Bmat *thee = VNULL;

   numB = 3;
   VASSERT( numB <= MAXV );
   numR[0] = (0 == key) ? 50 : 30;
   numC[0] = 20;
   numR[1] = (0 == key) ? 48 : 20;
   numC[1] = 28;
   numR[2] = (0 == key) ? 52 : 27;
   numC[2] = 25;
   for( p=0; p<numB; p++ ) {
      for( q=0; q<numB; q++ ) {
         mirror[p][q] = ISNOT_MIRROR;
      }
   }

   thee = Bmat_ctor( VNULL, "P", numB, numR, numC, mirror );

   if (0 == key) {
   Ab = thee->AD[0][0];
   IJA = Vmem_malloc(Ab->vmem, 131, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=3;IJA[4]=4;
   IJA[5]=5;IJA[6]=6;IJA[7]=7;IJA[8]=8;IJA[9]=9;
   IJA[10]=10;IJA[11]=11;IJA[12]=12;IJA[13]=13;IJA[14]=14;
   IJA[15]=15;IJA[16]=16;IJA[17]=17;IJA[18]=18;IJA[19]=19;
   IJA[20]=20;IJA[21]=22;IJA[22]=24;IJA[23]=26;IJA[24]=28;
   IJA[25]=30;IJA[26]=32;IJA[27]=34;IJA[28]=36;IJA[29]=38;
   IJA[30]=40;IJA[31]=42;IJA[32]=44;IJA[33]=46;IJA[34]=48;
   IJA[35]=50;IJA[36]=52;IJA[37]=54;IJA[38]=56;IJA[39]=58;
   IJA[40]=60;IJA[41]=62;IJA[42]=64;IJA[43]=66;IJA[44]=68;
   IJA[45]=70;IJA[46]=72;IJA[47]=74;IJA[48]=76;IJA[49]=78;
   IJA[50]=80;
   IJA[51]=0;IJA[52]=1;IJA[53]=2;IJA[54]=3;IJA[55]=4;
   IJA[56]=5;IJA[57]=6;IJA[58]=7;IJA[59]=8;IJA[60]=9;
   IJA[61]=10;IJA[62]=11;IJA[63]=12;IJA[64]=13;IJA[65]=14;
   IJA[66]=15;IJA[67]=16;IJA[68]=17;IJA[69]=18;IJA[70]=19;
   IJA[71]=2;IJA[72]=5;IJA[73]=11;IJA[74]=19;IJA[75]=13;
   IJA[76]=14;IJA[77]=7;IJA[78]=8;IJA[79]=11;IJA[80]=18;
   IJA[81]=11;IJA[82]=18;IJA[83]=2;IJA[84]=6;IJA[85]=5;
   IJA[86]=11;IJA[87]=13;IJA[88]=14;IJA[89]=5;IJA[90]=9;
   IJA[91]=15;IJA[92]=17;IJA[93]=7;IJA[94]=15;IJA[95]=0;
   IJA[96]=3;IJA[97]=0;IJA[98]=4;IJA[99]=0;IJA[100]=13;
   IJA[101]=0;IJA[102]=2;IJA[103]=4;IJA[104]=12;IJA[105]=2;
   IJA[106]=17;IJA[107]=0;IJA[108]=15;IJA[109]=9;IJA[110]=15;
   IJA[111]=7;IJA[112]=8;IJA[113]=2;IJA[114]=19;IJA[115]=7;
   IJA[116]=11;IJA[117]=3;IJA[118]=14;IJA[119]=4;IJA[120]=7;
   IJA[121]=17;IJA[122]=19;IJA[123]=9;IJA[124]=11;IJA[125]=4;
   IJA[126]=15;IJA[127]=9;IJA[128]=17;IJA[129]=11;IJA[130]=19;
   
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 80, IJA, VNULL);
   Ab->impl = ISNOT_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.0e+00;AD[1]=1.0e+00;AD[2]=1.0e+00;AD[3]=1.0e+00;AD[4]=1.0e+00;
   AD[5]=1.0e+00;AD[6]=1.0e+00;AD[7]=1.0e+00;AD[8]=0.0e+00;AD[9]=1.0e+00;
   AD[10]=1.0e+00;AD[11]=1.0e+00;AD[12]=1.0e+00;AD[13]=1.0e+00;AD[14]=1.0e+00;
   AD[15]=0.0e+00;AD[16]=1.0e+00;AD[17]=1.0e+00;AD[18]=1.0e+00;AD[19]=1.0e+00;
   AD[20]=5.0e-01;AD[21]=5.0e-01;AD[22]=5.0e-01;AD[23]=5.0e-01;AD[24]=5.0e-01;
   AD[25]=5.0e-01;AD[26]=5.0e-01;AD[27]=0.0e+00;AD[28]=5.0e-01;AD[29]=5.0e-01;
   AD[30]=5.0e-01;AD[31]=5.0e-01;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=5.0e-01;
   AD[35]=5.0e-01;AD[36]=5.0e-01;AD[37]=5.0e-01;AD[38]=5.0e-01;AD[39]=5.0e-01;
   AD[40]=0.0e+00;AD[41]=5.0e-01;AD[42]=5.0e-01;AD[43]=0.0e+00;AD[44]=5.0e-01;
   AD[45]=5.0e-01;AD[46]=5.0e-01;AD[47]=5.0e-01;AD[48]=0.0e+00;AD[49]=0.0e+00;
   AD[50]=5.0e-01;AD[51]=5.0e-01;AD[52]=5.0e-01;AD[53]=5.0e-01;AD[54]=5.0e-01;
   AD[55]=5.0e-01;AD[56]=5.0e-01;AD[57]=0.0e+00;AD[58]=5.0e-01;AD[59]=0.0e+00;
   AD[60]=5.0e-01;AD[61]=0.0e+00;AD[62]=5.0e-01;AD[63]=5.0e-01;AD[64]=0.0e+00;
   AD[65]=0.0e+00;AD[66]=5.0e-01;AD[67]=5.0e-01;AD[68]=5.0e-01;AD[69]=5.0e-01;
   AD[70]=0.0e+00;AD[71]=0.0e+00;AD[72]=5.0e-01;AD[73]=5.0e-01;AD[74]=5.0e-01;
   AD[75]=0.0e+00;AD[76]=5.0e-01;AD[77]=5.0e-01;AD[78]=5.0e-01;AD[79]=5.0e-01;
   
      Ab = thee->AD[1][1];
   IJA = Vmem_malloc(Ab->vmem, 117, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=3;IJA[4]=4;
   IJA[5]=5;IJA[6]=6;IJA[7]=7;IJA[8]=8;IJA[9]=9;
   IJA[10]=10;IJA[11]=11;IJA[12]=12;IJA[13]=13;IJA[14]=14;
   IJA[15]=15;IJA[16]=16;IJA[17]=17;IJA[18]=18;IJA[19]=19;
   IJA[20]=20;IJA[21]=21;IJA[22]=22;IJA[23]=23;IJA[24]=24;
   IJA[25]=25;IJA[26]=26;IJA[27]=27;IJA[28]=28;IJA[29]=30;
   IJA[30]=32;IJA[31]=34;IJA[32]=36;IJA[33]=38;IJA[34]=40;
   IJA[35]=42;IJA[36]=44;IJA[37]=46;IJA[38]=48;IJA[39]=50;
   IJA[40]=52;IJA[41]=54;IJA[42]=56;IJA[43]=58;IJA[44]=60;
   IJA[45]=62;IJA[46]=64;IJA[47]=66;IJA[48]=68;
   IJA[49]=0;IJA[50]=1;IJA[51]=2;IJA[52]=3;IJA[53]=4;
   IJA[54]=5;IJA[55]=6;IJA[56]=7;IJA[57]=8;IJA[58]=9;
   IJA[59]=10;IJA[60]=11;IJA[61]=12;IJA[62]=13;IJA[63]=14;
   IJA[64]=15;IJA[65]=16;IJA[66]=17;IJA[67]=18;IJA[68]=19;
   IJA[69]=20;IJA[70]=21;IJA[71]=22;IJA[72]=23;IJA[73]=24;
   IJA[74]=25;IJA[75]=26;IJA[76]=27;IJA[77]=2;IJA[78]=27;
   IJA[79]=13;IJA[80]=20;IJA[81]=13;IJA[82]=16;IJA[83]=11;
   IJA[84]=23;IJA[85]=9;IJA[86]=10;IJA[87]=5;IJA[88]=6;
   IJA[89]=5;IJA[90]=19;IJA[91]=13;IJA[92]=25;IJA[93]=6;
   IJA[94]=19;IJA[95]=2;IJA[96]=8;IJA[97]=1;IJA[98]=17;
   IJA[99]=1;IJA[100]=12;IJA[101]=12;IJA[102]=22;IJA[103]=11;
   IJA[104]=17;IJA[105]=4;IJA[106]=11;IJA[107]=17;IJA[108]=27;
   IJA[109]=4;IJA[110]=8;IJA[111]=1;IJA[112]=13;IJA[113]=0;
   IJA[114]=23;IJA[115]=4;IJA[116]=24;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 68, IJA, VNULL);
   Ab->impl = ISNOT_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.0e+00;AD[1]=1.0e+00;AD[2]=1.0e+00;AD[3]=1.0e+00;AD[4]=1.0e+00;
   AD[5]=0.0e+00;AD[6]=1.0e+00;AD[7]=1.0e+00;AD[8]=1.0e+00;AD[9]=1.0e+00;
   AD[10]=1.0e+00;AD[11]=1.0e+00;AD[12]=1.0e+00;AD[13]=1.0e+00;AD[14]=1.0e+00;
   AD[15]=1.0e+00;AD[16]=1.0e+00;AD[17]=1.0e+00;AD[18]=1.0e+00;AD[19]=1.0e+00;
   AD[20]=1.0e+00;AD[21]=1.0e+00;AD[22]=0.0e+00;AD[23]=1.0e+00;AD[24]=1.0e+00;
   AD[25]=1.0e+00;AD[26]=1.0e+00;AD[27]=1.0e+00;AD[28]=5.0e-01;AD[29]=5.0e-01;
   AD[30]=0.0e+00;AD[31]=0.0e+00;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=0.0e+00;
   AD[35]=0.0e+00;AD[36]=5.0e-01;AD[37]=5.0e-01;AD[38]=0.0e+00;AD[39]=5.0e-01;
   AD[40]=0.0e+00;AD[41]=5.0e-01;AD[42]=5.0e-01;AD[43]=5.0e-01;AD[44]=5.0e-01;
   AD[45]=5.0e-01;AD[46]=5.0e-01;AD[47]=5.0e-01;AD[48]=5.0e-01;AD[49]=5.0e-01;
   AD[50]=5.0e-01;AD[51]=5.0e-01;AD[52]=5.0e-01;AD[53]=0.0e+00;AD[54]=5.0e-01;
   AD[55]=5.0e-01;AD[56]=5.0e-01;AD[57]=5.0e-01;AD[58]=5.0e-01;AD[59]=5.0e-01;
   AD[60]=5.0e-01;AD[61]=5.0e-01;AD[62]=5.0e-01;AD[63]=5.0e-01;AD[64]=5.0e-01;
   AD[65]=5.0e-01;AD[66]=5.0e-01;AD[67]=5.0e-01;
      Ab = thee->AD[2][2];
   IJA = Vmem_malloc(Ab->vmem, 132, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=3;IJA[4]=4;
   IJA[5]=5;IJA[6]=6;IJA[7]=7;IJA[8]=8;IJA[9]=9;
   IJA[10]=10;IJA[11]=11;IJA[12]=12;IJA[13]=13;IJA[14]=14;
   IJA[15]=15;IJA[16]=16;IJA[17]=17;IJA[18]=18;IJA[19]=19;
   IJA[20]=20;IJA[21]=21;IJA[22]=22;IJA[23]=23;IJA[24]=24;
   IJA[25]=25;IJA[26]=27;IJA[27]=29;IJA[28]=31;IJA[29]=33;
   IJA[30]=35;IJA[31]=37;IJA[32]=39;IJA[33]=41;IJA[34]=43;
   IJA[35]=45;IJA[36]=47;IJA[37]=49;IJA[38]=51;IJA[39]=53;
   IJA[40]=55;IJA[41]=57;IJA[42]=59;IJA[43]=61;IJA[44]=63;
   IJA[45]=65;IJA[46]=67;IJA[47]=69;IJA[48]=71;IJA[49]=73;
   IJA[50]=75;IJA[51]=77;IJA[52]=79;
   IJA[53]=0;IJA[54]=1;IJA[55]=2;IJA[56]=3;IJA[57]=4;
   IJA[58]=5;IJA[59]=6;IJA[60]=7;IJA[61]=8;IJA[62]=9;
   IJA[63]=10;IJA[64]=11;IJA[65]=12;IJA[66]=13;IJA[67]=14;
   IJA[68]=15;IJA[69]=16;IJA[70]=17;IJA[71]=18;IJA[72]=19;
   IJA[73]=20;IJA[74]=21;IJA[75]=22;IJA[76]=23;IJA[77]=24;
   IJA[78]=11;IJA[79]=12;IJA[80]=1;IJA[81]=16;IJA[82]=10;
   IJA[83]=20;IJA[84]=13;IJA[85]=17;IJA[86]=9;IJA[87]=14;
   IJA[88]=3;IJA[89]=5;IJA[90]=6;IJA[91]=22;IJA[92]=4;
   IJA[93]=17;IJA[94]=4;IJA[95]=15;IJA[96]=9;IJA[97]=19;
   IJA[98]=6;IJA[99]=8;IJA[100]=0;IJA[101]=5;IJA[102]=1;
   IJA[103]=23;IJA[104]=14;IJA[105]=21;IJA[106]=2;IJA[107]=6;
   IJA[108]=9;IJA[109]=15;IJA[110]=16;IJA[111]=19;IJA[112]=16;
   IJA[113]=20;IJA[114]=14;IJA[115]=15;IJA[116]=2;IJA[117]=19;
   IJA[118]=0;IJA[119]=24;IJA[120]=8;IJA[121]=10;IJA[122]=20;
   IJA[123]=24;IJA[124]=2;IJA[125]=7;IJA[126]=20;IJA[127]=22;
   IJA[128]=5;IJA[129]=8;IJA[130]=16;IJA[131]=19;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 79, IJA, VNULL);
   Ab->impl = ISNOT_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.0e+00;AD[1]=1.0e+00;AD[2]=1.0e+00;AD[3]=1.0e+00;AD[4]=1.0e+00;
   AD[5]=0.0e+00;AD[6]=1.0e+00;AD[7]=0.0e+00;AD[8]=1.0e+00;AD[9]=1.0e+00;
   AD[10]=1.0e+00;AD[11]=1.0e+00;AD[12]=1.0e+00;AD[13]=1.0e+00;AD[14]=1.0e+00;
   AD[15]=1.0e+00;AD[16]=1.0e+00;AD[17]=1.0e+00;AD[18]=1.0e+00;AD[19]=1.0e+00;
   AD[20]=1.0e+00;AD[21]=1.0e+00;AD[22]=1.0e+00;AD[23]=1.0e+00;AD[24]=1.0e+00;
   AD[25]=5.0e-01;AD[26]=5.0e-01;AD[27]=5.0e-01;AD[28]=5.0e-01;AD[29]=5.0e-01;
   AD[30]=5.0e-01;AD[31]=5.0e-01;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=5.0e-01;
   AD[35]=5.0e-01;AD[36]=0.0e+00;AD[37]=5.0e-01;AD[38]=5.0e-01;AD[39]=5.0e-01;
   AD[40]=5.0e-01;AD[41]=0.0e+00;AD[42]=0.0e+00;AD[43]=5.0e-01;AD[44]=5.0e-01;
   AD[45]=5.0e-01;AD[46]=5.0e-01;AD[47]=5.0e-01;AD[48]=0.0e+00;AD[49]=5.0e-01;
   AD[50]=5.0e-01;AD[51]=5.0e-01;AD[52]=5.0e-01;AD[53]=5.0e-01;AD[54]=5.0e-01;
   AD[55]=0.0e+00;AD[56]=0.0e+00;AD[57]=5.0e-01;AD[58]=5.0e-01;AD[59]=5.0e-01;
   AD[60]=5.0e-01;AD[61]=5.0e-01;AD[62]=5.0e-01;AD[63]=5.0e-01;AD[64]=5.0e-01;
   AD[65]=5.0e-01;AD[66]=5.0e-01;AD[67]=5.0e-01;AD[68]=5.0e-01;AD[69]=5.0e-01;
   AD[70]=5.0e-01;AD[71]=5.0e-01;AD[72]=0.0e+00;AD[73]=5.0e-01;AD[74]=5.0e-01;
   AD[75]=0.0e+00;AD[76]=5.0e-01;AD[77]=5.0e-01;AD[78]=5.0e-01;
   
   }
   if (1 == key) {
   Ab = thee->AD[0][0];
   IJA = Vmem_malloc(Ab->vmem, 91, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=4;IJA[3]=6;IJA[4]=8;
   IJA[5]=10;IJA[6]=12;IJA[7]=14;IJA[8]=16;IJA[9]=18;
   IJA[10]=20;IJA[11]=22;IJA[12]=24;IJA[13]=26;IJA[14]=28;
   IJA[15]=30;IJA[16]=32;IJA[17]=34;IJA[18]=36;IJA[19]=38;
   IJA[20]=40;IJA[21]=42;IJA[22]=44;IJA[23]=46;IJA[24]=48;
   IJA[25]=50;IJA[26]=52;IJA[27]=54;IJA[28]=56;IJA[29]=58;
   IJA[30]=60;
   IJA[31]=2;IJA[32]=5;IJA[33]=11;IJA[34]=19;IJA[35]=13;
   IJA[36]=14;IJA[37]=7;IJA[38]=8;IJA[39]=11;IJA[40]=18;
   IJA[41]=11;IJA[42]=18;IJA[43]=2;IJA[44]=6;IJA[45]=5;
   IJA[46]=11;IJA[47]=13;IJA[48]=14;IJA[49]=5;IJA[50]=9;
   IJA[51]=15;IJA[52]=17;IJA[53]=7;IJA[54]=15;IJA[55]=0;
   IJA[56]=3;IJA[57]=0;IJA[58]=4;IJA[59]=0;IJA[60]=13;
   IJA[61]=0;IJA[62]=2;IJA[63]=4;IJA[64]=12;IJA[65]=2;
   IJA[66]=17;IJA[67]=0;IJA[68]=15;IJA[69]=9;IJA[70]=15;
   IJA[71]=7;IJA[72]=8;IJA[73]=2;IJA[74]=19;IJA[75]=7;
   IJA[76]=11;IJA[77]=3;IJA[78]=14;IJA[79]=4;IJA[80]=7;
   IJA[81]=17;IJA[82]=19;IJA[83]=9;IJA[84]=11;IJA[85]=4;
   IJA[86]=15;IJA[87]=9;IJA[88]=17;IJA[89]=11;IJA[90]=19;
   
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 60, IJA, VNULL);
   Ab->impl = IS_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=5.0e-01;AD[1]=5.0e-01;AD[2]=5.0e-01;AD[3]=5.0e-01;AD[4]=5.0e-01;
   AD[5]=5.0e-01;AD[6]=5.0e-01;AD[7]=0.0e+00;AD[8]=5.0e-01;AD[9]=5.0e-01;
   AD[10]=5.0e-01;AD[11]=5.0e-01;AD[12]=5.0e-01;AD[13]=5.0e-01;AD[14]=5.0e-01;
   AD[15]=5.0e-01;AD[16]=5.0e-01;AD[17]=5.0e-01;AD[18]=5.0e-01;AD[19]=5.0e-01;
   AD[20]=0.0e+00;AD[21]=5.0e-01;AD[22]=5.0e-01;AD[23]=0.0e+00;AD[24]=5.0e-01;
   AD[25]=5.0e-01;AD[26]=5.0e-01;AD[27]=5.0e-01;AD[28]=0.0e+00;AD[29]=0.0e+00;
   AD[30]=5.0e-01;AD[31]=5.0e-01;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=5.0e-01;
   AD[35]=5.0e-01;AD[36]=5.0e-01;AD[37]=0.0e+00;AD[38]=5.0e-01;AD[39]=0.0e+00;
   AD[40]=5.0e-01;AD[41]=0.0e+00;AD[42]=5.0e-01;AD[43]=5.0e-01;AD[44]=0.0e+00;
   AD[45]=0.0e+00;AD[46]=5.0e-01;AD[47]=5.0e-01;AD[48]=5.0e-01;AD[49]=5.0e-01;
   AD[50]=0.0e+00;AD[51]=0.0e+00;AD[52]=5.0e-01;AD[53]=5.0e-01;AD[54]=5.0e-01;
   AD[55]=0.0e+00;AD[56]=5.0e-01;AD[57]=5.0e-01;AD[58]=5.0e-01;AD[59]=5.0e-01;
   
      Ab = thee->AD[1][1];
   IJA = Vmem_malloc(Ab->vmem, 61, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=4;IJA[3]=6;IJA[4]=8;
   IJA[5]=10;IJA[6]=12;IJA[7]=14;IJA[8]=16;IJA[9]=18;
   IJA[10]=20;IJA[11]=22;IJA[12]=24;IJA[13]=26;IJA[14]=28;
   IJA[15]=30;IJA[16]=32;IJA[17]=34;IJA[18]=36;IJA[19]=38;
   IJA[20]=40;
   IJA[21]=2;IJA[22]=27;IJA[23]=13;IJA[24]=20;IJA[25]=13;
   IJA[26]=16;IJA[27]=11;IJA[28]=23;IJA[29]=9;IJA[30]=10;
   IJA[31]=5;IJA[32]=6;IJA[33]=5;IJA[34]=19;IJA[35]=13;
   IJA[36]=25;IJA[37]=6;IJA[38]=19;IJA[39]=2;IJA[40]=8;
   IJA[41]=1;IJA[42]=17;IJA[43]=1;IJA[44]=12;IJA[45]=12;
   IJA[46]=22;IJA[47]=11;IJA[48]=17;IJA[49]=4;IJA[50]=11;
   IJA[51]=17;IJA[52]=27;IJA[53]=4;IJA[54]=8;IJA[55]=1;
   IJA[56]=13;IJA[57]=0;IJA[58]=23;IJA[59]=4;IJA[60]=24;
   
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 40, IJA, VNULL);
   Ab->impl = IS_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=5.0e-01;AD[1]=5.0e-01;AD[2]=0.0e+00;AD[3]=0.0e+00;AD[4]=5.0e-01;
   AD[5]=5.0e-01;AD[6]=0.0e+00;AD[7]=0.0e+00;AD[8]=5.0e-01;AD[9]=5.0e-01;
   AD[10]=0.0e+00;AD[11]=5.0e-01;AD[12]=0.0e+00;AD[13]=5.0e-01;AD[14]=5.0e-01;
   AD[15]=5.0e-01;AD[16]=5.0e-01;AD[17]=5.0e-01;AD[18]=5.0e-01;AD[19]=5.0e-01;
   AD[20]=5.0e-01;AD[21]=5.0e-01;AD[22]=5.0e-01;AD[23]=5.0e-01;AD[24]=5.0e-01;
   AD[25]=0.0e+00;AD[26]=5.0e-01;AD[27]=5.0e-01;AD[28]=5.0e-01;AD[29]=5.0e-01;
   AD[30]=5.0e-01;AD[31]=5.0e-01;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=5.0e-01;
   AD[35]=5.0e-01;AD[36]=5.0e-01;AD[37]=5.0e-01;AD[38]=5.0e-01;AD[39]=5.0e-01;
   
      Ab = thee->AD[2][2];
   IJA = Vmem_malloc(Ab->vmem, 82, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=4;IJA[3]=6;IJA[4]=8;
   IJA[5]=10;IJA[6]=12;IJA[7]=14;IJA[8]=16;IJA[9]=18;
   IJA[10]=20;IJA[11]=22;IJA[12]=24;IJA[13]=26;IJA[14]=28;
   IJA[15]=30;IJA[16]=32;IJA[17]=34;IJA[18]=36;IJA[19]=38;
   IJA[20]=40;IJA[21]=42;IJA[22]=44;IJA[23]=46;IJA[24]=48;
   IJA[25]=50;IJA[26]=52;IJA[27]=54;
   IJA[28]=11;IJA[29]=12;IJA[30]=1;IJA[31]=16;IJA[32]=10;
   IJA[33]=20;IJA[34]=13;IJA[35]=17;IJA[36]=9;IJA[37]=14;
   IJA[38]=3;IJA[39]=5;IJA[40]=6;IJA[41]=22;IJA[42]=4;
   IJA[43]=17;IJA[44]=4;IJA[45]=15;IJA[46]=9;IJA[47]=19;
   IJA[48]=6;IJA[49]=8;IJA[50]=0;IJA[51]=5;IJA[52]=1;
   IJA[53]=23;IJA[54]=14;IJA[55]=21;IJA[56]=2;IJA[57]=6;
   IJA[58]=9;IJA[59]=15;IJA[60]=16;IJA[61]=19;IJA[62]=16;
   IJA[63]=20;IJA[64]=14;IJA[65]=15;IJA[66]=2;IJA[67]=19;
   IJA[68]=0;IJA[69]=24;IJA[70]=8;IJA[71]=10;IJA[72]=20;
   IJA[73]=24;IJA[74]=2;IJA[75]=7;IJA[76]=20;IJA[77]=22;
   IJA[78]=5;IJA[79]=8;IJA[80]=16;IJA[81]=19;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 54, IJA, VNULL);
   Ab->impl = IS_IMPL;
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=5.0e-01;AD[1]=5.0e-01;AD[2]=5.0e-01;AD[3]=5.0e-01;AD[4]=5.0e-01;
   AD[5]=5.0e-01;AD[6]=5.0e-01;AD[7]=5.0e-01;AD[8]=5.0e-01;AD[9]=5.0e-01;
   AD[10]=5.0e-01;AD[11]=0.0e+00;AD[12]=5.0e-01;AD[13]=5.0e-01;AD[14]=5.0e-01;
   AD[15]=5.0e-01;AD[16]=0.0e+00;AD[17]=0.0e+00;AD[18]=5.0e-01;AD[19]=5.0e-01;
   AD[20]=5.0e-01;AD[21]=5.0e-01;AD[22]=5.0e-01;AD[23]=0.0e+00;AD[24]=5.0e-01;
   AD[25]=5.0e-01;AD[26]=5.0e-01;AD[27]=5.0e-01;AD[28]=5.0e-01;AD[29]=5.0e-01;
   AD[30]=0.0e+00;AD[31]=0.0e+00;AD[32]=5.0e-01;AD[33]=5.0e-01;AD[34]=5.0e-01;
   AD[35]=5.0e-01;AD[36]=5.0e-01;AD[37]=5.0e-01;AD[38]=5.0e-01;AD[39]=5.0e-01;
   AD[40]=5.0e-01;AD[41]=5.0e-01;AD[42]=5.0e-01;AD[43]=5.0e-01;AD[44]=5.0e-01;
   AD[45]=5.0e-01;AD[46]=5.0e-01;AD[47]=0.0e+00;AD[48]=5.0e-01;AD[49]=5.0e-01;
   AD[50]=0.0e+00;AD[51]=5.0e-01;AD[52]=5.0e-01;AD[53]=5.0e-01;
   
   }
   return thee;
}

VPRIVATE void Bchar_example1( Bchar *thee, int key )
{
   char *uu;

   VASSERT((thee->numR)[0] == 50);
   VASSERT((thee->numR)[1] == 48);
   VASSERT((thee->numR)[2] == 52);

   if (0 == key) {
     uu = (thee->u)[0];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

   if (1 == key) {
     uu = (thee->u)[0];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='c';uu[21]='c';uu[22]='c';uu[23]='c';
     uu[24]='c';uu[25]='c';uu[26]='c';uu[27]='c';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='c';uu[21]='c';uu[22]='c';uu[23]='c';
     uu[24]='c';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

   if (2 == key) {
     uu = (thee->u)[0];
     uu[0]='f';uu[1]='c';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='c';uu[9]='f';uu[10]='c';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='c';uu[16]='c';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='c';uu[4]='f';uu[5]='c';
     uu[6]='f';uu[7]='c';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='c';uu[15]='c';uu[16]='f';uu[17]='f';
     uu[18]='c';uu[19]='f';uu[20]='c';uu[21]='c';uu[22]='c';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='c';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='c';
     uu[6]='f';uu[7]='c';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='c';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

}
VPRIVATE Bmat* Bmat_example_A( )
{
   int numB,numR[MAXV];
   Mat *Ab;
   double *AD;
   int p, q, *IJA;
   MATmirror mirror[MAXV][MAXV];
   Bmat *thee = VNULL;

   numB = 3;
   VASSERT( numB <= MAXV );
   numR[0] = 50;
   numR[1] = 48;
   numR[2] = 52;
   for( p=0; p<numB; p++ ) {
      for( q=0; q<numB; q++ ) {
         mirror[p][q] = ISNOT_MIRROR;
      }
   }

   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );

   Ab = thee->AD[0][0];
   IJA = Vmem_malloc(Ab->vmem, 62, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=0;IJA[4]=1;
   IJA[5]=1;IJA[6]=2;IJA[7]=2;IJA[8]=3;IJA[9]=3;
   IJA[10]=3;IJA[11]=4;IJA[12]=4;IJA[13]=4;IJA[14]=5;
   IJA[15]=5;IJA[16]=5;IJA[17]=6;IJA[18]=6;IJA[19]=6;
   IJA[20]=6;IJA[21]=6;IJA[22]=6;IJA[23]=7;IJA[24]=8;
   IJA[25]=8;IJA[26]=9;IJA[27]=9;IJA[28]=9;IJA[29]=9;
   IJA[30]=10;IJA[31]=10;IJA[32]=10;IJA[33]=10;IJA[34]=10;
   IJA[35]=11;IJA[36]=11;IJA[37]=11;IJA[38]=11;IJA[39]=11;
   IJA[40]=11;IJA[41]=11;IJA[42]=11;IJA[43]=11;IJA[44]=11;
   IJA[45]=11;IJA[46]=11;IJA[47]=11;IJA[48]=11;IJA[49]=11;
   IJA[50]=11;
   IJA[51]=17;IJA[52]=46;IJA[53]=32;IJA[54]=30;IJA[55]=22;
   IJA[56]=24;IJA[57]=48;IJA[58]=41;IJA[59]=34;IJA[60]=42;
   IJA[61]=36;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 11, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.7178651239e+00;AD[1]=1.5769790849e+00;AD[2]=1.9742151605e+00;
   AD[3]=2.3350274657e+00;AD[4]=2.1774043961e+00;AD[5]=1.9137699392e+00;
   AD[6]=2.0027462638e+00;AD[7]=1.6254399600e+00;AD[8]=1.6322853254e+00;
   AD[9]=2.3704753651e+00;AD[10]=2.1029501813e+00;AD[11]=1.7653017261e+00;
   AD[12]=2.3648025801e+00;AD[13]=1.5581094582e+00;AD[14]=1.9577538851e+00;
   AD[15]=2.2222096441e+00;AD[16]=1.8389991516e+00;AD[17]=1.9012198569e+00;
   AD[18]=2.0269797522e+00;AD[19]=2.3942357145e+00;AD[20]=2.2783606583e+00;
   AD[21]=1.5693676027e+00;AD[22]=1.7787845286e+00;AD[23]=1.8793698347e+00;
   AD[24]=2.3646725464e+00;AD[25]=1.9199603694e+00;AD[26]=1.7398774735e+00;
   AD[27]=2.0976545164e+00;AD[28]=1.9794044036e+00;AD[29]=2.3985475018e+00;
   AD[30]=2.4347092379e+00;AD[31]=2.3178868338e+00;AD[32]=2.2089089789e+00;
   AD[33]=2.2432205704e+00;AD[34]=2.3997097825e+00;AD[35]=1.5652398048e+00;
   AD[36]=1.8359111713e+00;AD[37]=1.5043350726e+00;AD[38]=2.3280956031e+00;
   AD[39]=2.0074353773e+00;AD[40]=1.8661624361e+00;AD[41]=1.7266397176e+00;
   AD[42]=2.0348317096e+00;AD[43]=1.7894848664e+00;AD[44]=1.5683708974e+00;
   AD[45]=1.5849707456e+00;AD[46]=1.5683394681e+00;AD[47]=1.9098164992e+00;
   AD[48]=1.6233813823e+00;AD[49]=1.9430165927e+00;
   AD[50]=-3.1815992133e-01;AD[51]=4.3900309145e-01;AD[52]=8.5746995234e-02;
   AD[53]=2.6478755626e-01;AD[54]=-4.2955036767e-01;AD[55]=-3.6334847810e-01;
   AD[56]=-4.9690930244e-01;AD[57]=1.1123713077e-01;AD[58]=-2.4693571225e-01;
   AD[59]=2.3592044711e-02;AD[60]=-3.1647180447e-01;
   AD[61]=-9.1131091958e-02;AD[62]=3.7132206657e-01;AD[63]=-4.6961097634e-01;
   AD[64]=-8.0482295987e-02;AD[65]=-3.3243185790e-02;AD[66]=2.0253001125e-01;
   AD[67]=3.4733343640e-01;AD[68]=1.7988023456e-01;AD[69]=3.5840218858e-01;
   AD[70]=-3.3767530797e-01;AD[71]=4.1705674829e-01;
   Ab = thee->AD[0][1];
   IJA = Vmem_malloc(Ab->vmem, 84, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=1;IJA[3]=3;IJA[4]=3;
   IJA[5]=4;IJA[6]=4;IJA[7]=4;IJA[8]=5;IJA[9]=7;
   IJA[10]=8;IJA[11]=8;IJA[12]=9;IJA[13]=9;IJA[14]=9;
   IJA[15]=9;IJA[16]=9;IJA[17]=10;IJA[18]=11;IJA[19]=14;
   IJA[20]=15;IJA[21]=15;IJA[22]=15;IJA[23]=15;IJA[24]=15;
   IJA[25]=15;IJA[26]=16;IJA[27]=17;IJA[28]=17;IJA[29]=18;
   IJA[30]=19;IJA[31]=19;IJA[32]=20;IJA[33]=21;IJA[34]=23;
   IJA[35]=23;IJA[36]=23;IJA[37]=23;IJA[38]=24;IJA[39]=25;
   IJA[40]=25;IJA[41]=26;IJA[42]=27;IJA[43]=29;IJA[44]=30;
   IJA[45]=31;IJA[46]=31;IJA[47]=32;IJA[48]=32;IJA[49]=32;
   IJA[50]=33;
   IJA[51]=26;IJA[52]=10;IJA[53]=36;IJA[54]=27;IJA[55]=27;
   IJA[56]=9;IJA[57]=15;IJA[58]=3;IJA[59]=43;IJA[60]=4;
   IJA[61]=37;IJA[62]=10;IJA[63]=40;IJA[64]=42;IJA[65]=36;
   IJA[66]=17;IJA[67]=42;IJA[68]=44;IJA[69]=41;IJA[70]=38;
   IJA[71]=9;IJA[72]=30;IJA[73]=40;IJA[74]=47;IJA[75]=42;
   IJA[76]=15;IJA[77]=31;IJA[78]=2;IJA[79]=10;IJA[80]=17;
   IJA[81]=28;IJA[82]=47;IJA[83]=43;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 33, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.2288034443e-01;AD[1]=-5.2992690665e-02;AD[2]=3.7986644028e-01;
   AD[3]=-2.6890463689e-01;AD[4]=2.7433962777e-02;AD[5]=4.4970635350e-01;
   AD[6]=-3.3487987619e-02;AD[7]=7.7989553526e-03;AD[8]=-4.5014249865e-01;
   AD[9]=-1.1568638212e-01;AD[10]=-1.4743989875e-01;AD[11]=8.7571263995e-02;
   AD[12]=1.5045932248e-01;AD[13]=4.7208916171e-01;AD[14]=-4.0462321391e-01;
   AD[15]=-4.3261668639e-01;AD[16]=-4.6854006444e-01;AD[17]=-1.7852693013e-01;
   AD[18]=-4.1562952895e-01;AD[19]=-6.6630932661e-02;AD[20]=-4.1650243821e-01;
   AD[21]=-7.1039646222e-02;AD[22]=3.5737406083e-01;AD[23]=-2.1680136616e-01;
   AD[24]=3.3540455044e-01;AD[25]=-1.8955128773e-03;AD[26]=1.0882144904e-01;
   AD[27]=-1.5952168923e-01;AD[28]=3.7763413841e-01;AD[29]=3.8839093480e-01;
   AD[30]=2.2499196136e-01;AD[31]=1.5345682398e-01;AD[32]=4.5886208891e-02;
   
   Ab = thee->AD[0][2];
   IJA = Vmem_malloc(Ab->vmem, 81, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=0;IJA[4]=0;
   IJA[5]=0;IJA[6]=2;IJA[7]=2;IJA[8]=4;IJA[9]=6;
   IJA[10]=6;IJA[11]=6;IJA[12]=7;IJA[13]=9;IJA[14]=9;
   IJA[15]=10;IJA[16]=11;IJA[17]=11;IJA[18]=11;IJA[19]=11;
   IJA[20]=12;IJA[21]=13;IJA[22]=14;IJA[23]=14;IJA[24]=14;
   IJA[25]=14;IJA[26]=14;IJA[27]=14;IJA[28]=14;IJA[29]=14;
   IJA[30]=15;IJA[31]=15;IJA[32]=16;IJA[33]=16;IJA[34]=16;
   IJA[35]=18;IJA[36]=19;IJA[37]=19;IJA[38]=19;IJA[39]=19;
   IJA[40]=21;IJA[41]=21;IJA[42]=22;IJA[43]=22;IJA[44]=23;
   IJA[45]=24;IJA[46]=25;IJA[47]=26;IJA[48]=26;IJA[49]=28;
   IJA[50]=30;
   IJA[51]=37;IJA[52]=41;IJA[53]=19;IJA[54]=32;IJA[55]=13;
   IJA[56]=26;IJA[57]=42;IJA[58]=7;IJA[59]=39;IJA[60]=26;
   IJA[61]=6;IJA[62]=31;IJA[63]=46;IJA[64]=49;IJA[65]=0;
   IJA[66]=25;IJA[67]=19;IJA[68]=45;IJA[69]=3;IJA[70]=25;
   IJA[71]=47;IJA[72]=45;IJA[73]=33;IJA[74]=31;IJA[75]=6;
   IJA[76]=42;IJA[77]=13;IJA[78]=51;IJA[79]=13;IJA[80]=29;
   
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 30, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=2.3947649264e-02;AD[1]=-1.2042651456e-01;AD[2]=-4.7597267499e-01;
   AD[3]=-4.7033224849e-01;AD[4]=4.5711217800e-01;AD[5]=1.7921965539e-01;
   AD[6]=4.1188981250e-01;AD[7]=2.4106009617e-02;AD[8]=4.6877766294e-01;
   AD[9]=4.5938058131e-01;AD[10]=3.5959345348e-01;AD[11]=-1.1985079711e-01;
   AD[12]=-2.1976991039e-01;AD[13]=-2.9628456571e-01;AD[14]=2.4848990998e-01;
   AD[15]=1.1642133165e-01;AD[16]=-8.8541959886e-03;AD[17]=1.5803030563e-01;
   AD[18]=-2.4389021894e-01;AD[19]=-2.3098939213e-01;AD[20]=-3.6738527315e-01;
   AD[21]=3.8963530338e-01;AD[22]=-2.7678934916e-02;AD[23]=-2.8672961092e-01;
   AD[24]=-4.7237099184e-01;AD[25]=-4.8514614423e-01;AD[26]=-1.5712948500e-01;
   AD[27]=3.5635076854e-01;AD[28]=1.3824370942e-01;AD[29]=2.7220673209e-01;
   
   Ab = thee->AD[1][1];
   IJA = Vmem_malloc(Ab->vmem, 58, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=2;IJA[3]=3;IJA[4]=3;
   IJA[5]=3;IJA[6]=4;IJA[7]=4;IJA[8]=4;IJA[9]=4;
   IJA[10]=4;IJA[11]=4;IJA[12]=5;IJA[13]=5;IJA[14]=5;
   IJA[15]=5;IJA[16]=5;IJA[17]=6;IJA[18]=6;IJA[19]=6;
   IJA[20]=6;IJA[21]=6;IJA[22]=6;IJA[23]=6;IJA[24]=6;
   IJA[25]=7;IJA[26]=8;IJA[27]=8;IJA[28]=8;IJA[29]=8;
   IJA[30]=8;IJA[31]=8;IJA[32]=8;IJA[33]=8;IJA[34]=9;
   IJA[35]=9;IJA[36]=9;IJA[37]=9;IJA[38]=9;IJA[39]=9;
   IJA[40]=9;IJA[41]=9;IJA[42]=9;IJA[43]=9;IJA[44]=9;
   IJA[45]=9;IJA[46]=9;IJA[47]=9;IJA[48]=9;
   IJA[49]=16;IJA[50]=18;IJA[51]=39;IJA[52]=19;IJA[53]=38;
   IJA[54]=35;IJA[55]=28;IJA[56]=32;IJA[57]=37;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 9, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=2.3989397370e+00;AD[1]=1.8536390018e+00;AD[2]=1.6201781196e+00;
   AD[3]=2.0691110254e+00;AD[4]=2.3750327264e+00;AD[5]=1.8485749771e+00;
   AD[6]=1.5419210049e+00;AD[7]=1.6423397194e+00;AD[8]=1.5765928349e+00;
   AD[9]=2.2405265893e+00;AD[10]=1.9565251273e+00;AD[11]=2.1682493153e+00;
   AD[12]=2.1992460756e+00;AD[13]=2.0713572124e+00;AD[14]=2.1286933420e+00;
   AD[15]=2.3777639251e+00;AD[16]=2.1623517396e+00;AD[17]=2.3754136119e+00;
   AD[18]=1.9675170188e+00;AD[19]=1.6413360283e+00;AD[20]=1.5681344572e+00;
   AD[21]=2.2142424069e+00;AD[22]=1.8079860282e+00;AD[23]=2.1711639717e+00;
   AD[24]=2.1524208354e+00;AD[25]=2.0310488383e+00;AD[26]=2.2151070318e+00;
   AD[27]=2.0048106230e+00;AD[28]=1.9879993585e+00;AD[29]=1.9978383090e+00;
   AD[30]=2.4359755533e+00;AD[31]=1.8892816828e+00;AD[32]=1.6171451657e+00;
   AD[33]=1.7404235540e+00;AD[34]=2.1849084946e+00;AD[35]=2.3392536151e+00;
   AD[36]=2.4701446329e+00;AD[37]=1.7151696128e+00;AD[38]=2.2603433464e+00;
   AD[39]=2.0841028499e+00;AD[40]=1.9029515776e+00;AD[41]=2.0100403378e+00;
   AD[42]=1.9956442191e+00;AD[43]=2.1513683425e+00;AD[44]=2.2437061446e+00;
   AD[45]=1.8019534691e+00;AD[46]=1.5896119352e+00;AD[47]=2.3259654825e+00;
   
   AD[48]=-1.2569345585e-02;AD[49]=3.6159575998e-01;AD[50]=2.5192950798e-01;
   AD[51]=3.7281299304e-01;AD[52]=-3.6024124090e-01;AD[53]=-2.5305863494e-01;
   AD[54]=1.0741579114e-01;AD[55]=-4.6440943662e-01;AD[56]=9.3420567787e-02;
   
   AD[57]=4.1353933308e-02;AD[58]=4.2616908258e-01;AD[59]=-3.6187959695e-01;
   AD[60]=1.9569092683e-01;AD[61]=-3.0899479771e-02;AD[62]=-2.7053122525e-01;
   AD[63]=3.9640977945e-01;AD[64]=-1.7769594563e-02;AD[65]=3.8623511133e-01;
   
   Ab = thee->AD[1][0];
   IJA = Vmem_malloc(Ab->vmem, 84, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=1;IJA[3]=3;IJA[4]=3;
   IJA[5]=4;IJA[6]=4;IJA[7]=4;IJA[8]=5;IJA[9]=7;
   IJA[10]=8;IJA[11]=8;IJA[12]=9;IJA[13]=9;IJA[14]=9;
   IJA[15]=9;IJA[16]=9;IJA[17]=10;IJA[18]=11;IJA[19]=14;
   IJA[20]=15;IJA[21]=15;IJA[22]=15;IJA[23]=15;IJA[24]=15;
   IJA[25]=15;IJA[26]=16;IJA[27]=17;IJA[28]=17;IJA[29]=18;
   IJA[30]=19;IJA[31]=19;IJA[32]=20;IJA[33]=21;IJA[34]=23;
   IJA[35]=23;IJA[36]=23;IJA[37]=23;IJA[38]=24;IJA[39]=25;
   IJA[40]=25;IJA[41]=26;IJA[42]=27;IJA[43]=29;IJA[44]=30;
   IJA[45]=31;IJA[46]=31;IJA[47]=32;IJA[48]=32;IJA[49]=32;
   IJA[50]=33;
   IJA[51]=26;IJA[52]=10;IJA[53]=36;IJA[54]=27;IJA[55]=27;
   IJA[56]=9;IJA[57]=15;IJA[58]=3;IJA[59]=43;IJA[60]=4;
   IJA[61]=37;IJA[62]=10;IJA[63]=40;IJA[64]=42;IJA[65]=36;
   IJA[66]=17;IJA[67]=42;IJA[68]=44;IJA[69]=41;IJA[70]=38;
   IJA[71]=9;IJA[72]=30;IJA[73]=40;IJA[74]=47;IJA[75]=42;
   IJA[76]=15;IJA[77]=31;IJA[78]=2;IJA[79]=10;IJA[80]=17;
   IJA[81]=28;IJA[82]=47;IJA[83]=43;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 33, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=3.9450066390e-01;AD[1]=-2.5297582074e-01;AD[2]=-1.8932098409e-01;
   AD[3]=-3.5636240494e-01;AD[4]=2.5320053271e-01;AD[5]=1.7990468552e-01;
   AD[6]=5.7292680690e-02;AD[7]=4.0177366405e-01;AD[8]=-1.4187164721e-01;
   AD[9]=-9.7670132013e-02;AD[10]=3.5625111615e-01;AD[11]=8.4201224537e-02;
   AD[12]=-1.2642121732e-01;AD[13]=-2.7830545323e-01;AD[14]=-2.8100588229e-01;
   AD[15]=-3.0016587533e-01;AD[16]=1.0733992176e-01;AD[17]=4.3044983654e-02;
   AD[18]=-4.9434693187e-01;AD[19]=-7.8930647638e-02;AD[20]=-3.2584475557e-01;
   AD[21]=2.2861066057e-01;AD[22]=3.4291049941e-02;AD[23]=2.3707265459e-01;
   AD[24]=1.9671485265e-01;AD[25]=-7.4503171997e-02;AD[26]=3.5577189136e-01;
   AD[27]=-2.0118458989e-01;AD[28]=2.0396907865e-01;AD[29]=-1.1838912401e-01;
   AD[30]=3.8786095531e-01;AD[31]=3.1543515594e-01;AD[32]=-4.7720132936e-01;
   
   Ab = thee->AD[1][2];
   IJA = Vmem_malloc(Ab->vmem, 92, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=3;IJA[3]=3;IJA[4]=4;
   IJA[5]=4;IJA[6]=5;IJA[7]=6;IJA[8]=6;IJA[9]=7;
   IJA[10]=8;IJA[11]=8;IJA[12]=8;IJA[13]=9;IJA[14]=9;
   IJA[15]=12;IJA[16]=12;IJA[17]=13;IJA[18]=14;IJA[19]=15;
   IJA[20]=16;IJA[21]=16;IJA[22]=17;IJA[23]=19;IJA[24]=20;
   IJA[25]=20;IJA[26]=21;IJA[27]=21;IJA[28]=21;IJA[29]=22;
   IJA[30]=24;IJA[31]=25;IJA[32]=27;IJA[33]=27;IJA[34]=27;
   IJA[35]=27;IJA[36]=30;IJA[37]=30;IJA[38]=33;IJA[39]=33;
   IJA[40]=34;IJA[41]=34;IJA[42]=34;IJA[43]=35;IJA[44]=36;
   IJA[45]=38;IJA[46]=40;IJA[47]=41;IJA[48]=43;
   IJA[49]=35;IJA[50]=46;IJA[51]=45;IJA[52]=7;IJA[53]=16;
   IJA[54]=38;IJA[55]=21;IJA[56]=35;IJA[57]=48;IJA[58]=5;
   IJA[59]=22;IJA[60]=45;IJA[61]=21;IJA[62]=4;IJA[63]=27;
   IJA[64]=50;IJA[65]=31;IJA[66]=10;IJA[67]=21;IJA[68]=35;
   IJA[69]=19;IJA[70]=29;IJA[71]=6;IJA[72]=22;IJA[73]=50;
   IJA[74]=6;IJA[75]=28;IJA[76]=28;IJA[77]=39;IJA[78]=44;
   IJA[79]=10;IJA[80]=26;IJA[81]=46;IJA[82]=24;IJA[83]=26;
   IJA[84]=34;IJA[85]=15;IJA[86]=35;IJA[87]=3;IJA[88]=40;
   IJA[89]=5;IJA[90]=35;IJA[91]=47;
   Mat_initStructure(Ab, ROW_FORMAT, ISNOT_SYM, 43, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=5.5443538620e-02;AD[1]=4.8524631245e-01;AD[2]=-3.9036739388e-01;
   AD[3]=-3.7980048735e-01;AD[4]=-7.8994218632e-02;AD[5]=6.7430056172e-02;
   AD[6]=1.9764956846e-01;AD[7]=3.4630363778e-01;AD[8]=3.2780393147e-01;
   AD[9]=3.1598725330e-01;AD[10]=-5.6933910592e-02;AD[11]=-6.2226885782e-02;
   AD[12]=-2.9632356287e-01;AD[13]=-5.3199137217e-02;AD[14]=-4.4035837641e-01;
   AD[15]=4.4417699249e-02;AD[16]=-1.1706201087e-01;AD[17]=2.0610759451e-01;
   AD[18]=1.6632648849e-01;AD[19]=-9.1936505598e-02;AD[20]=-2.2173297985e-01;
   AD[21]=-2.4645700042e-02;AD[22]=3.9915643426e-01;AD[23]=-6.6704734424e-02;
   AD[24]=3.7494272154e-01;AD[25]=3.9993550053e-01;AD[26]=-2.3128765476e-01;
   AD[27]=4.8668004398e-01;AD[28]=3.2449941982e-01;AD[29]=-4.4030896761e-01;
   AD[30]=3.3135975639e-01;AD[31]=2.7533431196e-01;AD[32]=1.0875870733e-01;
   AD[33]=-3.0679768824e-01;AD[34]=1.0772696632e-01;AD[35]=-1.6662731316e-01;
   AD[36]=-2.2116109521e-01;AD[37]=-3.7981836226e-02;AD[38]=3.8656379441e-01;
   AD[39]=4.5960927900e-01;AD[40]=-4.0166269826e-01;AD[41]=3.2630672085e-01;
   AD[42]=4.5004891218e-02;
   Ab = thee->AD[2][2];
   IJA = Vmem_malloc(Ab->vmem, 71, sizeof(int));

   IJA[0]=0;IJA[1]=1;IJA[2]=2;IJA[3]=2;IJA[4]=2;
   IJA[5]=2;IJA[6]=2;IJA[7]=2;IJA[8]=3;IJA[9]=3;
   IJA[10]=3;IJA[11]=4;IJA[12]=5;IJA[13]=5;IJA[14]=7;
   IJA[15]=9;IJA[16]=9;IJA[17]=9;IJA[18]=9;IJA[19]=10;
   IJA[20]=12;IJA[21]=14;IJA[22]=14;IJA[23]=15;IJA[24]=15;
   IJA[25]=15;IJA[26]=16;IJA[27]=16;IJA[28]=16;IJA[29]=16;
   IJA[30]=17;IJA[31]=17;IJA[32]=17;IJA[33]=17;IJA[34]=17;
   IJA[35]=17;IJA[36]=17;IJA[37]=17;IJA[38]=17;IJA[39]=17;
   IJA[40]=17;IJA[41]=18;IJA[42]=18;IJA[43]=18;IJA[44]=18;
   IJA[45]=18;IJA[46]=18;IJA[47]=18;IJA[48]=18;IJA[49]=18;
   IJA[50]=18;IJA[51]=18;IJA[52]=18;
   IJA[53]=48;IJA[54]=36;IJA[55]=37;IJA[56]=25;IJA[57]=29;
   IJA[58]=15;IJA[59]=43;IJA[60]=41;IJA[61]=48;IJA[62]=46;
   IJA[63]=25;IJA[64]=34;IJA[65]=26;IJA[66]=42;IJA[67]=51;
   IJA[68]=43;IJA[69]=37;IJA[70]=50;
   Mat_initStructure(Ab, DRC_FORMAT, ISNOT_SYM, 18, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=1.8895870089e+00;AD[1]=2.2753048533e+00;AD[2]=1.6793690953e+00;
   AD[3]=1.6093612097e+00;AD[4]=2.4051583381e+00;AD[5]=2.3763510039e+00;
   AD[6]=2.4997925644e+00;AD[7]=2.3642546861e+00;AD[8]=1.5368775223e+00;
   AD[9]=2.0446824420e+00;AD[10]=2.4976161822e+00;AD[11]=2.0110081542e+00;
   AD[12]=2.3735121759e+00;AD[13]=1.5702214723e+00;AD[14]=2.4875387368e+00;
   AD[15]=2.4227134295e+00;AD[16]=2.0642609196e+00;AD[17]=1.9314620537e+00;
   AD[18]=1.8378445653e+00;AD[19]=2.2207234278e+00;AD[20]=1.5136555667e+00;
   AD[21]=1.8740601928e+00;AD[22]=2.4226852204e+00;AD[23]=2.0464796480e+00;
   AD[24]=1.9738868698e+00;AD[25]=1.9965373184e+00;AD[26]=1.8089710812e+00;
   AD[27]=2.4508375588e+00;AD[28]=2.4819932809e+00;AD[29]=2.0135631035e+00;
   AD[30]=2.4925898185e+00;AD[31]=1.9558437021e+00;AD[32]=1.9260408809e+00;
   AD[33]=1.7132147788e+00;AD[34]=1.6932494804e+00;AD[35]=2.3327542460e+00;
   AD[36]=2.2266370996e+00;AD[37]=2.0297456939e+00;AD[38]=2.3290807375e+00;
   AD[39]=2.0118744313e+00;AD[40]=2.0519618463e+00;AD[41]=1.7132848940e+00;
   AD[42]=2.0878206263e+00;AD[43]=1.6427632253e+00;AD[44]=1.5522235278e+00;
   AD[45]=2.1833079153e+00;AD[46]=2.1085594784e+00;AD[47]=1.7196559348e+00;
   AD[48]=1.9062799423e+00;AD[49]=2.1299079448e+00;AD[50]=2.0553076247e+00;
   AD[51]=1.6275790620e+00;
   AD[52]=3.3700627102e-01;AD[53]=4.9120319987e-01;AD[54]=4.2543688963e-01;
   AD[55]=5.9677931616e-02;AD[56]=1.8089955555e-01;AD[57]=8.2431428704e-02;
   AD[58]=-2.8432123470e-02;AD[59]=-2.3425319120e-02;AD[60]=3.3334864703e-01;
   AD[61]=-2.4625079308e-01;AD[62]=4.4478399175e-01;AD[63]=4.7584480411e-01;
   AD[64]=4.4800235933e-01;AD[65]=-3.4330615277e-01;AD[66]=3.9977601896e-01;
   AD[67]=4.2991694845e-02;AD[68]=2.3902186152e-01;AD[69]=-3.7899991383e-01;
   
   AD[70]=6.7841149739e-02;AD[71]=-2.0103583654e-01;AD[72]=-3.2220590818e-01;
   AD[73]=-4.6516617943e-01;AD[74]=2.5783871039e-01;AD[75]=-1.5699418803e-01;
   AD[76]=-2.8352860382e-01;AD[77]=2.8620062703e-01;AD[78]=2.2308995955e-01;
   AD[79]=-4.0793129325e-01;AD[80]=-1.6024283585e-01;AD[81]=-2.1265039048e-01;
   AD[82]=-3.2909676475e-01;AD[83]=-1.0073668572e-01;AD[84]=-3.2476055761e-01;
   AD[85]=2.1447163575e-01;AD[86]=-8.3065245069e-02;AD[87]=1.4634606544e-01;
   
   Ab = thee->AD[2][0];
   IJA = Vmem_malloc(Ab->vmem, 81, sizeof(int));

   IJA[0]=0;IJA[1]=0;IJA[2]=0;IJA[3]=0;IJA[4]=0;
   IJA[5]=0;IJA[6]=2;IJA[7]=2;IJA[8]=4;IJA[9]=6;
   IJA[10]=6;IJA[11]=6;IJA[12]=7;IJA[13]=9;IJA[14]=9;
   IJA[15]=10;IJA[16]=11;IJA[17]=11;IJA[18]=11;IJA[19]=11;
   IJA[20]=12;IJA[21]=13;IJA[22]=14;IJA[23]=14;IJA[24]=14;
   IJA[25]=14;IJA[26]=14;IJA[27]=14;IJA[28]=14;IJA[29]=14;
   IJA[30]=15;IJA[31]=15;IJA[32]=16;IJA[33]=16;IJA[34]=16;
   IJA[35]=18;IJA[36]=19;IJA[37]=19;IJA[38]=19;IJA[39]=19;
   IJA[40]=21;IJA[41]=21;IJA[42]=22;IJA[43]=22;IJA[44]=23;
   IJA[45]=24;IJA[46]=25;IJA[47]=26;IJA[48]=26;IJA[49]=28;
   IJA[50]=30;
   IJA[51]=37;IJA[52]=41;IJA[53]=19;IJA[54]=32;IJA[55]=13;
   IJA[56]=26;IJA[57]=42;IJA[58]=7;IJA[59]=39;IJA[60]=26;
   IJA[61]=6;IJA[62]=31;IJA[63]=46;IJA[64]=49;IJA[65]=0;
   IJA[66]=25;IJA[67]=19;IJA[68]=45;IJA[69]=3;IJA[70]=25;
   IJA[71]=47;IJA[72]=45;IJA[73]=33;IJA[74]=31;IJA[75]=6;
   IJA[76]=42;IJA[77]=13;IJA[78]=51;IJA[79]=13;IJA[80]=29;
   
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 30, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=-4.1684410325e-01;AD[1]=-3.8262161632e-02;AD[2]=2.0004266953e-01;
   AD[3]=-2.8548775384e-01;AD[4]=3.5067890259e-01;AD[5]=5.8565491803e-02;
   AD[6]=-1.1012482621e-02;AD[7]=-2.4403785900e-01;AD[8]=4.2916926899e-01;
   AD[9]=-2.4599214944e-01;AD[10]=-6.8781552722e-02;AD[11]=2.2232443025e-02;
   AD[12]=-6.6577286512e-02;AD[13]=2.4130398830e-01;AD[14]=2.7148514717e-01;
   AD[15]=-4.4318681903e-01;AD[16]=2.5819452972e-01;AD[17]=3.8703073223e-01;
   AD[18]=-4.3120182890e-01;AD[19]=2.7699290571e-01;AD[20]=1.9034191537e-03;
   AD[21]=1.7079710898e-01;AD[22]=6.7684997801e-02;AD[23]=3.4294928900e-01;
   AD[24]=3.9879855583e-01;AD[25]=-4.9864217121e-01;AD[26]=-4.1253118368e-01;
   AD[27]=-2.3927264880e-01;AD[28]=-7.5915181194e-02;AD[29]=-1.5893503109e-01;
   
   Ab = thee->AD[2][1];
   IJA = Vmem_malloc(Ab->vmem, 92, sizeof(int));

   IJA[0]=0;IJA[1]=2;IJA[2]=3;IJA[3]=3;IJA[4]=4;
   IJA[5]=4;IJA[6]=5;IJA[7]=6;IJA[8]=6;IJA[9]=7;
   IJA[10]=8;IJA[11]=8;IJA[12]=8;IJA[13]=9;IJA[14]=9;
   IJA[15]=12;IJA[16]=12;IJA[17]=13;IJA[18]=14;IJA[19]=15;
   IJA[20]=16;IJA[21]=16;IJA[22]=17;IJA[23]=19;IJA[24]=20;
   IJA[25]=20;IJA[26]=21;IJA[27]=21;IJA[28]=21;IJA[29]=22;
   IJA[30]=24;IJA[31]=25;IJA[32]=27;IJA[33]=27;IJA[34]=27;
   IJA[35]=27;IJA[36]=30;IJA[37]=30;IJA[38]=33;IJA[39]=33;
   IJA[40]=34;IJA[41]=34;IJA[42]=34;IJA[43]=35;IJA[44]=36;
   IJA[45]=38;IJA[46]=40;IJA[47]=41;IJA[48]=43;
   IJA[49]=35;IJA[50]=46;IJA[51]=45;IJA[52]=7;IJA[53]=16;
   IJA[54]=38;IJA[55]=21;IJA[56]=35;IJA[57]=48;IJA[58]=5;
   IJA[59]=22;IJA[60]=45;IJA[61]=21;IJA[62]=4;IJA[63]=27;
   IJA[64]=50;IJA[65]=31;IJA[66]=10;IJA[67]=21;IJA[68]=35;
   IJA[69]=19;IJA[70]=29;IJA[71]=6;IJA[72]=22;IJA[73]=50;
   IJA[74]=6;IJA[75]=28;IJA[76]=28;IJA[77]=39;IJA[78]=44;
   IJA[79]=10;IJA[80]=26;IJA[81]=46;IJA[82]=24;IJA[83]=26;
   IJA[84]=34;IJA[85]=15;IJA[86]=35;IJA[87]=3;IJA[88]=40;
   IJA[89]=5;IJA[90]=35;IJA[91]=47;
   Mat_initStructure(Ab, COL_FORMAT, ISNOT_SYM, 43, IJA, VNULL);
   Ab->state = ASSEMBLED_STATE;
   AD = Ab->A;

   AD[0]=-2.0150055294e-01;AD[1]=-1.6191520615e-01;AD[2]=3.5948010721e-01;
   AD[3]=3.5665647689e-01;AD[4]=1.2790417779e-01;AD[5]=-4.9611845648e-02;
   AD[6]=-2.6382057901e-02;AD[7]=-2.2017108000e-01;AD[8]=-6.2581524298e-02;
   AD[9]=2.4618493997e-01;AD[10]=-3.2089534192e-02;AD[11]=3.6082735106e-01;
   AD[12]=-4.1444776759e-01;AD[13]=-2.6683231433e-01;AD[14]=2.1173509301e-01;
   AD[15]=4.3800200692e-01;AD[16]=-3.6031072145e-01;AD[17]=-1.0609985515e-01;
   AD[18]=4.8056282972e-01;AD[19]=1.4479402599e-01;AD[20]=-4.8590692481e-01;
   AD[21]=8.8366445795e-02;AD[22]=-6.6565159967e-02;AD[23]=-2.5582710649e-01;
   AD[24]=-4.8982254448e-01;AD[25]=4.5797518820e-01;AD[26]=-4.0455347645e-01;
   AD[27]=-4.9108494375e-01;AD[28]=3.1492027145e-01;AD[29]=-3.5950056345e-01;
   AD[30]=8.5181638479e-02;AD[31]=1.6768176418e-01;AD[32]=1.4802711506e-01;
   AD[33]=-2.5821320641e-01;AD[34]=3.3571334817e-01;AD[35]=4.4316983966e-01;
   AD[36]=3.0646680379e-01;AD[37]=1.0139875525e-01;AD[38]=2.8962046512e-01;
   AD[39]=2.9918503504e-01;AD[40]=-4.5043523442e-01;AD[41]=-1.0344654672e-02;
   AD[42]=4.7285223701e-01;
   return thee;
}

VPRIVATE void Bchar_example2( Bchar *thee, int key )
{
   char *uu;

   VASSERT((thee->numR)[0] == 50);
   VASSERT((thee->numR)[1] == 48);
   VASSERT((thee->numR)[2] == 52);

   if (0 == key) {
     uu = (thee->u)[0];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='f';uu[4]='f';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='f';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

   if (1 == key) {
     uu = (thee->u)[0];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='c';uu[21]='c';uu[22]='c';uu[23]='c';
     uu[24]='c';uu[25]='c';uu[26]='c';uu[27]='c';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='c';uu[1]='c';uu[2]='c';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='c';uu[7]='c';uu[8]='c';uu[9]='c';uu[10]='c';uu[11]='c';
     uu[12]='c';uu[13]='c';uu[14]='c';uu[15]='c';uu[16]='c';uu[17]='c';
     uu[18]='c';uu[19]='c';uu[20]='c';uu[21]='c';uu[22]='c';uu[23]='c';
     uu[24]='c';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

   if (2 == key) {
     uu = (thee->u)[0];
     uu[0]='c';uu[1]='c';uu[2]='f';uu[3]='c';uu[4]='c';uu[5]='f';
     uu[6]='c';uu[7]='f';uu[8]='f';uu[9]='c';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='f';uu[14]='f';uu[15]='c';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='f';uu[22]='f';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';
     uu = (thee->u)[1];
     uu[0]='f';uu[1]='f';uu[2]='f';uu[3]='c';uu[4]='c';uu[5]='c';
     uu[6]='f';uu[7]='c';uu[8]='c';uu[9]='f';uu[10]='f';uu[11]='f';
     uu[12]='f';uu[13]='c';uu[14]='f';uu[15]='f';uu[16]='f';uu[17]='f';
     uu[18]='f';uu[19]='f';uu[20]='c';uu[21]='f';uu[22]='c';uu[23]='f';
     uu[24]='f';uu[25]='f';uu[26]='c';uu[27]='c';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     
     uu = (thee->u)[2];
     uu[0]='f';uu[1]='f';uu[2]='c';uu[3]='f';uu[4]='c';uu[5]='f';
     uu[6]='f';uu[7]='f';uu[8]='c';uu[9]='c';uu[10]='f';uu[11]='f';
     uu[12]='c';uu[13]='f';uu[14]='f';uu[15]='f';uu[16]='c';uu[17]='c';
     uu[18]='f';uu[19]='f';uu[20]='f';uu[21]='c';uu[22]='f';uu[23]='c';
     uu[24]='f';uu[25]='f';uu[26]='f';uu[27]='f';uu[28]='f';uu[29]='f';
     uu[30]='f';uu[31]='f';uu[32]='f';uu[33]='f';uu[34]='f';uu[35]='f';
     uu[36]='f';uu[37]='f';uu[38]='f';uu[39]='f';uu[40]='f';uu[41]='f';
     uu[42]='f';uu[43]='f';uu[44]='f';uu[45]='f';uu[46]='f';uu[47]='f';
     uu[48]='f';uu[49]='f';uu[50]='f';uu[51]='f';
   }

}

int main(int argc, char **argv)
{
    Bmat *Amat = VNULL;
    Bmat *Ppro = VNULL;
    Bchar *ptype = VNULL;
    Bchar *pexact = VNULL;

    int i, key, t, p, numB, numR[MAXV];
    char PF;

    Vnm_print(1,"P = 1; F = 0; %% 1: Pass Test, 0: Fail Test\n");
    Vnm_print(1,"\n");
    Vnm_print(1,"fpoint_test_assem1 = [\n");
    Vnm_print(1,"%% -----------------------------\n");
    Vnm_print(1,"%% Test  Pass/Fail  Key   isimpl\n");

    for (t=0; t<2; t++) {
        /* Load a permutation matrix */
        Ppro = Bmat_example_Pro(t);
    
        numB = Ppro->numB;

        for (p=0; p<numB; p++) {
            numR[p] = Bmat_numR(Ppro, p, p);
            if (IS_IMPL == Bmat_impl(Ppro, p, p)) {
                numR[p] += Bmat_numC(Ppro, p, p);
            }
        }

        /* Construct some block vectors */
        ptype = Bchar_ctor( VNULL, "ptype", numB, numR );
        pexact = Bchar_ctor( VNULL, "pexact", numB, numR );

        for( key=0; key<3; key++ ) {
            /* Compute the list of F and C points */
            Bchar_assem( ptype, key, Ppro );
            /* Check with exact solution */
            Bchar_example1( pexact, key );
            PF = 'P';
            for (p=0; p<numB; p++) {
                for (i=0; i<(ptype->numR)[p]; i++) {
                    if ( (ptype->u)[p][i] != (pexact->u)[p][i] ) {
                        PF = 'F';
			Vnm_print(1,"(%d,%d) %c != %c : ", p, i, (ptype->u)[p][i], (pexact->u)[p][i]);
                    }
                }
            }
            Vnm_print(1," %4d   %6c   %3d   %3d\n", t*3+key+1, PF, key, t);
        }

        /* Destroy the vectors and matrix */
        Bmat_dtor( &Ppro );

        Bchar_dtor( &ptype );
        Bchar_dtor( &pexact);
    }

    Vnm_print(1,"%% -----------------------------\n");
    Vnm_print(1,"];\n");
    Vnm_print(1,"\n");
    Vnm_print(1,"fpoint_test_assem2 = [\n");
    Vnm_print(1,"%% -----------------------------\n");
    Vnm_print(1,"%% Test  Pass/Fail  Key   isimpl\n");

    /* Load a stiffness matrix */
    Amat = Bmat_example_A();

    for (t=0; t<2; t++) {
	/* Load a permutation matrix */
	Ppro = Bmat_example_Pro(t);
	
	numB = Ppro->numB;

        for (p=0; p<numB; p++) {
            numR[p] = Bmat_numR(Ppro, p, p);
            if (IS_IMPL == Bmat_impl(Ppro, p, p)) {
                numR[p] += Bmat_numC(Ppro, p, p);
            }
        }

        /* Construct some block vectors */
        ptype = Bchar_ctor( VNULL, "ptype", numB, numR );
        pexact = Bchar_ctor( VNULL, "pexact", numB, numR );

        for( key=0; key<3; key++ ) {
            /* Compute the list of F and C points */
            Bchar_assem2( ptype, key, Amat, Ppro );
            /* Check with exact solution */
            Bchar_example2( pexact, key );
            PF = 'P';
            for (p=0; p<numB; p++) {
                for (i=0; i<(ptype->numR)[p]; i++) {
                    if ( (ptype->u)[p][i] != (pexact->u)[p][i] ) {
			Vnm_print(1,"(%d,%d) %c != %c : ", p, i, (ptype->u)[p][i], (pexact->u)[p][i]);
                        PF = 'F';
                    }
                }
            }
            Vnm_print(1," %4d   %6c   %3d   %3d\n", t*3+key+1, PF, key, t);
        }

        /* Destroy the vectors and matrix */
        Bmat_dtor( &Ppro );

        Bchar_dtor( &ptype );
        Bchar_dtor( &pexact);
    }

    Bmat_dtor( &Amat );

    Vnm_print(1,"%% -----------------------------\n");
    Vnm_print(1,"];\n");

    Vnm_print(1,"\n");
    Vnm_print(1,"mc_leaks = [\n");
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"%%  Footprint        Areas       Malloc         Free"
                "    Highwater   Class\n"),
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vmem_print(VNULL);
    Vmem_printTotal();
    Vnm_print(1,"%% --------------------------------------"
                "--------------------------------------\n");
    Vnm_print(1,"];\n");

    /* normal return */
    return 0;
}

/* ************************************************************************* *
 *                   Matlab code for generating new problems                 *
 * ************************************************************************* *

% Size of each block
N = cell(1,3);
N{1} = 50; N{2} = 48; N{3} = 52;
M = cell(1,3);
M{1} = 20; M{2} = 28; M{3} = 25;

% Number of blocks
Nb = length(N);

% Create Nb x Nb cell arrays
UIA1 = cell(Nb); UJA1 = cell(Nb); UA1  = cell(Nb);
UIA2 = cell(Nb); UJA2 = cell(Nb); UA2  = cell(Nb);
ptype1 = cell(3,Nb);

si = 0;
sj = 0;
for ki = 1:Nb
   Pi = speye(N{ki},M{ki});
   for i=(M{ki}+1):N{ki}
      j = randperm(M{ki});
      j = j([1 2]);
      Pi(i,j) = [0.5 0.5];
   end
   zerocols = floor(M{ki}/10);
   zerotail = floor((N{ki}-M{ki})/10);
   j = randperm(M{ki});
   j = j(1:zerocols);
   Pi(j,:) = Pi(j,:) * 10^(-10);
   Pi(:,j) = Pi(:,j) * 10^(-10);
   i = randperm(N{ki}-M{ki}) + M{ki};
   i = i(1:zerotail);
   Pi(i,:) = Pi(i,:) * 10^(-10);
   si = si + N{ki};
   sj = sj + M{ki};
   [UIA1{ki,ki},UJA1{ki,ki},UA1{ki,ki}] = sp2csr(Pi);
   [UIA2{ki,ki},UJA2{ki,ki},UA2{ki,ki}] = sp2csr(Pi((M{ki}+1):N{ki},:));
   for i = 1:length(UA1{ki,ki})
      if( abs(UA1{ki,ki}(i)) < 10^(-9) )
        UA1{ki,ki}(i) = 0.0;
      end
   end
   for i = 1:length(UA2{ki,ki})
      if( abs(UA2{ki,ki}(i)) < 10^(-9) )
        UA2{ki,ki}(i) = 0.0;
      end
   end

   for key=1:3
      ptype1{key,ki} = char('c'*ones(1,N{ki}));
   end
   ptype1{1,ki}(1:N{ki}) = 'f';
   ptype1{2,ki}((M{ki}+1):N{ki}) = 'f';
   ptype1{3,ki}((M{ki}+1):N{ki}) = 'f';
   
   for i = (M{ki}+1):N{ki}
     j = find( abs(Pi(i,:)) > 10^(-9) );
     if( length(j) > 0 )
        ptype1{3,ki}(j) = 'f';
     end
   end
end

% Print the Ppro matrix as FETK C-Code
fid = fopen('problem.c','wt');
fprintf(fid,'VPRIVATE Bmat* Bmat_example_Pro( int key )\n{\n');
fprintf(fid,'   int numB, numC[MAXV], numR[MAXV];\n');
fprintf(fid,'   Mat *Ab;\n   double *AD;\n   int p, q, *IJA;\n');
fprintf(fid,'   MATmirror mirror[MAXV][MAXV];\n   Bmat *thee = VNULL;\n\n');
fprintf(fid,'   numB = %d;\n',Nb);
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = (0 == key) ? %d : %d;\n',ki-1,N{ki},N{ki}-M{ki});
  fprintf(fid,'   numC[%d] = %d;\n',ki-1,M{ki});
end
fprintf(fid,'   for( p=0; p<numB; p++ ) {\n');
fprintf(fid,'      for( q=0; q<numB; q++ ) {\n');
fprintf(fid,'         mirror[p][q] = ISNOT_MIRROR;\n      }\n   }\n\n');
fprintf(fid,'   thee = Bmat_ctor( VNULL, "P", numB, numR, numC, mirror );\n');
fprintf(fid,'\n');
for key = 0:1
  fprintf(fid,'   if (%d == key) {\n',key);
  for ki = 1:1:Nb
    fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,ki-1);
    if( 0 == key ) 
      IA = UIA1{ki,ki}; JA = UJA1{ki,ki}; A = UA1{ki,ki};
    else
      IA = UIA2{ki,ki}; JA = UJA2{ki,ki}; A = UA2{ki,ki};
    end
    numIJ = length([IA; JA]);
    fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
    k = 0;
    fprintf(fid,'\n   ');
    for i=1:length(IA)
      fprintf(fid,'IJA[%d]=%d;',k,IA(i)-1);
      k=k+1;
      if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
    end
    fprintf(fid,'\n   ');
    for i=1:length(JA)
      fprintf(fid,'IJA[%d]=%d;',k,JA(i)-1);
      k=k+1;
      if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
    end
    fprintf(fid,'\n');
    fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
                'ROW_FORMAT', 'ISNOT_SYM', length(JA));
    if( 0 == key )
      fprintf(fid,'   Ab->impl = ISNOT_IMPL;\n');
    else 
      fprintf(fid,'   Ab->impl = IS_IMPL;\n');
    end
    fprintf(fid,'   Ab->state = ASSEMBLED_STATE;\n   AD = Ab->A;\n');
    k=0;
    fprintf(fid,'\n   ');
    for i=1:length(A)
      fprintf(fid,'AD[%d]=%7.1e;',k,A(i));
      k=k+1;
      if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
    end
    fprintf(fid,'\n   ');
  end
  fprintf(fid,'\n   }\n');
end
fprintf(fid,'   return thee;\n}\n\n');
% Print the Bchar array as FETK C-Code
fprintf(fid,'VPRIVATE void Bchar_example1( Bchar *thee, int key )\n{\n');
fprintf(fid,'   char *uu;\n\n');
for ki = 1:1:Nb
fprintf(fid,'   VASSERT((thee->numR)[%d] == %d);\n',ki-1,N{ki});
end
for key = 1:3
  fprintf(fid,'\n   if (%d == key) {', key-1);
  for ki = 1:1:Nb
    fprintf(fid,'\n     uu = (thee->u)[%d];\n     ',ki-1);
    for i=1:1:N{ki}
      fprintf(fid,'uu[%d]=%c%c%c;',i-1,39,ptype1{key,ki}(i),39);
      if( 0 == mod(i,6) ) fprintf(fid,'\n     '); end;
    end
  end
  fprintf(fid,'\n   }\n');
end
fprintf(fid,'\n}\n');

% Total number of rows
numRT = sum(cell2mat(N));

% Generate a global shifted random matrix
A = sprand(numRT,numRT,1/(numRT));
% Symmetrize the structure
A = 0.5*(A + A');
% Randomize the values
randval = inline('rand(size(x)) - 0.5','x');
A = spfun(randval,A);
A = A + spdiags(1.5 + rand(numRT,1), 0, numRT, numRT);

% Create Nb x Nb cell arrays
UIA = cell(Nb); UJA = cell(Nb); UA  = cell(Nb);
LIA = cell(Nb); LJA = cell(Nb); LA  = cell(Nb);
DA  = cell(Nb);
ptype2 = cell(3,Nb);

si = 0;
for ki = 1:1:Nb
  for key=1:3
    ptype2{key,ki} = char('c'*ones(1,N{ki}));
    ptype2{key,ki}((M{ki}+1):N{ki}) = 'f';
  end
  ptype2{1,ki}(1:M{ki}) = 'f';
  
  sj = 0;
  for kj = 1:1:(ki-1)
    % Convert lower off-diagonal to CSC
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(Asp);
    sj = sj + N{kj};
  end
  kj = ki;
  % Convert diagonal to DRC
  Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
  [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(triu(Asp,1 ));
  [LIA{ki,kj},LJA{ki,kj},LA{ki,kj}] = sp2csc(tril(Asp,-1));
  DA{ki,kj} = diag(Asp);
  sj = sj + N{kj};
  for kj = (ki+1):1:Nb
    % Convert upper off-diagonal to CSR
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    [UIA{ki,kj},UJA{ki,kj},UA{ki,kj}] = sp2csr(Asp);
    sj = sj + N{kj};
  end
  si = si + N{ki};
end

si = 0;
for ki = 1:1:Nb
  for key=1:3
    ptype2{key,ki} = char('c'*ones(1,N{ki}));
  end
  ptype2{1,ki}(1:N{ki}) = 'f';
  ptype2{2,ki}((M{ki}+1):N{ki}) = 'f';
  ptype2{3,ki}((M{ki}+1):N{ki}) = 'f';
  
  sj = 0;
  for kj = 1:1:Nb
    Asp = A( (si+1):(si+N{ki}), (sj+1):(sj+N{kj}) );
    for i=(M{ki}+1):N{ki}
      j = find( abs(Asp(i,:)) );
      ptype2{3,kj}(j) = 'f';
    end
    for j=(M{kj}+1):N{kj}
      i = find( abs(Asp(:,j)) );
      ptype2{3,ki}(i) = 'f';
    end
    sj = sj + N{kj};    
  end
  si = si + N{ki};
end

% Print the A matrix as FETK C-Code
fprintf(fid,'VPRIVATE Bmat* Bmat_example_A( )\n{\n   int numB,numR[MAXV];\n');
fprintf(fid,'   Mat *Ab;\n   double *AD;\n   int p, q, *IJA;\n');
fprintf(fid,'   MATmirror mirror[MAXV][MAXV];\n   Bmat *thee = VNULL;\n\n');
fprintf(fid,'   numB = %d;\n',Nb);
fprintf(fid,'   VASSERT( numB <= MAXV );\n');
for ki = 1:1:Nb
  fprintf(fid,'   numR[%d] = %d;\n',ki-1,N{ki});
end
fprintf(fid,'   for( p=0; p<numB; p++ ) {\n');
fprintf(fid,'      for( q=0; q<numB; q++ ) {\n');
fprintf(fid,'         mirror[p][q] = ISNOT_MIRROR;\n      }\n   }\n\n');
fprintf(fid,'   thee = Bmat_ctor( VNULL, "A", numB, numR, numR, mirror );\n');
fprintf(fid,'\n');
for ki = 1:1:Nb
   fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,ki-1);
   numIJ = length([UIA{ki,ki}; UJA{ki,ki}]);
   fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
   k = 0;
   fprintf(fid,'\n   ');
   for i=1:length(UIA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UJA{ki,ki})
     fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,ki}(i)-1);
     k=k+1;
     if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'DRC_FORMAT', 'ISNOT_SYM', length(UJA{ki,ki}));
   fprintf(fid,'   Ab->state = ASSEMBLED_STATE;\n   AD = Ab->A;\n');
   k=0;
   fprintf(fid,'\n   ');
   for i=1:length(DA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,DA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(UA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n   ');
   for i=1:length(LA{ki,ki})
     fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,ki}(i));
     k=k+1;
     if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
   end
   fprintf(fid,'\n');
   for kj = 1:1:(ki-1)
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([LIA{ki,kj}; LJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(LJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,LJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'COL_FORMAT', 'ISNOT_SYM', length(LJA{ki,kj}));
      fprintf(fid,'   Ab->state = ASSEMBLED_STATE;\n   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(LA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,LA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
   end
   for kj = (ki+1):1:Nb
      fprintf(fid,'   Ab = thee->AD[%d][%d];\n',ki-1,kj-1);
      numIJ = length([UIA{ki,kj}; UJA{ki,kj}]);
      fprintf(fid,'   IJA = Vmem_malloc(Ab->vmem, %d, sizeof(int));\n',numIJ);
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UIA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UIA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n   ');
      for i=1:length(UJA{ki,kj})
        fprintf(fid,'IJA[%d]=%d;',k,UJA{ki,kj}(i)-1);
        k=k+1;
        if( 0 == mod(i,5) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
      fprintf(fid,'   Mat_initStructure(Ab, %s, %s, %d, IJA, VNULL);\n',...
               'ROW_FORMAT', 'ISNOT_SYM', length(UJA{ki,kj}));
      fprintf(fid,'   Ab->state = ASSEMBLED_STATE;\n   AD = Ab->A;\n');
      k = 0;
      fprintf(fid,'\n   ');
      for i=1:length(UA{ki,kj})
        fprintf(fid,'AD[%d]=%16.10e;',k,UA{ki,kj}(i));
        k=k+1;
        if( 0 == mod(i,3) ) fprintf(fid,'\n   '); end;
      end
      fprintf(fid,'\n');
   end
end
fprintf(fid,'   return thee;\n}\n\n');
% Print the Bchar array as FETK C-Code
fprintf(fid,'VPRIVATE void Bchar_example2( Bchar *thee, int key )\n{\n');
fprintf(fid,'   char *uu;\n\n');
for ki = 1:1:Nb
fprintf(fid,'   VASSERT((thee->numR)[%d] == %d);\n',ki-1,N{ki});
end
for key = 1:3
  fprintf(fid,'\n   if (%d == key) {', key-1);
  for ki = 1:1:Nb
    fprintf(fid,'\n     uu = (thee->u)[%d];\n     ',ki-1);
    for i=1:1:N{ki}
      fprintf(fid,'uu[%d]=%c%c%c;',i-1,39,ptype2{key,ki}(i),39);
      if( 0 == mod(i,6) ) fprintf(fid,'\n     '); end;
    end
  end
  fprintf(fid,'\n   }\n');
end
fprintf(fid,'\n}\n');
fclose(fid);

 * ************************************************************************* *
 *                        Sparse Conversion Functions                        *
 * ************************************************************************* *

function [IA, JA, A] = sp2csr(B)
%
% [IA, JA, A] = sp2csr(B)
%
[m,n] = size(B);
nz = nnz(B);

% Allocate space
IA = zeros(m+1,1);
JA = zeros(nz,1);
A = zeros(nz,1);

IA(1) = 1;
for i = 1:m
  IA(i+1) = IA(i) + nnz(B(i,:));
  jset = find(B(i,:));
  JA((IA(i)):(IA(i+1)-1)) = jset;
  A((IA(i)):(IA(i+1)-1)) = B(i,jset);
end

 * ************************************************************************* *
 *                               End Matlab Code                             *
 * ************************************************************************* */
