/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _bloom_h
#define _bloom_h

typedef struct {
  int			bfsize;
  int			numhash;
  globus_mutex_t	mtx;	/* Sync updates to bits,count,flags fields */
  u_char		*bits;
  short			*count;
  int			startlfns;	/* Num lfns when BF created	*/
  int			flags;
#define BF_NEEDUPDATE	0x1
} bloomfilter_t;

#define BITS2BYTES(bits)	((bits) / 8 + 1)

void		bf_addlfn(bloomfilter_t *bf, char *lfn);
void		bf_deletelfn(bloomfilter_t *bf, char *lfn);
extern void	bf_free(bloomfilter_t *bf);
extern int	bf_init(bloomfilter_t *bf, int bfsize, int numhash,
			int countbits);
extern void	bf_save(char *lrc_url, bloomfilter_t *bf);
extern int	bf_testlfn(bloomfilter_t *bf, char *lfn);
extern void	bf_unsave(char *lrc_url);
#endif
