-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/apps/insert.adb,v $
--  Description     : Main Driver of the Demo                                --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/01/14 08:50:24 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Text_IO;		use Ada.Text_IO;
with Ada.Strings.Unbounded;	use Ada.Strings.Unbounded;
with Ada.Exceptions;            use Ada.Exceptions;
with Ada.Command_Line;		use Ada.Command_Line;

with Persistent;		use Persistent;
with Person;			use Person;
with Account;			use Account;
with Group;			use Group;
with Account_Transaction;	use Account_Transaction;
with Root;			use Root;
with String_Table;		use String_Table;
with Objects;			use Objects;

procedure Insert is

   Version : constant String :=
       "$Id: insert.adb,v 1.4 2007/01/14 08:50:24 merdmann Exp $";

   Input_Record: String( 1..1024 );
   Next_Pos    : Natural := Input_Record'First;

   Length      : Natural := 0;
   End_Of_Line : exception;

   ---------------
   -- Get_Token --
   ---------------
   function Get_Token return String is
      Result : String( 1..1024 );
      J      : Natural := Result'First;
   begin
      if Next_Pos > Length then
         raise End_of_Line;
      end if;

      while Next_Pos in Input_Record'First..Length loop
         Result(J) := Input_Record(Next_Pos);

         Next_Pos  := Next_Pos + 1;
         exit when Next_Pos > Length or Input_Record(Next_Pos) = ';';

         J := J + 1;
      end loop;

      -- skip the ';'
      if Next_Pos in Input_Record'First..Length then
         Next_Pos := Next_Pos + 1;
      end if;

      return Result( 1..J );

   end Get_Token;

   Input : File_Type ;

begin
   if Argument_Count < 1 then
      Put_Line("usage:");
      Put_Line("   insert file(s)");
      return;
   end if;

   Put_Line("Database Insertion tool; Version 0.1");
   Put_Line("Copyright (C) 2006-2007 Michael Erdmann");
   Put_Line("" );

   Root.Initialize;

   for i in 1..Argument_Count loop

      Open( Name => Argument(i), File => Input, Mode => In_File );

      while not End_of_File( Input ) loop
         declare
            Firstname    : Unbounded_String;
            Lastname     : Unbounded_String;
            Account_Type : Unbounded_String;
            Value        : Integer;

            P            : Person.Object;
         begin
            Get_Line( Input, Input_Record, Length );
            Put_Line(Positive_Count'Image(Line(Input)));

            Next_Pos  := Input_Record'First;

            if Input_Record(1) /= '#' then
               Firstname := To_Unbounded_String( Get_Token );
               Lastname  := To_Unbounded_String( Get_Token );

               Person.Create( P, Firstname, Lastname );

               loop
                  Account_Type := To_Unbounded_String( Get_Token );
                  Value := Integer'Value( Get_Token );

                  Account.Create( P, To_String(Account_Type), Value );
               end loop;
            end if;

         exception
            when End_Of_Line =>
               null;

            when OBJECTS.INSERT_FAILED =>
               Put_Line("Error at line : " &
                        Positive_Count'Image( Line(Input) ));
         end;
      end loop;

      Close( Input );
   end loop;

   Root.Finalize;

   Put_Line("");
   Put_Line("Terminating normally");

exception
   when Error : others =>
      Put_Line("abnormal termination.");
      Put_Line( Exception_Name( Error ) & " at " & Exception_Message( Error ) );

end Insert;
