-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-row.adb,v $
--  Description     : Ada Database Objects - Row object                      --
--  Author          : Michael Erdmann                                        --
--  Created         : 18.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/03/16 21:08:59 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2002 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package is a place holder for a row in the result set. Each row     --
--  contains several field. The procedures in this package provide access    --
--  to these fields by means of an abstract interface which is in fact       --
--  implemented in the driver package.                                       --
--                                                                           --
--  This package is not intended as a programmer interface but as an         --
--  internal interface since the row object is not available to the          --
--  end user (programmer).                                                   --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;   use Ada.Text_Io;

package body GNU.DB.ADBC.Row is

   Version : constant String :=
      "$Id: gnu-db-adbc-row.adb,v 1.5 2002/03/16 21:08:59 merdmann Exp $";

   ---------
   -- Get --
   ---------
   function Get(
      This   : in Object'Class;
      Pos    : in Positive ) return Integer is
      -- get the integer value of the column addressed by pos.
      V      : String(1..50);
      Length : Positive;
   begin
      Get( This, Pos, V, Length );            -- dispatch into driver module
      return Integer'Value(V(1..Length));
   end;

   ---------
   -- Get --
   ---------
   function Get(
      This   : in Object'Class;
      Pos    : in Positive ) return Float is
      V      : String(1..50);
      Length : Positive;
   begin
      Get( This, Pos, V, Length );            -- dispatch into driver module
      return Float'Value(V(1..Length));
   end Get;

   ---------
   -- Get --
   ---------
   procedure Get(
      This   : in  Object'Class;
      Pos    : in  Positive;
      Length : out Positive;
      V      : out String ) is
      -- get the string
   begin
      V := (others => ' ');
      Get( This, Pos, V, Length );           -- dispatch into driver
   end Get;

end GNU.DB.ADBC.Row ;

