------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: blocking.adb,v 1.8 2006/12/10 09:29:35 merdmann Exp $

--  Example of the non blocking execution.

with
   Ada.Text_IO,
   OCI.Thick.OCINumber_Var,
   OCI.Thick.Number_Functions,
   OCI.Thick.Servers,
   OCI.Thick.Connections,
   OCI.Thick.Statements;

procedure Blocking is
   use OCI.Thick;
   use Ada.Text_IO;

   Server : Servers.Server := Servers.Attach ("");
   --  Using the OCI.Thick.Servers package.
   --  Creating server attachment.
   --  Empty name mean local server.

   Connect1 : Connections.Connection := Connections.Logon
     (DB       => Server,
      User     => "scott",
      Password => "tiger");

   Connect2 : Connections.Connection := Connections.Logon
     (DB       => Server,
      User     => "scott",
      Password => "tiger");
   --  Using the OCI.Thick.Connections package.
   --  Logon to the database and creating database connection

   Connect3 : Connections.Connection := Connections.Logon
                                              (Server_Name => "",
                                               User        => "scott",
                                               Password    => "tiger");

   Stmt_Text : String
      :=   "declare" & ASCII.LF
         & "  Dt Date := Sysdate;" & ASCII.LF
         & "  J  Integer;" & ASCII.LF
         & "begin" & ASCII.LF
         & "   loop" & ASCII.LF
         & "      J := NVL (J, 0) + 1;" & ASCII.LF
         & "      exit when Sysdate - Dt > 1/24/3600;" & ASCII.LF
         & "   end loop;" & ASCII.LF
         & "   :J := NVL (:J, 0) + 1;" & ASCII.LF
         & "end;" & ASCII.LF;

   Stmt : Statements.Statement := Statements.Prepare (Stmt_Text);
   --  Prepearing statement.
   --  OCI is prepearing statements without any communication with a server.

   J : OCINumber_Var.Variable;

begin
   --  We can see the server version information.

   Put_Line (Servers.Server_Version (Server));
   New_Line;

   Servers.Set_Blocking (Server, False);

   OCINumber_Var.Bind (Stmt, J, "J");

   loop
      Statements.Execute_And_Commit (Connect1, Stmt);
      exit when not Statements.Is_Executing (Stmt);
      Servers.Set_Blocking (Server, True);
      Put ('.');
      delay 0.1;
   end loop;

   Put_Line ("J = " & Number_Functions.To_String
                        (OCINumber_Var.Value (J), "9999999"));

   Servers.Set_Blocking (Server, False);

   loop
      Statements.Execute (Connect2, Stmt);
      exit when not Statements.Is_Executing (Stmt);
      Put ('.');
      delay 0.1;
   end loop;

   Put_Line ("J = " & Number_Functions.To_String
                        (OCINumber_Var.Value (J), "9999999"));

   loop
      Statements.Execute (Connect3, Stmt);
      exit when not Statements.Is_Executing (Stmt);
      Put ('.');
      delay 0.1;
   end loop;

   Put_Line ("J = " & Number_Functions.To_String
                        (OCINumber_Var.Value (J), "9999999"));

end Blocking;
