------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2006 Maxim Reznik                                         --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: change_subscriber.adb,v 1.2 2007/06/20 06:56:21 vagul Exp $

with Ada.Text_IO;
with Ada.Strings.Unbounded;

package body Change_Subscriber is

   ------------
   -- Notify --
   ------------

   procedure Notify
     (Item   : in out Subscriber_Type;
      Data   : in     Change_Descriptor)
   is
      use Ada.Text_IO;
      pragma Unreferenced (Item);
   begin
      Put_Line ("Change_Kind: " & Change_Kinds'Image (Change_Kind (Data)));

      declare
         Count : constant Positive := Table_Count (Data);
      begin
         for J in 1 .. Count loop
            Put_Line ("Table_Name: " & Table_Name (Data, J));
            Put_Line ("Table_Operation: "
                      & Operation_Kinds'Image (Table_Operation (Data, J)));
            declare
               use Ada.Strings.Unbounded;
               Rows : constant Row_Array := Table_Rows (Data, J);
            begin
               for R in Rows'Range loop
                  Put_Line ("Rowid: " & To_String (Rows (R).Id)
                            & " Operation_Kind: "
                            & Operation_Kinds'Image (Rows (R).Kind));
               end loop;
            end;
         end loop;
      end;
   end Notify;

end Change_Subscriber;
