/***************************************************************************
 *            dlgconnected.c
 *
 *  Mon May 10 20:27:42 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


void on_conn_disconnect (GtkWidget *widget, gpointer data)
{
	/* try to kill wvdial process */
	if (wvdial.pid != 0)
		if (kill (wvdial.pid, 2) < 0)
			g_print ("GNOME PPP: Unable to KILL wvdial process!\n");
	
	if (gnome_ppp.connected.update) {		
		gtk_timeout_remove (gnome_ppp.connected.update);
		gnome_ppp.connected.seconds = 0;
		gtk_label_set_markup (GTK_LABEL (gnome_ppp.connected.time), _("<big>Connected: 00:00:00</big>"));
		gtk_window_set_title (GTK_WINDOW (gnome_ppp.connected.window), "00:00:00");
	}	
	gtk_widget_hide (gnome_ppp.connected.window);
	gtk_widget_hide (gnome_ppp.details.window);
	gtk_widget_hide (gnome_ppp.log.window);
	gtk_widget_show (gnome_ppp.gnome_ppp.window);
}

void on_conn_details (GtkWidget *widget, gpointer data)
{
	gtk_widget_show (gnome_ppp.details.window);
}

gboolean on_conn_delete_event (GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return TRUE;
}

gboolean timer (gpointer data)
{
	gchar *caption = NULL;
	gchar *caption_markup = NULL;
	guint hours = 0;
	guint minutes = 0;
	guint seconds = 0;
	
	gnome_ppp.connected.seconds++;
	
	hours = gnome_ppp.connected.seconds / 3600;
	minutes = (gnome_ppp.connected.seconds - hours * 3600) / 60;
	seconds = gnome_ppp.connected.seconds - hours * 3600 - minutes * 60;
	
	caption = g_strdup_printf ("%2d:%2d:%2d", hours, minutes, seconds);
	caption = g_strcanon (caption, ":0123456789", '0');
	
	caption_markup = g_strdup_printf (_("<big>Connected: %s</big>"), caption);
	
	gtk_label_set_markup (GTK_LABEL (gnome_ppp.connected.time), caption_markup);
	gtk_window_set_title (GTK_WINDOW (gnome_ppp.connected.window), caption);
	
	g_free (caption);
	g_free (caption_markup);
	
	/* get details on connection */
	/* transfer details */
	gchar *error = NULL;
	glong packets_in = 0;
	glong packets_out = 0;
	glong bytes_in = 0;
	glong bytes_out = 0;
	gchar *kbytes_in = NULL;
	gchar *kbytes_out = NULL;
	const gchar *iface;
	gchar *in = NULL;
	gchar *out = NULL;
	gchar *in_packets = NULL;
	gchar *out_packets = NULL;
	
	iface = gtk_label_get_text (GTK_LABEL (gnome_ppp.details.interface));
	error = get_transfer_details (iface, &packets_in, &packets_out, &bytes_in, &bytes_out);
	
	if (bytes_in > gnome_ppp.connected.old_bytes_in && bytes_out > gnome_ppp.connected.old_bytes_out) {
		glong tmp_in = bytes_in - gnome_ppp.connected.old_bytes_in;
		glong tmp_out = bytes_out - gnome_ppp.connected.old_bytes_out;

		tmp_in *= 10;
		tmp_out *= 10;
		tmp_in = tmp_in / 1024;
		tmp_out = tmp_out / 1024;
		kbytes_in = g_strdup_printf ("%ld.%ld KB/s", tmp_in / 10, tmp_in % 10);
		kbytes_out = g_strdup_printf ("%ld.%ld KB/s", tmp_out / 10, tmp_out % 10);
		
		gnome_ppp.connected.old_bytes_in = bytes_in;
		gnome_ppp.connected.old_bytes_out = bytes_out;
		
		if (gnome_ppp.dock == TRUE)
			update_notification (0); /* sending/receiving */
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.status), _("Sending/Receiving"));
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_in), kbytes_in);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_out), kbytes_out);

		g_free (kbytes_in);
		g_free (kbytes_out);
	} else if (bytes_in > gnome_ppp.connected.old_bytes_in && bytes_out == gnome_ppp.connected.old_bytes_out) {
		glong tmp_in = bytes_in - gnome_ppp.connected.old_bytes_in;
		
		tmp_in *= 10;
		tmp_in = tmp_in / 1024;
		kbytes_in = g_strdup_printf ("%ld.%ld KB/s", tmp_in / 10, tmp_in % 10);
		
		gnome_ppp.connected.old_bytes_in = bytes_in;
		
		if (gnome_ppp.dock == TRUE)
			update_notification (1); /* receiving */
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.status), _("Receiving"));
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_in), kbytes_in);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_out), "0.0 KB/s");

		g_free (kbytes_in);
	} else if (bytes_in == gnome_ppp.connected.old_bytes_in && bytes_out > gnome_ppp.connected.old_bytes_out) {
		glong tmp_out = bytes_out - gnome_ppp.connected.old_bytes_out;
		
		tmp_out *= 10;
		tmp_out = tmp_out / 1024;
		kbytes_out = g_strdup_printf ("%ld.%ld KB/s", tmp_out / 10, tmp_out % 10);
		
		gnome_ppp.connected.old_bytes_out = bytes_out;
		
		if (gnome_ppp.dock == TRUE)
			update_notification (2); /* sending */
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.status), _("Sending"));
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_in), "0.0 KB/s");
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_out), kbytes_out);

		g_free (kbytes_out);
	} else if (bytes_out == gnome_ppp.connected.old_bytes_out && bytes_in == gnome_ppp.connected.old_bytes_in) {
		gnome_ppp.connected.old_bytes_in = bytes_in;
		gnome_ppp.connected.old_bytes_out = bytes_out;
		
		if (gnome_ppp.dock == TRUE)
			update_notification (3); /* idle */
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.status), _("Idle"));
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_in), "0.0 KB/s");
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.speed_out), "0.0 KB/s");
	}
	
	bytes_in *= 10;
	bytes_out *= 10;
	
	if (bytes_in > 1024) { /* KB */
		bytes_in = bytes_in / 1024;
		in = g_strdup_printf ("%ld.%ld KB", bytes_in / 10, bytes_in % 10);
	} else if (bytes_in >= 0) { /* B */
		in = g_strdup_printf ("%ld.%ld B", bytes_in / 10, bytes_in % 10);
	}
	
	if (bytes_out > 1024) { /* KB */
		bytes_out = bytes_out / 1024;
		out = g_strdup_printf ("%ld.%ld KB", bytes_out / 10, bytes_out % 10);
	} else if (bytes_out >= 0) { /* B */
		out = g_strdup_printf ("%ld.%ld B", bytes_out / 10, bytes_out % 10);
	}
	
	in_packets = g_strdup_printf ("%ld", packets_in);
	out_packets = g_strdup_printf ("%ld", packets_out);
	
	if (error == NULL) {		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.received), in);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.sent), out);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.received_packets), in_packets);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.sent_packets), out_packets);
	} else {
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.received), "0");
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.sent), "0");
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.received_packets), "0");
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.sent_packets), "0");
		g_free (error);
	}
	
	if (in != NULL)
		g_free (in);
	
	if (out != NULL)
		g_free (out);
	
	if (in_packets != NULL)
		g_free (in_packets);
	
	if (out_packets != NULL)
		g_free (out_packets);
	/* address details */
	gchar *addr = NULL;
	gchar *dest = NULL;
	
	if (get_addr_details (iface, &addr, &dest)) {
		
		if (addr)			
			gtk_label_set_text (GTK_LABEL (gnome_ppp.details.ip), addr);
			
		else
			gtk_label_set_text (GTK_LABEL (gnome_ppp.details.ip), _("Unknown"));
		
		if (dest)
			gtk_label_set_text (GTK_LABEL (gnome_ppp.details.destination), dest);
		else
			gtk_label_set_text (GTK_LABEL (gnome_ppp.details.destination), _("Unknown"));
		
		if (addr != NULL)
			g_free (addr);
		
		if (dest != NULL)
			g_free (dest);
	}
	
	return TRUE;
}
