<!--
Copyright (c) ONNX Project Contributors

SPDX-License-Identifier: Apache-2.0
-->

# Repositories under ONNX GitHub organization

The ONNX GitHub organization contains a number of repositories. Every repository is owned by a SIG and the Steering Committee is responsible for managing these repos. Requests for creating, transferring, modifying, or archiving repositories can be made by filing an issue a request against https://github.com/onnx/steering-committee.

## Rules for all repos

* Must be owned and managed by one of the ONNX SIGs or the Steering Committee
* Must be actively maintained
* Must adopt the ONNX Code of Conduct
* Must adopt the standard ONNX license(s) [All code projects use the Apache 2.0 license. Documentation repositories must use the Creative Commons License version 4.0.]
* Must adopt the ONNX DCO bot
* Must adopt all ONNX automation (like static code analysis)
* Must have CI or other automation in place for repos containing code to ensure quality
* All OWNERS must be members of standing as defined by ability to vote in Steering Committee elections.

## Requirements for new, contributed repos

We are happy to accept contributions as repos under the ONNX organization of new projects that meet the following requirements:

* Project is closely related to ONNX
* Adds value to the ONNX ecosystem
* Determined to need a new repo rather than a folder in an existing repo
* Applicable and usable by a wide set of ONNX users (for example, implemented support for multiple hardware backends at time of contribution or committment to do so soon after)
* All contributors must have signed the ONNX DCO
* Licenses of dependencies must be acceptable
* Commitment to maintain the repo
* Approval of the SIG that will own the repo
* Approval of the Steering Committee

If you want to contribute a repository, you should first work with the SIG that will own it. Then the SIG can work with the Steering Committee to finalize.

## Archiving repos

Repositories that are inactive or unneeded will be archived. The SIG that owns the repo is responsible for deciding when it should be archived. SIGs should regularly validate the repos they own are still active and necessary.
