<?php
/**
* acp_permissions_phpbb (phpBB Permission Set) [Slovenian]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @author 2009-01-09 - pucer, borut, kebabek, KoMar, kramp, lithium, mitja_i, NoBody, nSk, Razor, sollers, Tody, Veron, Janet, JureB
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

/**
*	MODDERS PLEASE NOTE
*
*	You are able to put your permission sets into a separate file too by
*	prefixing the new file with permissions_ and putting it into the acp
*	language folder.
*
*	An example of how the file could look like:
*
*	<code>
*
*	if (empty($lang) || !is_array($lang))
*	{
*		$lang = array();
*	}
*
*	// Adding new category
*	$lang['permission_cat']['bugs'] = 'Bugs';
*
*	// Adding new permission set
*	$lang['permission_type']['bug_'] = 'Bug Permissions';
*
*	// Adding the permissions
*	$lang = array_merge($lang, array(
*		'acl_bug_view'		=> array('lang' => 'Can view bug reports', 'cat' => 'bugs'),
*		'acl_bug_post'		=> array('lang' => 'Can post bugs', 'cat' => 'post'), // Using a phpBB category here
*	));
*
*	</code>
*/

// Define categories and permission types
$lang = array_merge($lang, array(
	'permission_cat'	=> array(
		'actions'		=> 'Dejanja',
		'content'		=> 'Vsebina',
		'forums'		=> 'Forumi',
		'misc'			=> 'Razno',
		'permissions'	=> 'Dovoljenja',
		'pm'			=> 'Zasebna sporočila',
		'polls'			=> 'Ankete',
		'post'			=> 'Prispevek',
		'post_actions'	=> 'Dejanja objav',
		'posting'		=> 'Objavljanje prispevkov',
		'profile'		=> 'Profil',
		'settings'		=> 'Nastavitve',
		'topic_actions'	=> 'Dejanja tem',
		'user_group'	=> 'Uporabniki &amp; skupine',
	),

	// With defining 'global' here we are able to specify what is printed out if the permission is within the global scope.
	'permission_type'	=> array(
		'u_'	=> 'Dovoljenja uporabnikov',
		'a_'	=> 'Dovoljenja administratorjev',
		'm_'	=> 'Dovoljenja moderatorjev',
		'f_'	=> 'Dovoljenja forumov',
		'global'		=> array(
			'm_'			=> 'Dovoljenja globalnih moderatorjev',
		),
	),
));

// User Permissions
$lang = array_merge($lang, array(
	'acl_u_viewprofile'	=> array('lang' => 'Lahko vidi profil, seznam uporabnikov in spletni seznam', 'cat' => 'profile'),
	'acl_u_chgname'		=> array('lang'	=> 'Lahko spreminja uporabniško ime', 'cat' => 'profile',),
	'acl_u_chgpasswd'	=> array('lang'	=> 'Lahko spreminja geslo', 'cat' => 'profile',),
	'acl_u_chgemail'	=> array('lang'	=> 'Lahko spreminja e-poštni naslov', 'cat' => 'profile',),
	'acl_u_chgavatar'	=> array('lang'	=> 'Lahko spreminja avatar', 'cat' => 'profile',),
	'acl_u_chggrp'		=> array('lang'	=> 'Lahko spreminja privzeto uporabniško skupino', 'cat' => 'profile',),

	'acl_u_attach'		=> array('lang'	=> 'Lahko pripenja dodoteke', 'cat' => 'post',),
	'acl_u_download'	=> array('lang'	=> 'Lahko prenaša datoteke', 'cat' => 'post',),
	'acl_u_savedrafts'	=> array('lang'	=> 'Lahko shranjuje osnutke', 'cat' => 'post',),
	'acl_u_chgcensors'	=> array('lang'	=> 'Lahko onemogoči cenzuro besed', 'cat' => 'post',),
	'acl_u_sig'			=> array('lang'	=> 'Lahko uporablja podpise', 'cat' => 'post',),

	'acl_u_sendpm'		=> array('lang'	=> 'Lahko pošilja zasebna sporočila', 'cat' => 'pm',),
	'acl_u_masspm'		=> array('lang'	=> 'Lahko pošilja zasebna sporočila množično uporabnikom in skupinam.', 'cat' => 'pm',),
	'acl_u_readpm'		=> array('lang'	=> 'Lahko bere zasebna sporočila', 'cat' => 'pm',),
	'acl_u_masspm_group'=> array('lang'	=> 'Lahko pošilja sporočila skupinam', 'cat' => 'pm',),
	'acl_u_pm_edit'		=> array('lang'	=> 'Lahko ureja lastna zasebna sporočila', 'cat' => 'pm',),
	'acl_u_pm_delete'	=> array('lang'	=> 'Lahko odstranjuje zasebna sporočila iz lastne mape', 'cat' => 'pm',),
	'acl_u_pm_forward'	=> array('lang'	=> 'Lahko posreduje zasebna sporočila', 'cat' => 'pm',),
	'acl_u_pm_emailpm'	=> array('lang'	=> 'Lahko pošilja zasebna sporočila po e-pošti.', 'cat' => 'pm',),
	'acl_u_pm_printpm'	=> array('lang'	=> 'Lahko natisne zasebna sporočila', 'cat' => 'pm',),
	'acl_u_pm_attach'	=> array('lang'	=> 'Lahko pripenja datoteke k zasebnim sporočilom', 'cat' => 'pm',),
	'acl_u_pm_download'	=> array('lang'	=> 'Lahko prenaša datoteke v zasebnih sporočilih', 'cat' => 'pm',),
	'acl_u_pm_bbcode'	=> array('lang'	=> 'Lahko objavlja BB kodo v zasebnih sporočilih', 'cat' => 'pm',),
	'acl_u_pm_smilies'	=> array('lang'	=> 'Lahko objavlja smeške v zasebnih sporočilih', 'cat' => 'pm',),
	'acl_u_pm_img'		=> array('lang'	=> 'Lahko objavlja slike v zasebnih sporočilih', 'cat' => 'pm',),
	'acl_u_pm_flash'	=> array('lang'	=> 'Lahko objavlja Flash v zasebnih sporočilih', 'cat' => 'pm',),

	'acl_u_sendemail'	=> array('lang'	=> 'Lahko pošilja e-pošto', 'cat' => 'misc',),
	'acl_u_sendim'		=> array('lang'	=> 'Lahko pošilja hitra sporočila', 'cat' => 'misc',),
	'acl_u_ignoreflood'	=> array('lang'	=> 'Lahko ignorira prenatrpanost', 'cat' => 'misc',),
	'acl_u_hideonline'	=> array('lang'	=> 'Lahko skrije online (spletni) status', 'cat' => 'misc',),
	'acl_u_viewonline'	=> array('lang'	=> 'Lahko vidi skrite uporabnike', 'cat' => 'misc',),
	'acl_u_search'		=> array('lang'	=> 'Lahko uporablja iskanje', 'cat' => 'misc',),
));

// Forum Permissions
$lang = array_merge($lang, array(
	'acl_f_list'		=> array('lang'	=> 'Lahko vidi forum', 'cat' => 'post',),
	'acl_f_read'		=> array('lang'	=> 'Lahko bere forum', 'cat' => 'post',),
	'acl_f_post'		=> array('lang'	=> 'Lahko odpira nove teme', 'cat' => 'post',),
	'acl_f_reply'		=> array('lang'	=> 'Lahko odgovarja na teme', 'cat' => 'post',),
	'acl_f_icons'		=> array('lang'	=> 'Lahko uporablja ikone tem/prispevkov', 'cat' => 'post',),
	'acl_f_announce'	=> array('lang'	=> 'Lahko objavlja obvestila', 'cat' => 'post',),
	'acl_f_sticky'		=> array('lang'	=> 'Lahko objavlja lepljivke', 'cat' => 'post',),

	'acl_f_poll'		=> array('lang'	=> 'Lahko ustvarja ankete', 'cat' => 'polls',),
	'acl_f_vote'		=> array('lang'	=> 'Lahko glasuje na anketah', 'cat' => 'polls',),
	'acl_f_votechg'		=> array('lang'	=> 'Lahko spreminja obstoječa glasovanja', 'cat' => 'polls',),

	'acl_f_attach'		=> array('lang'	=> 'Lahko pripenja datoteke', 'cat' => 'content',),
	'acl_f_download'	=> array('lang'	=> 'Lahko prenaša datoteke', 'cat' => 'content',),
	'acl_f_sigs'		=> array('lang'	=> 'Lahko uporablja podpis', 'cat' => 'content',),
	'acl_f_bbcode'		=> array('lang'	=> 'Lahko objavlja BB kodo', 'cat' => 'content',),
	'acl_f_smilies'		=> array('lang'	=> 'Lahko objavlja smeške', 'cat' => 'content',),
	'acl_f_img'			=> array('lang'	=> 'Lahko objavlja slike', 'cat' => 'content',),
	'acl_f_flash'		=> array('lang'	=> 'Lahko objavlja Flash', 'cat' => 'content',),

	'acl_f_edit'		=> array('lang'	=> 'Lahko ureja lastna zasebna sporočila', 'cat' => 'actions',),
	'acl_f_delete'		=> array('lang'	=> 'Lahko briše lastna zasebna sporočila', 'cat' => 'actions',),
	'acl_f_user_lock'	=> array('lang'	=> 'Lahko zaklepa lastne teme', 'cat' => 'actions',),
	'acl_f_bump'		=> array('lang'	=> 'Lahko zavrže teme', 'cat' => 'actions',),
	'acl_f_report'		=> array('lang'	=> 'Lahko opozarja na prispevke', 'cat' => 'actions',),
	'acl_f_subscribe'	=> array('lang'	=> 'Lahko se naroči na forume', 'cat' => 'actions',),
	'acl_f_print'		=> array('lang'	=> 'Lahko tiska teme', 'cat' => 'actions',),
	'acl_f_email'		=> array('lang'	=> 'Lahko pošilja teme po e-pošti', 'cat' => 'actions',),

	'acl_f_search'		=> array('lang'	=> 'Lahko išče po forumu', 'cat' => 'misc',),
	'acl_f_ignoreflood'	=> array('lang'	=> 'Lahko prezre prenatrpanost', 'cat' => 'misc',),
	'acl_f_postcount'	=> array('lang'	=> 'Povečanje štetja objav<br /><em>Prosimo bodite pozorni na to, da ta nastavitev velja samo za nove prispevke.</em>', 'cat' => 'misc',),
	'acl_f_noapprove'	=> array('lang'	=> 'Lahko objavlja brez odobravanja', 'cat' => 'misc',),
));

// Moderator Permissions
$lang = array_merge($lang, array(
	'acl_m_edit'		=> array('lang'	=> 'Lahko ureja prispevke', 'cat' => 'post_actions',),
	'acl_m_delete'		=> array('lang'	=> 'Lahko briše prispevke', 'cat' => 'post_actions',),
	'acl_m_approve'		=> array('lang'	=> 'Lahko odobrava prispevke', 'cat' => 'post_actions',),
	'acl_m_report'		=> array('lang'	=> 'Lahko zapira in briše opozorila', 'cat' => 'post_actions',),
	'acl_m_chgposter'	=> array('lang'	=> 'Lahko spremeni avtorja prispevka', 'cat' => 'post_actions',),

	'acl_m_move'	=> array('lang'	=> 'Lahko premakne temo', 'cat' => 'topic_actions',),
	'acl_m_lock'	=> array('lang'	=> 'Lahko zaklene temo', 'cat' => 'topic_actions',),
	'acl_m_split'	=> array('lang'	=> 'Lahko razdeli temo', 'cat' => 'topic_actions',),
	'acl_m_merge'	=> array('lang'	=> 'Lahko združi temo', 'cat' => 'topic_actions',),

	'acl_m_info'	=> array('lang'	=> 'Lahko vidi podrobnosti prispevka', 'cat' => 'misc',),
	'acl_m_warn'	=> array('lang'	=> 'Lahko razrešuje opozorila<br /><em> Ta nastavitev se lahko dodeljuje samo na splošno. Ni osnovana na forumu.</em>', 'cat' => 'misc',), // This moderator setting is only global (and not local)
	'acl_m_ban'	=> array('lang'	=> 'Lahko ureja izključitve<br /><em> Ta nastavitev se lahko dodeljuje samo na splošno. Ni osnovana na forumu.</em>', 'cat' => 'misc',), // This moderator setting is only global (and not local)
));

// Admin Permissions
$lang = array_merge($lang, array(
	'acl_a_board'		=> array('lang'	=> 'Lahko spreminja nastavitve administrativne nadzorne plošče/preverja posodobitve', 'cat' => 'settings',),
	'acl_a_server'		=> array('lang'	=> 'Lahko spreminja nastavitve serverja/povezovanja', 'cat' => 'settings',),
	'acl_a_jabber'		=> array('lang'	=> 'Lahko spreminja Jabber nastavitve', 'cat' => 'settings',),
	'acl_a_phpinfo'		=> array('lang'	=> 'Lahko vidi php nastavitve', 'cat' => 'settings',),

	'acl_a_forum'		=> array('lang'	=> 'Lahko ureja forume', 'cat' => 'forums',),
	'acl_a_forumadd'	=> array('lang'	=> 'Lahko dodaja nove forume', 'cat' => 'forums',),
	'acl_a_forumdel'	=> array('lang'	=> 'Lahko briše forume', 'cat' => 'forums',),
	'acl_a_prune'		=> array('lang'	=> 'Lahko čisti forume', 'cat' => 'forums',),

	'acl_a_icons'		=> array('lang'	=> 'Lahko spreminja ikone in smeške tem/prispevkov', 'cat' => 'posting',),
	'acl_a_words'		=> array('lang'	=> 'Lahko spreminja cenzuro besed', 'cat' => 'posting',),
	'acl_a_bbcode'		=> array('lang'	=> 'Lahko določa BBcode zastavice', 'cat' => 'posting',),
	'acl_a_attach'		=> array('lang'	=> 'Lahko ureja nastavitve v zvezi z priponkami', 'cat' => 'posting',),

	'acl_a_user'		=> array('lang'	=> 'Lahko ureja uporabnike<br /><em>To vključuje tudi gledanje uporabnikovega brskalnika znotraj seznama na spletu.</em>', 'cat' => 'user_group',),
	'acl_a_userdel'		=> array('lang'	=> 'Lahko briše/čisti uporabnike', 'cat' => 'user_group',),
	'acl_a_group'		=> array('lang'	=> 'Lahko ureja skupine', 'cat' => 'user_group',),
	'acl_a_groupadd'	=> array('lang'	=> 'Lahko dodaja nove skupine', 'cat' => 'user_group',),
	'acl_a_groupdel'	=> array('lang'	=> 'Lahko briše skupine', 'cat' => 'user_group',),
	'acl_a_ranks'		=> array('lang'	=> 'Lahko ureja stopnje uporabnikov', 'cat' => 'user_group',),
	'acl_a_profile'		=> array('lang'	=> 'Lahko ureja polja po meri', 'cat' => 'user_group',),
	'acl_a_names'		=> array('lang'	=> 'Lahko ureja nedovoljena imena', 'cat' => 'user_group',),
	'acl_a_ban'			=> array('lang'	=> 'Lahko ureja izključitve', 'cat' => 'user_group',),

	'acl_a_viewauth'	=> array('lang'	=> 'Lahko vidi shematski ogled dovoljenj', 'cat' => 'permissions',),
	'acl_a_authgroups'	=> array('lang'	=> 'Lahko spreminja dovoljenja posameznih skupin', 'cat' => 'permissions',),
	'acl_a_authusers'	=> array('lang'	=> 'Lahko spreminja dovoljenja posameznih uporabnikov', 'cat' => 'permissions',),
	'acl_a_fauth'		=> array('lang'	=> 'Lahko spreminja razrede dovoljenja foruma', 'cat' => 'permissions',),
	'acl_a_mauth'		=> array('lang'	=> 'Lahko spreminja razrede dovoljenj moderatorjev', 'cat' => 'permissions',),
	'acl_a_aauth'		=> array('lang'	=> 'Lahko spreminja razrede dovoljenj administratorjev', 'cat' => 'permissions',),
	'acl_a_uauth'		=> array('lang'	=> 'Lahko spreminja razrede dovoljenj uporabnikov', 'cat' => 'permissions',),
	'acl_a_roles'		=> array('lang'	=> 'Lahko ureja vloge', 'cat' => 'permissions',),
	'acl_a_switchperm'	=> array('lang'	=> 'Lahko uporablja druga dovoljenja', 'cat' => 'permissions',),

	'acl_a_styles'		=> array('lang'	=> 'Lahko ureja teme', 'cat' => 'misc',),
	'acl_a_viewlogs'	=> array('lang'	=> 'Lahko vidi poročila', 'cat' => 'misc',),
	'acl_a_clearlogs'	=> array('lang'	=> 'Lahko čisti poročila', 'cat' => 'misc',),
	'acl_a_modules'		=> array('lang'	=> 'Lahko ureja module', 'cat' => 'misc',),
	'acl_a_language'	=> array('lang'	=> 'Lahko ureja jezikovne pakete', 'cat' => 'misc',),
	'acl_a_email'		=> array('lang'	=> 'Lahko pošilja množično e-pošto', 'cat' => 'misc',),
	'acl_a_bots'		=> array('lang'	=> 'Lahko ureja bote', 'cat' => 'misc',),
	'acl_a_reasons'		=> array('lang'	=> 'Lahko ureja vzroke poročil/zanikanj', 'cat' => 'misc',),
	'acl_a_backup'		=> array('lang'	=> 'Lahko izdeluje varnostne kopije baze in obnavlja bazo', 'cat' => 'misc',),
	'acl_a_search'		=> array('lang'	=> 'Lahko ureja ozadje in nastavitve iskanja.', 'cat' => 'misc',),
));

?>