/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __OPTION__
#define __OPTION__

#include <src/global/global.h>

typedef struct option CONTENEUR(Option);

#include <src/donnees/commandes/commandeoption.h>

#define TAILLEINIT	5
#define MULTTAILLE	2

#define OPTION_NON_TROUVEE	-1

struct option
{
	STOCKAGE_SCALAIRE(Taille) memoire;
	//Taille rserve en mmoire.
	STOCKAGE_SCALAIRE(Taille) taille;
	//Taille rellement utilise.
	TABLEAU(STOCKAGE(CommandeOption)) option;
	//Options dclares dans le flux,
	//ranges par ordre lexicographique du nom.
};

Resultat option_initialisation(TRAVAIL(Option) option);
/* Cre une structure de dclaration d'option vide.
 */

Resultat option_ajout_option(TRAVAIL(Option) option , TRAVAIL(CommandeOption) commandeoption);
/* Ajoute une option  la structure de dclaration d'option.
 * Les options sont ajoutes dans l'ordre lexicographique.
 */

Resultat option_lecture_taille(TRAVAIL(Option) option , REFERENCE_SCALAIRE(Taille) taille);
/* Renvoie la taille du tableau d'options.
 * Renvoie RESULTAT_ERREUR si option est NULL.
 */

Resultat option_lecture_option(TRAVAIL(Option) option , TRAVAIL_SCALAIRE(Indice) indice , REFERENCE(CommandeOption) commandeoption);
/* Retourne la commande d'option enregistre  l'indice indiqu.
 * Renvoie RESULTAT_ERREUR si option est NULL.
 * Renvoie RESULTAT_ERREUR_DEPASSEMENT si l'indice est incorrect.
 */

Resultat option_recherche_option(TRAVAIL(Option) option , TRAVAIL_SCALAIRE(NomOption) nomoption , REFERENCE_SCALAIRE(Indice) indice);
/* Renvoie l'indice de l'option passe en paramtre. Si elle n'est pas prsente,
 * la fonction renvoie OPTION_NON_TROUVEE  la place de l'indice.
 */

Resultat option_fusion(TRAVAIL(Option) destination , TRAVAIL(Option) ajout);
/* Fusionne deux listes de dclaration d'option, en ajoutant
 * les options dclares dans ajout  celles de la destination.
 * Les options restent dans l'ordre lexicographique.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat option_copie(TRAVAIL(Option) option , TRAVAIL(Option) copie);
/* Cre une copie de l'option donne en paramtre.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation,
 * Attention ! Si *copie est diffrent de NULL, la copie tente une
 * destruction pralable de la valeur prsume dans la copie.
 */

Resultat option_destruction(TRAVAIL(Option) option);
/* Dtruit une liste de dclaration d'options.
 */

#endif
