#!/usr/bin/env python
# ----------------------------------------------------------------------------
# pyglet
# Copyright (c) 2006-2008 Alex Holkner
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions 
# are met:
#
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright 
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#  * Neither the name of pyglet nor the names of its
#    contributors may be used to endorse or promote products
#    derived from this software without specific prior written
#    permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
# ----------------------------------------------------------------------------

"""Demonstrates how to manage OpenGL calls with two independent windows.
"""

import pyglet
from pyglet.gl import *


def on_resize(width, height):
    glViewport(0, 0, int(width * pixel_ratio), int(height * pixel_ratio))
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(60., width / float(height), 1., 100.)
    glMatrixMode(GL_MODELVIEW)


def setup():
    glClearColor(1, 1, 1, 1)
    glColor3f(.5, .5, .5)


def on_draw():
    glClear(GL_COLOR_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0, 0, -5)
    glRotatef(r, 0, 0, 1)
    glRectf(-1, -1, 1, 1)


r = 0


def update(dt):
    global r
    r += 1
    if r > 360:
        r = 0


pyglet.clock.schedule_interval(update, 1 / 20.)

w1 = pyglet.window.Window(200, 200, caption='First window', resizable=True)
w1.on_resize = on_resize
w1.on_draw = on_draw
w1.switch_to()
setup()

w2 = pyglet.window.Window(300, 300, caption='Second window', resizable=True)
w2.on_resize = on_resize
w2.on_draw = on_draw
w2.switch_to()
setup()

# On some platforms the actual framebuffer size is bigger than the window.
pixel_ratio = w1.get_pixel_ratio()

pyglet.app.run()
