## about.py
## 
## Copyright (C) 2006-2008 Betz Stefan <stefan_betz@gmx.net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 3 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gettext
from pyneighborhood.misc import sharepath, version

_ = gettext.gettext

class AboutDialog(object):
    """
    about-dialog for pyNeighborhood
    """

    def __init__(self):
        """
        Constructor of the about-dialog
        """
        self.xml = gtk.glade.XML(sharepath() + "/pyNeighborhood.glade",
            "about_dialog")
        self.xml.signal_autoconnect(self)
        self.window = self.xml.get_widget("about_dialog")
        self.window.set_version(version)

    def close_handler(self, widget = None, response_id = None):
        """
        Window Close Handler
        """
        self.window.destroy()
