'''OpenGL extension EXT.cull_vertex

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.cull_vertex to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces a method for culling vertexes in object
	space based on the value of the dot product between the normal at
	the vertex and a culling eye direction.
	
	Culling a polygon by examining its vertexes in object space can be
	more efficient than screen space polygon culling since the transformation
	to screen space (which may include a division by w) can be avoided for
	culled vertexes.  Also, vertex culling can be computed before vertexes
	are assembled into primitives.  This is a useful property when drawing
	meshes with shared vertexes, since a vertex can be culled once, and the
	resulting state can be used for all primitives which share the vertex.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/cull_vertex.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.cull_vertex import *
from OpenGL.raw.GL.EXT.cull_vertex import _EXTENSION_NAME

def glInitCullVertexEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glCullParameterdvEXT=wrapper.wrapper(glCullParameterdvEXT).setOutput(
    'params',size=(4,),orPassIn=True
)
glCullParameterfvEXT=wrapper.wrapper(glCullParameterfvEXT).setOutput(
    'params',size=(4,),orPassIn=True
)
### END AUTOGENERATED SECTION