#
# PySNMP MIB module IFCP-MGMT-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/IFCP-MGMT-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:16:39 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint")
( PhysicalIndexOrZero, ) = mibBuilder.importSymbols("ENTITY-MIB", "PhysicalIndexOrZero")
( FcAddressIdOrZero, FcNameIdOrZero, ) = mibBuilder.importSymbols("FC-MGMT-MIB", "FcAddressIdOrZero", "FcNameIdOrZero")
( ZeroBasedCounter64, ) = mibBuilder.importSymbols("HCNUM-TC", "ZeroBasedCounter64")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddress, InetPortNumber, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetPortNumber", "InetAddressType")
( ZeroBasedCounter32, ) = mibBuilder.importSymbols("RMON2-MIB", "ZeroBasedCounter32")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( MibIdentifier, Counter64, ModuleIdentity, Gauge32, Unsigned32, Counter32, ObjectIdentity, transmission, iso, NotificationType, TimeTicks, MibScalar, MibTable, MibTableRow, MibTableColumn, Integer32, IpAddress, Bits, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibIdentifier", "Counter64", "ModuleIdentity", "Gauge32", "Unsigned32", "Counter32", "ObjectIdentity", "transmission", "iso", "NotificationType", "TimeTicks", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Integer32", "IpAddress", "Bits")
( TruthValue, TextualConvention, StorageType, DisplayString, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "TruthValue", "TextualConvention", "StorageType", "DisplayString", "TimeStamp")
ifcpMgmtMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 230)).setRevisions(("2006-01-17 00:00",))
if mibBuilder.loadTexts: ifcpMgmtMIB.setLastUpdated('200601170000Z')
if mibBuilder.loadTexts: ifcpMgmtMIB.setOrganization('IETF IPS Working Group')
if mibBuilder.loadTexts: ifcpMgmtMIB.setContactInfo('\n           Attn: Kevin Gibbons\n                 McDATA Corporation\n                 4555 Great America Pkwy\n                 Santa Clara, CA 95054-1208 USA\n                 Phone: (408) 567-5765\n                 EMail: kevin.gibbons@mcdata.com\n\n                 Charles Monia\n                 Consultant\n                 7553 Morevern Circle\n                 San Jose, CA 95135 USA\n                 EMail: charles_monia@yahoo.com\n\n                 Josh Tseng\n                 Riverbed Technology\n                 501 2nd Street, Suite 410\n                 San Francisco, CA 94107 USA\n                 Phone: (650) 274-2109\n                 EMail: joshtseng@yahoo.com\n\n                 Franco Travostino\n                 Nortel\n                 600 Technology Park Drive\n                 Billerica, MA 01821 USA\n                 Phone: (978) 288-7708\n                 EMail: travos@nortel.com')
if mibBuilder.loadTexts: ifcpMgmtMIB.setDescription('This module defines management information specific\n                  to internet Fibre Channel Protocol (iFCP) gateway\n                  management.\n\n                  Copyright (C) The Internet Society 2006.  This\n                  version of this MIB module is part of RFC 4369; see\n                  the RFC itself for full legal notices.')
class IfcpIpTOVorZero(Unsigned32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,3600)

class IfcpLTIorZero(Unsigned32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,65535)

class IfcpSessionStates(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("down", 1), ("openPending", 2), ("open", 3),)

class IfcpAddressMode(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("addressTransparent", 1), ("addressTranslation", 2),)

ifcpGatewayObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 1))
ifcpGatewayConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 2))
ifcpLclGatewayInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 1, 1))
ifcpLclGtwyInstTable = MibTable((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1), )
if mibBuilder.loadTexts: ifcpLclGtwyInstTable.setDescription('Information about all local iFCP Gateway instances that can\n    be monitored and controlled.  This table contains an entry\n    for each local iFCP Gateway instance that is being managed.')
ifcpLclGtwyInstEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1), ).setIndexNames((0, "IFCP-MGMT-MIB", "ifcpLclGtwyInstIndex"))
if mibBuilder.loadTexts: ifcpLclGtwyInstEntry.setDescription('An entry in the local iFCP Gateway Instance table.\n    Parameters and settings for the gateway are found here.')
ifcpLclGtwyInstIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: ifcpLclGtwyInstIndex.setDescription('An arbitrary integer value to uniquely identify this iFCP\n    Gateway from other local Gateway instances.')
ifcpLclGtwyInstPhyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 2), PhysicalIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpLclGtwyInstPhyIndex.setDescription('An index indicating the location of this local gateway within\n    a larger entity, if one exists.  If supported, this is the\n    entPhysicalIndex from the Entity MIB (Version 3), for this\n    iFCP Gateway.  If not supported, or if not related to a\n    physical entity, then the value of this object is 0.')
ifcpLclGtwyInstVersionMin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpLclGtwyInstVersionMin.setDescription('The minimum iFCP protocol version supported by the local iFCP\n    gateway instance.')
ifcpLclGtwyInstVersionMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpLclGtwyInstVersionMax.setDescription('The maximum iFCP protocol version supported by the local iFCP\n    gateway instance.')
ifcpLclGtwyInstAddrTransMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 5), IfcpAddressMode().clone('addressTranslation')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpLclGtwyInstAddrTransMode.setDescription('The local iFCP gateway operating mode.  Changing this value\n    may cause existing sessions to be disrupted.')
ifcpLclGtwyInstFcBrdcstSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 6), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpLclGtwyInstFcBrdcstSupport.setDescription('Whether the local iFCP gateway supports FC Broadcast.\n    Changing this value may cause existing sessions to be\n    disrupted.')
ifcpLclGtwyInstDefaultIpTOV = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 7), IfcpIpTOVorZero().clone(6)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpLclGtwyInstDefaultIpTOV.setDescription('The default IP_TOV used for iFCP sessions at this gateway.\n    This is the default maximum propagation delay that will be\n    used for an iFCP session.  The value can be changed on a\n    per-session basis.  The valid range is 0 - 3600 seconds.\n    A value of 0 implies that fibre channel frame lifetime limits\n    will not be enforced.')
ifcpLclGtwyInstDefaultLTInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 8), IfcpLTIorZero().clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpLclGtwyInstDefaultLTInterval.setDescription('The default Liveness Test Interval (LTI), in seconds, used\n    for iFCP sessions at this gateway.  This is the default\n    value for an iFCP session and can be changed on a\n    per-session basis.  The valid range is 0 - 65535 seconds.\n    A value of 0 implies no Liveness Test Interval will be\n    performed on a session.')
ifcpLclGtwyInstDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 9), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpLclGtwyInstDescr.setDescription('A user-entered description for this iFCP Gateway.')
ifcpLclGtwyInstNumActiveSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 10), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpLclGtwyInstNumActiveSessions.setDescription('The current total number of iFCP sessions in the open or\n    open-pending state.')
ifcpLclGtwyInstStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 1, 1, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpLclGtwyInstStorageType.setDescription('The storage type for this row.  Parameter values defined\n    for a gateway are usually non-volatile, but may be volatile\n    or permanent in some configurations.  If permanent, then\n    the following parameters must have read-write access:\n    ifcpLclGtwyInstAddrTransMode, ifcpLclGtwyInstDefaultIpTOV,\n    and ifcpLclGtwyInstDefaultLTInterval.')
ifcpNportSessionInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 1, 2))
ifcpSessionAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1), )
if mibBuilder.loadTexts: ifcpSessionAttributesTable.setDescription('An iFCP session consists of the pair of N_PORTs comprising\n    the session endpoints joined by a single TCP/IP connection.\n    This table provides information on each iFCP session\n    currently using a local iFCP Gateway instance.  iFCP sessions\n    are created and removed by the iFCP Gateway instances, which\n    are reflected in this table.')
ifcpSessionAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1), ).setIndexNames((0, "IFCP-MGMT-MIB", "ifcpLclGtwyInstIndex"), (0, "IFCP-MGMT-MIB", "ifcpSessionIndex"))
if mibBuilder.loadTexts: ifcpSessionAttributesEntry.setDescription("Each entry contains information about one iFCP session consisting\n    of a pair of N_PORTs joined by a single TCP/IP connection.  This\n    table's INDEX includes ifcpLclGtwyInstIndex, which identifies the\n    local iFCP Gateway instance that created the session for the\n    entry.\n\n    Soon after an entry is created in this table for an iFCP session, it\n    will correspond to an entry in the tcpConnectionTable of the TCP-MIB\n    (RFC 4022).  The corresponding entry might represent a preexisting\n    TCP connection, or it might be a newly-created entry.  (Note that if\n    IPv4 is being used, an entry in RFC 2012's tcpConnTable may also\n    correspond.)  The values of ifcpSessionLclPrtlAddrType and\n    ifcpSessionRmtPrtlIfAddrType in this table and the values of\n    tcpConnectionLocalAddressType and tcpConnectionRemAddressType used\n    as INDEX values for the corresponding entry in the\n    tcpConnectionTable should be the same; this makes it simpler to\n    locate a session's TCP connection in the TCP-MIB.  (Of course, all\n    four values need to be 'ipv4' if there's a corresponding entry in\n    the tcpConnTable.)\n\n    If an entry is created in this table for a session, prior to\n    knowing which local and/or remote port numbers will be used for\n    the TCP connection, then ifcpSessionLclPrtlTcpPort and/or\n    ifcpSessionRmtPrtlTcpPort have the value zero until such time as\n    they can be updated to the port numbers (to be) used for the\n    connection.  (Thus, a port value of zero should not be used to\n    locate a session's TCP connection in the TCP-MIB.)\n\n    When the TCP connection terminates, the entry in the\n    tcpConnectionTable and the entry in this table both get deleted\n    (and, if applicable, so does the entry in the tcpConnTable).")
ifcpSessionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: ifcpSessionIndex.setDescription('The iFCP session index is a unique value used as an index\n    to the table, along with a specific local iFCP Gateway\n    instance.  This index is used because the local N Port and\n    remote N Port information would create an complex index that\n    would be difficult to implement.')
ifcpSessionLclPrtlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclPrtlIfIndex.setDescription('This is the interface index in the IF-MIB ifTable being used\n    as the local portal in this session, as described in the\n    IF-MIB.  If the local portal is not associated with an entry\n    in the ifTable, then the value is 0.  The ifType of the\n    interface will generally be a type that supports IP, but an\n    implementation may support iFCP using other protocols.  This\n    object can be used to obtain additional information about the\n    interface.')
ifcpSessionLclPrtlAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclPrtlAddrType.setDescription('The type of address in ifcpSessionLclIfAddr.')
ifcpSessionLclPrtlAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 4), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclPrtlAddr.setDescription('This is the external IP address of the interface being used\n    for the iFCP local portal in this session.  The address type\n    is defined in ifcpSessionLclPrtlAddrType.  If the value is a\n    DNS name, then the name is resolved once, during the initial\n    session instantiation.')
ifcpSessionLclPrtlTcpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 5), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclPrtlTcpPort.setDescription('This is the TCP port number that is being used for the iFCP\n    local portal in this session.  This is normally an ephemeral\n    port number selected by the gateway.  The value may be 0\n    during an initial setup period.')
ifcpSessionLclNpWwun = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 6), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclNpWwun.setDescription('World Wide Unique Name of the local N Port.  For an unbound\n    session, this variable will be a zero-length string.')
ifcpSessionLclNpFcid = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 7), FcAddressIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclNpFcid.setDescription('Fibre Channel Identifier of the local N Port.  For an unbound\n    session, this variable will be a zero-length string.')
ifcpSessionRmtNpWwun = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 8), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtNpWwun.setDescription('World Wide Unique Name of the remote N Port.  For an unbound\n    session, this variable will be a zero-length string.')
ifcpSessionRmtPrtlIfAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 9), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtPrtlIfAddrType.setDescription('The type of address in ifcpSessionRmtPrtlIfAddr.')
ifcpSessionRmtPrtlIfAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 10), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtPrtlIfAddr.setDescription('This is the remote gateway IP address being used for the\n    portal on the remote iFCP gateway.  The address type is\n    defined in ifcpSessionRmtPrtlIfAddrType.  If the value is a\n    DNS name, then the name is resolved once, during the initial\n    session instantiation.')
ifcpSessionRmtPrtlTcpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 11), InetPortNumber().clone(3420)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtPrtlTcpPort.setDescription('This is the TCP port number being used for the portal on the\n    remote iFCP gateway.  Generally, this will be the iFCP\n    canonical port.  The value may be 0 during an initial setup\n    period.')
ifcpSessionRmtNpFcid = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 12), FcAddressIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtNpFcid.setDescription('Fibre Channel Identifier of the remote N Port.  For an\n    unbound session, this variable will be a zero-length string.')
ifcpSessionRmtNpFcidAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 13), FcAddressIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtNpFcidAlias.setDescription('Fibre Channel Identifier Alias assigned by the local gateway\n    for the remote N Port.  For an unbound session, this variable\n    will be a zero-length string.')
ifcpSessionIpTOV = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 14), IfcpIpTOVorZero()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifcpSessionIpTOV.setDescription('The IP_TOV being used for this iFCP session.  This is the\n    maximum propagation delay that will be used for the iFCP\n    session.  The value can be changed on a per-session basis\n    and initially defaults to ifcpLclGtwyInstDefaultIpTOV for\n    the local gateway instance.  The valid range is 0 - 3600\n    seconds.  A value of 0 implies fibre channel frame lifetime\n    limits will not be enforced.')
ifcpSessionLclLTIntvl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 15), IfcpLTIorZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLclLTIntvl.setDescription('The Liveness Test Interval (LTI) used for this iFCP session.\n    The value can be changed on a per-session basis and initially\n    defaults to ifcpLclGtwyInstDefaultLTInterval for the local\n    gateway instance.  The valid range is 0 - 65535 seconds.\n    A value of 0 implies that the gateway will not originate\n    Liveness Test messages for the session.')
ifcpSessionRmtLTIntvl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 16), IfcpLTIorZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRmtLTIntvl.setDescription('The Liveness Test Interval (LTI) as requested by the remote\n    gateway instance to use for this iFCP session.  This value may\n    change over the life of the session.  The valid range is 0 -\n    65535 seconds.  A value of 0 implies that the remote gateway\n    has not been requested to originate Liveness Test messages for\n    the session.')
ifcpSessionBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionBound.setDescription('This value indicates whether this session is bound to a\n    specific local and remote N Port.  Sessions by default are\n    unbound and ready for future assignment to a local and remote\n    N Port.')
ifcpSessionStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 1, 1, 18), StorageType().clone('nonVolatile')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionStorageType.setDescription('The storage type for this row.  Parameter values defined\n    for a session are usually non-volatile, but may be volatile\n    or permanent in some configurations.  If permanent, then\n    ifcpSessionIpTOV must have read-write access.')
ifcpSessionStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2), )
if mibBuilder.loadTexts: ifcpSessionStatsTable.setDescription('This table provides statistics on an iFCP session.')
ifcpSessionStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1), )
ifcpSessionAttributesEntry.registerAugmentions(("IFCP-MGMT-MIB", "ifcpSessionStatsEntry"))
ifcpSessionStatsEntry.setIndexNames(*ifcpSessionAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: ifcpSessionStatsEntry.setDescription('Provides iFCP-specific statistics per session.')
ifcpSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 1), IfcpSessionStates()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionState.setDescription('The current session operating state.')
ifcpSessionDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionDuration.setDescription('This indicates, in seconds, how long the iFCP session has\n    been in an open or open-pending state.  When a session is\n    down, the value is reset to 0.')
ifcpSessionTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 3), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionTxOctets.setDescription('The total number of octets transmitted by the iFCP gateway\n    for this session.  Discontinuities in the value of this\n    counter can occur at reinitialization of the management\n    system, and at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 4), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRxOctets.setDescription('The total number of octets received by the iFCP gateway for\n    this session.  Discontinuities in the value of this\n    counter can occur at reinitialization of the management\n    system, and at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionTxFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 5), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionTxFrames.setDescription('The total number of iFCP frames transmitted by the gateway\n    for this session.  Discontinuities in the value of this\n    counter can occur at reinitialization of the management\n    system, and at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionRxFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 6), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionRxFrames.setDescription('The total number of iFCP frames received by the gateway\n    for this session.  Discontinuities in the value of this\n    counter can occur at reinitialization of the management\n    system, and at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionStaleFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 7), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionStaleFrames.setDescription('The total number of received iFCP frames that were stale and\n    discarded by the gateway for this session.  Discontinuities\n    in the value of this counter can occur at reinitialization\n    of the management system, and at other times as indicated by\n    the value of ifcpSessionDiscontinuityTime.')
ifcpSessionHeaderCRCErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 8), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionHeaderCRCErrors.setDescription('The total number of CRC errors that occurred in the frame\n    header, detected by the gateway for this session.  Usually,\n    a single Header CRC error is sufficient to terminate an\n    iFCP session.  Discontinuities in the value of this\n    counter can occur at reinitialization of the management\n    system, and at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionFcPayloadCRCErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 9), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionFcPayloadCRCErrors.setDescription('The total number of CRC errors that occurred in the Fibre\n    Channel frame payload, detected by the gateway for this\n    session.  Discontinuities in the value of this counter can\n    occur at reinitialization of the management system, and\n    at other times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionOtherErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 10), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionOtherErrors.setDescription('The total number of errors, other than errors explicitly\n    measured, detected by the gateway for this session.\n    Discontinuities in the value of this counter can occur at\n    reinitialization of the management system, and at other\n    times as indicated by the value of\n    ifcpSessionDiscontinuityTime.')
ifcpSessionDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 2, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionDiscontinuityTime.setDescription('The value of sysUpTime on the most recent occasion at which\n    any one (or more) of the ifcpSessionStatsTable counters\n    suffered a discontinuity.  The relevant counters are the\n    specific Counter64-based instances associated with the\n    ifcpSessionStatsTable: ifcpSessionTxOctets,\n    ifcpSessionRxOctets, ifcpSessionTxFrames,\n    ifcpSessionRxFrames, ifcpSessionStaleFrames,\n    ifcpSessionHeaderCRCErrors, ifcpSessionFcPayloadCRCErrors,\n    and ifcpSessionOtherErrors.  If no such discontinuities have\n    occurred since the last reinitialization of the local\n    management subsystem, then this object contains a zero value.')
ifcpSessionLcStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3), )
if mibBuilder.loadTexts: ifcpSessionLcStatsTable.setDescription('This table provides low capacity statistics for an iFCP\n    session.  These are provided for backward compatibility with\n    systems that do not support Counter64-based objects.  At\n    1-Gbps rates, a Counter32-based object can wrap as often as\n    every 34 seconds.  Counter32-based objects can be sufficient\n    for many situations.  However, when possible, it is\n    recommended to use the high capacity statistics in\n    ifcpSessionStatsTable based on Counter64 objects.')
ifcpSessionLcStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1), )
ifcpSessionAttributesEntry.registerAugmentions(("IFCP-MGMT-MIB", "ifcpSessionLcStatsEntry"))
ifcpSessionLcStatsEntry.setIndexNames(*ifcpSessionAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: ifcpSessionLcStatsEntry.setDescription('Provides iFCP-specific statistics per session.')
ifcpSessionLcTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 1), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcTxOctets.setDescription('The total number of octets transmitted by the iFCP gateway\n    for this session.')
ifcpSessionLcRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcRxOctets.setDescription('The total number of octets received by the iFCP gateway for\n    this session.')
ifcpSessionLcTxFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcTxFrames.setDescription('The total number of iFCP frames transmitted by the gateway\n    for this session.')
ifcpSessionLcRxFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcRxFrames.setDescription('The total number of iFCP frames received by the gateway\n    for this session.')
ifcpSessionLcStaleFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcStaleFrames.setDescription('The total number of received iFCP frames that were stale and\n    discarded by the gateway for this session.')
ifcpSessionLcHeaderCRCErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 6), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcHeaderCRCErrors.setDescription('The total number of CRC errors that occurred in the frame\n    header, detected by the gateway for this session.  Usually,\n    a single Header CRC error is sufficient to terminate an\n    iFCP session.')
ifcpSessionLcFcPayloadCRCErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 7), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcFcPayloadCRCErrors.setDescription('The total number of CRC errors that occurred in the Fibre\n    Channel frame payload, detected by the gateway for this\n    session.')
ifcpSessionLcOtherErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 230, 1, 2, 3, 1, 8), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifcpSessionLcOtherErrors.setDescription('The total number of errors, other than errors explicitly\n    measured, detected by the gateway for this session.')
ifcpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 2, 1))
ifcpGatewayCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 230, 2, 1, 1)).setObjects(*(("IFCP-MGMT-MIB", "ifcpLclGatewayGroup"), ("IFCP-MGMT-MIB", "ifcpLclGatewaySessionGroup"), ("IFCP-MGMT-MIB", "ifcpLclGatewaySessionStatsGroup"), ("IFCP-MGMT-MIB", "ifcpLclGatewaySessionLcStatsGroup"),))
if mibBuilder.loadTexts: ifcpGatewayCompliance.setDescription('Implementation requirements for iFCP MIB compliance.')
ifcpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 230, 2, 2))
ifcpLclGatewayGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 230, 2, 2, 1)).setObjects(*(("IFCP-MGMT-MIB", "ifcpLclGtwyInstPhyIndex"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstVersionMin"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstVersionMax"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstAddrTransMode"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstFcBrdcstSupport"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstDefaultIpTOV"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstDefaultLTInterval"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstDescr"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstNumActiveSessions"), ("IFCP-MGMT-MIB", "ifcpLclGtwyInstStorageType"),))
if mibBuilder.loadTexts: ifcpLclGatewayGroup.setDescription('iFCP local device info group.  This group provides\n    information about each gateway.')
ifcpLclGatewaySessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 230, 2, 2, 4)).setObjects(*(("IFCP-MGMT-MIB", "ifcpSessionLclPrtlIfIndex"), ("IFCP-MGMT-MIB", "ifcpSessionLclPrtlAddrType"), ("IFCP-MGMT-MIB", "ifcpSessionLclPrtlAddr"), ("IFCP-MGMT-MIB", "ifcpSessionLclPrtlTcpPort"), ("IFCP-MGMT-MIB", "ifcpSessionLclNpWwun"), ("IFCP-MGMT-MIB", "ifcpSessionLclNpFcid"), ("IFCP-MGMT-MIB", "ifcpSessionRmtNpWwun"), ("IFCP-MGMT-MIB", "ifcpSessionRmtPrtlIfAddrType"), ("IFCP-MGMT-MIB", "ifcpSessionRmtPrtlIfAddr"), ("IFCP-MGMT-MIB", "ifcpSessionRmtPrtlTcpPort"), ("IFCP-MGMT-MIB", "ifcpSessionRmtNpFcid"), ("IFCP-MGMT-MIB", "ifcpSessionRmtNpFcidAlias"), ("IFCP-MGMT-MIB", "ifcpSessionIpTOV"), ("IFCP-MGMT-MIB", "ifcpSessionLclLTIntvl"), ("IFCP-MGMT-MIB", "ifcpSessionRmtLTIntvl"), ("IFCP-MGMT-MIB", "ifcpSessionBound"), ("IFCP-MGMT-MIB", "ifcpSessionStorageType"),))
if mibBuilder.loadTexts: ifcpLclGatewaySessionGroup.setDescription('iFCP Session group.  This group provides information\n    about each iFCP session currently active between iFCP\n    gateways.')
ifcpLclGatewaySessionStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 230, 2, 2, 5)).setObjects(*(("IFCP-MGMT-MIB", "ifcpSessionState"), ("IFCP-MGMT-MIB", "ifcpSessionDuration"), ("IFCP-MGMT-MIB", "ifcpSessionTxOctets"), ("IFCP-MGMT-MIB", "ifcpSessionRxOctets"), ("IFCP-MGMT-MIB", "ifcpSessionTxFrames"), ("IFCP-MGMT-MIB", "ifcpSessionRxFrames"), ("IFCP-MGMT-MIB", "ifcpSessionStaleFrames"), ("IFCP-MGMT-MIB", "ifcpSessionHeaderCRCErrors"), ("IFCP-MGMT-MIB", "ifcpSessionFcPayloadCRCErrors"), ("IFCP-MGMT-MIB", "ifcpSessionOtherErrors"), ("IFCP-MGMT-MIB", "ifcpSessionDiscontinuityTime"),))
if mibBuilder.loadTexts: ifcpLclGatewaySessionStatsGroup.setDescription('iFCP Session Statistics group.  This group provides\n    statistics with 64-bit counters for each iFCP session\n    currently active between iFCP gateways.  This group\n    is only required for agents that can support Counter64-\n    based data types.')
ifcpLclGatewaySessionLcStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 230, 2, 2, 6)).setObjects(*(("IFCP-MGMT-MIB", "ifcpSessionLcTxOctets"), ("IFCP-MGMT-MIB", "ifcpSessionLcRxOctets"), ("IFCP-MGMT-MIB", "ifcpSessionLcTxFrames"), ("IFCP-MGMT-MIB", "ifcpSessionLcRxFrames"), ("IFCP-MGMT-MIB", "ifcpSessionLcStaleFrames"), ("IFCP-MGMT-MIB", "ifcpSessionLcHeaderCRCErrors"), ("IFCP-MGMT-MIB", "ifcpSessionLcFcPayloadCRCErrors"), ("IFCP-MGMT-MIB", "ifcpSessionLcOtherErrors"),))
if mibBuilder.loadTexts: ifcpLclGatewaySessionLcStatsGroup.setDescription('iFCP Session Low Capacity Statistics group.  This group\n    provides statistics with low-capacity 32-bit counters\n    for each iFCP session currently active between iFCP\n    gateways.  This group is only required for agents that\n    do not support Counter64-based data types, or that need\n    to support SNMPv1 applications.')
mibBuilder.exportSymbols("IFCP-MGMT-MIB", ifcpNportSessionInfo=ifcpNportSessionInfo, ifcpSessionStaleFrames=ifcpSessionStaleFrames, ifcpSessionDuration=ifcpSessionDuration, ifcpSessionLcFcPayloadCRCErrors=ifcpSessionLcFcPayloadCRCErrors, ifcpSessionLcStatsTable=ifcpSessionLcStatsTable, ifcpLclGtwyInstPhyIndex=ifcpLclGtwyInstPhyIndex, ifcpSessionLcStatsEntry=ifcpSessionLcStatsEntry, IfcpLTIorZero=IfcpLTIorZero, ifcpSessionLclLTIntvl=ifcpSessionLclLTIntvl, ifcpSessionLcStaleFrames=ifcpSessionLcStaleFrames, ifcpLclGatewaySessionGroup=ifcpLclGatewaySessionGroup, ifcpSessionLclNpWwun=ifcpSessionLclNpWwun, ifcpSessionHeaderCRCErrors=ifcpSessionHeaderCRCErrors, ifcpSessionLclPrtlIfIndex=ifcpSessionLclPrtlIfIndex, ifcpLclGtwyInstFcBrdcstSupport=ifcpLclGtwyInstFcBrdcstSupport, ifcpLclGatewaySessionLcStatsGroup=ifcpLclGatewaySessionLcStatsGroup, ifcpSessionStatsEntry=ifcpSessionStatsEntry, ifcpSessionLcTxFrames=ifcpSessionLcTxFrames, ifcpSessionLclPrtlAddrType=ifcpSessionLclPrtlAddrType, ifcpGroups=ifcpGroups, ifcpLclGtwyInstDescr=ifcpLclGtwyInstDescr, ifcpLclGtwyInstVersionMax=ifcpLclGtwyInstVersionMax, ifcpCompliances=ifcpCompliances, IfcpAddressMode=IfcpAddressMode, PYSNMP_MODULE_ID=ifcpMgmtMIB, ifcpLclGtwyInstAddrTransMode=ifcpLclGtwyInstAddrTransMode, ifcpLclGtwyInstIndex=ifcpLclGtwyInstIndex, IfcpIpTOVorZero=IfcpIpTOVorZero, ifcpSessionRmtNpFcid=ifcpSessionRmtNpFcid, ifcpSessionTxOctets=ifcpSessionTxOctets, ifcpSessionRxOctets=ifcpSessionRxOctets, ifcpSessionLcTxOctets=ifcpSessionLcTxOctets, ifcpSessionLcRxOctets=ifcpSessionLcRxOctets, IfcpSessionStates=IfcpSessionStates, ifcpSessionOtherErrors=ifcpSessionOtherErrors, ifcpGatewayCompliance=ifcpGatewayCompliance, ifcpSessionLcOtherErrors=ifcpSessionLcOtherErrors, ifcpSessionIpTOV=ifcpSessionIpTOV, ifcpSessionLcRxFrames=ifcpSessionLcRxFrames, ifcpSessionState=ifcpSessionState, ifcpSessionRxFrames=ifcpSessionRxFrames, ifcpSessionLcHeaderCRCErrors=ifcpSessionLcHeaderCRCErrors, ifcpSessionBound=ifcpSessionBound, ifcpSessionStorageType=ifcpSessionStorageType, ifcpSessionLclPrtlAddr=ifcpSessionLclPrtlAddr, ifcpSessionAttributesEntry=ifcpSessionAttributesEntry, ifcpGatewayObjects=ifcpGatewayObjects, ifcpSessionRmtPrtlIfAddr=ifcpSessionRmtPrtlIfAddr, ifcpLclGtwyInstDefaultLTInterval=ifcpLclGtwyInstDefaultLTInterval, ifcpSessionFcPayloadCRCErrors=ifcpSessionFcPayloadCRCErrors, ifcpLclGatewaySessionStatsGroup=ifcpLclGatewaySessionStatsGroup, ifcpLclGtwyInstTable=ifcpLclGtwyInstTable, ifcpSessionLclPrtlTcpPort=ifcpSessionLclPrtlTcpPort, ifcpSessionRmtLTIntvl=ifcpSessionRmtLTIntvl, ifcpLclGtwyInstDefaultIpTOV=ifcpLclGtwyInstDefaultIpTOV, ifcpSessionStatsTable=ifcpSessionStatsTable, ifcpSessionDiscontinuityTime=ifcpSessionDiscontinuityTime, ifcpLclGatewayInfo=ifcpLclGatewayInfo, ifcpSessionLclNpFcid=ifcpSessionLclNpFcid, ifcpSessionRmtNpWwun=ifcpSessionRmtNpWwun, ifcpMgmtMIB=ifcpMgmtMIB, ifcpGatewayConformance=ifcpGatewayConformance, ifcpLclGtwyInstNumActiveSessions=ifcpLclGtwyInstNumActiveSessions, ifcpLclGtwyInstStorageType=ifcpLclGtwyInstStorageType, ifcpSessionAttributesTable=ifcpSessionAttributesTable, ifcpSessionRmtPrtlTcpPort=ifcpSessionRmtPrtlTcpPort, ifcpSessionRmtNpFcidAlias=ifcpSessionRmtNpFcidAlias, ifcpSessionRmtPrtlIfAddrType=ifcpSessionRmtPrtlIfAddrType, ifcpSessionIndex=ifcpSessionIndex, ifcpLclGtwyInstEntry=ifcpLclGtwyInstEntry, ifcpSessionTxFrames=ifcpSessionTxFrames, ifcpLclGatewayGroup=ifcpLclGatewayGroup, ifcpLclGtwyInstVersionMin=ifcpLclGtwyInstVersionMin)
