/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import org.eclipse.swt.widgets.Display;
import org.piccolo2d.extras.swt.SWTTimer;

public class SWTTimerQueue
implements Runnable {
    private static SWTTimerQueue instance;
    private final Display display;
    private SWTTimer firstTimer;
    private boolean running;

    public SWTTimerQueue(Display display) {
        this.display = display;
        this.start();
    }

    public static SWTTimerQueue sharedInstance(Display display) {
        if (instance == null) {
            instance = new SWTTimerQueue(display);
        }
        return instance;
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Thread timerThread = new Thread((Runnable)SWTTimerQueue.this, "TimerQueue");
                timerThread.setDaemon(true);
                timerThread.setPriority(5);
                timerThread.start();
            }
        });
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notifyAll();
    }

    synchronized void addTimer(SWTTimer timer, long expirationTime) {
        if (!timer.isRunning()) {
            this.insertTimer(timer, expirationTime);
            timer.setExpirationTime(expirationTime);
            timer.setRunning(true);
            this.notifyAll();
        }
    }

    private void insertTimer(SWTTimer timer, long expirationTime) {
        SWTTimer previousTimer = this.findLastTimerExpiringBefore(expirationTime);
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            timer.setNextTimer(previousTimer.getNextTimer());
            previousTimer.setNextTimer(timer);
        }
    }

    private SWTTimer findLastTimerExpiringBefore(long expirationTime) {
        SWTTimer previousTimer = null;
        for (SWTTimer nextTimer = this.firstTimer; nextTimer != null && nextTimer.getExpirationTime() > expirationTime; nextTimer = nextTimer.getNextTimer()) {
            previousTimer = nextTimer;
        }
        return previousTimer;
    }

    synchronized void removeTimer(SWTTimer timer) {
        if (!timer.isRunning()) {
            return;
        }
        if (timer == this.firstTimer) {
            this.firstTimer = timer.getNextTimer();
        } else {
            SWTTimer previousTimer = this.findLastTimerBefore(timer);
            if (previousTimer != null) {
                previousTimer.setNextTimer(timer.getNextTimer());
            }
        }
        timer.setExpirationTime(0L);
        timer.setNextTimer(null);
        timer.setRunning(false);
    }

    private SWTTimer findLastTimerBefore(SWTTimer timer) {
        SWTTimer previousTimer = null;
        for (SWTTimer currentTimer = this.firstTimer; currentTimer != null; currentTimer = currentTimer.getNextTimer()) {
            if (currentTimer == timer) {
                return previousTimer;
            }
            previousTimer = currentTimer;
        }
        return null;
    }

    synchronized boolean containsTimer(SWTTimer timer) {
        return timer.running;
    }

    private synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            SWTTimer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.getExpirationTime() - currentTime;
            if (timeToWait > 0L) continue;
            try {
                timer.postOverride();
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not post event", e);
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, currentTime + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    public synchronized void run() {
        try {
            while (this.running) {
                long timeToWait = this.postExpiredTimers();
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (ThreadDeath td) {
            this.running = false;
            for (SWTTimer timer = this.firstTimer; timer != null; timer = timer.getNextTimer()) {
                timer.cancelEventOverride();
            }
            this.display.asyncExec((Runnable)new SWTTimerQueueRestart(this.display));
            throw td;
        }
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimerQueue (");
        SWTTimer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            if ((nextTimer = nextTimer.getNextTimer()) == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    protected static class SWTTimerQueueRestart
    implements Runnable {
        private boolean attemptedStart;
        private final Display display;

        public SWTTimerQueueRestart(Display display) {
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            SWTTimerQueue q;
            if (this.attemptedStart) {
                return;
            }
            SWTTimerQueue sWTTimerQueue = q = SWTTimerQueue.sharedInstance(this.display);
            synchronized (sWTTimerQueue) {
                if (!q.running) {
                    q.start();
                }
            }
            this.attemptedStart = true;
        }
    }
}

