#  Copyright (C) 2003  Stanislav Sinyagin
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

# Stanislav Sinyagin <ssinyagin@k-open.com>


# DO NOT EDIT THIS FILE!

# Torrus Device Discovery local configuration.
# Put all your local settings into devdiscover-siteconfig.pl

use lib(@perllibdirs@);

$Torrus::Global::version        = '@VERSION@';
$Torrus::Global::discoveryDir   = '@sitedir@/discovery/';
$Torrus::Global::siteXmlDir     = '@sitexmldir@';

$Torrus::Global::threadsEnabled  = '@perlithreads@';

$Torrus::DevDiscover::timeFormat = '%d-%m-%Y %H:%M';


@Torrus::DevDiscover::loadModules =
    (
     'Torrus::DevDiscover::RFC1628_UPS_MIB',
     'Torrus::DevDiscover::RFC1657_BGP4_MIB',
     'Torrus::DevDiscover::RFC2011_IP_MIB',
     'Torrus::DevDiscover::RFC2863_IF_MIB',
     'Torrus::DevDiscover::RFC2662_ADSL_LINE',
     'Torrus::DevDiscover::RFC2670_DOCS_IF',
     'Torrus::DevDiscover::RFC2737_ENTITY_MIB',
     'Torrus::DevDiscover::RFC2790_HOST_RESOURCES',
     'Torrus::DevDiscover::RFC4293_IP_MIB',     
     'Torrus::DevDiscover::RFC4319_HDSL2_SHDSL_LINE_MIB',     
     'Torrus::DevDiscover::Actelis',
     'Torrus::DevDiscover::Albis_ULAF',
     'Torrus::DevDiscover::Alteon',
     'Torrus::DevDiscover::ALU_Timetra',
     'Torrus::DevDiscover::AlliedTelesyn_PBC18',
     'Torrus::DevDiscover::APC_PowerNet',
     'Torrus::DevDiscover::Apple_AE',
     'Torrus::DevDiscover::Arbor_E',
     'Torrus::DevDiscover::Arista',
     'Torrus::DevDiscover::AscendMax',
     'Torrus::DevDiscover::ATMEL',
     'Torrus::DevDiscover::AxxessIT',
     'Torrus::DevDiscover::BetterNetworks',
     'Torrus::DevDiscover::CasaCMTS',
     'Torrus::DevDiscover::CCOM',
     'Torrus::DevDiscover::CiscoCatOS',
     'Torrus::DevDiscover::CiscoFirewall',
     'Torrus::DevDiscover::CiscoGeneric',
     'Torrus::DevDiscover::CiscoIOS',
     'Torrus::DevDiscover::CiscoIOS_Docsis',
     'Torrus::DevDiscover::CiscoIOS_MacAccounting',
     'Torrus::DevDiscover::CiscoIOS_SAA',
     'Torrus::DevDiscover::CiscoSCE',
     'Torrus::DevDiscover::CiscoVDSL',
     'Torrus::DevDiscover::CiscoWLC',
     'Torrus::DevDiscover::CompaqCIM',
     'Torrus::DevDiscover::ComtechEFData',
     'Torrus::DevDiscover::EmpireSystemedge',
     'Torrus::DevDiscover::F5BigIp',
     'Torrus::DevDiscover::Fortinet',
     'Torrus::DevDiscover::Foundry',
     'Torrus::DevDiscover::FTOS',
     'Torrus::DevDiscover::Jacarta',
     'Torrus::DevDiscover::JunOS',
     'Torrus::DevDiscover::Liebert',
     'Torrus::DevDiscover::MicrosoftWindows',
     'Torrus::DevDiscover::MotorolaBSR',
     'Torrus::DevDiscover::NetApp',
     'Torrus::DevDiscover::NetScreen',
     'Torrus::DevDiscover::NetBotz',
     'Torrus::DevDiscover::NexComm',
     'Torrus::DevDiscover::OracleDatabase',
     'Torrus::DevDiscover::Paradyne',          # needs testing
     'Torrus::DevDiscover::Patton',
     'Torrus::DevDiscover::RFC1697_RDBMS',
     'Torrus::DevDiscover::Symmetricom',
     'Torrus::DevDiscover::Thomson_xDSL',
     'Torrus::DevDiscover::UcdSnmp',
     'Torrus::DevDiscover::Xylan'
     );



# Template name and source file for each template referenced in discovery
# modules

%Torrus::ConfigBuilder::templateRegistry =
    (
     ####  SNMP defaults
     '::holt-winters-defaults' => {
         'name'   => 'holt-winters-defaults',
         'source' => 'snmp-defs.xml'
         },
     '::snmp-defaults' => {
         'name'   => 'snmp-defaults',
         'source' => 'snmp-defs.xml'
         },
     '::viewonly-defaults' => {
         'name'   => 'viewonly-defaults',
         'source' => 'snmp-defs.xml'
         },
     '::snmp-reachability' => {
         'name'   => 'snmp-reachability',
         'source' => 'snmp-defs.xml'
         },

     #### CDef Collector defaults
     '::cdef-collector-defaults' => {
         'name'   => 'cdef-collector-defaults',
         'source' => 'cdef-collector-defs.xml'
         },

     #### UPS-MIB
     'RFC1628_UPS_MIB::battery-subtree' => {
         'name'   => 'battery-subtree',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS_MIB::ups-input-subtree' => {
         'name'   => 'ups-input-subtree',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS::ups-input-leaf' => {
         'name'   => 'ups-input-leaf',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS_MIB::ups-output-subtree' => {
         'name'   => 'ups-output-subtree',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS::ups-output-leaf' => {
         'name'   => 'ups-output-leaf',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS_MIB::ups-bypass-subtree' => {
         'name'   => 'ups-bypass-subtree',
         'source' => 'generic/rfc1628.ups.xml'
         },
     'RFC1628_UPS::ups-bypass-leaf' => {
         'name'   => 'ups-bypass-leaf',
         'source' => 'generic/rfc1628.ups.xml'
         },

     #### IF-MIB
     'RFC2863_IF_MIB::rfc2863-ifmib-hostlevel' => {
         'name'   => 'rfc2863-ifmib-hostlevel',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::rfc2863-ifmib-subtree' => {
         'name'   => 'rfc2863-ifmib-subtree',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-octets' => {
         'name'   => 'iftable-octets',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-ucast-packets' => {
         'name'   => 'iftable-ucast-packets',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-discards-in' => {
         'name'   => 'iftable-discards-in',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-discards-out' => {
         'name'   => 'iftable-discards-out',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-errors-in' => {
         'name'   => 'iftable-errors-in',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-errors-out' => {
         'name'   => 'iftable-errors-out',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-ifspeed' => {
         'name'   => 'iftable-ifspeed',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::ifxtable-hcoctets' => {
         'name'   => 'ifxtable-hcoctets',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::ifxtable-hcucast-packets' => {
         'name'   => 'ifxtable-hcucast-packets',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::iftable-ifhighspeed' => {
         'name'   => 'iftable-ifhighspeed',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::interface-bandwidth-usage' => {
         'name'   => 'interface-bandwidth-usage',
         'source' => 'generic/rfc2863.if-mib.xml'
         },
     'RFC2863_IF_MIB::interface-bandwidth-usage-ifspeed' => {
         'name'   => 'interface-bandwidth-usage-ifspeed',
         'source' => 'generic/rfc2863.if-mib.xml'
         },

     #### RDBMS MIB
     'RFC1697_RDBMS::rdbms-dbtable' => {
         'name'     => 'rdbms-dbtable',
         'source'   => 'generic/rfc1697.rdbms.xml',
     },
     
     #### DOCSIS MIB
     'RFC2670_DOCS_IF::docsis-downstream-subtree' => {
         'name'   => 'docsis-downstream-subtree',
         'source' => 'generic/rfc2670.docsis-if.xml'
         },
     'RFC2670_DOCS_IF::docsis-downstream-util' => {
         'name'   => 'docsis-downstream-util',
         'source' => 'generic/rfc2670.docsis-if.xml'
         },
     'RFC2670_DOCS_IF::docsis-upstream-subtree' => {
         'name'   => 'docsis-upstream-subtree',
         'source' => 'generic/rfc2670.docsis-if.xml'
         },
     'RFC2670_DOCS_IF::docsis-upstream-stats' => {
         'name'   => 'docsis-upstream-stats',
         'source' => 'generic/rfc2670.docsis-if.xml'
         },

     #### RFC2790_HOST_RESOURCES
     'RFC2790_HOST_RESOURCES::hr-system-performance-subtree' => {
         'name'   => 'hr-system-performance-subtree',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-system-uptime' => {
         'name'   => 'hr-system-uptime',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-system-num-users' => {
         'name'   => 'hr-system-num-users',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-system-processes' => {
         'name'   => 'hr-system-processes',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-processor-load' => {
         'name'   => 'hr-processor-load',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-storage-subtree' => {
         'name'   => 'hr-storage-subtree',
         'source' => 'generic/rfc2790.host-resources.xml'
         },
     'RFC2790_HOST_RESOURCES::hr-storage-usage' => {
         'name'   => 'hr-storage-usage',
         'source' => 'generic/rfc2790.host-resources.xml'
         },

     #### ADSL-LINE-MIB
     'RFC2662_ADSL_LINE::adsl-line-snr' => {
         'name'   => 'adsl-line-snr',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-line-atn' => {
         'name'   => 'adsl-line-atn',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-line-attrate' => {
         'name'   => 'adsl-line-attrate',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-channel-txrate' => {
         'name'   => 'adsl-channel-txrate',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-perf-lofs' => {
         'name'   => 'adsl-perf-lofs',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-perf-loss' => {
         'name'   => 'adsl-perf-loss',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-perf-lprs' => {
         'name'   => 'adsl-perf-lprs',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-perf-ess' => {
         'name'   => 'adsl-perf-ess',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     'RFC2662_ADSL_LINE::adsl-perf-inits' => {
         'name'   => 'adsl-perf-inits',
         'source' => 'generic/rfc2662.adsl-line.xml'
         },
     
     #### IP-MIB traffic stats
     'RFC4293_IP_MIB::rfc4293-ipmib-subtree' => {
         'name'   => 'rfc4293-ipmib-subtree',
         'source' => 'generic/rfc4293.ip-mib.xml'
         },
     'RFC4293_IP_MIB::ipifstats-hcoctets' => {
         'name'   => 'ipifstats-hcoctets',
         'source' => 'generic/rfc4293.ip-mib.xml'
         },

     #### HDSL2-SHDSL-LINE-MIB
     'RFC4319_HDSL2_SHDSL_LINE_MIB::hdsl-subtree' => {
         'name'   => 'hdsl-subtree',
         'source' => 'generic/rfc4319_hdsl2_shdsl_line.xml'
         },
     'RFC4319_HDSL2_SHDSL_LINE_MIB::hdsl-interface' => {
         'name'   => 'hdsl-interface',
         'source' => 'generic/rfc4319_hdsl2_shdsl_line.xml'
         },
     'RFC4319_HDSL2_SHDSL_LINE_MIB::hdsl-endpoint' => {
         'name'   => 'hdsl-endpoint',
         'source' => 'generic/rfc4319_hdsl2_shdsl_line.xml'
         },
     
     #### Albis technologies ULAF
     'Albis_ULAF::albis-soam-lm-subtree' => {
         'name'   => 'albis-soam-lm-subtree',
         'source' => 'vendor/albis-ulaf.xml'
         },
     'Albis_ULAF::albis-soam-lm' => {
         'name'   => 'albis-soam-lm',
         'source' => 'vendor/albis-ulaf.xml'
         },
     'Albis_ULAF::albis-soam-dm-subtree' => {
         'name'   => 'albis-soam-dm-subtree',
         'source' => 'vendor/albis-ulaf.xml'
         },
     'Albis_ULAF::albis-soam-dm' => {
         'name'   => 'albis-soam-dm',
         'source' => 'vendor/albis-ulaf.xml'
         },
     
     #### Alteon application switches
     'Alteon::alteon-cpu' => {
         'name'   => 'alteon-cpu',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-mem' => {
         'name'   => 'alteon-mem',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-packets' => {
         'name'   => 'alteon-packets',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-sensor' => {
         'name'   => 'alteon-sensor',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-vserver-subtree' => {
         'name'   => 'alteon-vserver-subtree',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-vserver' => {
         'name'   => 'alteon-vserver',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-maint-subtree' => {
         'name'   => 'alteon-maint-subtree',
         'source' => 'vendor/alteon.xml'
         },     
     'Alteon::alteon-maint' => {
         'name'   => 'alteon-maint',
         'source' => 'vendor/alteon.xml'
         },     

     #### Alcatel-Lucent ESS and SR
     'ALU_Timetra::alu-timetra-customer' => {
         'name'   => 'alu-timetra-customer',
         'source' => 'vendor/alu-timetra.xml'
         },     
     'ALU_Timetra::alu-timetra-sap' => {
         'name'   => 'alu-timetra-sap',
         'source' => 'vendor/alu-timetra.xml'
         },     

     #### APC Powernet
     'APC_PowerNet::apc-pdu2-subtree' => {
         'name'   => 'apc-pdu2-subtree',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-pdu2-phase' => {
         'name'   => 'apc-pdu2-phase',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-pdu2-bank' => {
         'name'   => 'apc-pdu2-bank',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-pdu-subtree' => {
         'name'   => 'apc-pdu-subtree',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-pdu-stat' => {
         'name'   => 'apc-pdu-stat',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-mem-subtree' => {
         'name'   => 'apc-mem-subtree',
         'source' => 'vendor/apc.powernet.xml'
         },
     'APC_PowerNet::apc-mem-sensor' => {
         'name'   => 'apc-mem-sensor',
         'source' => 'vendor/apc.powernet.xml'
         },
     
     #### Apple Airport Extreme
     'Apple_AE::ae-wireless-clients-subtree' => {
         'name'   => 'ae-wireless-clients-subtree',
         'source' => 'vendor/apple.ae.xml'
         },
     'Apple_AE::ae-wireless-clients-leaf' => {
         'name'   => 'ae-wireless-clients-leaf',
         'source' => 'vendor/apple.ae.xml'
         },
     'Apple_AE::ae-global-stats' => {
         'name'   => 'ae-global-stats',
         'source' => 'vendor/apple.ae.xml'
         },
     
     #### Arbor Networks E Series
     'Arbor_E::arbor-bundle-subtree' => {
         'name'   => 'arbor-bundle-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-bundle' => {
         'name'   => 'arbor-bundle',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-bundle-deny' => {
         'name'   => 'arbor-bundle-deny',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-bundle-pktsize' => {
         'name'   => 'arbor-bundle-pktsize',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-bundle-ratelimit' => {
         'name'   => 'arbor-bundle-ratelimit',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-bundle-subcount' => {
         'name'   => 'arbor-bundle-subcount',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-flowlkup-subtree' => {
         'name'   => 'arbor-flowlkup-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-flowlkup' => {
         'name'   => 'arbor-flowlkup',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::arbor-flowlkup-leaf' => {
         'name'   => 'arbor-flowlkup-leaf',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-buffers' => {
         'name'   => 'e30-buffers',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-bundle-subtree' => {
         'name'   => 'e30-bundle-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-bundle' => {
         'name'   => 'e30-bundle',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-bundle-deny' => {
         'name'   => 'e30-bundle-deny',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-bundle-ratelimit' => {
         'name'   => 'e30-bundle-ratelimit',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-cpu' => {
         'name'   => 'e30-cpu',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-fwdTable' => {
         'name'   => 'e30-fwdTable',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-fwdTable-login' => {
         'name'   => 'e30-fwdTable-login',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-hdd-subtree' => {
         'name'   => 'e30-hdd-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-hdd' => {
         'name'   => 'e30-hdd',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-hdd-errors' => {
         'name'   => 'e30-hdd-errors',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-hdd-logs' => {
         'name'   => 'e30-hdd-logs',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-l2tp-subtree' => {
         'name'   => 'e30-l2tp-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-l2tp' => {
         'name'   => 'e30-l2tp',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-l2tp-secure-endpoints-subtree' => {
         'name'   => 'e30-l2tp-secure-endpoints-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-l2tp-secure-endpoints-leaf' => {
         'name'   => 'e30-l2tp-secure-endpoints-leaf',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-mem' => {
         'name'   => 'e30-mem',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-mempool-subtree' => {
         'name'   => 'e30-mempool-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-mempool' => {
         'name'   => 'e30-mempool',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e30-slowpath' => {
         'name'   => 'e30-slowpath',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-cpu-subtree' => {
         'name'   => 'e100-cpu-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-cpu' => {
         'name'   => 'e100-cpu',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-hdd-subtree' => {
         'name'   => 'e100-hdd-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-hdd' => {
         'name'   => 'e100-hdd',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-mem-subtree' => {
         'name'   => 'e100-mem-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-mem' => {
         'name'   => 'e100-mem',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-policymgmt' => {
         'name'   => 'e100-policymgmt',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-submgmt-subtree' => {
         'name'   => 'e100-submgmt-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-submgmt-state-subtree' => {
         'name'   => 'e100-submgmt-state-subtree',
         'source' => 'vendor/arbor_e.xml'
         },
     'Arbor_E::e100-submgmt-state' => {
         'name'   => 'e100-submgmt-state',
         'source' => 'vendor/arbor_e.xml'
         },

     #### ATMEL smartbridges
     'ATMEL::atmel-device-subtree' => {
         'name'   => 'atmel-device-subtree',
         'source' => 'vendor/atmel.xml'
         },
     'ATMEL::atmel-accesspoint-stats' => {
         'name'   => 'atmel-accesspoint-stats',
         'source' => 'vendor/atmel.xml'
         },
     'ATMEL::atmel-client-stats' => {
         'name'   => 'atmel-client-stats',
         'source' => 'vendor/atmel.xml'
         },

     #### AscendMax
     'AscendMax::ascend-totalcalls' => {
         'name'   => 'ascend-totalcalls',
         'source' => 'vendor/ascend.max.xml'
         },
     'AscendMax::ascend-line-stats' => {
         'name'   => 'ascend-line-stats',
         'source' => 'vendor/ascend.max.xml'
         },

     #### BetterNetworks
     'BetterNetworks::betternetworks-sensor' => {
         'name'   => 'betternetworks-sensor',
         'source' => 'vendor/betternetworks.xml'
         },
     
     #### CASA Systems CMTS
     'CasaCMTS::casa-docsis-mac-subtree' => {
         'name'   => 'casa-docsis-mac-subtree',
         'source' => 'vendor/casa-cmts.xml'
         },
     'CasaCMTS::casa-docsis-mac-util' => {
         'name'   => 'casa-docsis-mac-util',
         'source' => 'vendor/casa-cmts.xml'
         },
     'CasaCMTS::casa-docsis-upstream-util' => {
         'name'   => 'casa-docsis-upstream-util',
         'source' => 'vendor/casa-cmts.xml'
         },
     'CasaCMTS::casa-docsis-downstream-util' => {
         'name'   => 'casa-docsis-downstream-util',
         'source' => 'vendor/casa-cmts.xml'
         },
     
     #### Cisco
     'CiscoGeneric::cisco-cpu' => {
         'name'   => 'cisco-cpu',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-cpu-revised' => {
         'name'   => 'cisco-cpu-revised',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-cpu-usage-subtree' => {
         'name'   => 'cisco-cpu-usage-subtree',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::old-cisco-cpu' => {
         'name'   => 'old-cisco-cpu',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::old-cisco-mempool' => {
         'name'   => 'cisco-mempool',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-mempool' => {
         'name'   => 'cisco-mempool',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-enh-mempool' => {
         'name'   => 'cisco-enh-mempool',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-enh-mempool-hc' => {
         'name'   => 'cisco-enh-mempool-hc',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-memusage-subtree' => {
         'name'   => 'cisco-memusage-subtree',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-temperature-subtree' => {
         'name'   => 'cisco-temperature-subtree',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-temperature-sensor' => {
         'name'   => 'cisco-temperature-sensor',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-temperature-sensor-fahrenheit' => {
         'name'   => 'cisco-temperature-sensor-fahrenheit',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-power-supply' => {
         'name'   => 'cisco-power-supply',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoGeneric::cisco-system-ext-mib' => {
         'name'   => 'cisco-system-ext-mib',
         'source' => 'vendor/cisco.generic.xml'
         },
     'CiscoIOS::cisco-interface-counters' => {
         'name'   => 'cisco-interface-counters',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::old-cisco-memory-buffers' => {
         'name'   => 'old-cisco-memory-buffers',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-ipsec-flow-globals' => {
         'name'   => 'cisco-ipsec-flow-globals',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-bgp' => {
         'name'   => 'cisco-bgp',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-car-subtree' => {
         'name'   => 'cisco-car-subtree',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-car' => {
         'name'   => 'cisco-car',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-vpdn-subtree' => {
         'name'   => 'cisco-vpdn-subtree',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-vpdn-leaf' => {
         'name'   => 'cisco-vpdn-leaf',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-3g-gsm-stats' => {
         'name'   => 'cisco-3g-gsm-stats',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS::cisco-port-qos-packets' => {
         'name'   => 'cisco-port-qos-packets',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS_Docsis::cisco-docsis-mac-subtree' => {
         'name'   => 'cisco-docsis-mac-subtree',
         'source' => 'vendor/cisco.ios.docsis.xml'
         },
     'CiscoIOS_Docsis::cisco-docsis-mac-util' => {
         'name'   => 'cisco-docsis-mac-util',
         'source' => 'vendor/cisco.ios.docsis.xml'
         },
     'CiscoIOS_Docsis::cisco-docsis-upstream-util' => {
         'name'   => 'cisco-docsis-upstream-util',
         'source' => 'vendor/cisco.ios.docsis.xml'
         },
     'CiscoIOS_MacAccounting::cisco-macacc-subtree' => {
         'name'   => 'cisco-macacc-subtree',
         'source' => 'vendor/cisco.ios.mac-accounting.xml'
         },
     'CiscoIOS_MacAccounting::cisco-macacc' => {
         'name'   => 'cisco-macacc',
         'source' => 'vendor/cisco.ios.mac-accounting.xml'
         },
     'CiscoIOS_SAA::cisco-saa-subtree' => {
         'name'   => 'cisco-saa-subtree',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoIOS_SAA::cisco-rtt-echo-subtree' => {
         'name'   => 'cisco-rtt-echo-subtree',
         'source' => 'vendor/cisco.ios.xml'
         },
     'CiscoFirewall::cisco-firewall-subtree' => {
         'name'   => 'cisco-firewall-subtree',
         'source' => 'vendor/cisco.firewall.xml',
     },
     'CiscoFirewall::events' => {
         'name'   => 'cisco-firewall-events-delta',
         'source' => 'vendor/cisco.firewall.xml',
     },
     'CiscoFirewall::connections' => {
         'name'   => 'cisco-firewall-connections',
         'source' => 'vendor/cisco.firewall.xml',
     },

     'CiscoSCE::cisco-sce-disk' => {
         'name'   => 'cisco-sce-disk',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-subscribers' => {
         'name'   => 'cisco-sce-subscribers',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-tp-subtree' => {
         'name'   => 'cisco-sce-tp-subtree',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-tp' => {
         'name'   => 'cisco-sce-tp',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-rdr' => {
         'name'   => 'cisco-sce-rdr',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-rdr-category' => {
         'name'   => 'cisco-sce-rdr-category',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-rdr-category-subtree' => {
         'name'   => 'cisco-sce-rdr-category-subtree',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-queues-subtree' => {
         'name'   => 'cisco-sce-queues-subtree',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-gc-subtree' => {
         'name'   => 'cisco-sce-gc-subtree',
         'source' => 'vendor/cisco.sce.xml',
     },
     'CiscoSCE::cisco-sce-gcounter' => {
         'name'   => 'cisco-sce-gcounter',
         'source' => 'vendor/cisco.sce.xml',
     },
     
     'CiscoVDSL::cvdsl-subtree' => {
         'name'   => 'cvdsl-subtree',
         'source' => 'vendor/cisco.vdsl-line.xml',
     },
     'CiscoVDSL::cvdsl-interface' => {
         'name'   => 'cvdsl-interface',
         'source' => 'vendor/cisco.vdsl-line.xml',
     },
     'CiscoWLC::ciscowlc-clients-subtree' => {
         'name'   => 'ciscowlc-clients-subtree',
         'source' => 'vendor/cisco.wlc.xml',
     },
     'CiscoWLC::ciscowlc-ess-leaf' => {
         'name'   => 'ciscowlc-ess-leaf',
         'source' => 'vendor/cisco.wlc.xml',
     },

     ### Compaq Insite Manager
     'CompaqCIM::cpq-cim-temperature-sensor' => {
         'name'     => 'cpq-cim-temperature-sensor',
         'source'   => 'vendor/compaq.cim.xml',
     },
     'CompaqCIM::cpq-cim-corr-mem-errs' => {
         'name'     => 'cpq-cim-corr-mem-errs',
         'source'   => 'vendor/compaq.cim.xml',
     },

     ### Comtech EF Data
     'ComtechEFData::cdm570' => {
         'name'     => 'cdm570',
         'source'   => 'vendor/comtechefdata.xml',
     },
     'ComtechEFData::cdmip' => {
         'name'     => 'cdmip',
         'source'   => 'vendor/comtechefdata.xml',
     },

     #### Empire Sysedge
     'EmpireSystemedge::sysedge_opmode' => {
         'name'      => 'sysedge_opmode',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-memory' => {
         'name'      => 'empire-memory',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-nt' => {
         'name'      => 'empire-swap-counters-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-nt40Intel' => {
         'name'      => 'empire-swap-counters-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-nt50Intel' => {
         'name'      => 'empire-swap-counters-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-unix' => {
         'name'      => 'empire-swap-counters-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-solarisSparc' => {
         'name'      => 'empire-swap-counters-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-aix5RS6000' => {
         'name'      => 'empire-swap-counters-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swap-counters-linuxIntel' => {
         'name'      => 'empire-swap-counters-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-performance' => {
         'name'      => 'empire-performance',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-device-subtree' => {
         'name'      => 'empire-device-subtree',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-device' => {
         'name'      => 'empire-device',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-load' => {
         'name'      => 'empire-load',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-subtree' => {
         'name'      => 'empire-cpu-subtree',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-nt' => {
         'name'      => 'empire-cpu-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-nt40Intel' => {
         'name'      => 'empire-cpu-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-nt50Intel' => {
         'name'      => 'empire-cpu-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-unix' => {
         'name'      => 'empire-cpu-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-solarisSparc' => {
         'name'      => 'empire-cpu-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-aix5RS6000' => {
         'name'      => 'empire-cpu-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-linuxIntel' => {
         'name'      => 'empire-cpu-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-nt' => {
         'name'      => 'empire-total-cpu-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-nt40Intel' => {
         'name'      => 'empire-total-cpu-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-nt50Intel' => {
         'name'      => 'empire-total-cpu-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-unix' => {
         'name'      => 'empire-total-cpu-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-solarisSparc' => {
         'name'      => 'empire-total-cpu-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-aix5RS6000' => {
         'name'      => 'empire-total-cpu-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-linuxIntel' => {
         'name'      => 'empire-total-cpu-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-unix' => {
         'name'      => 'empire-cpu-raw-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-solarisSparc' => {
         'name'      => 'empire-cpu-raw-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-aix5RS6000' => {
         'name'      => 'empire-cpu-raw-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-linuxIntel' => {
         'name'      => 'empire-cpu-raw-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-nt' => {
         'name'      => 'empire-cpu-raw-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-nt40Intel' => {
         'name'      => 'empire-cpu-raw-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-cpu-raw-nt50Intel' => {
         'name'      => 'empire-cpu-raw-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-nt' => {
         'name'      => 'empire-total-cpu-raw-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-nt40Intel' => {
         'name'      => 'empire-total-cpu-raw-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-nt50Intel' => {
         'name'      => 'empire-total-cpu-raw-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-unix' => {
         'name'      => 'empire-total-cpu-raw-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-solarisSparc' => {
         'name'      => 'empire-total-cpu-raw-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-aix5RS6000' => {
         'name'      => 'empire-total-cpu-raw-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-total-cpu-raw-linuxIntel' => {
         'name'      => 'empire-total-cpu-raw-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-nt' => {
         'name'      => 'empire-counters-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-nt40Intel' => {
         'name'      => 'empire-counters-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-nt50Intel' => {
         'name'      => 'empire-counters-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-unix' => {
         'name'      => 'empire-counters-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-solarisSparc' => {
         'name'      => 'empire-counters-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-aix5RS6000' => {
         'name'      => 'empire-counters-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-counters-linuxIntel' => {
         'name'      => 'empire-counters-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-runq' => {
         'name'      => 'empire-runq',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-diskwait' => {
         'name'      => 'empire-diskwait',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-pagewait' => {
         'name'      => 'empire-pagewait',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-swapactive' => {
         'name'      => 'empire-swapactive',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-sleepactive' => {
         'name'      => 'empire-sleepactive',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-subtree' => {
         'name'      => 'empire-disk-stats-subtree',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-unix' => {
         'name'      => 'empire-disk-stats-unix',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-solarisSparc' => {
         'name'      => 'empire-disk-stats-solarisSparc',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-aix5RS6000' => {
         'name'      => 'empire-disk-stats-aix5RS6000',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-linuxIntel' => {
         'name'      => 'empire-disk-stats-linuxIntel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-nt' => {
         'name'      => 'empire-disk-stats-nt',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-nt40Intel' => {
         'name'      => 'empire-disk-stats-nt40Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-disk-stats-nt50Intel' => {
         'name'      => 'empire-disk-stats-nt50Intel',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-svc-subtree' => {
         'name'      => 'empire-svc-subtree',
         'source'    => 'vendor/empire.systemedge.xml',
     },
     'EmpireSystemedge::empire-svc-response' => {
         'name'      => 'empire-svc-response',
         'source'    => 'vendor/empire.systemedge.xml',
     },

     #### F5 BigIP
     'F5BigIp::f5-global-host' => {
         'name'      => 'f5-global-host',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-multihost-host' => {
         'name'      => 'f5-multihost-host',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-multihost-cpu-subtree' => {
         'name'      => 'f5-multihost-cpu-subtree',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-multihost-cpu' => {
         'name'      => 'f5-multihost-cpu',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-interface-counters-subtree' => {
         'name'      => 'f5-interface-counters-subtree',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-interface' => {
         'name'      => 'f5-interface',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-object-statistics' => {
         'name'      => 'f5-object-statistics',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::ltm-node-statistics' => {
         'name'      => 'ltm-node-statistics',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::ltm-pool-statistics' => {
         'name'      => 'ltm-pool-statistics',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::ltm-poolmember-statistics' => {
         'name'      => 'ltm-poolmember-statistics',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::ltm-vserver-statistics' => {
         'name'      => 'ltm-vserver-statistics',
         'source'    => 'vendor/f5.bigip.xml',
     },
     'F5BigIp::f5-category-subtree' => {
         'name'      => 'f5-category-subtree',
         'source'    => 'vendor/f5.bigip.xml',
     },
     
     #### Fortinet
     'Fortinet::fortigate-system-stats' => {
         'name'      => 'fortigate-system-stats',
         'source'    => 'vendor/fortinet.xml',
     },
     'Fortinet::fortigate-cpu' => {
         'name'      => 'fortigate-cpu',
         'source'    => 'vendor/fortinet.xml',
     },
     'Fortinet::fortigate-vdoms-subtree' => {
         'name'      => 'fortigate-vdoms-subtree',
         'source'    => 'vendor/fortinet.xml',
     },
     'Fortinet::fortigate-vdom' => {
         'name'      => 'fortigate-vdom',
         'source'    => 'vendor/fortinet.xml',
     },
     'Fortinet::fortimanager-system-stats' => {
         'name'      => 'fortimanager-system-stats',
         'source'    => 'vendor/fortinet.xml',
     },
     

     #### MicrosoftWindows
     'MicrosoftWindows::microsoft-iis-ftp-stats' => {
         'name'     => 'microsoft-iis-ftp-stats',
         'source'   => 'vendor/microsoft.windows.xml',
     },
     'MicrosoftWindows::microsoft-iis-http-stats' => {
         'name'     => 'microsoft-iis-http-stats',
         'source'   => 'vendor/microsoft.windows.xml',
     },

     #### Motorola BSR
     'MotorolaBSR::motorola-bsr-docsis-upstream-util' => {
         'name'     => 'motorola-bsr-docsis-upstream-util',
         'source'   => 'vendor/motorola.bsr.xml',
     },     

     ##### Foundry/Brocade
     'Foundry::fdry-chass-temperature' => {
         'name'     => 'fdry-chass-temperature',
         'source'   => 'vendor/foundry.xml',
     },
     'Foundry::fdry-board-overview' => {
         'name'     => 'fdry-board-overview',
         'source'   => 'vendor/foundry.xml',
     },
     'Foundry::fdry-board-subtree' => {
         'name'     => 'fdry-board-subtree',
         'source'   => 'vendor/foundry.xml',
     },
     'Foundry::fdry-board-memstats' => {
         'name'     => 'fdry-board-memstats',
         'source'   => 'vendor/foundry.xml',
     },     
     'Foundry::fdry-board-cpustats' => {
         'name'     => 'fdry-board-cpustats',
         'source'   => 'vendor/foundry.xml',
     },
     'Foundry::fdry-board-tempstats' => {
         'name'     => 'fdry-board-tempstats',
         'source'   => 'vendor/foundry.xml',
     },
     'Foundry::fdry-board-temp-sensor-halfcelsius' => {
         'name'     => 'fdry-board-temp-sensor-halfcelsius',
         'source'   => 'vendor/foundry.xml',
     },
     
     ##### Force10 networks (by Jon Nistor)
     'FTOS::ftos-cpu-subtree' => {
         'name'     => 'ftos-cpu-subtree',
         'source'   => 'vendor/ftos.xml',
     },
     'FTOS::ftos-cpu' => {
         'name'     => 'ftos-cpu',
         'source'   => 'vendor/ftos.xml',
     },
     'FTOS::ftos-power-supply-leaf' => {
         'name'     => 'ftos-power-supply-leaf',
         'source'   => 'vendor/ftos.xml',
     },
     'FTOS::ftos-temperature-subtree' => {
         'name'     => 'ftos-temperature-subtree',
         'source'   => 'vendor/ftos.xml',
     },
     'FTOS::ftos-temperature-sensor' => {
         'name'     => 'ftos-temperature-sensor',
         'source'   => 'vendor/ftos.xml',
     },
     'FTOS::ftos-temperature-sensor-fahrenheit' => {
         'name'     => 'ftos-temperature-sensor-fahrenheit',
         'source'   => 'vendor/ftos.xml',
     },

     #### Jacarta
     'Jacarta::imeter-amps-sensor' => {
         'name'     => 'imeter-amps-sensor',
         'source'   => 'vendor/jacarta.xml',
     },
     'Jacarta::imeter-humi-sensor' => {
         'name'     => 'imeter-humi-sensor',
         'source'   => 'vendor/jacarta.xml',
     },
     'Jacarta::imeter-temp-sensor' => {
         'name'     => 'imeter-temp-sensor',
         'source'   => 'vendor/jacarta.xml',
     },

     ##### Juniper JunOS (by Jon Nistor)
     'JunOS::junos-cos-subtree' => {
         'name'     => 'junos-cos-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cos-subtree-interface' => {
         'name'     => 'junos-cos-subtree-interface',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cos-leaf' => {
         'name'     => 'junos-cos-leaf',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cos-red' => {
         'name'     => 'junos-cos-red',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cos-tail' => {
         'name'     => 'junos-cos-tail',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cpu-subtree' => {
         'name'     => 'junos-cpu-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-cpu' => {
         'name'     => 'junos-cpu',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-firewall-subtree' => {
         'name'     => 'junos-firewall-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-firewall-filter-subtree' => {
         'name'     => 'junos-firewall-filter-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-firewall-filter' => {
         'name'     => 'junos-firewall-filter',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-firewall-filter-counter' => {
         'name'     => 'junos-firewall-filter-counter',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-firewall-filter-policer' => {
         'name'     => 'junos-firewall-filter-policer',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-memory-subtree' => {
         'name'     => 'junos-memory-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-memory' => {
         'name'     => 'junos-memory',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-rpf-subtree' => {
         'name'     => 'junos-rpf-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-rpf' => {
         'name'     => 'junos-rpf',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-temperature-subtree' => {
         'name'     => 'junos-temperature-subtree',
         'source'   => 'vendor/junos.xml',
     },
     'JunOS::junos-temperature-sensor' => {
         'name'     => 'junos-temperature-sensor',
         'source'   => 'vendor/junos.xml',
     },


     ##### Liebert
     'Liebert::humidity-sensor' => {
         'name'     => 'humidity-sensor',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::humidity-subtree' => {
         'name'     => 'humidity-subtree',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::state-subtree' => {
         'name'     => 'state-subtree',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::state-capacity' => {
         'name'     => 'state-capacity',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::temperature-subtree' => {
         'name'     => 'temperature-subtree',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::temperature-sensor' => {
         'name'     => 'temperature-sensor',
         'source'   => 'vendor/liebert.xml',
     },
     'Liebert::temperature-sensor-fahrenheit' => {
         'name'     => 'temperature-sensor-fahrenheit',
         'source'   => 'vendor/liebert.xml',
     },

     
     ##### Ucd Snmp
     'UcdSnmp::ucdsnmp-memory-real' => {
         'name'     => 'ucdsnmp-memory-real',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-memory-swap' => {
         'name'     => 'ucdsnmp-memory-swap',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-blockio' => {
         'name'     => 'ucdsnmp-blockio',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-raw-interrupts' => {
         'name'     => 'ucdsnmp-raw-interrupts',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-user-multi' => {
         'name'     => 'ucdsnmp-cpu-user-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-user' => {
         'name'     => 'ucdsnmp-cpu-user',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-system-multi' => {
         'name'     => 'ucdsnmp-cpu-system-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-system' => {
         'name'     => 'ucdsnmp-cpu-system',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-wait-multi' => {
         'name'     => 'ucdsnmp-cpu-wait-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-wait' => {
         'name'     => 'ucdsnmp-cpu-wait',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-kernel-multi' => {
         'name'     => 'ucdsnmp-cpu-kernel-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-kernel' => {
         'name'     => 'ucdsnmp-cpu-kernel',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-idle-multi' => {
         'name'     => 'ucdsnmp-cpu-idle-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-idle' => {
         'name'     => 'ucdsnmp-cpu-idle',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-nice-multi' => {
         'name'     => 'ucdsnmp-cpu-nice-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-nice' => {
         'name'     => 'ucdsnmp-cpu-nice',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-interrupts-multi' => {
         'name'     => 'ucdsnmp-cpu-interrupts-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-softirq' => {
         'name'     => 'ucdsnmp-cpu-softirq',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-softirq-multi' => {
         'name'     => 'ucdsnmp-cpu-softirq-multi',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-cpu-interrupts' => {
         'name'     => 'ucdsnmp-cpu-interrupts',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },
     'UcdSnmp::ucdsnmp-load-average' => {
         'name'     => 'ucdsnmp-load-average',
         'source'   => 'vendor/ucd.ucd-snmp.xml',
     },

     #### NetApp (Network Appliance)
     'NetApp::CPU' => {
         'name'     => 'netapp-cpu',
         'source'   => 'vendor/netapp.filer.xml',
     },
     'NetApp::misc' => {
         'name'     => 'netapp-misc',
         'source'   => 'vendor/netapp.filer.xml',
     },
     'NetApp::nfsv2' => {
         'name'     => 'netapp-nfsv2',
         'source'   => 'vendor/netapp.filer.xml',
     },
     'NetApp::nfsv3' => {
         'name'     => 'netapp-nfsv3',
         'source'   => 'vendor/netapp.filer.xml',
     },
     'NetApp::cifs' => {
         'name'     => 'netapp-cifs',
         'source'   => 'vendor/netapp.filer.xml',
     },

     #### NetBotz
     'NetBotz::netbotz-temp-sensor' => {
         'name'     => 'netbotz-temp-sensor',
         'source'   => 'vendor/netbotz.xml',
     },
     'NetBotz::netbotz-humi-sensor' => {
         'name'     => 'netbotz-humi-sensor',
         'source'   => 'vendor/netbotz.xml',
     },
     'NetBotz::netbotz-dew-sensor' => {
         'name'     => 'netbotz-dew-sensor',
         'source'   => 'vendor/netbotz.xml',
     },
     'NetBotz::netbotz-audio-sensor' => {
         'name'     => 'netbotz-audio-sensor',
         'source'   => 'vendor/netbotz.xml',
     },
     'NetBotz::netbotz-air-sensor' => {
         'name'     => 'netbotz-air-sensor',
         'source'   => 'vendor/netbotz.xml',
     },
     'NetBotz::netbotz-door-sensor' => {
         'name'     => 'netbotz-door-sensor',
         'source'   => 'vendor/netbotz.xml',
     },

     #### NetScreen
     'NetScreen::netscreen-cpu-stats' => {
         'name'     => 'netscreen-cpu-stats',
         'source'   => 'vendor/netscreen.xml',
     },
     'NetScreen::netscreen-memory-stats' => {
         'name'     => 'netscreen-memory-stats',
         'source'   => 'vendor/netscreen.xml',
     },
     'NetScreen::netscreen-sessions-stats' => {
         'name'     => 'netscreen-sessions-stats',
         'source'   => 'vendor/netscreen.xml',
     },

     #### OracleDatabase
     'OracleDatabase::Sys' => {
         'name'     => 'oracle-database-sys',
         'source'   => 'vendor/oracle.database.xml',
     },
     'OracleDatabase::CacheSum' => {
         'name'     => 'oracle-cache-sum',
         'source'   => 'vendor/oracle.database.xml',
     },
     'OracleDatabase::SGA' => {
         'name'     => 'oracle-sga',
         'source'   => 'vendor/oracle.database.xml',
     },
     'OracleDatabase::table-space' => {
         'name'     => 'oracle-table-space',
         'source'   => 'vendor/oracle.database.xml',
     },
     'OracleDatabase::data-file' => {
         'name'     => 'oracle-data-file',
         'source'   => 'vendor/oracle.database.xml',
     },
     'OracleDatabase::library-cache' => {
         'name'     => 'oracle-library-cache',
         'source'   => 'vendor/oracle.database.xml',
     },

     #### Paradyne
     'Paradyne::paradyne-xdsl-interface' => {
         'name'   => 'paradyne-xdsl-interface',
         'source' => 'vendor/paradyne.xdsl.xml'
         },

     #### Symmetricom
     'Symmetricom::ntp-stats' => {
         'name'   => 'ntp-stats',
         'source' => 'vendor/symmetricom.xml'
         },
     );

##########################
# Common parameters

# If true, data-dir would be hashed across a number of subdirectories
# Only concatenation of hostname and domain name is hashed.
$Torrus::DevDiscover::hashDataDirEnabled = 0;

# Format for hashed data-dir subdirectory name. The argument is a number
# from 0 to bucketSize-1.
$Torrus::DevDiscover::hashDataDirFormat = '%.2X';

# How many hashed data-dir subdirectories are used.
$Torrus::DevDiscover::hashDataDirBucketSize = 256;


##########################
# RFC2790_HOST_RESOURCES parameters

# The top level of the Host Resources Storage graph, percentage
$Torrus::DevDiscover::RFC2790_HOST_RESOURCES::storageGraphTop = 105;

# Where to draw the hi-mark line in Host Resources Storage, percentage
$Torrus::DevDiscover::RFC2790_HOST_RESOURCES::storageHiMark = 100;


##########################
# EmpireSystemedge parameters

# The top level of the Host Resources Storage graph, percentage
$Torrus::DevDiscover::EmpireSystemedge::storageGraphTop = 105;

# Where to draw the hi-mark line in Empire Storage, percentage
$Torrus::DevDiscover::EmpireSystemedge::storageHiMark = 100;


##########################
#  CiscoIOS parameters

# For mkroutercfg compatibility, set this to 1
$Torrus::DevDiscover::CiscoIOS::useCiscoInterfaceCounters = 0;



# Read plugin configurations
{
    my $dir = '@plugdevdisccfgdir@';
    local *CFGDIR;
    opendir(CFGDIR, $dir) or die("Cannot open directory $dir: $!");
    my @files = grep { !/^\./ } readdir(CFGDIR);
    closedir( CFGDIR );
    foreach my $file ( @files )
    {
        require $dir . '/' . $file;
    }
}


require '@devdiscover_siteconfig_pl@';

1;
