C Copyright (c) 2007-2017 National Technology & Engineering Solutions of
C Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
C NTESS, the U.S. Government retains certain rights in this software.
C 
C Redistribution and use in source and binary forms, with or without
C modification, are permitted provided that the following conditions are
C met:
C 
C     * Redistributions of source code must retain the above copyright
C       notice, this list of conditions and the following disclaimer.
C 
C     * Redistributions in binary form must reproduce the above
C       copyright notice, this list of conditions and the following
C       disclaimer in the documentation and/or other materials provided
C       with the distribution.  
C 
C     * Neither the name of NTESS nor the names of its
C       contributors may be used to endorse or promote products derived
C       from this software without specific prior written permission.
C 
C THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
C "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
C LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
C A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
C OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
C SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
C LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
C DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
C THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
C (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
C OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
C 

C $Id: rdmap.f,v 1.3 2007/10/17 18:47:22 gdsjaar Exp $
C $Log: rdmap.f,v $
C Revision 1.3  2007/10/17 18:47:22  gdsjaar
C Added copyright notice to all files.
C
C extexo2 is licensed under the BSD license
C
C Revision 1.2  1999/02/25 21:10:54  gdsjaar
C Changes to read text file generated by exotxt2 after this change:
C
C Shortened text file a little bit. If the element maps are simple
C sequences (1..number_entries), the map is not written and instead the
C text 'sequence 1..numel' or 'sequence 1..numnp' is written. If not a
C simple sequence, then the text 'explicit map' is written followed by
C the map entries on the next line.
C
C Revision 1.1.1.1  1991/02/22 19:22:41  gdsjaar
C TxtExo - Convert Text File to EXODUS File
C
c Revision 1.1  1991/02/22  19:22:40  gdsjaar
c Initial revision
c

C=======================================================================
      SUBROUTINE RDMAP (NTXT, NUM, MAP, *)
C=======================================================================

C   --*** RDMAP *** (TXTEXO) Read database element order map
C   --   Written by Amy Gilkey - revised 02/27/86
C   --
C   --RDMAP reads the element order map, node number map, and element 
C     number maps from the text file.  An error
C   --message is displayed if the end of file is read.
C   --
C   --Parameters:
C   --   NTXT - IN - the text file
C   --   NUM - IN - the number of elements or nodes
C   --   MAP - OUT - the map
C   --   * - return statement if end of file or read error
C   --
C   --Database must be positioned at start of map upon entry;
C   --upon exit at end of map.

      INTEGER MAP(*)
      CHARACTER*80 LINE

      READ (NTXT, *, END=100, ERR=100)
      READ (NTXT, '(A)', END=100, ERR=100) LINE
C ... Check for keyword 'sequence' at beginning of line
      if (line(:8) .eq. 'sequence' .or. line(:8) .eq. 'SEQUENCE') then
        do 10 i=1, num
          map(i) = i
 10     continue
      else
        READ (NTXT, *, END=100, ERR=100) (MAP(I), I=1,NUM)
      end if

      RETURN

  100 CONTINUE
      CALL PRTERR ('FATAL', 'Reading MAP')
      RETURN 1
      END
