/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.util.xml.SVGWriter;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.SvgFontMetrics;
import rene.zirkel.objects.ConstructionObject;

public class MyGraphicsSvg
extends MyGraphics {
    int W;
    int H;
    PrintWriter Out;
    static final int STROKE_NORMAL = 0;
    static final int STROKE_THIN = 1;
    static final int STROKE_THICK = 2;
    static final int STYLE_NORMAL = 0;
    static final int STYLE_THIN = 1;
    static final int STYLE_THICK = 0;
    int Stroke = 0;
    Color col;
    Color fillcol;
    SvgFontMetrics MFM = new SvgFontMetrics();
    int yoffset = 6000;
    int FontH = 12;
    SVGWriter svg;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsSvg(PrintWriter printWriter, int n, int n2) {
        this.svg = new SVGWriter(printWriter);
        this.svg.startSVG(n, n2);
        this.W = n;
        this.H = n2;
    }

    public void close() {
        this.svg.endTagNewLine("svg");
    }

    public void setColor(Color color) {
        this.col = color;
    }

    public void setFillcolor(Color color) {
        this.fillcol = color;
    }

    public void setColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else {
            if (constructionObject.getColorType() == 2) {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterLightColors[n]);
                } else {
                    this.setColor(ZirkelFrame.LightColors[n]);
                }
            } else {
                int n = constructionObject.getColorIndex();
                if (constructionObject.isHidden()) {
                    this.setColor(ZirkelFrame.BrighterColors[n]);
                } else {
                    this.setColor(ZirkelFrame.Colors[n]);
                }
            }
            this.Stroke = constructionObject.getColorType() == 2 ? 1 : (constructionObject.getColorType() == 1 ? 2 : 0);
        }
    }

    public void setFillColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setFillcolor(ZirkelFrame.TargetColor);
        } else if (constructionObject.getColorType() != 1) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setFillcolor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillcolor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setFillcolor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            this.setColor(constructionObject);
            constructionObject.setColorType(n);
        } else {
            this.setColor(constructionObject);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + d2 + " " + d3 + " H " + (d2 + (d4 -= 1.0)) + " V " + (d3 + (d5 -= 1.0)) + " H " + d2 + " Z");
        this.svg.printArg("style", "fill:none;stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public String rgb() {
        return "rgb(" + this.col.getRed() + "," + this.col.getGreen() + "," + this.col.getBlue() + ")";
    }

    public String frgb() {
        return "rgb(" + this.fillcol.getRed() + "," + this.fillcol.getGreen() + "," + this.fillcol.getBlue() + ")";
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + d2);
        this.svg.printArg("y1", "" + d3);
        this.svg.printArg("x2", "" + d4);
        this.svg.printArg("y2", "" + d5);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + d2);
        this.svg.printArg("y1", "" + d3);
        this.svg.printArg("x2", "" + d4);
        this.svg.printArg("y2", "" + d5);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3");
        this.svg.finishTagNewLine();
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.svg.startTagStart("line");
        this.svg.printArg("x1", "" + d2);
        this.svg.printArg("y1", "" + d3);
        this.svg.printArg("x2", "" + d4);
        this.svg.printArg("y2", "" + d5);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.round(d2 + d4 / 2.0 + d4 * Math.cos(d6 / 180.0 * Math.PI) / 2.0);
        double d9 = Math.round(d3 + d5 / 2.0 - d5 * Math.sin(d6 / 180.0 * Math.PI) / 2.0);
        double d10 = Math.round(d2 + d4 / 2.0 + d4 * Math.cos((d6 + d7) / 180.0 * Math.PI) / 2.0);
        double d11 = Math.round(d3 + d5 / 2.0 - d5 * Math.sin((d6 + d7) / 180.0 * Math.PI) / 2.0);
        int n = 0;
        if (d7 > 180.0) {
            n = 1;
        }
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + d8 + " " + d9 + " A " + d4 / 2.0 + " " + d5 / 2.0 + " 0 " + n + " 0 " + d10 + " " + d11);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
        this.svg.finishTagNewLine();
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        double d8 = Math.round((d2 += (d4 /= 2.0)) + d4 * Math.cos(d6 / 180.0 * Math.PI));
        double d9 = Math.round((d3 += (d5 /= 2.0)) - d5 * Math.sin(d6 / 180.0 * Math.PI));
        double d10 = Math.round(d2 + d4 * Math.cos((d6 + d7) / 180.0 * Math.PI));
        double d11 = Math.round(d3 - d5 * Math.sin((d6 + d7) / 180.0 * Math.PI));
        int n = 0;
        if (d7 > 180.0) {
            n = 1;
        }
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + d8 + " " + d9 + " A " + d4 + " " + d5 + " 0 " + n + " 0 " + d10 + " " + d11);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:3;fill:none");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public FontMetrics getFontMetrics() {
        return this.MFM;
    }

    public void drawString(String string, double d2, double d3) {
        this.svg.startTagStart("text");
        this.svg.printArg("x", "" + d2);
        this.svg.printArg("y", "" + (d3 + 10.0));
        this.svg.printArg("style", "font-size:" + this.FontH + ";fill:" + this.rgb() + ";font-weight:" + (Global.getParameter("font.bold", false) ? "gold" : "normal"));
        this.svg.startTagEnd();
        this.svg.print(string);
        this.svg.endTag("text");
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (d2 += (d4 /= 2.0)));
        this.svg.printArg("cy", "" + (d3 += (d5 /= 2.0)));
        this.svg.printArg("rx", "" + d4);
        this.svg.printArg("ry", "" + d5);
        this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none");
        this.svg.finishTagNewLine();
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (d2 += (d4 /= 2.0)));
        this.svg.printArg("cy", "" + (d3 += (d5 /= 2.0)));
        this.svg.printArg("rx", "" + d4);
        this.svg.printArg("ry", "" + d5);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";fill:none;stroke-width:1");
                break;
            }
            case 2: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";fill:none;stroke-width:3");
                break;
            }
            case 1: {
                this.svg.printArg("style", "stroke:" + this.rgb() + ";stroke-width:1;fill:none;stroke-dasharray:5,5");
            }
        }
        this.svg.finishTagNewLine();
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.svg.startTagStart("path");
        this.svg.printArg("d", "M " + d2 + " " + d3 + " H " + (d2 + (d4 -= 1.0)) + " V " + (d3 + (d5 -= 1.0)) + " H " + d2 + " Z");
        this.svg.printArg("style", "fill:" + this.rgb() + ";stroke:" + this.rgb() + ";stroke-width:1");
        this.svg.finishTagNewLine();
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        int n = (int)Math.round(d2 + d4 / 2.0 + d4 * Math.cos(d6 / 180.0 * Math.PI) / 2.0);
        int n2 = (int)Math.round(d3 + d5 / 2.0 - d5 * Math.sin(d6 / 180.0 * Math.PI) / 2.0);
        int n3 = (int)Math.round(d2 + d4 / 2.0 + d4 * Math.cos((d6 + d7) / 180.0 * Math.PI) / 2.0);
        int n4 = (int)Math.round(d3 + d5 / 2.0 - d5 * Math.sin((d6 + d7) / 180.0 * Math.PI) / 2.0);
        int n5 = 0;
        if (d7 > 180.0) {
            n5 = 1;
        }
        this.svg.startTagStart("path");
        if (bl3) {
            this.svg.printArg("d", "M " + (d2 + d4 / 2.0) + " " + (d3 + d5 / 2.0) + " L " + n + " " + n2 + " A " + d4 / 2.0 + " " + d5 / 2.0 + " 0 " + n5 + " 0 " + n3 + " " + n4 + " L " + (d2 + d4 / 2.0) + " " + (d3 + d5 / 2.0));
        } else {
            this.svg.printArg("d", "M " + n + " " + n2 + " A " + d4 / 2.0 + " " + d5 / 2.0 + " 0 " + n5 + " 0 " + n3 + " " + n4 + " L " + n + " " + n2);
        }
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (bl) {
            this.setColor(constructionObject);
            this.drawArc(d2, d3, d4, d5, d6, d7);
        }
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        this.svg.startTagStart("ellipse");
        this.svg.printArg("cx", "" + (d2 + d4 / 2.0));
        this.svg.printArg("cy", "" + (d3 + d5 / 2.0));
        this.svg.printArg("rx", "" + d4 / 2.0);
        this.svg.printArg("ry", "" + d5 / 2.0);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (bl) {
            this.setColor(constructionObject);
            this.drawOval(d2, d3, d4, d5);
        }
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        this.svg.startTagStart("path");
        String string = "M " + dArray[0] + " " + dArray2[0];
        for (int i = 1; i < n; ++i) {
            string = string + " L " + dArray[i] + " " + dArray2[i];
        }
        string = string + " L " + dArray[0] + " " + dArray2[0];
        this.svg.printArg("d", string);
        switch (this.Stroke) {
            case 0: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
                break;
            }
            case 2: {
                this.svg.printArg("style", "fill:" + this.frgb());
                break;
            }
            case 1: {
                this.svg.printArg("style", "fill:" + this.frgb() + (bl2 && !constructionObject.isSolid() ? ";fill-opacity:0.5" : ""));
            }
        }
        this.svg.finishTagNewLine();
        if (bl) {
            this.svg.startTagStart("path");
            this.svg.printArg("d", string);
            this.setColor(constructionObject);
            this.svg.printArg("style", "fill:none;stroke:" + this.rgb() + ";stroke-width:1");
            this.svg.finishTagNewLine();
        }
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
    }

    public void setFont(int n, boolean bl) {
        this.FontH = n;
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String string) {
        return this.getFontMetrics().stringWidth(string);
    }

    public int stringHeight(String string) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String string, double d2, double d3) {
        this.drawString(string, d2, d3 + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String string) {
        return this.getFontMetrics().getAscent();
    }
}

